/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;

public class DynamicChangeInfo {
    private final JAUtilities jaUtilities;
    private final ReentrantReadWriteLock treeLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeTreeLock = this.treeLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readTreeLock = this.treeLock.readLock();
    private long changeNumber = 0L;
    private final Hub hub;
    private final XmlServiceImpl idGenerator;
    private final DynamicConfigurationService dynamicService;

    DynamicChangeInfo(JAUtilities jaUtilities, Hub hub, XmlServiceImpl idGenerator, DynamicConfigurationService dynamicService) {
        this.jaUtilities = jaUtilities;
        this.hub = hub;
        this.idGenerator = idGenerator;
        this.dynamicService = dynamicService;
    }

    public Hub getHub() {
        return this.hub;
    }

    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readTreeLock;
    }

    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeTreeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChangeNumber() {
        this.readTreeLock.lock();
        try {
            long l = this.changeNumber;
            return l;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementChangeNumber() {
        this.writeTreeLock.lock();
        try {
            ++this.changeNumber;
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    public UnparentedNode getNode(Class<?> iface) {
        return this.jaUtilities.getNode(iface);
    }

    public JAUtilities getJAUtilities() {
        return this.jaUtilities;
    }

    public String getGeneratedId() {
        return this.idGenerator.getUniqueId();
    }

    public XmlServiceImpl getIdGenerator() {
        return this.idGenerator;
    }

    public DynamicConfigurationService getDynamicConfigurationService() {
        return this.dynamicService;
    }
}

