/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.api.annotations.XmlIdentifier;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.jaxb.internal.XmlElementImpl;
import org.glassfish.hk2.xml.jaxb.internal.XmlRootElementImpl;
import org.jvnet.hk2.annotations.Contract;

public class JAUtilities {
    static final String GET = "get";
    static final String SET = "set";
    static final String IS = "is";
    static final String LOOKUP = "lookup";
    static final String ADD = "add";
    static final String REMOVE = "remove";
    static final String JAXB_DEFAULT_STRING = "##default";
    private static final String CLASS_ADD_ON_NAME = "_$$_Hk2_Jaxb";
    private static final HashSet<String> DO_NOT_HANDLE_METHODS = new HashSet();
    private final HashMap<Class<?>, UnparentedNode> interface2NodeCache = new HashMap();
    private final HashMap<Class<?>, UnparentedNode> proxy2NodeCache = new HashMap();
    private final ClassPool defaultClassPool = ClassPool.getDefault();
    private final CtClass superClazz;

    JAUtilities() {
        try {
            this.superClazz = this.defaultClassPool.get(BaseHK2JAXBBean.class.getName());
        }
        catch (NotFoundException e) {
            throw new MultiException((Throwable)e);
        }
    }

    public synchronized UnparentedNode getNode(Class<?> type) {
        UnparentedNode retVal = this.proxy2NodeCache.get(type);
        if (retVal == null) {
            return this.interface2NodeCache.get(type);
        }
        return retVal;
    }

    public synchronized UnparentedNode convertRootAndLeaves(Class<?> root) {
        LinkedHashSet needsToBeConverted = new LinkedHashSet();
        JAUtilities.getAllToConvert(root, needsToBeConverted);
        needsToBeConverted.removeAll(this.interface2NodeCache.keySet());
        for (Class clazz : needsToBeConverted) {
            UnparentedNode converted;
            try {
                converted = this.convert(clazz);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable e) {
                throw new MultiException(e);
            }
            this.interface2NodeCache.put(clazz, converted);
        }
        return this.interface2NodeCache.get(root);
    }

    private static Map<String, String> getXmlNameMap(Class<?> convertMe) {
        HashMap<String, String> xmlNameMap = new HashMap<String, String>();
        for (Method originalMethod : convertMe.getMethods()) {
            String setterVariable = Utilities.isSetter(originalMethod);
            if (setterVariable == null && (setterVariable = Utilities.isGetter(originalMethod)) == null) continue;
            XmlElement xmlElement = originalMethod.getAnnotation(XmlElement.class);
            if (xmlElement != null) {
                if (JAXB_DEFAULT_STRING.equals(xmlElement.name())) {
                    xmlNameMap.put(setterVariable, setterVariable);
                    continue;
                }
                xmlNameMap.put(setterVariable, xmlElement.name());
                continue;
            }
            XmlAttribute xmlAttribute = originalMethod.getAnnotation(XmlAttribute.class);
            if (xmlAttribute == null) continue;
            if (JAXB_DEFAULT_STRING.equals(xmlAttribute.name())) {
                xmlNameMap.put(setterVariable, setterVariable);
                continue;
            }
            xmlNameMap.put(setterVariable, xmlAttribute.name());
        }
        return xmlNameMap;
    }

    private UnparentedNode convert(Class<?> convertMe) throws Throwable {
        StringBuffer sb;
        Logger.getLogger().debug("XmlService converting " + convertMe.getName());
        UnparentedNode retVal = new UnparentedNode(convertMe);
        CtClass originalCtClass = this.defaultClassPool.get(convertMe.getName());
        String targetClassName = convertMe.getName() + CLASS_ADD_ON_NAME;
        CtClass foundClass = this.defaultClassPool.getOrNull(targetClassName);
        if (foundClass != null) {
            Class<?> proxy = convertMe.getClassLoader().loadClass(targetClassName);
            for (java.lang.annotation.Annotation convertMeAnnotation : convertMe.getAnnotations()) {
                if (!XmlRootElement.class.equals(convertMeAnnotation.annotationType())) continue;
                XmlRootElement xre = (XmlRootElement)convertMeAnnotation;
                String rootName = Utilities.convertXmlRootElementName(xre, convertMe);
                retVal.setRootName(rootName);
            }
            Map<String, String> xmlNameMap = JAUtilities.getXmlNameMap(convertMe);
            HashMap<UnparentedNode, String> childTypes = new HashMap<UnparentedNode, String>();
            MethodInformation foundKey = null;
            for (Method originalMethod : convertMe.getMethods()) {
                MethodInformation mi = JAUtilities.getMethodInformation(originalMethod, xmlNameMap);
                if (mi.key) {
                    if (foundKey != null) {
                        throw new RuntimeException("Class " + convertMe.getName() + " has multiple key properties (" + originalMethod.getName() + " and " + foundKey.originalMethod.getName());
                    }
                    foundKey = mi;
                    retVal.setKeyProperty(mi.representedProperty);
                }
                boolean getterOrSetter = false;
                UnparentedNode childType = null;
                if (MethodType.SETTER.equals((Object)mi.methodType)) {
                    getterOrSetter = true;
                    if (mi.baseChildType != null) {
                        if (!this.interface2NodeCache.containsKey(mi.baseChildType)) {
                            throw new RuntimeException("The child of type " + mi.baseChildType.getName() + " is unknown for method " + mi.originalMethod);
                        }
                        childType = this.interface2NodeCache.get(mi.baseChildType);
                    }
                } else if (MethodType.GETTER.equals((Object)mi.methodType)) {
                    getterOrSetter = true;
                    if (mi.baseChildType != null) {
                        if (!this.interface2NodeCache.containsKey(mi.baseChildType)) {
                            throw new RuntimeException("The child of type " + mi.baseChildType.getName() + " is unknown for method " + mi.originalMethod);
                        }
                        childType = this.interface2NodeCache.get(mi.baseChildType);
                    }
                }
                if (!getterOrSetter) continue;
                if (childType != null) {
                    if (childTypes.containsKey(childType)) {
                        String variableName = (String)childTypes.get(childType);
                        if (variableName.equals(mi.representedProperty)) continue;
                        throw new RuntimeException("Multiple children of " + convertMe.getName() + " cannot have the same type.  Consider extending one or more of these to disambiguate the child: " + childType.getOriginalInterface().getName());
                    }
                    childTypes.put(childType, mi.representedProperty);
                    retVal.addChild(mi.representedProperty, mi.isList, childType);
                    continue;
                }
                retVal.addNonChildProperty(mi.representedProperty);
            }
            retVal.setTranslatedClass(proxy);
            this.proxy2NodeCache.put(proxy, retVal);
            return retVal;
        }
        CtClass targetCtClass = this.defaultClassPool.makeClass(targetClassName);
        ClassFile targetClassFile = targetCtClass.getClassFile();
        targetClassFile.setVersionToJava5();
        ConstPool targetConstPool = targetClassFile.getConstPool();
        AnnotationsAttribute ctAnnotations = null;
        for (java.lang.annotation.Annotation convertMeAnnotation : convertMe.getAnnotations()) {
            if (Contract.class.equals(convertMeAnnotation.annotationType())) continue;
            if (ctAnnotations == null) {
                ctAnnotations = new AnnotationsAttribute(targetConstPool, "RuntimeVisibleAnnotations");
            }
            if (XmlRootElement.class.equals(convertMeAnnotation.annotationType())) {
                XmlRootElement xre = (XmlRootElement)convertMeAnnotation;
                String rootName = Utilities.convertXmlRootElementName(xre, convertMe);
                retVal.setRootName(rootName);
                XmlRootElementImpl replacement = new XmlRootElementImpl(xre.namespace(), rootName);
                JAUtilities.createAnnotationCopy(targetConstPool, (java.lang.annotation.Annotation)((Object)replacement), ctAnnotations);
                continue;
            }
            JAUtilities.createAnnotationCopy(targetConstPool, convertMeAnnotation, ctAnnotations);
        }
        if (ctAnnotations != null) {
            targetClassFile.addAttribute(ctAnnotations);
        }
        targetCtClass.setSuperclass(this.superClazz);
        targetCtClass.addInterface(originalCtClass);
        Map<String, String> xmlNameMap = JAUtilities.getXmlNameMap(convertMe);
        HashMap<UnparentedNode, String> childTypes = new HashMap<UnparentedNode, String>();
        MethodInformation foundKey = null;
        HashSet<String> setters = new HashSet<String>();
        HashMap<String, MethodInformation> getters = new HashMap<String, MethodInformation>();
        for (Method originalMethod : convertMe.getMethods()) {
            Class<?>[] paramTypes;
            MethodInformation mi = JAUtilities.getMethodInformation(originalMethod, xmlNameMap);
            if (mi.key) {
                if (foundKey != null) {
                    throw new RuntimeException("Class " + convertMe.getName() + " has multiple key properties (" + originalMethod.getName() + " and " + foundKey.originalMethod.getName());
                }
                foundKey = mi;
                retVal.setKeyProperty(mi.representedProperty);
            }
            String name = originalMethod.getName();
            sb = new StringBuffer("public ");
            Class<?> originalRetType = originalMethod.getReturnType();
            if (originalRetType == null || Void.TYPE.equals(originalRetType)) {
                sb.append("void ");
            } else {
                sb.append(originalRetType.getName() + " ");
            }
            sb.append(name + "(");
            UnparentedNode childType = null;
            boolean getterOrSetter = false;
            if (MethodType.SETTER.equals((Object)mi.methodType)) {
                getterOrSetter = true;
                setters.add(mi.representedProperty);
                if (mi.baseChildType != null) {
                    if (!this.interface2NodeCache.containsKey(mi.baseChildType)) {
                        throw new RuntimeException("The child of type " + mi.baseChildType.getName() + " is unknown for method " + mi.originalMethod);
                    }
                    childType = this.interface2NodeCache.get(mi.baseChildType);
                }
                sb.append(mi.getterSetterType.getName() + " arg0) { super._setProperty(\"" + mi.representedProperty + "\", arg0); }");
            } else if (MethodType.GETTER.equals((Object)mi.methodType)) {
                getterOrSetter = true;
                getters.put(mi.representedProperty, mi);
                if (mi.baseChildType != null) {
                    if (!this.interface2NodeCache.containsKey(mi.baseChildType)) {
                        throw new RuntimeException("The child of type " + mi.baseChildType.getName() + " is unknown for method " + mi.originalMethod);
                    }
                    childType = this.interface2NodeCache.get(mi.baseChildType);
                }
                String cast = "";
                String superMethodName = "_getProperty";
                if (Integer.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "I";
                } else if (Long.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "J";
                } else if (Boolean.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "Z";
                } else if (Byte.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "B";
                } else if (Character.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "C";
                } else if (Short.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "S";
                } else if (Float.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "F";
                } else if (Double.TYPE.equals(mi.getterSetterType)) {
                    superMethodName = superMethodName + "D";
                } else {
                    cast = "(" + mi.getterSetterType.getName() + ") ";
                }
                sb.append(") { return " + cast + "super." + superMethodName + "(\"" + mi.representedProperty + "\"); }");
            } else if (MethodType.LOOKUP.equals((Object)mi.methodType)) {
                sb.append("java.lang.String arg0) { return (" + originalRetType.getName() + ") super._lookupChild(\"" + mi.representedProperty + "\", arg0); }");
            } else if (MethodType.ADD.equals((Object)mi.methodType)) {
                paramTypes = originalMethod.getParameterTypes();
                if (paramTypes.length == 0) {
                    sb.append(") { super._doAdd(\"" + mi.representedProperty + "\", null, null, -1); }");
                } else if (paramTypes.length == 1) {
                    sb.append(paramTypes[0].getName() + " arg0) { super._doAdd(\"" + mi.representedProperty + "\",");
                    if (paramTypes[0].isInterface()) {
                        sb.append("arg0, null, -1); }");
                    } else if (String.class.equals(paramTypes[0])) {
                        sb.append("null, arg0, -1); }");
                    } else {
                        sb.append("null, null, arg0); }");
                    }
                } else {
                    sb.append(paramTypes[0].getName() + " arg0, int arg1) { super._doAdd(\"" + mi.representedProperty + "\",");
                    if (paramTypes[0].isInterface()) {
                        sb.append("arg0, null, arg1); }");
                    } else {
                        sb.append("null, arg0, arg1); }");
                    }
                }
            } else if (MethodType.REMOVE.equals((Object)mi.methodType)) {
                paramTypes = originalMethod.getParameterTypes();
                if (paramTypes.length == 0) {
                    sb.append(") { return (" + originalRetType.getName() + ") super._doRemove(\"" + mi.representedProperty + "\", null, -1); }");
                } else if (String.class.equals(paramTypes[0])) {
                    sb.append("java.lang.String arg0) { return (" + originalRetType.getName() + ") super._doRemove(\"" + mi.representedProperty + "\", arg0, -1); }");
                } else {
                    sb.append("int arg0) { return (" + originalRetType.getName() + ") super._doRemove(\"" + mi.representedProperty + "\", null, arg0); }");
                }
            }
            if (getterOrSetter) {
                if (childType != null) {
                    if (childTypes.containsKey(childType)) {
                        String variableName = (String)childTypes.get(childType);
                        if (!variableName.equals(mi.representedProperty)) {
                            throw new RuntimeException("Multiple children of " + convertMe.getName() + " cannot have the same type.  Consider extending one or more of these to disambiguate the child: " + childType.getOriginalInterface().getName());
                        }
                    } else {
                        childTypes.put(childType, mi.representedProperty);
                        retVal.addChild(mi.representedProperty, mi.isList, childType);
                    }
                } else {
                    retVal.addNonChildProperty(mi.representedProperty);
                }
            }
            CtMethod addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            MethodInfo methodInfo = addMeCtMethod.getMethodInfo();
            ConstPool methodConstPool = methodInfo.getConstPool();
            ctAnnotations = null;
            for (Object convertMeAnnotation : originalMethod.getAnnotations()) {
                if (ctAnnotations == null) {
                    ctAnnotations = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                }
                if (childType != null && XmlElement.class.equals(convertMeAnnotation.annotationType())) {
                    XmlElement original = (XmlElement)convertMeAnnotation;
                    convertMeAnnotation = new XmlElementImpl(original.name(), original.nillable(), original.required(), original.namespace(), original.defaultValue(), childType.getTranslatedClass());
                }
                JAUtilities.createAnnotationCopy(methodConstPool, convertMeAnnotation, ctAnnotations);
            }
            if (ctAnnotations != null) {
                methodInfo.addAttribute((AttributeInfo)ctAnnotations);
            }
            targetCtClass.addMethod(addMeCtMethod);
        }
        for (Map.Entry getterEntry : getters.entrySet()) {
            String getterProperty = (String)getterEntry.getKey();
            MethodInformation mi = (MethodInformation)getterEntry.getValue();
            if (setters.contains(getterProperty)) continue;
            String getterName = mi.originalMethod.getName();
            String setterName = Utilities.convertToSetter(getterName);
            sb = new StringBuffer("private void " + setterName + "(");
            sb.append(mi.getterSetterType.getName() + " arg0) { super._setProperty(\"" + mi.representedProperty + "\", arg0); }");
            CtMethod addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            targetCtClass.addMethod(addMeCtMethod);
        }
        Class proxy = targetCtClass.toClass(convertMe.getClassLoader(), convertMe.getProtectionDomain());
        retVal.setTranslatedClass(proxy);
        this.proxy2NodeCache.put(proxy, retVal);
        return retVal;
    }

    private static void createAnnotationCopy(ConstPool parent, java.lang.annotation.Annotation javaAnnotation, AnnotationsAttribute retVal) throws Throwable {
        Annotation annotation = new Annotation(javaAnnotation.annotationType().getName(), parent);
        for (Method javaAnnotationMethod : javaAnnotation.annotationType().getMethods()) {
            Object value;
            if (javaAnnotationMethod.getParameterTypes().length != 0 || DO_NOT_HANDLE_METHODS.contains(javaAnnotationMethod.getName())) continue;
            Class<?> javaAnnotationType = javaAnnotationMethod.getReturnType();
            if (String.class.equals(javaAnnotationType)) {
                value = (String)ReflectionHelper.invoke((Object)javaAnnotation, (Method)javaAnnotationMethod, (Object[])new Object[0], (boolean)false);
                annotation.addMemberValue(javaAnnotationMethod.getName(), (MemberValue)new StringMemberValue((String)value, parent));
                continue;
            }
            if (Boolean.TYPE.equals(javaAnnotationType)) {
                boolean value2 = (Boolean)ReflectionHelper.invoke((Object)javaAnnotation, (Method)javaAnnotationMethod, (Object[])new Object[0], (boolean)false);
                annotation.addMemberValue(javaAnnotationMethod.getName(), (MemberValue)new BooleanMemberValue(value2, parent));
                continue;
            }
            if (Class.class.equals(javaAnnotationType)) {
                value = (Class)ReflectionHelper.invoke((Object)javaAnnotation, (Method)javaAnnotationMethod, (Object[])new Object[0], (boolean)false);
                String sValue = value == null ? null : ((Class)value).getName();
                annotation.addMemberValue(javaAnnotationMethod.getName(), (MemberValue)new ClassMemberValue(sValue, parent));
                continue;
            }
            throw new AssertionError((Object)("Annotation type " + javaAnnotationType.getName() + " is not yet implemented"));
        }
        retVal.addAnnotation(annotation);
    }

    private static void getAllToConvert(Class<?> toBeConverted, LinkedHashSet<Class<?>> needsToBeConverted) {
        if (needsToBeConverted.contains(toBeConverted)) {
            return;
        }
        for (Method method : toBeConverted.getMethods()) {
            Class childClass;
            Type listReturnType;
            Class returnRawClass;
            String methodName = method.getName();
            if (!methodName.startsWith(GET)) continue;
            Class<?> returnClass = method.getReturnType();
            if (returnClass.isInterface() && !List.class.equals(returnClass)) {
                JAUtilities.getAllToConvert(returnClass, needsToBeConverted);
                continue;
            }
            Type retType = method.getGenericReturnType();
            if (retType == null || !(retType instanceof ParameterizedType) || (returnRawClass = ReflectionHelper.getRawClass((Type)retType)) == null || !List.class.equals((Object)returnRawClass) || Object.class.equals((Object)(listReturnType = ReflectionHelper.getFirstTypeArgument((Type)retType))) || (childClass = ReflectionHelper.getRawClass((Type)listReturnType)) == null || Object.class.equals((Object)childClass)) continue;
            JAUtilities.getAllToConvert(childClass, needsToBeConverted);
        }
        needsToBeConverted.add(toBeConverted);
    }

    private static MethodInformation getMethodInformation(Method m, Map<String, String> xmlNameMap) {
        Type typeChildType;
        String variable;
        MethodType methodType;
        String setterVariable = Utilities.isSetter(m);
        String getterVariable = null;
        String lookupVariable = null;
        String addVariable = null;
        String removeVariable = null;
        if (setterVariable == null && (getterVariable = Utilities.isGetter(m)) == null && (lookupVariable = Utilities.isLookup(m)) == null && (addVariable = Utilities.isAdd(m)) == null) {
            removeVariable = Utilities.isRemove(m);
        }
        if (setterVariable == null && getterVariable == null && lookupVariable == null && addVariable == null && removeVariable == null) {
            throw new RuntimeException("Unknown method type, neither setter nor getter nor lookup: " + m);
        }
        Class baseChildType = null;
        Class gsType = null;
        boolean isList = false;
        if (getterVariable != null) {
            Class returnType;
            methodType = MethodType.GETTER;
            variable = getterVariable;
            gsType = returnType = m.getReturnType();
            if (List.class.equals(returnType)) {
                isList = true;
                typeChildType = ReflectionHelper.getFirstTypeArgument((Type)m.getGenericReturnType());
                baseChildType = ReflectionHelper.getRawClass((Type)typeChildType);
                if (baseChildType == null) {
                    throw new RuntimeException("Cannot find child type of method " + m);
                }
            } else if (returnType.isInterface()) {
                baseChildType = returnType;
            }
        } else if (setterVariable != null) {
            Class setterType;
            methodType = MethodType.SETTER;
            variable = setterVariable;
            gsType = setterType = m.getParameterTypes()[0];
            if (List.class.equals(setterType)) {
                isList = true;
                typeChildType = ReflectionHelper.getFirstTypeArgument((Type)m.getGenericParameterTypes()[0]);
                baseChildType = ReflectionHelper.getRawClass((Type)typeChildType);
                if (baseChildType == null) {
                    throw new RuntimeException("Cannot find child type of method " + m);
                }
            } else if (setterType.isInterface()) {
                baseChildType = setterType;
            }
        } else if (lookupVariable != null) {
            methodType = MethodType.LOOKUP;
            variable = lookupVariable;
            Class<?> lookupType = m.getReturnType();
            gsType = lookupType;
        } else if (addVariable != null) {
            methodType = MethodType.ADD;
            variable = addVariable;
        } else if (removeVariable != null) {
            methodType = MethodType.REMOVE;
            variable = addVariable;
        } else {
            throw new RuntimeException("Unknown method type: " + m);
        }
        String representedProperty = xmlNameMap.get(variable);
        if (representedProperty == null) {
            representedProperty = variable;
        }
        boolean key = false;
        if (m.getAnnotation(XmlID.class) != null || m.getAnnotation(XmlIdentifier.class) != null) {
            key = true;
        }
        return new MethodInformation(m, methodType, representedProperty, baseChildType, gsType, key, isList);
    }

    static {
        DO_NOT_HANDLE_METHODS.add("hashCode");
        DO_NOT_HANDLE_METHODS.add("equals");
        DO_NOT_HANDLE_METHODS.add("toString");
        DO_NOT_HANDLE_METHODS.add("annotationType");
    }

    private static enum MethodType {
        GETTER,
        SETTER,
        LOOKUP,
        ADD,
        REMOVE;

    }

    private static class MethodInformation {
        private final Method originalMethod;
        private final MethodType methodType;
        private final Class<?> getterSetterType;
        private final String representedProperty;
        private final Class<?> baseChildType;
        private final boolean key;
        private final boolean isList;

        private MethodInformation(Method originalMethod, MethodType methodType, String representedProperty, Class<?> baseChildType, Class<?> gsType, boolean key, boolean isList) {
            this.originalMethod = originalMethod;
            this.methodType = methodType;
            this.representedProperty = representedProperty;
            this.baseChildType = baseChildType;
            this.getterSetterType = gsType;
            this.key = key;
            this.isList = isList;
        }

        public String toString() {
            return "MethodInformation(" + this.originalMethod.getName() + "," + (Object)((Object)this.methodType) + "," + this.getterSetterType + "," + this.representedProperty + "," + this.baseChildType + "," + this.key + "," + System.identityHashCode(this) + ")";
        }
    }
}

