/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.xml.internal.ParentedNode;

public class UnparentedNode
implements Serializable {
    private static final long serialVersionUID = -1875168445525432246L;
    private final Object lock = new Object();
    private Class<?> originalInterface;
    private Class<?> translatedClass;
    private String rootName;
    private final Map<Class<?>, ParentedNode> children = new HashMap();
    private final Map<String, ParentedNode> childrenByName = new HashMap<String, ParentedNode>();
    private final Set<String> nonChildProperty = new HashSet<String>();
    private Set<String> unKeyedChildren = null;
    private String keyProperty;

    public UnparentedNode() {
    }

    public UnparentedNode(Class<?> originalInterface) {
        this.originalInterface = originalInterface;
    }

    public Class<?> getOriginalInterface() {
        return this.originalInterface;
    }

    public Class<?> getTranslatedClass() {
        return this.translatedClass;
    }

    public void setTranslatedClass(Class<?> translatedClass) {
        this.translatedClass = translatedClass;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(String xmlTag, boolean multiChild, UnparentedNode child) {
        Object object = this.lock;
        synchronized (object) {
            ParentedNode pn = new ParentedNode(xmlTag, multiChild, child);
            this.children.put(child.getOriginalInterface(), pn);
            this.childrenByName.put(xmlTag, pn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonChildProperty(String xmlTag) {
        Object object = this.lock;
        synchronized (object) {
            this.nonChildProperty.add(xmlTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentedNode getChild(Class<?> childType) {
        Object object = this.lock;
        synchronized (object) {
            return this.children.get(childType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentedNode getChild(String propName) {
        Object object = this.lock;
        synchronized (object) {
            return this.childrenByName.get(propName);
        }
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnKeyedChildren() {
        Object object = this.lock;
        synchronized (object) {
            if (this.unKeyedChildren != null) {
                return this.unKeyedChildren;
            }
            this.unKeyedChildren = new HashSet<String>();
            for (Map.Entry<String, ParentedNode> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChild().getKeyProperty() != null) continue;
                this.unKeyedChildren.add(entry.getKey());
            }
            return this.unKeyedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNonChildProperties() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.nonChildProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ParentedNode> getChildrenProperties() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.childrenByName);
        }
    }

    public String toString() {
        return "UnparentedNode(" + this.originalInterface + "," + System.identityHashCode(this) + ")";
    }
}

