/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Utilities {
    public static final char INSTANCE_PATH_SEPARATOR = '.';

    static String isGetter(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            if (name.length() <= "get".length()) {
                return null;
            }
            if (method.getParameterTypes().length != 0) {
                return null;
            }
            if (Void.TYPE.equals(method.getReturnType())) {
                return null;
            }
            String variableName = name.substring("get".length());
            return Introspector.decapitalize(variableName);
        }
        if (name.startsWith("is")) {
            if (name.length() <= "is".length()) {
                return null;
            }
            if (method.getParameterTypes().length != 0) {
                return null;
            }
            if (Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType())) {
                String variableName = name.substring("is".length());
                return Introspector.decapitalize(variableName);
            }
            return null;
        }
        return null;
    }

    static String isSetter(Method method) {
        String name = method.getName();
        if (name.startsWith("set")) {
            if (name.length() <= "set".length()) {
                return null;
            }
            if (method.getParameterTypes().length != 1) {
                return null;
            }
            if (Void.TYPE.equals(method.getReturnType())) {
                String variableName = name.substring("set".length());
                return Introspector.decapitalize(variableName);
            }
            return null;
        }
        return null;
    }

    static String isLookup(Method method) {
        String name = method.getName();
        if (!name.startsWith("lookup")) {
            return null;
        }
        if (name.length() <= "lookup".length()) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return null;
        }
        if (!String.class.equals(parameterTypes[0])) {
            return null;
        }
        if (method.getReturnType() == null || Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        String variableName = name.substring("lookup".length());
        return Introspector.decapitalize(variableName);
    }

    static String isAdd(Method method) {
        String name = method.getName();
        if (!name.startsWith("add")) {
            return null;
        }
        if (name.length() <= "add".length()) {
            return null;
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        String variableName = name.substring("add".length());
        String retVal = Introspector.decapitalize(variableName);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 2) {
            return null;
        }
        if (parameterTypes.length == 0) {
            return retVal;
        }
        Class<?> param0 = parameterTypes[0];
        Class<?> param1 = null;
        if (parameterTypes.length == 2) {
            param1 = parameterTypes[1];
        }
        if (String.class.equals(param0) || Integer.TYPE.equals(param0) || param0.isInterface()) {
            if (parameterTypes.length == 1) {
                return retVal;
            }
            if (Integer.TYPE.equals(param0)) {
                return null;
            }
            if (String.class.equals(param0) ? Integer.TYPE.equals(param1) : Integer.TYPE.equals(param1)) {
                return retVal;
            }
        }
        return null;
    }

    static String isRemove(Method method) {
        String name = method.getName();
        if (!name.startsWith("remove")) {
            return null;
        }
        if (name.length() <= "remove".length()) {
            return null;
        }
        if (method.getReturnType() == null || Void.TYPE.equals(method.getReturnType())) {
            return null;
        }
        String variableName = name.substring("remove".length());
        String retVal = Introspector.decapitalize(variableName);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            return null;
        }
        if (parameterTypes.length == 0) {
            return retVal;
        }
        Class<?> param0 = parameterTypes[0];
        if (String.class.equals(param0) || Integer.TYPE.equals(param0)) {
            return retVal;
        }
        return null;
    }

    static String getRootElementName(Class<?> clazz) {
        XmlRootElement root = clazz.getAnnotation(XmlRootElement.class);
        if (root == null) {
            throw new AssertionError((Object)("XmlRootElement not available on " + clazz.getName()));
        }
        return Utilities.convertXmlRootElementName(root, clazz);
    }

    static String convertXmlRootElementName(XmlRootElement root, Class<?> clazz) {
        if (!"##default".equals(root.name())) {
            return root.name();
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    public static BaseHK2JAXBBean createBean(Class<?> implClass) {
        try {
            Constructor<?> noArgsConstructor = implClass.getConstructor(new Class[0]);
            return (BaseHK2JAXBBean)ReflectionHelper.makeMe(noArgsConstructor, (Object[])new Object[0], (boolean)false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static String getKeySegment(BaseHK2JAXBBean bean) {
        String baseKeySegment = bean._getKeyValue();
        if (baseKeySegment == null) {
            baseKeySegment = bean._getSelfXmlTag();
        }
        return baseKeySegment;
    }

    public static String createInstanceName(BaseHK2JAXBBean bean) {
        if (bean._getParent() == null) {
            return Utilities.getKeySegment(bean);
        }
        return Utilities.createInstanceName((BaseHK2JAXBBean)bean._getParent()) + '.' + Utilities.getKeySegment(bean);
    }

    public static void advertise(WriteableBeanDatabase wbd, DynamicConfiguration config, BaseHK2JAXBBean bean) {
        if (config != null) {
            AbstractActiveDescriptor cDesc = BuilderHelper.createConstantDescriptor((Object)bean);
            if (bean._getKeyValue() != null) {
                cDesc.setName(bean._getKeyValue());
            }
            config.addActiveDescriptor((ActiveDescriptor)cDesc);
        }
        if (wbd != null) {
            WriteableType wt = wbd.findOrAddWriteableType(bean._getXmlPath());
            wt.addInstance(bean._getInstanceName(), bean._getBeanLikeMap());
        }
    }

    public static String convertToSetter(String getterName) {
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring("is".length());
        }
        if (!getterName.startsWith("get")) {
            throw new IllegalArgumentException("Unknown getter format: " + getterName);
        }
        return "set" + getterName.substring("get".length());
    }
}

