/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ParentedNode;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

@Singleton
public class XmlServiceImpl
implements XmlService {
    private static final String ID_PREFIX = "XmlServiceUID-";
    private final JAUtilities jaUtilities = new JAUtilities();
    @Inject
    private DynamicConfigurationService dynamicConfigurationService;
    @Inject
    private Hub hub;
    private final ClassReflectionHelper classReflectionHelper = new ClassReflectionHelperImpl();
    private final AtomicLong idGenerator = new AtomicLong();

    public String getUniqueId() {
        return ID_PREFIX + this.idGenerator.getAndAdd(1L);
    }

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedClassOrInterface) {
        return this.unmarshall(uri, jaxbAnnotatedClassOrInterface, true, true);
    }

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (uri == null || jaxbAnnotatedInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            UnparentedNode parent = this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface);
            return this.unmarshallClass(uri, parent, advertiseInRegistry, advertiseInHub);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MultiException((Throwable)e);
        }
    }

    private <T> XmlRootHandle<T> unmarshallClass(URI uri, UnparentedNode node, boolean advertise, boolean advertiseInHub) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{node.getTranslatedClass()});
        Listener listener = new Listener();
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setListener((Unmarshaller.Listener)listener);
        Object root = unmarshaller.unmarshal(uri.toURL());
        DynamicChangeInfo changeControl = new DynamicChangeInfo(this.jaUtilities, this.hub, this, advertise ? this.dynamicConfigurationService : null);
        for (BaseHK2JAXBBean base : listener.getAllBeans()) {
            String instanceName = Utilities.createInstanceName(base);
            base._setInstanceName(instanceName);
            base._setDynamicChangeInfo(changeControl);
        }
        DynamicConfiguration config = advertise ? this.dynamicConfigurationService.createDynamicConfiguration() : null;
        WriteableBeanDatabase wdb = advertiseInHub ? this.hub.getWriteableDatabaseCopy() : null;
        for (BaseHK2JAXBBean bean : listener.getAllBeans()) {
            Utilities.advertise(wdb, config, bean);
        }
        if (config != null) {
            config.commit();
        }
        if (wdb != null) {
            wdb.commit((Object)new XmlHubCommitMessage(){});
        }
        return new XmlRootHandleImpl<Object>(this, this.hub, root, node, uri, advertise, advertiseInHub, changeControl);
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            UnparentedNode node = this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface);
            return new XmlRootHandleImpl<Object>(this, this.hub, null, node, null, advertiseInRegistry, advertiseInHub, new DynamicChangeInfo(this.jaUtilities, this.hub, this, advertiseInRegistry ? this.dynamicConfigurationService : null));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MultiException((Throwable)e);
        }
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotationInterface) {
        return this.createEmptyHandle(jaxbAnnotationInterface, true, true);
    }

    @Override
    public <T> T createBean(Class<T> beanInterface) {
        if (!beanInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + beanInterface.getName());
        }
        UnparentedNode node = this.jaUtilities.convertRootAndLeaves(beanInterface);
        BaseHK2JAXBBean retVal = Utilities.createBean(node.getTranslatedClass());
        retVal._setModel(node, this.classReflectionHelper);
        return (T)retVal;
    }

    ClassReflectionHelper getClassReflectionHelper() {
        return this.classReflectionHelper;
    }

    DynamicConfigurationService getDynamicConfigurationService() {
        return this.dynamicConfigurationService;
    }

    private class Listener
    extends Unmarshaller.Listener {
        private final LinkedList<BaseHK2JAXBBean> allBeans = new LinkedList();

        private Listener() {
        }

        public void afterUnmarshal(Object target, Object parent) {
            if (!(target instanceof BaseHK2JAXBBean)) {
                return;
            }
            BaseHK2JAXBBean targetBean = (BaseHK2JAXBBean)target;
            UnparentedNode targetNode = XmlServiceImpl.this.jaUtilities.getNode(target.getClass());
            String keyPropertyName = targetNode.getKeyProperty();
            String keyProperty = null;
            if (keyPropertyName != null) {
                keyProperty = (String)targetBean._getProperty(keyPropertyName);
                targetBean._setKeyValue(keyProperty);
            }
            targetBean._setParent(parent);
            this.allBeans.add(targetBean);
            if (parent == null) {
                return;
            }
            BaseHK2JAXBBean parentBean = (BaseHK2JAXBBean)parent;
            UnparentedNode parentNode = XmlServiceImpl.this.jaUtilities.getNode(parent.getClass());
            ParentedNode childNode = parentNode.getChild(targetNode.getOriginalInterface());
            if (keyProperty == null) {
                if (childNode.isMultiChild()) {
                    targetBean._setKeyValue(XmlServiceImpl.this.getUniqueId());
                }
            } else {
                parentBean._addChild(childNode.getChildName(), keyProperty, targetBean);
            }
        }

        public void beforeUnmarshal(Object target, Object parent) {
            if (!(target instanceof BaseHK2JAXBBean)) {
                return;
            }
            BaseHK2JAXBBean baseBean = (BaseHK2JAXBBean)target;
            BaseHK2JAXBBean parentBean = (BaseHK2JAXBBean)parent;
            UnparentedNode baseNode = XmlServiceImpl.this.jaUtilities.getNode(target.getClass());
            baseBean._setModel(baseNode, XmlServiceImpl.this.classReflectionHelper);
            if (parentBean == null) {
                baseBean._setSelfXmlTag(baseNode.getRootName());
            } else {
                baseBean._setParentXmlPath(parentBean._getXmlPath());
                UnparentedNode parentNode = XmlServiceImpl.this.jaUtilities.getNode(parent.getClass());
                ParentedNode childNode = parentNode.getChild(baseNode.getOriginalInterface());
                baseBean._setSelfXmlTag(childNode.getChildName());
            }
        }

        private LinkedList<BaseHK2JAXBBean> getAllBeans() {
            return this.allBeans;
        }
    }
}

