/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.adds;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Employee;
import org.glassfish.hk2.xml.test.basic.Employees;
import org.glassfish.hk2.xml.test.basic.Financials;
import org.glassfish.hk2.xml.test.basic.OtherData;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class AddsTest {
    private static final String DAVE = "Dave";
    private static final String EMPLOYEE_TYPE = "/employees/employee";
    private static final String OTHER_DATA_TYPE = "/employees/other-data";
    private static final String DAVE_INSTANCE = "employees.Dave";
    private static final String ATT_SYMBOL = "ATT";
    private static final String NASDAQ = "Nasdaq";
    private static final long ALICE_ID = 12L;
    private static final long BOB_ID = 14L;
    private static final long CAROL_ID = 16L;
    private static final String DATA1 = "Spiner";
    private static final String DATA2 = "10100101";

    @Test
    public void testCreateAndAdd() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        Assert.assertNull((Object)rootHandle.getRoot());
        rootHandle.addRoot();
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.getFinancials());
        Assert.assertNull(root.getEmployees());
        Assert.assertNull((Object)root.getCompanyName());
    }

    @Test
    public void testAddToExistingTree() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addEmployees(DAVE);
        Employee daveDirect = employees.lookupEmployees(DAVE);
        Assert.assertNotNull((Object)daveDirect);
        Employee daveService = (Employee)locator.getService(Employee.class, DAVE, new Annotation[0]);
        Assert.assertNotNull((Object)daveService);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, DAVE_INSTANCE));
    }

    @Test
    public void testAddToExistingTreeUnKeyed() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addOtherData(0);
        OtherData found = null;
        for (OtherData other : employees.getOtherData()) {
            Assert.assertNull(found);
            found = other;
        }
        Assert.assertNotNull(found);
        OtherData otherService = (OtherData)locator.getService(OtherData.class, new Annotation[0]);
        Assert.assertNotNull((Object)otherService);
        Assert.assertEquals((Object)found, (Object)otherService);
        Type type = hub.getCurrentDatabase().getType(OTHER_DATA_TYPE);
        Instance foundInstance = null;
        for (Instance i : type.getInstances().values()) {
            Assert.assertNull(foundInstance);
            foundInstance = i;
        }
        Assert.assertNotNull(foundInstance);
    }

    @Test
    public void testAddToExistingTreeDirect() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme2.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertNull((Object)employees.getFinancials());
        employees.addFinancials();
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertNull((Object)financials.getExchange());
        Assert.assertNull((Object)financials.getSymbol());
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance("/employees/financials", "employees.financials"));
    }

    private static Employee createEmployee(XmlService xmlService, String name, long id) {
        Employee employee = (Employee)xmlService.createBean(Employee.class);
        employee.setName(name);
        employee.setId(id);
        return employee;
    }

    private static OtherData createOtherData(XmlService xmlService, String data) {
        OtherData other = (OtherData)xmlService.createBean(OtherData.class);
        other.setData(data);
        return other;
    }

    private static void checkEmployee(Employee employee, String name, long id) {
        Assert.assertNotNull((Object)employee);
        Assert.assertEquals((Object)name, (Object)employee.getName());
        Assert.assertEquals((long)id, (long)employee.getId());
    }

    private static void checkOtherData(OtherData other, String data) {
        Assert.assertNotNull((Object)other);
        Assert.assertEquals((Object)data, (Object)other.getData());
    }

    private static void checkFinancials(Financials fin, String exchange, String symbol) {
        Assert.assertNotNull((Object)fin);
        Assert.assertEquals((Object)exchange, (Object)fin.getExchange());
        Assert.assertEquals((Object)symbol, (Object)fin.getSymbol());
    }

    @Test
    public void testAddOneLevelComplexRoot() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        Assert.assertNull((Object)rootHandle.getRoot());
        Employees employees = (Employees)xmlService.createBean(Employees.class);
        Financials financials = (Financials)xmlService.createBean(Financials.class);
        financials.setExchange(NASDAQ);
        financials.setSymbol(ATT_SYMBOL);
        employees.setFinancials(financials);
        Employee alice = AddsTest.createEmployee(xmlService, "Alice", 12L);
        Employee bob = AddsTest.createEmployee(xmlService, "Bob", 14L);
        Employee carol = AddsTest.createEmployee(xmlService, "Carol", 16L);
        employees.addEmployees(alice);
        employees.addEmployees(carol);
        employees.addEmployees(bob, 1);
        OtherData data1 = AddsTest.createOtherData(xmlService, DATA1);
        OtherData data2 = AddsTest.createOtherData(xmlService, DATA2);
        employees.addOtherData(data2);
        employees.addOtherData(data1, 0);
        rootHandle.addRoot((Object)employees);
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        AddsTest.checkFinancials(root.getFinancials(), NASDAQ, ATT_SYMBOL);
        AddsTest.checkEmployee(root.getEmployees().get(0), "Alice", 12L);
        AddsTest.checkEmployee(root.getEmployees().get(1), "Bob", 14L);
        AddsTest.checkEmployee(root.getEmployees().get(2), "Carol", 16L);
        AddsTest.checkOtherData(root.getOtherData().get(0), DATA1);
        AddsTest.checkOtherData(root.getOtherData().get(1), DATA2);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Alice", new Annotation[0]), "Alice", 12L);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Bob", new Annotation[0]), "Bob", 14L);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Carol", new Annotation[0]), "Carol", 16L);
        int lcv = 0;
        for (OtherData other : locator.getAllServices(OtherData.class, new Annotation[0])) {
            if (lcv == 0) {
                AddsTest.checkOtherData(other, DATA1);
            } else if (lcv == 1) {
                AddsTest.checkOtherData(other, DATA2);
            } else {
                Assert.fail((String)"Too many OtherData");
            }
            ++lcv;
        }
        Assert.assertEquals((long)2L, (long)lcv);
        AddsTest.checkFinancials((Financials)locator.getService(Financials.class, new Annotation[0]), NASDAQ, ATT_SYMBOL);
    }
}

