/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootCopyImpl;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class XmlRootHandleImpl<T>
implements XmlRootHandle<T> {
    private final XmlServiceImpl parent;
    private final Hub hub;
    private T root;
    private final UnparentedNode rootNode;
    private URI rootURI;
    private final boolean advertised;
    private final boolean advertisedInHub;
    private final DynamicChangeInfo changeControl;

    XmlRootHandleImpl(XmlServiceImpl parent, Hub hub, T root, UnparentedNode rootNode, URI rootURI, boolean advertised, boolean inHub, DynamicChangeInfo changes) {
        this.parent = parent;
        this.hub = hub;
        this.root = root;
        this.rootNode = rootNode;
        this.rootURI = rootURI;
        this.advertised = advertised;
        this.advertisedInHub = inHub;
        this.changeControl = changes;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public Class<T> getRootClass() {
        return this.rootNode.getOriginalInterface();
    }

    @Override
    public URI getURI() {
        return this.rootURI;
    }

    @Override
    public boolean isAdvertisedInLocator() {
        return this.advertised;
    }

    @Override
    public boolean isAdvertisedInHub() {
        return this.advertisedInHub;
    }

    @Override
    public void overlay(XmlRootHandle<T> newRoot) {
        throw new AssertionError((Object)"overlay not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlRootCopy<T> getXmlRootCopy() {
        Hub useHub = this.advertisedInHub ? this.hub : null;
        DynamicChangeInfo copyController = new DynamicChangeInfo(this.changeControl.getJAUtilities(), null, this.changeControl.getIdGenerator(), null, this.changeControl.getServiceLocator());
        this.changeControl.getReadLock().lock();
        try {
            BaseHK2JAXBBean copy;
            BaseHK2JAXBBean bean = (BaseHK2JAXBBean)this.root;
            if (bean == null) {
                XmlRootCopyImpl<Object> xmlRootCopyImpl = new XmlRootCopyImpl<Object>(useHub, this, this.changeControl.getChangeNumber(), null);
                return xmlRootCopyImpl;
            }
            try {
                copy = XmlRootHandleImpl.doCopy(bean, copyController);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            XmlRootCopyImpl<BaseHK2JAXBBean> xmlRootCopyImpl = new XmlRootCopyImpl<BaseHK2JAXBBean>(useHub, this, this.changeControl.getChangeNumber(), copy);
            return xmlRootCopyImpl;
        }
        finally {
            this.changeControl.getReadLock().unlock();
        }
    }

    private static BaseHK2JAXBBean doCopy(BaseHK2JAXBBean copyMe, DynamicChangeInfo copyController) throws Throwable {
        if (copyMe == null) {
            return null;
        }
        BaseHK2JAXBBean retVal = Utilities.createBean(copyMe.getClass());
        retVal._shallowCopyFrom(copyMe);
        Set<String> childrenProps = copyMe._getChildrenXmlTags();
        for (String childProp : childrenProps) {
            Object child = copyMe._getProperty(childProp);
            if (child == null) continue;
            if (child instanceof List) {
                List childList = (List)child;
                ArrayList<BaseHK2JAXBBean> toSetChildList = new ArrayList<BaseHK2JAXBBean>(childList.size());
                for (Object subChild : childList) {
                    BaseHK2JAXBBean copiedChild = XmlRootHandleImpl.doCopy((BaseHK2JAXBBean)subChild, copyController);
                    copiedChild._setParent(retVal);
                    toSetChildList.add(copiedChild);
                }
                retVal._setProperty(childProp, toSetChildList);
                continue;
            }
            BaseHK2JAXBBean copiedChild = XmlRootHandleImpl.doCopy((BaseHK2JAXBBean)child, copyController);
            copiedChild._setParent(retVal);
            retVal._setProperty(childProp, copiedChild);
        }
        retVal._setDynamicChangeInfo(copyController);
        return retVal;
    }

    long getRevision() {
        return this.changeControl.getChangeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoot(T newRoot) {
        this.changeControl.getWriteLock().lock();
        try {
            if (this.root != null) {
                throw new IllegalStateException("An attempt was made to add a root to a handle that already has a root " + this);
            }
            if (!(newRoot instanceof BaseHK2JAXBBean)) {
                throw new IllegalArgumentException("The added bean must be from XmlService.createBean");
            }
            WriteableBeanDatabase wbd = null;
            if (this.advertisedInHub) {
                wbd = this.hub.getWriteableDatabaseCopy();
            }
            DynamicConfiguration config = null;
            if (this.advertised) {
                config = this.parent.getDynamicConfigurationService().createDynamicConfiguration();
            }
            BaseHK2JAXBBean copiedRoot = BaseHK2JAXBBean._addRoot(this.rootNode, newRoot, this.changeControl, this.parent.getClassReflectionHelper(), wbd, config);
            if (config != null) {
                config.commit();
            }
            if (wbd != null) {
                wbd.commit((Object)new XmlHubCommitMessage(){});
            }
            this.root = copiedRoot;
        }
        finally {
            this.changeControl.getWriteLock().unlock();
        }
    }

    @Override
    public void addRoot() {
        this.addRoot(this.parent.createBean(this.rootNode.getOriginalInterface()));
    }

    @Override
    public T removeRoot() {
        throw new AssertionError((Object)"removeRoot not implemented");
    }

    DynamicChangeInfo getChangeInfo() {
        return this.changeControl;
    }

    public String toString() {
        return "XmlRootHandleImpl(" + this.root + "," + this.rootNode + "," + this.rootURI + "," + System.identityHashCode(this) + ")";
    }
}

