/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Constructor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.ArrayTypeAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.TypeElementAltClassImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Utilities {
    public static final char INSTANCE_PATH_SEPARATOR = '.';

    static String convertXmlRootElementName(XmlRootElement root, Class<?> clazz) {
        if (!"##default".equals(root.name())) {
            return root.name();
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    public static BaseHK2JAXBBean createBean(Class<?> implClass) {
        try {
            Constructor<?> noArgsConstructor = implClass.getConstructor(new Class[0]);
            return (BaseHK2JAXBBean)ReflectionHelper.makeMe(noArgsConstructor, (Object[])new Object[0], (boolean)false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static String getKeySegment(BaseHK2JAXBBean bean) {
        String baseKeySegment = bean._getKeyValue();
        if (baseKeySegment == null) {
            baseKeySegment = bean._getSelfXmlTag();
        }
        return baseKeySegment;
    }

    public static String createInstanceName(BaseHK2JAXBBean bean) {
        if (bean._getParent() == null) {
            return Utilities.getKeySegment(bean);
        }
        return Utilities.createInstanceName((BaseHK2JAXBBean)bean._getParent()) + '.' + Utilities.getKeySegment(bean);
    }

    public static void advertise(WriteableBeanDatabase wbd, DynamicConfiguration config, BaseHK2JAXBBean bean) {
        if (config != null) {
            AbstractActiveDescriptor cDesc = BuilderHelper.createConstantDescriptor((Object)bean);
            if (bean._getKeyValue() != null) {
                cDesc.setName(bean._getKeyValue());
            }
            config.addActiveDescriptor((ActiveDescriptor)cDesc);
        }
        if (wbd != null) {
            WriteableType wt = wbd.findOrAddWriteableType(bean._getXmlPath());
            wt.addInstance(bean._getInstanceName(), bean._getBeanLikeMap());
        }
    }

    public static String convertToSetter(String getterName) {
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring("is".length());
        }
        if (!getterName.startsWith("get")) {
            throw new IllegalArgumentException("Unknown getter format: " + getterName);
        }
        return "set" + getterName.substring("get".length());
    }

    public static String convertNameToString(Name name) {
        if (name == null) {
            return null;
        }
        return name.toString();
    }

    public static AltClass convertTypeMirror(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        if (TypeKind.VOID.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.VOID;
        }
        if (TypeKind.BOOLEAN.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BOOLEAN;
        }
        if (TypeKind.INT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.INT;
        }
        if (TypeKind.LONG.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.LONG;
        }
        if (TypeKind.BYTE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BYTE;
        }
        if (TypeKind.CHAR.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.CHAR;
        }
        if (TypeKind.SHORT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.SHORT;
        }
        if (TypeKind.FLOAT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.FLOAT;
        }
        if (TypeKind.DOUBLE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.DOUBLE;
        }
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            DeclaredType dt = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dt.asElement();
            TypeElementAltClassImpl addMe = new TypeElementAltClassImpl(typeElement, processingEnv);
            return addMe;
        }
        if (TypeKind.ARRAY.equals((Object)typeMirror.getKind())) {
            ArrayType at = (ArrayType)typeMirror;
            return new ArrayTypeAltClassImpl(at, processingEnv);
        }
        throw new AssertionError((Object)("Unknown parameter kind: " + (Object)((Object)typeMirror.getKind())));
    }
}

