/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.customizer;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.customizer.CustomizerOne;
import org.glassfish.hk2.xml.test.customizer.MuseumBean;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class CustomizerTest {
    private static final String PREFIX = "Go ";
    private static final String POSTFIX = " Eagles";
    public static final boolean C4 = false;
    public static final int C5 = 5;
    public static final long C6 = 6L;
    public static final float C7 = 7.0f;
    public static final double C8 = 8.0;
    public static final byte C9 = 9;
    public static final short C10 = 10;
    public static final char C11 = 'E';

    @Test
    public void testBasicCustomizerOnRoot() throws Exception {
        ServiceLocator locator = Utilities.createLocator(CustomizerOne.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), MuseumBean.class);
        MuseumBean museum = (MuseumBean)rootHandle.getRoot();
        String retVal = museum.customizer1(PREFIX, POSTFIX);
        Assert.assertEquals((Object)retVal, (Object)"Go Ben Franklin Eagles");
        CustomizerOne customizer = (CustomizerOne)locator.getService(CustomizerOne.class, new Annotation[0]);
        Assert.assertFalse((boolean)customizer.getCustomizer2Called());
        museum.customizer2();
        Assert.assertTrue((boolean)customizer.getCustomizer2Called());
        long[] c3 = museum.customizer3(null);
        Assert.assertNotNull((Object)c3);
        Assert.assertEquals((long)0L, (long)c3.length);
        Assert.assertEquals((Object)false, (Object)museum.customizer4());
        Assert.assertEquals((long)5L, (long)museum.customizer5());
        Assert.assertEquals((long)6L, (long)museum.customizer6());
        Assert.assertEquals((long)0L, (long)Float.compare(7.0f, museum.customizer7()));
        Assert.assertEquals((long)0L, (long)Double.compare(8.0, museum.customizer8()));
        Assert.assertEquals((long)9L, (long)museum.customizer9());
        Assert.assertEquals((long)10L, (long)museum.customizer10());
        Assert.assertEquals((long)69L, (long)museum.customizer11());
        int varSize = museum.customizer12(false, 5, 6L, 7.0f, 8.0, (byte)9, (short)10, 'E', new int[0][]);
        Assert.assertEquals((long)0L, (long)varSize);
        int[] i1 = new int[]{1, 2, 3};
        int[] i2 = new int[]{4, 5, 6, 7};
        varSize = museum.customizer12(false, 5, 6L, 7.0f, 8.0, (byte)9, (short)10, 'E', i1, i2);
        Assert.assertEquals((long)2L, (long)varSize);
        Assert.assertFalse((boolean)customizer.getFauxAddCalled());
        museum.addListener(null);
        Assert.assertTrue((boolean)customizer.getFauxAddCalled());
        String[] uppers = museum.toUpper(new String[]{"Go", "Eagles"});
        Assert.assertEquals((Object)"GO", (Object)uppers[0]);
        Assert.assertEquals((Object)"EAGLES", (Object)uppers[1]);
        Assert.assertEquals((long)2L, (long)uppers.length);
    }
}

