/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.api.annotations.DefaultChild;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Generator;
import org.glassfish.hk2.xml.internal.MethodInformation;
import org.glassfish.hk2.xml.internal.MethodType;
import org.glassfish.hk2.xml.internal.NameInformation;
import org.glassfish.hk2.xml.internal.ParentedNode;
import org.glassfish.hk2.xml.internal.UnparentedNode;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.MethodAltMethodImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class JAUtilities {
    private static final String ID_PREFIX = "XmlServiceUID-";
    private static final boolean DEBUG_METHODS = Boolean.parseBoolean(GeneralUtilities.getSystemProperty((String)"org.jvnet.hk2.properties.xmlservice.jaxb.methods", (String)"false"));
    private static final boolean DEBUG_PREGEN = Boolean.parseBoolean(GeneralUtilities.getSystemProperty((String)"org.jvnet.hk2.properties.xmlservice.jaxb.pregenerated", (String)"false"));
    static final boolean DEBUG_GENERATION_TIMING = Boolean.parseBoolean(GeneralUtilities.getSystemProperty((String)"org.jvnet.hk2.properties.xmlservice.jaxb.generationtime", (String)"false"));
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";
    public static final String LOOKUP = "lookup";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String JAXB_DEFAULT_STRING = "##default";
    public static final String JAXB_DEFAULT_DEFAULT = "\u0000";
    private static final String NO_CHILD_PACKAGE = "java.";
    private final HashMap<Class<?>, UnparentedNode> interface2NodeCache = new HashMap();
    private final HashMap<Class<?>, UnparentedNode> proxy2NodeCache = new HashMap();
    private final ClassPool defaultClassPool = ClassPool.getDefault();
    private final CtClass superClazz;
    private int numGeneratedClasses = 0;
    private int numFoundClasses = 0;
    private final AtomicLong idGenerator = new AtomicLong();

    JAUtilities() {
        try {
            this.superClazz = this.defaultClassPool.get(BaseHK2JAXBBean.class.getName());
        }
        catch (NotFoundException e) {
            throw new MultiException((Throwable)e);
        }
    }

    public String getUniqueId() {
        return ID_PREFIX + this.idGenerator.getAndAdd(1L);
    }

    public synchronized UnparentedNode getNode(Class<?> type) {
        UnparentedNode retVal = this.proxy2NodeCache.get(type);
        if (retVal == null) {
            return this.interface2NodeCache.get(type);
        }
        return retVal;
    }

    public synchronized UnparentedNode convertRootAndLeaves(Class<?> root) {
        ClassReflectionHelperImpl helper = new ClassReflectionHelperImpl();
        LinkedHashSet needsToBeConverted = new LinkedHashSet();
        JAUtilities.getAllToConvert(root, needsToBeConverted, new HashSet(), (ClassReflectionHelper)helper);
        long elapsedTime = 0L;
        if (DEBUG_METHODS || DEBUG_GENERATION_TIMING) {
            elapsedTime = System.currentTimeMillis();
            Logger.getLogger().debug("Converting " + needsToBeConverted.size() + " nodes for root " + root.getName());
        }
        needsToBeConverted.removeAll(this.interface2NodeCache.keySet());
        LinkedList<UnparentedNode> contributions = new LinkedList<UnparentedNode>();
        for (Class clazz : needsToBeConverted) {
            UnparentedNode converted;
            try {
                converted = this.convert(clazz, (ClassReflectionHelper)helper);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable e) {
                throw new MultiException(e);
            }
            this.interface2NodeCache.put(clazz, converted);
            contributions.add(converted);
        }
        for (UnparentedNode unparentedNode : contributions) {
            for (ParentedNode child : unparentedNode.getAllChildren()) {
                if (!child.getChild().isPlaceholder()) continue;
                UnparentedNode nonPlaceholder = this.interface2NodeCache.get(child.getChild().getOriginalInterface());
                if (nonPlaceholder == null) {
                    throw new RuntimeException("The child of type " + child.getChild().getOriginalInterface().getName() + " is unknown for " + unparentedNode);
                }
                child.setChild(nonPlaceholder);
            }
        }
        helper.dispose();
        if (DEBUG_METHODS || DEBUG_GENERATION_TIMING) {
            elapsedTime = System.currentTimeMillis() - elapsedTime;
            Logger.getLogger().debug("Converted " + needsToBeConverted.size() + " nodes.  " + "There were " + this.numFoundClasses + " pre-generated, and " + this.numGeneratedClasses + " dynamically generated.  Analysis took " + elapsedTime + " milliseconds");
        }
        return this.interface2NodeCache.get(root);
    }

    private UnparentedNode convert(Class<?> convertMe, ClassReflectionHelper helper) throws Throwable {
        Logger.getLogger().debug("XmlService converting " + convertMe.getName());
        UnparentedNode retVal = new UnparentedNode(convertMe);
        String targetClassName = convertMe.getName() + "_Hk2_Jaxb";
        CtClass foundClass = this.defaultClassPool.getOrNull(targetClassName);
        if (foundClass == null) {
            ++this.numGeneratedClasses;
            long elapsedTime = 0L;
            if (DEBUG_PREGEN) {
                elapsedTime = System.nanoTime();
                Logger.getLogger().debug("Dynamically generating impl for " + targetClassName);
            }
            CtClass generated = Generator.generate(new ClassAltClassImpl(convertMe, helper), this.superClazz, this.defaultClassPool);
            generated.toClass(convertMe.getClassLoader(), convertMe.getProtectionDomain());
            if (DEBUG_PREGEN) {
                elapsedTime = System.nanoTime() - elapsedTime;
                Logger.getLogger().debug("Generating impl for " + targetClassName + " took " + elapsedTime + " nanoseconds");
            }
            foundClass = this.defaultClassPool.getOrNull(targetClassName);
        } else {
            ++this.numFoundClasses;
        }
        Class<?> proxy = convertMe.getClassLoader().loadClass(targetClassName);
        XmlRootElement xre = convertMe.getAnnotation(XmlRootElement.class);
        if (xre != null) {
            String rootName = Utilities.convertXmlRootElementName(xre, convertMe);
            retVal.setRootName(rootName);
        }
        ClassAltClassImpl altConvertMe = new ClassAltClassImpl(convertMe, helper);
        NameInformation xmlNameMap = Generator.getXmlNameMap(altConvertMe);
        MethodInformation foundKey = null;
        for (AltMethod altMethodRaw : altConvertMe.getMethods()) {
            MethodAltMethodImpl altMethod = (MethodAltMethodImpl)altMethodRaw;
            MethodInformation mi = Generator.getMethodInformation(altMethod, xmlNameMap);
            if (DEBUG_METHODS) {
                Logger.getLogger().debug("Analyzing method " + mi + " of " + convertMe.getSimpleName());
            }
            if (mi.isKey()) {
                if (foundKey != null) {
                    throw new RuntimeException("Class " + convertMe.getName() + " has multiple key properties (" + altMethodRaw.getName() + " and " + foundKey.getOriginalMethod().getName());
                }
                foundKey = mi;
                retVal.setKeyProperty(mi.getRepresentedProperty());
            }
            boolean getterOrSetter = false;
            UnparentedNode childType = null;
            if (MethodType.SETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                if (mi.getBaseChildType() != null) {
                    childType = !this.interface2NodeCache.containsKey(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass()) ? new UnparentedNode(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass(), true) : this.interface2NodeCache.get(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass());
                }
            } else if (MethodType.GETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                if (mi.getBaseChildType() != null) {
                    childType = !this.interface2NodeCache.containsKey(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass()) ? new UnparentedNode(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass(), true) : this.interface2NodeCache.get(((ClassAltClassImpl)mi.getBaseChildType()).getOriginalClass());
                }
            }
            if (!getterOrSetter) continue;
            if (childType != null) {
                Map<String, String> defaultChild = null;
                AltAnnotation defaultChildAnnotation = mi.getOriginalMethod().getAnnotation(DefaultChild.class.getName());
                if (defaultChildAnnotation != null) {
                    String[] defaultStrings = defaultChildAnnotation.getStringArrayValue("value");
                    defaultChild = JAUtilities.convertDefaultChildValueArray(defaultStrings);
                }
                retVal.addChild(mi.getRepresentedProperty(), JAUtilities.getChildType(mi.isList(), mi.isArray()), childType, defaultChild);
                continue;
            }
            Class<?> expectedType = null;
            AltClass gsType = mi.getGetterSetterType();
            if (gsType instanceof ClassAltClassImpl) {
                expectedType = ((ClassAltClassImpl)gsType).getOriginalClass();
            }
            retVal.addNonChildProperty(mi.getRepresentedProperty(), mi.getDefaultValue(), expectedType);
        }
        retVal.setTranslatedClass(proxy);
        this.proxy2NodeCache.put(proxy, retVal);
        return retVal;
    }

    private static Map<String, String> convertDefaultChildValueArray(String[] values) {
        LinkedHashMap<String, String> retVal = new LinkedHashMap<String, String>();
        if (values == null) {
            return retVal;
        }
        for (String value : values) {
            if ("".equals(value = value.trim())) continue;
            if (value.charAt(0) == '=') {
                throw new AssertionError((Object)("First character of " + value + " may not be an ="));
            }
            int indexOfEquals = value.indexOf(61);
            if (indexOfEquals < 0) {
                retVal.put(value, null);
                continue;
            }
            String key = value.substring(0, indexOfEquals);
            String attValue = indexOfEquals >= value.length() - 1 ? null : value.substring(indexOfEquals + 1);
            retVal.put(key, attValue);
        }
        return retVal;
    }

    private static ChildType getChildType(boolean isList, boolean isArray) {
        if (isList) {
            return ChildType.LIST;
        }
        if (isArray) {
            return ChildType.ARRAY;
        }
        return ChildType.DIRECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAllToConvert(Class<?> toBeConverted, LinkedHashSet<Class<?>> needsToBeConverted, Set<Class<?>> cycleDetector, ClassReflectionHelper helper) {
        if (needsToBeConverted.contains(toBeConverted)) {
            return;
        }
        if (cycleDetector.contains(toBeConverted)) {
            return;
        }
        cycleDetector.add(toBeConverted);
        try {
            for (Method method : toBeConverted.getMethods()) {
                Class childClass;
                Type listReturnType;
                Class returnRawClass;
                Class<?> aType;
                if (Generator.isGetter(new MethodAltMethodImpl(method, helper)) == null) continue;
                Class<?> returnClass = method.getReturnType();
                if (returnClass.isInterface() && !List.class.equals(returnClass)) {
                    if (returnClass.getName().startsWith(NO_CHILD_PACKAGE)) continue;
                    JAUtilities.getAllToConvert(returnClass, needsToBeConverted, cycleDetector, helper);
                    continue;
                }
                if (returnClass.isArray() && (aType = returnClass.getComponentType()).isInterface()) {
                    JAUtilities.getAllToConvert(aType, needsToBeConverted, cycleDetector, helper);
                    continue;
                }
                Type retType = method.getGenericReturnType();
                if (retType == null || !(retType instanceof ParameterizedType) || (returnRawClass = ReflectionHelper.getRawClass((Type)retType)) == null || !List.class.equals((Object)returnRawClass) || Object.class.equals((Object)(listReturnType = ReflectionHelper.getFirstTypeArgument((Type)retType))) || (childClass = ReflectionHelper.getRawClass((Type)listReturnType)) == null || Object.class.equals((Object)childClass)) continue;
                JAUtilities.getAllToConvert(childClass, needsToBeConverted, cycleDetector, helper);
            }
            needsToBeConverted.add(toBeConverted);
        }
        finally {
            cycleDetector.remove(toBeConverted);
        }
    }
}

