/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.rawsets;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Museum;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RawSetsTest {
    public static final String MUSEUM2_FILE = "museum2.xml";
    private static final String MUSEUM_TYPE = "/museum";
    private static final String MUSEUM_INSTANCE = "museum";
    private static final String AGE_TAG = "age";
    private static final int ONE_OH_ONE_INT = 101;

    private void verifyPreState(XmlRootHandle<Museum> rootHandle, Hub hub) {
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)110, beanLikeMap.get(AGE_TAG));
    }

    @Test
    public void testModifySingleProperty() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        this.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        museum.setAge(101);
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List changes = listener.changes;
        Assert.assertNotNull((Object)changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        }
    }

    @Test
    public void testModifyTwoPropertiesOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        this.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        Museum museumCopy = (Museum)copy.getChildRoot();
        Museum museumOld = (Museum)rootHandle.getRoot();
        museumCopy.setAge(101);
        museumCopy.setId(101);
        this.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        copy.merge();
        Assert.assertEquals((long)101L, (long)museumOld.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museumOld.getName());
        Assert.assertEquals((long)101L, (long)museumOld.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List changes = listener.changes;
        Assert.assertNotNull((Object)changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
            List events = change.getModifiedProperties();
            Assert.assertEquals((long)2L, (long)events.size());
            boolean gotId = false;
            boolean gotAge = false;
            for (PropertyChangeEvent event : events) {
                if (AGE_TAG.equals(event.getPropertyName())) {
                    gotAge = true;
                    continue;
                }
                if (!"id".equals(event.getPropertyName())) continue;
                gotId = true;
            }
            Assert.assertTrue((boolean)gotId);
            Assert.assertTrue((boolean)gotAge);
        }
    }

    @Test
    @Ignore
    public void testOverlay() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        this.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        URL url2 = this.getClass().getClassLoader().getResource(MUSEUM2_FILE);
        XmlRootHandle rootHandle2 = xmlService.unmarshall(url2.toURI(), Museum.class, false, false);
        this.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        rootHandle.overlay(rootHandle2);
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)101L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List changes = listener.changes;
        Assert.assertNotNull((Object)changes);
        Assert.assertEquals((long)2L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        }
    }

    @Singleton
    private static class UpdateListener
    implements BeanDatabaseUpdateListener {
        private List<Change> changes;

        private UpdateListener() {
        }

        public void prepareDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }

        public void commitDatabaseChange(BeanDatabase oldDatabase, BeanDatabase currentDatabase, Object commitMessage, List<Change> changes) {
            this.changes = changes;
        }

        public void rollbackDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }
    }
}

