/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.basic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.lifecycle.config.Association;
import org.glassfish.hk2.xml.lifecycle.config.Associations;
import org.glassfish.hk2.xml.lifecycle.config.Environment;
import org.glassfish.hk2.xml.lifecycle.config.LifecycleConfig;
import org.glassfish.hk2.xml.lifecycle.config.Service;
import org.glassfish.hk2.xml.lifecycle.config.Tenant;
import org.glassfish.hk2.xml.test.basic.Employee;
import org.glassfish.hk2.xml.test.basic.Employees;
import org.glassfish.hk2.xml.test.basic.EverythingBagel;
import org.glassfish.hk2.xml.test.basic.Financials;
import org.glassfish.hk2.xml.test.basic.FooBarBean;
import org.glassfish.hk2.xml.test.basic.GreekEnum;
import org.glassfish.hk2.xml.test.basic.Museum;
import org.glassfish.hk2.xml.test.basic.OtherData;
import org.glassfish.hk2.xml.test.basic.RootWithCycle;
import org.glassfish.hk2.xml.test.basic.TypeBean;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class UnmarshallTest {
    public static final String MUSEUM1_FILE = "museum1.xml";
    public static final String ACME1_FILE = "Acme1.xml";
    public static final String ACME2_FILE = "Acme2.xml";
    private static final String SAMPLE_CONFIG_FILE = "sample-config.xml";
    private static final String CYCLE = "cycle.xml";
    private static final String TYPE1_FILE = "type1.xml";
    public static final String BEN_FRANKLIN = "Ben Franklin";
    public static final String ACME = "Acme";
    public static final String ALICE = "Alice";
    public static final String BOB = "Bob";
    public static final String CAROL = "Carol";
    public static final String DAVE = "Dave";
    public static final String ENGLEBERT = "Englebert";
    public static final String FRANK = "Frank";
    private static final String ACME_SYMBOL = "acme";
    private static final String NYSE = "NYSE";
    private static final String COKE_TENANT = "coke";
    private static final String HRPROD_SERVICE = "HRProd";
    public static final String FINANCIALS_TYPE = "/employees/financials";
    public static final String FINANCIALS_INSTANCE = "employees.financials";
    public static final int HUNDRED_INT = 100;
    public static final int HUNDRED_TEN_INT = 110;
    public static final long HUNDRED_LONG = 100L;
    public static final long HUNDRED_ONE_LONG = 101L;
    public static final String COMPANY_NAME_TAG = "company-name";
    public static final String EMPLOYEE_TAG = "employee";
    public static final String NAME_TAG = "name";
    public static final String ID_TAG = "id";
    private static final String COKE_ENV = "cokeenv";
    private static final String LIFECYCLE_ROOT_TYPE = "/lifecycle-config";
    private static final String LIFECYCLE_ROOT_INSTANCE = "lifecycle-config";
    private static final String LIFECYCLE_RUNTIMES_TYPE = "/lifecycle-config/runtimes";
    private static final String LIFECYCLE_RUNTIMES_INSTANCE = "lifecycle-config.runtimes";
    private static final String LIFECYCLE_TENANTS_TYPE = "/lifecycle-config/tenants";
    private static final String LIFECYCLE_TENANTS_INSTANCE = "lifecycle-config.tenants";
    private static final String LIFECYCLE_ENVIRONMENTS_TYPE = "/lifecycle-config/environments";
    private static final String LIFECYCLE_ENVIRONMENTS_INSTANCE = "lifecycle-config.environments";
    private static final String LIFECYCLE_RUNTIME_TYPE = "/lifecycle-config/runtimes/runtime";
    private static final String LIFECYCLE_RUNTIME_wlsRuntime_INSTANCE = "lifecycle-config.runtimes.wlsRuntime";
    private static final String LIFECYCLE_RUNTIME_DatabaseTestRuntime_INSTANCE = "lifecycle-config.runtimes.DatabaseTestRuntime";
    private static final String ASSOCIATION_PARTITION1_TYPE = "/lifecycle-config/environments/environment/associations/association/partition1";
    private static final String ASSOCIATION_PARTITION2_TYPE = "/lifecycle-config/environments/environment/associations/association/partition2";
    private static final String ASSOCIATION_PARTITION_INSTANCE_PREFIX = "lifecycle-config.environments.cokeenv.associations.";
    private static final String ASSOCIATION_PARTITION1_0_INSTANCE_APPENDIX = ".part1-0";
    private static final String ASSOCIATION_PARTITION2_0_INSTANCE_APPENDIX = ".part2-0";
    private static final String ASSOCIATION_PARTITION1_1_INSTANCE_APPENDIX = ".part1-1";
    private static final String ASSOCIATION_PARTITION2_1_INSTANCE_APPENDIX = ".part2-1";
    private static final String PART1_0_NAME = "part1-0";
    private static final String PART2_0_NAME = "part2-0";
    private static final String PART1_1_NAME = "part1-1";
    private static final String PART2_1_NAME = "part2-1";
    private static final String FOOBAR_ROOT_TYPE = "/foobar";
    private static final String FOOBAR_ROOT_INSTANCE = "foobar";
    private static final String FOOBAR_FOO_TYPE = "/foobar/foo";
    private static final String FOOBAR_FOO1_INSTANCE = "foobar.foo1";
    private static final String FOOBAR_FOO2_INSTANCE = "foobar.foo2";
    private static final String FOOBAR_BAR_TYPE = "/foobar/bar";
    private static final String FOOBAR_BAR1_INSTANCE = "foobar.bar1";
    private static final String FOOBAR_BAR2_INSTANCE = "foobar.bar2";

    @Test
    public void testInterfaceJaxbUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(MUSEUM1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)BEN_FRANKLIN, (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Museum asService = (Museum)locator.getService(Museum.class, new Annotation[0]);
        Assert.assertNotNull((Object)asService);
        Assert.assertEquals((Object)museum, (Object)asService);
    }

    @Test
    public void testBeanLikeMapOfInterface() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertTrue((boolean)(employees instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean hk2Configuration = (XmlHk2ConfigurationBean)employees;
        Map beanLikeMap = hk2Configuration._getBeanLikeMap();
        Assert.assertEquals((Object)ACME, beanLikeMap.get(COMPANY_NAME_TAG));
        List employeeChildList = (List)beanLikeMap.get(EMPLOYEE_TAG);
        Assert.assertNotNull((Object)employeeChildList);
        Assert.assertEquals((long)2L, (long)employeeChildList.size());
        boolean first = true;
        for (Employee employee : employeeChildList) {
            Assert.assertTrue((boolean)(employee instanceof XmlHk2ConfigurationBean));
            XmlHk2ConfigurationBean employeeConfiguration = (XmlHk2ConfigurationBean)employee;
            Map employeeBeanLikeMap = employeeConfiguration._getBeanLikeMap();
            if (first) {
                first = false;
                Assert.assertEquals((Object)100L, employeeBeanLikeMap.get(ID_TAG));
                Assert.assertEquals((Object)BOB, employeeBeanLikeMap.get(NAME_TAG));
                continue;
            }
            Assert.assertEquals((Object)101L, employeeBeanLikeMap.get(ID_TAG));
            Assert.assertEquals((Object)CAROL, employeeBeanLikeMap.get(NAME_TAG));
        }
        Assert.assertNotNull((Object)locator.getService(Employees.class, new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, BOB, new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, CAROL, new Annotation[0]));
    }

    @Test
    public void testInterfaceJaxbUnmarshallingWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertEquals((Object)ACME, (Object)employees.getCompanyName());
        Assert.assertEquals((long)2L, (long)employees.getEmployees().size());
        boolean first = true;
        for (Employee employee : employees.getEmployees()) {
            if (first) {
                first = false;
                Assert.assertEquals((long)100L, (long)employee.getId());
                Assert.assertEquals((Object)BOB, (Object)employee.getName());
                continue;
            }
            Assert.assertEquals((long)101L, (long)employee.getId());
            Assert.assertEquals((Object)CAROL, (Object)employee.getName());
        }
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertEquals((Object)ACME_SYMBOL, (Object)financials.getSymbol());
        Assert.assertEquals((Object)NYSE, (Object)financials.getExchange());
        Assert.assertEquals(Employees.class, (Object)rootHandle.getRootClass());
        Assert.assertEquals((Object)url, (Object)rootHandle.getURI().toURL());
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FINANCIALS_TYPE, FINANCIALS_INSTANCE));
    }

    @Test
    public void testComplexUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(SAMPLE_CONFIG_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), LifecycleConfig.class);
        LifecycleConfig lifecycleConfig = (LifecycleConfig)rootHandle.getRoot();
        Assert.assertNotNull((Object)lifecycleConfig);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_ROOT_TYPE, LIFECYCLE_ROOT_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIMES_TYPE, LIFECYCLE_RUNTIMES_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_TENANTS_TYPE, LIFECYCLE_TENANTS_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_ENVIRONMENTS_TYPE, LIFECYCLE_ENVIRONMENTS_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIME_TYPE, LIFECYCLE_RUNTIME_wlsRuntime_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIME_TYPE, LIFECYCLE_RUNTIME_DatabaseTestRuntime_INSTANCE));
        Tenant tenant = (Tenant)locator.getService(Tenant.class, COKE_TENANT, new Annotation[0]);
        Assert.assertNotNull((Object)tenant);
        Service hrProdService = tenant.lookupService(HRPROD_SERVICE);
        Assert.assertNotNull((Object)hrProdService);
        Assert.assertEquals((Object)HRPROD_SERVICE, (Object)hrProdService.getName());
    }

    @Test
    public void testUnkeyedChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(SAMPLE_CONFIG_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), LifecycleConfig.class);
        LifecycleConfig lifecycleConfig = (LifecycleConfig)rootHandle.getRoot();
        Assert.assertNotNull((Object)lifecycleConfig);
        Environment cokeEnv = (Environment)locator.getService(Environment.class, COKE_ENV, new Annotation[0]);
        Assert.assertNotNull((Object)cokeEnv);
        Associations associations = cokeEnv.getAssociations();
        Assert.assertNotNull((Object)associations);
        String generatedKey1 = null;
        String generatedKey2 = null;
        for (Association association : associations.getAssociations()) {
            XmlHk2ConfigurationBean bean = (XmlHk2ConfigurationBean)association;
            Assert.assertNull((Object)bean._getKeyPropertyName());
            if (generatedKey1 == null) {
                generatedKey1 = bean._getKeyValue();
                continue;
            }
            if (generatedKey2 == null) {
                generatedKey2 = bean._getKeyValue();
                continue;
            }
            Assert.fail((String)"Should only have been two associations, but we found at least three");
        }
        Assert.assertNotNull(generatedKey1);
        Assert.assertNotNull(generatedKey2);
        Assert.assertNotEquals(generatedKey1, generatedKey2);
        String part1_0_instance_name = ASSOCIATION_PARTITION_INSTANCE_PREFIX + generatedKey1 + ASSOCIATION_PARTITION1_0_INSTANCE_APPENDIX;
        String part2_0_instance_name = ASSOCIATION_PARTITION_INSTANCE_PREFIX + generatedKey1 + ASSOCIATION_PARTITION2_0_INSTANCE_APPENDIX;
        String part1_1_instance_name = ASSOCIATION_PARTITION_INSTANCE_PREFIX + generatedKey2 + ASSOCIATION_PARTITION1_1_INSTANCE_APPENDIX;
        String part2_1_instance_name = ASSOCIATION_PARTITION_INSTANCE_PREFIX + generatedKey2 + ASSOCIATION_PARTITION2_1_INSTANCE_APPENDIX;
        Instance p1_0 = hub.getCurrentDatabase().getInstance(ASSOCIATION_PARTITION1_TYPE, part1_0_instance_name);
        Instance p2_0 = hub.getCurrentDatabase().getInstance(ASSOCIATION_PARTITION2_TYPE, part2_0_instance_name);
        Instance p1_1 = hub.getCurrentDatabase().getInstance(ASSOCIATION_PARTITION1_TYPE, part1_1_instance_name);
        Instance p2_1 = hub.getCurrentDatabase().getInstance(ASSOCIATION_PARTITION2_TYPE, part2_1_instance_name);
        Assert.assertNotNull((Object)p1_0);
        Assert.assertNotNull((Object)p2_0);
        Assert.assertNotNull((Object)p1_1);
        Assert.assertNotNull((Object)p2_1);
        String p1_0_name = (String)((Map)p1_0.getBean()).get(NAME_TAG);
        String p2_0_name = (String)((Map)p2_0.getBean()).get(NAME_TAG);
        String p1_1_name = (String)((Map)p1_1.getBean()).get(NAME_TAG);
        String p2_1_name = (String)((Map)p2_1.getBean()).get(NAME_TAG);
        Assert.assertEquals((Object)PART1_0_NAME, (Object)p1_0_name);
        Assert.assertEquals((Object)PART2_0_NAME, (Object)p2_0_name);
        Assert.assertEquals((Object)PART1_1_NAME, (Object)p1_1_name);
        Assert.assertEquals((Object)PART2_1_NAME, (Object)p2_1_name);
    }

    @Test
    public void testSameClassTwoChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("foobar.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), FooBarBean.class);
        FooBarBean foobar = (FooBarBean)rootHandle.getRoot();
        Assert.assertNotNull((Object)foobar);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_ROOT_TYPE, FOOBAR_ROOT_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_FOO_TYPE, FOOBAR_FOO1_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_FOO_TYPE, FOOBAR_FOO2_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_BAR_TYPE, FOOBAR_BAR1_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_BAR_TYPE, FOOBAR_BAR2_INSTANCE));
    }

    @Test
    public void testBeanCycle() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(CYCLE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), RootWithCycle.class);
        RootWithCycle cycle = (RootWithCycle)rootHandle.getRoot();
        Assert.assertNotNull((Object)cycle);
        Assert.assertNotNull((Object)cycle.getLeafWithCycle());
        Assert.assertNotNull((Object)cycle.getLeafWithCycle().getRootWithCycle());
        Assert.assertNull((Object)cycle.getLeafWithCycle().getRootWithCycle().getLeafWithCycle());
    }

    @Test
    public void testEveryType() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(TYPE1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), TypeBean.class);
        TypeBean types = (TypeBean)rootHandle.getRoot();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)13L, (long)types.getIType());
        Assert.assertEquals((long)-13L, (long)types.getJType());
        Assert.assertEquals((Object)true, (Object)types.getZType());
        Assert.assertEquals((long)120L, (long)types.getBType());
        Assert.assertEquals((long)161L, (long)types.getSType());
        Assert.assertEquals((long)0L, (long)Float.compare(3.14f, types.getFType()));
        Assert.assertEquals((long)0L, (long)Double.compare(2.71828, types.getDType()));
    }

    @Test
    public void testAnnotationWithEverythingCopied() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Method setBagelMethod = employees.getClass().getMethod("setBagelPreference", Integer.TYPE);
        EverythingBagel bagel = setBagelMethod.getAnnotation(EverythingBagel.class);
        Assert.assertEquals((long)13L, (long)bagel.byteValue());
        Assert.assertTrue((boolean)bagel.booleanValue());
        Assert.assertEquals((long)101L, (long)bagel.charValue());
        Assert.assertEquals((long)13L, (long)bagel.shortValue());
        Assert.assertEquals((long)13L, (long)bagel.intValue());
        Assert.assertEquals((long)13L, (long)bagel.longValue());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, bagel.floatValue()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, bagel.doubleValue()));
        Assert.assertEquals((Object)"13", (Object)bagel.stringValue());
        Assert.assertEquals(Employees.class, bagel.classValue());
        Assert.assertEquals((Object)((Object)GreekEnum.BETA), (Object)((Object)bagel.enumValue()));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{13, 14}, bagel.byteArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false}, bagel.booleanArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'e', 'E'}, bagel.charArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{13, 14}, bagel.shortArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{13, 14}, bagel.intArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{13L, 14L}, bagel.longArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"13", "14"}, bagel.stringArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new Class[]{String.class, Double.TYPE}, bagel.classArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new GreekEnum[]{GreekEnum.GAMMA, GreekEnum.ALPHA}, (Object[])bagel.enumArrayValue()));
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, bagel.floatArrayValue()[0]));
        Assert.assertEquals((long)0L, (long)Float.compare(14.0f, bagel.floatArrayValue()[1]));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, bagel.doubleArrayValue()[0]));
        Assert.assertEquals((long)0L, (long)Double.compare(14.0, bagel.doubleArrayValue()[1]));
    }

    @Test
    public void testEmptyListChildReturnsEmptyList() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        List<OtherData> noChildrenList = employees.getNoChildList();
        Assert.assertNotNull(noChildrenList);
        Assert.assertTrue((boolean)noChildrenList.isEmpty());
    }

    @Test
    public void testEmptyArrayChildReturnsEmptyArray() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        OtherData[] noChildrenList = employees.getNoChildArray();
        Assert.assertNotNull((Object)noChildrenList);
        Assert.assertEquals((long)0L, (long)noChildrenList.length);
    }
}

