/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.clazz;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.MethodAltMethodImpl;

public class ClassAltClassImpl
implements AltClass {
    private static final ClassReflectionHelper SCALAR_HELPER = new ClassReflectionHelperImpl();
    public static final AltClass VOID = new ClassAltClassImpl(Void.TYPE, SCALAR_HELPER);
    public static final AltClass BOOLEAN = new ClassAltClassImpl(Boolean.TYPE, SCALAR_HELPER);
    public static final AltClass BYTE = new ClassAltClassImpl(Byte.TYPE, SCALAR_HELPER);
    public static final AltClass CHAR = new ClassAltClassImpl(Character.TYPE, SCALAR_HELPER);
    public static final AltClass SHORT = new ClassAltClassImpl(Short.TYPE, SCALAR_HELPER);
    public static final AltClass INT = new ClassAltClassImpl(Integer.TYPE, SCALAR_HELPER);
    public static final AltClass LONG = new ClassAltClassImpl(Long.TYPE, SCALAR_HELPER);
    public static final AltClass FLOAT = new ClassAltClassImpl(Float.TYPE, SCALAR_HELPER);
    public static final AltClass DOUBLE = new ClassAltClassImpl(Double.TYPE, SCALAR_HELPER);
    public static final AltClass OBJECT = new ClassAltClassImpl(Object.class, SCALAR_HELPER);
    private final Class<?> clazz;
    private final ClassReflectionHelper helper;
    private List<AltMethod> methods;
    private List<AltAnnotation> annotations;

    public ClassAltClassImpl(Class<?> clazz, ClassReflectionHelper helper) {
        this.clazz = clazz;
        this.helper = helper;
    }

    public Class<?> getOriginalClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    @Override
    public synchronized List<AltAnnotation> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        Annotation[] annotationz = this.clazz.getAnnotations();
        ArrayList<AnnotationAltAnnotationImpl> retVal = new ArrayList<AnnotationAltAnnotationImpl>(annotationz.length);
        for (Annotation annotation : annotationz) {
            retVal.add(new AnnotationAltAnnotationImpl(annotation, this.helper));
        }
        this.annotations = Collections.unmodifiableList(retVal);
        return this.annotations;
    }

    @Override
    public synchronized List<AltMethod> getMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        Set wrappers = this.helper.getAllMethods(this.clazz);
        ArrayList<MethodAltMethodImpl> retVal = new ArrayList<MethodAltMethodImpl>(wrappers.size());
        for (MethodWrapper method : wrappers) {
            retVal.add(new MethodAltMethodImpl(method.getMethod(), this.helper));
        }
        this.methods = Collections.unmodifiableList(retVal);
        return this.methods;
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    @Override
    public AltClass getComponentType() {
        Class<?> cType = this.clazz.getComponentType();
        if (cType == null) {
            return null;
        }
        return new ClassAltClassImpl(cType, this.helper);
    }

    public int hashCode() {
        return this.clazz.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AltClass)) {
            return false;
        }
        AltClass other = (AltClass)o;
        return this.clazz.getName().equals(other.getName());
    }

    public String toString() {
        return "ClassAltClassImpl(" + this.clazz.getName() + "," + System.identityHashCode(this) + ")";
    }
}

