/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.removes;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Employee;
import org.glassfish.hk2.xml.test.basic.Employees;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class RemovesTest {
    public static final String EMPLOYEE_TYPE = "/employees/employee";
    public static final String BOB_EMPLOYEE_INSTANCE = "employees.Bob";

    @Test
    public void testRemoveOfIndexedChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Employee bob = employees.lookupEmployee("Bob");
        Assert.assertNotNull((Object)bob);
        Assert.assertNotNull((Object)locator.getService(Employee.class, "Bob", new Annotation[0]));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, BOB_EMPLOYEE_INSTANCE));
        employees.removeEmployee("Bob");
        bob = employees.lookupEmployee("Bob");
        Assert.assertNull((Object)bob);
        Assert.assertNull((Object)locator.getService(Employee.class, "Bob", new Annotation[0]));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, BOB_EMPLOYEE_INSTANCE));
    }
}

