/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ParentedModel;

public class Model
implements Serializable {
    private static final long serialVersionUID = 752816761552710497L;
    private static final Object lock = new Object();
    private String originalInterface;
    private volatile Class<?> originalInterfaceAsClass;
    private String translatedClass;
    private volatile Class<?> translatedClassAsClass;
    private String rootName;
    private final Map<String, ParentedModel> childrenByName = new HashMap<String, ParentedModel>();
    private final Map<String, ChildDataModel> nonChildProperty = new HashMap<String, ChildDataModel>();
    private String keyProperty;
    private Set<String> unKeyedChildren = null;
    private Set<String> keyedChildren = null;
    private transient JAUtilities jaUtilities = null;
    private ClassLoader myLoader;

    public Model() {
    }

    public Model(String originalInterface, String translatedClass) {
        this.originalInterface = originalInterface;
        this.translatedClass = translatedClass;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public void addChild(String childInterface, String xmlTag, ChildType childType, String givenDefault) {
        ParentedModel pm = new ParentedModel(childInterface, xmlTag, childType, givenDefault);
        this.childrenByName.put(xmlTag, pm);
    }

    public void addNonChild(String xmlTag, String defaultValue, String childType) {
        this.nonChildProperty.put(xmlTag, new ChildDataModel(childType, defaultValue));
    }

    public String getOriginalInterface() {
        return this.originalInterface;
    }

    public String getTranslatedClass() {
        return this.translatedClass;
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public Map<String, ParentedModel> getChildrenByName() {
        return this.childrenByName;
    }

    public Map<String, ChildDataModel> getNonChildProperties() {
        return this.nonChildProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnKeyedChildren() {
        Object object = lock;
        synchronized (object) {
            if (this.unKeyedChildren != null) {
                return this.unKeyedChildren;
            }
            this.unKeyedChildren = new HashSet<String>();
            for (Map.Entry<String, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() != null) continue;
                this.unKeyedChildren.add(entry.getKey());
            }
            return this.unKeyedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeyedChildren() {
        Object object = lock;
        synchronized (object) {
            if (this.keyedChildren != null) {
                return this.keyedChildren;
            }
            this.keyedChildren = new HashSet<String>();
            for (Map.Entry<String, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() == null) continue;
                this.keyedChildren.add(entry.getKey());
            }
            return this.keyedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJAUtilities(JAUtilities jaUtilities, ClassLoader myLoader) {
        Object object = lock;
        synchronized (object) {
            if (this.jaUtilities != null) {
                return;
            }
            this.jaUtilities = jaUtilities;
            this.myLoader = myLoader;
            for (ParentedModel pm : this.childrenByName.values()) {
                pm.setRuntimeInformation(jaUtilities, myLoader);
            }
            for (ChildDataModel cdm : this.nonChildProperty.values()) {
                cdm.setLoader(myLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultChildValue(String propName) {
        Object object = lock;
        synchronized (object) {
            ChildDataModel cd = this.nonChildProperty.get(propName);
            if (cd == null) {
                return null;
            }
            return cd.getDefaultAsString();
        }
    }

    public boolean isChildProperty(String propName) {
        Object object = lock;
        synchronized (object) {
            if (this.nonChildProperty.containsKey(propName)) {
                return false;
            }
            if (this.childrenByName.containsKey(propName)) {
                return true;
            }
            throw new AssertionError((Object)("Unknwn property " + propName + " for " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getNonChildType(String propName) {
        Object object = lock;
        synchronized (object) {
            ChildDataModel cd = this.nonChildProperty.get(propName);
            if (cd == null) {
                return null;
            }
            return cd.getChildTypeAsClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentedModel getChild(String propName) {
        Object object = lock;
        synchronized (object) {
            return this.childrenByName.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getOriginalInterfaceAsClass() {
        if (this.originalInterfaceAsClass != null) {
            return this.originalInterfaceAsClass;
        }
        Object object = lock;
        synchronized (object) {
            if (this.originalInterfaceAsClass != null) {
                return this.originalInterfaceAsClass;
            }
            this.originalInterfaceAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.originalInterface);
            return this.originalInterfaceAsClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getProxyAsClass() {
        if (this.translatedClassAsClass != null) {
            return this.translatedClassAsClass;
        }
        Object object = lock;
        synchronized (object) {
            if (this.translatedClassAsClass != null) {
                return this.translatedClassAsClass;
            }
            this.translatedClassAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.translatedClass);
            return this.translatedClassAsClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ParentedModel> getAllChildren() {
        Object object = lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.childrenByName.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ParentedModel> getChildrenProperties() {
        Object object = lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.childrenByName);
        }
    }

    public int hashCode() {
        return this.translatedClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        return this.translatedClass.equals(((Model)o).getTranslatedClass());
    }

    public String toString() {
        return "Model(" + this.originalInterface + "," + this.translatedClass + "," + this.rootName + "," + this.keyProperty + ")";
    }
}

