/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.Model;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.ArrayTypeAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.TypeElementAltClassImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Utilities {
    public static final char INSTANCE_PATH_SEPARATOR = '.';
    private static final String CLASS_ADD_ON_NAME = "_Hk2_Jaxb";
    private static final String NOT_UNIQUE_UNIQUE_ID = "not-unique";
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Byte DEFAULT_BYTE = new Byte(0);
    private static final Character DEFAULT_CHARACTER = new Character('\u0000');
    private static final Short DEFAULT_SHORT = new Short(0);
    private static final Integer DEFAULT_INTEGER = new Integer(0);
    private static final Long DEFAULT_LONG = new Long(0L);
    private static final Float DEFAULT_FLOAT = new Float(0.0f);
    private static final Double DEFAULT_DOUBLE = new Double(0.0);

    static String convertXmlRootElementName(XmlRootElement root, Class<?> clazz) {
        if (!"##default".equals(root.name())) {
            return root.name();
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    public static BaseHK2JAXBBean createBean(Class<?> implClass) {
        try {
            Constructor<?> noArgsConstructor = implClass.getConstructor(new Class[0]);
            return (BaseHK2JAXBBean)ReflectionHelper.makeMe(noArgsConstructor, (Object[])new Object[0], (boolean)false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static String getKeySegment(BaseHK2JAXBBean bean) {
        String baseKeySegment = bean._getKeyValue();
        if (baseKeySegment == null) {
            baseKeySegment = bean._getSelfXmlTag();
        }
        return baseKeySegment;
    }

    public static String createInstanceName(BaseHK2JAXBBean bean) {
        if (bean._getParent() == null) {
            return Utilities.getKeySegment(bean);
        }
        return Utilities.createInstanceName((BaseHK2JAXBBean)bean._getParent()) + '.' + Utilities.getKeySegment(bean);
    }

    public static void advertise(WriteableBeanDatabase wbd, DynamicConfiguration config, BaseHK2JAXBBean bean) {
        if (config != null) {
            AbstractActiveDescriptor cDesc = BuilderHelper.createConstantDescriptor((Object)bean);
            if (bean._getKeyValue() != null) {
                cDesc.setName(bean._getKeyValue());
            }
            ActiveDescriptor selfDescriptor = config.addActiveDescriptor((ActiveDescriptor)cDesc);
            bean._setSelfDescriptor(selfDescriptor);
        }
        if (wbd != null) {
            WriteableType wt = wbd.findOrAddWriteableType(bean._getXmlPath());
            wt.addInstance(bean._getInstanceName(), bean._getBeanLikeMap());
        }
    }

    public static String convertToSetter(String getterName) {
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring("is".length());
        }
        if (!getterName.startsWith("get")) {
            throw new IllegalArgumentException("Unknown getter format: " + getterName);
        }
        return "set" + getterName.substring("get".length());
    }

    public static String convertNameToString(Name name) {
        if (name == null) {
            return null;
        }
        return name.toString();
    }

    public static AltClass convertTypeMirror(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        if (TypeKind.VOID.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.VOID;
        }
        if (TypeKind.BOOLEAN.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BOOLEAN;
        }
        if (TypeKind.INT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.INT;
        }
        if (TypeKind.LONG.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.LONG;
        }
        if (TypeKind.BYTE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BYTE;
        }
        if (TypeKind.CHAR.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.CHAR;
        }
        if (TypeKind.SHORT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.SHORT;
        }
        if (TypeKind.FLOAT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.FLOAT;
        }
        if (TypeKind.DOUBLE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.DOUBLE;
        }
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            DeclaredType dt = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dt.asElement();
            TypeElementAltClassImpl addMe = new TypeElementAltClassImpl(typeElement, processingEnv);
            return addMe;
        }
        if (TypeKind.ARRAY.equals((Object)typeMirror.getKind())) {
            ArrayType at = (ArrayType)typeMirror;
            return new ArrayTypeAltClassImpl(at, processingEnv);
        }
        throw new AssertionError((Object)("Unknown parameter kind: " + (Object)((Object)typeMirror.getKind())));
    }

    public static BaseHK2JAXBBean internalAdd(BaseHK2JAXBBean myParent, String childProperty, Object rawChild, String childKey, int index, DynamicChangeInfo changeInformation, WriteableBeanDatabase writeableDatabase, DynamicConfiguration dynamicService) {
        if (index < -1) {
            throw new IllegalArgumentException("Unknown index " + index);
        }
        if (childKey != null && myParent._lookupChild(childProperty, childKey) != null) {
            throw new IllegalStateException("There is already a child with name " + childKey + " for child " + childProperty);
        }
        if (rawChild != null && !(rawChild instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The child added must be from XmlService.createBean");
        }
        ParentedModel childNode = myParent._getModel().getChild(childProperty);
        if (childNode == null) {
            throw new IllegalArgumentException("There is no child with xmlTag " + childProperty + " of " + myParent);
        }
        Object allMyChildren = myParent._getProperty(childProperty);
        ArrayList<Object> multiChildren = null;
        if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
            multiChildren = allMyChildren == null ? new ArrayList(10) : (ChildType.LIST.equals((Object)childNode.getChildType()) ? new ArrayList((List)allMyChildren) : new ArrayList<Object>(Arrays.asList((Object[])allMyChildren)));
            if (index > multiChildren.size()) {
                throw new IllegalArgumentException("The index given to add child " + childProperty + " to " + myParent + " is not in range");
            }
            if (index == -1) {
                index = multiChildren.size();
            }
        } else if (allMyChildren != null) {
            throw new IllegalStateException("Attempting to add direct child of " + myParent + " of name " + childProperty + " but there is already one there");
        }
        BaseHK2JAXBBean child = Utilities.createBean(childNode.getChildModel().getProxyAsClass());
        child._setClassReflectionHelper(myParent._getClassReflectionHelper());
        if (rawChild != null) {
            BaseHK2JAXBBean childToCopy = (BaseHK2JAXBBean)rawChild;
            for (String nonChildProperty : childToCopy._getModel().getNonChildProperties().keySet()) {
                Object value = childToCopy._getProperty(nonChildProperty);
                if (value == null) continue;
                child._setProperty(nonChildProperty, value, false);
            }
        }
        if (childKey == null) {
            if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
                if (childNode.getChildModel().getKeyProperty() != null) {
                    if (rawChild != null) {
                        childKey = (String)child._getProperty(childNode.getChildModel().getKeyProperty());
                    }
                    if (childKey == null) {
                        throw new IllegalArgumentException("Attempted to create child with xmlTag " + childProperty + " with no key field in " + myParent);
                    }
                    child._setKeyValue(childKey);
                } else if (myParent._getChangeControl() == null) {
                    childKey = NOT_UNIQUE_UNIQUE_ID;
                    child._setKeyValue(NOT_UNIQUE_UNIQUE_ID);
                } else {
                    childKey = myParent._getChangeControl().getGeneratedId();
                    child._setKeyValue(childKey);
                }
            }
        } else {
            if (childNode.getChildModel().getKeyProperty() == null) {
                throw new IllegalArgumentException("Attempted to add an unkeyed child with key " + childKey + " in " + myParent);
            }
            child._setProperty(childNode.getChildModel().getKeyProperty(), childKey, false);
            child._setKeyValue(childKey);
        }
        child._setParent(myParent);
        child._setSelfXmlTag(childNode.getChildXmlTag());
        child._setKeyValue(childKey);
        if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
            child._setInstanceName(myParent._getInstanceName() + '.' + child._getKeyValue());
        } else {
            child._setInstanceName(myParent._getInstanceName() + '.' + childNode.getChildXmlTag());
        }
        if (rawChild != null) {
            Utilities.handleChildren(child, (BaseHK2JAXBBean)rawChild, changeInformation);
        }
        child._setDynamicChangeInfo(changeInformation);
        Utilities.externalAdd(child, dynamicService, writeableDatabase);
        if (multiChildren != null) {
            Object finalChildList;
            multiChildren.add(index, child);
            if (ChildType.LIST.equals((Object)childNode.getChildType())) {
                finalChildList = Collections.unmodifiableList(multiChildren);
            } else {
                finalChildList = Array.newInstance(childNode.getChildModel().getOriginalInterfaceAsClass(), multiChildren.size());
                for (int lcv = 0; lcv < multiChildren.size(); ++lcv) {
                    Array.set(finalChildList, lcv, multiChildren.get(lcv));
                }
            }
            if (writeableDatabase != null) {
                myParent.changeInHub(childProperty, finalChildList, writeableDatabase);
            }
            myParent._setProperty(childProperty, finalChildList, false);
        } else {
            if (writeableDatabase != null) {
                myParent.changeInHub(childProperty, child, writeableDatabase);
            }
            myParent._setProperty(childProperty, child, false);
        }
        return child;
    }

    public static String getProxyNameFromInterfaceName(String iFaceName) {
        return iFaceName + CLASS_ADD_ON_NAME;
    }

    private static void handleChildren(BaseHK2JAXBBean child, BaseHK2JAXBBean childToCopy, DynamicChangeInfo changeInformation) {
        Map<String, ParentedModel> childrenMap = childToCopy._getModel().getChildrenProperties();
        for (Map.Entry<String, ParentedModel> childsChildrenEntry : childrenMap.entrySet()) {
            String childsChildProperty = childsChildrenEntry.getKey();
            ParentedModel childsChildParentNode = childsChildrenEntry.getValue();
            if (!ChildType.DIRECT.equals((Object)childsChildParentNode.getChildType())) {
                ArrayList<BaseHK2JAXBBean> childsChildren = null;
                if (ChildType.LIST.equals((Object)childsChildParentNode.getChildType())) {
                    childsChildren = (ArrayList<BaseHK2JAXBBean>)childToCopy._getProperty(childsChildProperty);
                } else {
                    Object arrayChildsChildren = childToCopy._getProperty(childsChildProperty);
                    if (arrayChildsChildren != null) {
                        childsChildren = new ArrayList<BaseHK2JAXBBean>(Array.getLength(arrayChildsChildren));
                        for (int lcv = 0; lcv < Array.getLength(arrayChildsChildren); ++lcv) {
                            childsChildren.add(lcv, (BaseHK2JAXBBean)Array.get(arrayChildsChildren, lcv));
                        }
                    }
                }
                if (childsChildren == null || childsChildren.size() <= 0) continue;
                ArrayList<BaseHK2JAXBBean> copiedChildArray = new ArrayList<BaseHK2JAXBBean>(childsChildren.size());
                Object asArray = Array.newInstance(childsChildParentNode.getChildModel().getOriginalInterfaceAsClass(), childsChildren.size());
                int lcv = 0;
                for (BaseHK2JAXBBean childsChild : childsChildren) {
                    BaseHK2JAXBBean grandchild = Utilities.internalAdd(child, childsChildProperty, childsChild, null, -1, changeInformation, null, null);
                    copiedChildArray.add(grandchild);
                    Array.set(asArray, lcv++, grandchild);
                }
                if (ChildType.LIST.equals((Object)childsChildParentNode.getChildType())) {
                    child._setProperty(childsChildProperty, copiedChildArray, false);
                    continue;
                }
                child._setProperty(childsChildProperty, asArray, false);
                continue;
            }
            BaseHK2JAXBBean childsChild = (BaseHK2JAXBBean)childToCopy._getProperty(childsChildProperty);
            if (childsChild == null) continue;
            BaseHK2JAXBBean grandchild = Utilities.internalAdd(child, childsChildProperty, childsChild, null, -1, changeInformation, null, null);
            child._setProperty(childsChildProperty, grandchild, false);
        }
    }

    private static void externalAdd(BaseHK2JAXBBean root, DynamicConfiguration config, WriteableBeanDatabase writeableDatabase) {
        BaseHK2JAXBBean child2;
        if (config == null && writeableDatabase == null) {
            return;
        }
        Utilities.advertise(writeableDatabase, config, root);
        for (String keyedChildProperty : root._getModel().getKeyedChildren()) {
            Object keyedRawChild = root._getProperty(keyedChildProperty);
            if (keyedRawChild == null) continue;
            if (keyedRawChild instanceof Iterable) {
                Iterable iterable = (Iterable)keyedRawChild;
                for (BaseHK2JAXBBean child2 : iterable) {
                    Utilities.externalAdd(child2, config, writeableDatabase);
                }
                continue;
            }
            if (keyedRawChild.getClass().isArray()) {
                int aLength = Array.getLength(keyedRawChild);
                for (int lcv = 0; lcv < aLength; ++lcv) {
                    child2 = (BaseHK2JAXBBean)Array.get(keyedRawChild, lcv);
                    Utilities.externalAdd(child2, config, writeableDatabase);
                }
                continue;
            }
            Utilities.externalAdd((BaseHK2JAXBBean)keyedRawChild, config, writeableDatabase);
        }
        for (String unkeyedChildProperty : root._getModel().getUnKeyedChildren()) {
            Object unkeyedRawChild = root._getProperty(unkeyedChildProperty);
            if (unkeyedRawChild == null) continue;
            if (unkeyedRawChild instanceof Iterable) {
                Iterable unkeyedMultiChildren = (Iterable)unkeyedRawChild;
                for (BaseHK2JAXBBean child2 : unkeyedMultiChildren) {
                    Utilities.externalAdd(child2, config, writeableDatabase);
                }
                continue;
            }
            if (unkeyedRawChild.getClass().isArray()) {
                int aLength = Array.getLength(unkeyedRawChild);
                for (int lcv = 0; lcv < aLength; ++lcv) {
                    child2 = (BaseHK2JAXBBean)Array.get(unkeyedRawChild, lcv);
                    Utilities.externalAdd(child2, config, writeableDatabase);
                }
                continue;
            }
            Utilities.externalAdd((BaseHK2JAXBBean)unkeyedRawChild, config, writeableDatabase);
        }
    }

    public static BaseHK2JAXBBean _addRoot(Model rootNode, Object rawRoot, DynamicChangeInfo changeInfo, ClassReflectionHelper helper, WriteableBeanDatabase writeableDatabase, DynamicConfiguration dynamicService) {
        if (!(rawRoot instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The root added must be from XmlService.createBean");
        }
        BaseHK2JAXBBean child = Utilities.createBean(rootNode.getProxyAsClass());
        child._setClassReflectionHelper(helper);
        BaseHK2JAXBBean childToCopy = (BaseHK2JAXBBean)rawRoot;
        for (String nonChildProperty : childToCopy._getModel().getNonChildProperties().keySet()) {
            Object value = childToCopy._getProperty(nonChildProperty);
            if (value == null) continue;
            child._setProperty(nonChildProperty, value, false);
        }
        if (rootNode.getKeyProperty() != null) {
            child._setKeyValue((String)child._getProperty(rootNode.getKeyProperty()));
        }
        child._setSelfXmlTag(rootNode.getRootName());
        child._setInstanceName(rootNode.getRootName());
        Utilities.handleChildren(child, childToCopy, changeInfo);
        child._setDynamicChangeInfo(changeInfo);
        Utilities.externalAdd(child, dynamicService, writeableDatabase);
        return child;
    }

    public static BaseHK2JAXBBean internalRemove(BaseHK2JAXBBean myParent, String childProperty, String childKey, int index, DynamicChangeInfo changeInformation, WriteableBeanDatabase writeableDatabase, DynamicConfiguration dynamicService) {
        if (childProperty == null) {
            return null;
        }
        if (childKey == null && index < 0) {
            return null;
        }
        ParentedModel removeMeParentedNode = myParent._getModel().getChild(childProperty);
        Model removeMeNode = removeMeParentedNode.getChildModel();
        BaseHK2JAXBBean rootForDeletion = null;
        if (!ChildType.DIRECT.equals((Object)removeMeParentedNode.getChildType())) {
            if (ChildType.LIST.equals((Object)removeMeParentedNode.getChildType())) {
                List removeFromList = (List)myParent._getProperty(childProperty);
                if (removeFromList == null) {
                    return null;
                }
                ArrayList<BaseHK2JAXBBean> listWithObjectRemoved = new ArrayList<BaseHK2JAXBBean>(removeFromList.size() - 1);
                if (childKey != null) {
                    for (BaseHK2JAXBBean candidate : removeFromList) {
                        String candidateKeyValue = candidate._getKeyValue();
                        if (GeneralUtilities.safeEquals((Object)candidateKeyValue, (Object)childKey)) {
                            rootForDeletion = candidate;
                            continue;
                        }
                        listWithObjectRemoved.add(candidate);
                    }
                } else {
                    if (index >= removeFromList.size()) {
                        return null;
                    }
                    for (int lcv = 0; lcv < index; ++lcv) {
                        if (lcv == index) {
                            rootForDeletion = (BaseHK2JAXBBean)removeFromList.get(lcv);
                            continue;
                        }
                        listWithObjectRemoved.add((BaseHK2JAXBBean)removeFromList.get(lcv));
                    }
                }
                if (rootForDeletion == null) {
                    return null;
                }
                if (writeableDatabase != null) {
                    myParent.changeInHub(childProperty, listWithObjectRemoved, writeableDatabase);
                }
                myParent._setProperty(childProperty, listWithObjectRemoved, false);
            } else {
                int lcv;
                Object removeFromArray = myParent._getProperty(childProperty);
                if (removeFromArray == null) {
                    return null;
                }
                int removeFromArrayLength = Array.getLength(removeFromArray);
                if (removeFromArrayLength == 0) {
                    return null;
                }
                Class<?> arrayType = removeMeNode.getOriginalInterfaceAsClass();
                Object arrayWithObjectRemoved = Array.newInstance(arrayType, removeFromArrayLength - 1);
                if (childKey != null) {
                    int removeIndex = -1;
                    for (lcv = 0; lcv < removeFromArrayLength; ++lcv) {
                        BaseHK2JAXBBean candidate = (BaseHK2JAXBBean)Array.get(removeFromArray, lcv);
                        String candidateKeyValue = candidate._getKeyValue();
                        if (!GeneralUtilities.safeEquals((Object)candidateKeyValue, (Object)childKey)) continue;
                        rootForDeletion = candidate;
                        removeIndex = lcv;
                        break;
                    }
                    if (rootForDeletion == null) {
                        return null;
                    }
                    int addIndex = 0;
                    for (int lcv2 = 0; lcv2 < removeFromArrayLength; ++lcv2) {
                        if (lcv2 == removeIndex) continue;
                        Array.set(arrayWithObjectRemoved, addIndex++, Array.get(removeFromArray, lcv2));
                    }
                } else {
                    if (index >= removeFromArrayLength) {
                        return null;
                    }
                    rootForDeletion = (BaseHK2JAXBBean)Array.get(removeFromArray, index);
                    int addIndex = 0;
                    for (lcv = 0; lcv < removeFromArrayLength; ++lcv) {
                        if (lcv == index) continue;
                        Array.set(arrayWithObjectRemoved, addIndex++, Array.get(removeFromArray, lcv));
                    }
                }
                if (rootForDeletion == null) {
                    return null;
                }
                if (writeableDatabase != null) {
                    myParent.changeInHub(childProperty, arrayWithObjectRemoved, writeableDatabase);
                }
                myParent._setProperty(childProperty, arrayWithObjectRemoved);
            }
        } else {
            throw new AssertionError((Object)"Remove of direct child not yet implemented");
        }
        if (dynamicService != null) {
            HashSet descriptorsToRemove = new HashSet();
            Utilities.getDescriptorsToRemove(rootForDeletion, descriptorsToRemove);
            for (ActiveDescriptor<?> descriptorToRemove : descriptorsToRemove) {
                dynamicService.addUnbindFilter((Filter)BuilderHelper.createSpecificDescriptorFilter(descriptorToRemove));
            }
        }
        if (writeableDatabase != null) {
            String rootXmlPath = rootForDeletion._getXmlPath();
            String rootInstanceName = rootForDeletion._getInstanceName();
            WriteableType rootType = writeableDatabase.getWriteableType(rootXmlPath);
            if (rootType != null) {
                rootType.removeInstance(rootInstanceName);
                String typeRemovalIndicator = rootXmlPath + '/';
                Set allTypes = writeableDatabase.getAllTypes();
                for (Type allType : allTypes) {
                    if (!allType.getName().startsWith(typeRemovalIndicator)) continue;
                    writeableDatabase.removeType(allType.getName());
                }
            }
        }
        return rootForDeletion;
    }

    private static void getDescriptorsToRemove(BaseHK2JAXBBean fromMe, HashSet<ActiveDescriptor<?>> descriptorsToRemove) {
        ActiveDescriptor<?> fromMeDescriptor = fromMe._getSelfDescriptor();
        if (fromMeDescriptor == null) {
            return;
        }
        descriptorsToRemove.add(fromMeDescriptor);
        Model model = fromMe._getModel();
        if (model == null) {
            return;
        }
        block5: for (ParentedModel parentedChild : model.getAllChildren()) {
            String childPropertyName = parentedChild.getChildXmlTag();
            switch (parentedChild.getChildType()) {
                case LIST: {
                    List listChildren = (List)fromMe._getProperty(childPropertyName);
                    if (listChildren == null) continue block5;
                    for (BaseHK2JAXBBean listChild : listChildren) {
                        Utilities.getDescriptorsToRemove(listChild, descriptorsToRemove);
                    }
                    continue block5;
                }
                case ARRAY: {
                    Object arrayChildren = fromMe._getProperty(childPropertyName);
                    if (arrayChildren == null) continue block5;
                    int arrayLength = Array.getLength(arrayChildren);
                    for (int lcv = 0; lcv < arrayLength; ++lcv) {
                        BaseHK2JAXBBean bean = (BaseHK2JAXBBean)Array.get(arrayChildren, lcv);
                        Utilities.getDescriptorsToRemove(bean, descriptorsToRemove);
                    }
                    continue block5;
                }
                case DIRECT: {
                    BaseHK2JAXBBean bean = (BaseHK2JAXBBean)fromMe._getProperty(childPropertyName);
                    if (bean == null) continue block5;
                    Utilities.getDescriptorsToRemove(bean, descriptorsToRemove);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown child type " + (Object)((Object)parentedChild.getChildType())));
                }
            }
        }
    }

    public static Object getDefaultValue(String givenStringDefault, Class<?> expectedClass) {
        if (givenStringDefault == null || "\u0000".equals(givenStringDefault)) {
            if (Integer.TYPE.equals(expectedClass)) {
                return DEFAULT_INTEGER;
            }
            if (Long.TYPE.equals(expectedClass)) {
                return DEFAULT_LONG;
            }
            if (Boolean.TYPE.equals(expectedClass)) {
                return DEFAULT_BOOLEAN;
            }
            if (Short.TYPE.equals(expectedClass)) {
                return DEFAULT_SHORT;
            }
            if (Byte.TYPE.equals(expectedClass)) {
                return DEFAULT_BYTE;
            }
            if (Character.TYPE.equals(expectedClass)) {
                return DEFAULT_CHARACTER;
            }
            if (Float.TYPE.equals(expectedClass)) {
                return DEFAULT_FLOAT;
            }
            if (Double.TYPE.equals(expectedClass)) {
                return DEFAULT_DOUBLE;
            }
            return null;
        }
        if (String.class.equals(expectedClass)) {
            return givenStringDefault;
        }
        if (Integer.TYPE.equals(expectedClass)) {
            return Integer.parseInt(givenStringDefault);
        }
        if (Long.TYPE.equals(expectedClass)) {
            return Long.parseLong(givenStringDefault);
        }
        if (Boolean.TYPE.equals(expectedClass)) {
            return Boolean.parseBoolean(givenStringDefault);
        }
        if (Short.TYPE.equals(expectedClass)) {
            return Short.parseShort(givenStringDefault);
        }
        if (Byte.TYPE.equals(expectedClass)) {
            return Byte.parseByte(givenStringDefault);
        }
        if (Character.TYPE.equals(expectedClass)) {
            return Character.valueOf(givenStringDefault.charAt(0));
        }
        if (Float.TYPE.equals(expectedClass)) {
            return Float.valueOf(Float.parseFloat(givenStringDefault));
        }
        if (Double.TYPE.equals(expectedClass)) {
            return Double.parseDouble(givenStringDefault);
        }
        if (expectedClass.isArray() && Byte.TYPE.equals(expectedClass.getComponentType())) {
            return givenStringDefault.getBytes();
        }
        throw new AssertionError((Object)("Default for type " + expectedClass.getName() + " not implemented"));
    }
}

