/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.merge;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Museum;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.QueueBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.beans.ServerBean;
import org.glassfish.hk2.xml.test.beans.TopicBean;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MergeTest {
    public static final String DOMAIN1_FILE = "domain1.xml";
    private static final String DOMAIN1_NAME = "domain1";
    public static final String RSA_ATZ_PROV_NAME = "RSA";
    private static final String RSA_DOM_PFX = "rsa";
    private static final String ALICE_NAME = "Alice";
    private static final String BOB_NAME = "Bob";
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    public static final String TOPIC0_NAME = "Topic0";
    public static final String TOPIC1_NAME = "Topic1";
    public static final String QUEUE0_NAME = "Queue0";
    public static final String QUEUE1_NAME = "Queue1";
    public static final String QUEUE2_NAME = "Queue2";
    public static final String TOPICD0_NAME = "TopicD0";
    public static final String QUEUED0_NAME = "QueueD0";
    private static final String ALICE_ADDRESS = "10.0.0.1";
    private static final String ALICE_SERVER0_NAME = "Server-0";
    private static final int ALICE_SERVER0_PORT = 12345;
    private static final String DOMAIN_TYPE = "/domain";
    private static final String DOMAIN_INSTANCE = "domain";
    private static final String MACHINE_TYPE = "/domain/machine";
    private static final String SERVER_TYPE = "/domain/machine/server";
    public static final String SECURITY_MANAGER_TYPE = "/domain/security-manager";
    public static final String AUTHORIZATION_PROVIDER_TYPE = "/domain/security-manager/authorization-provider";
    public static final String JMS_SERVER_TYPE = "/domain/jms-server";
    public static final String TOPIC_TYPE = "/domain/jms-server/topic";
    public static final String QUEUE_TYPE = "/domain/jms-server/queue";
    private static final String ALICE_INSTANCE = "domain.Alice";
    private static final String BOB_INSTANCE = "domain.Bob";
    public static final String DAVE_INSTANCE = "domain.Dave";
    private static final String SERVER0_INSTANCE = "domain.Alice.Server-0";
    private static final String SECURITY_MANAGER_INSTANCE = "domain.security-manager";
    private static final String RSA_INSTANCE = "domain.security-manager.RSA";
    private static final String JMS_SERVER_INSTANCE = "domain.Carol";
    private static final String TOPIC0_INSTANCE = "domain.Carol.Topic0";
    private static final String TOPIC1_INSTANCE = "domain.Carol.Topic1";
    private static final String QUEUE0_INSTANCE = "domain.Carol.Queue0";
    private static final String QUEUE1_INSTANCE = "domain.Carol.Queue1";
    private static final String QUEUE2_INSTANCE = "domain.Carol.Queue2";
    private static final String ADDRESS_TAG = "address";
    private static final String PORT_TAG = "port";
    private static final String ATZ_DOMAIN_PFX_TAG = "domain-pfx";

    @Test
    public void testMergeModifyTwoPropertiesOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        Museum museumCopy = (Museum)copy.getChildRoot();
        Museum museumOld = (Museum)rootHandle.getRoot();
        museumCopy.setAge(101);
        museumCopy.setId(101);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        copy.merge();
        Assert.assertEquals((long)101L, (long)museumOld.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museumOld.getName());
        Assert.assertEquals((long)101L, (long)museumOld.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance("/museum", "museum");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get("age"));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
            List events = change.getModifiedProperties();
            Assert.assertEquals((long)2L, (long)events.size());
            boolean gotId = false;
            boolean gotAge = false;
            for (PropertyChangeEvent event : events) {
                if ("age".equals(event.getPropertyName())) {
                    gotAge = true;
                    continue;
                }
                if (!"id".equals(event.getPropertyName())) continue;
                gotId = true;
            }
            Assert.assertTrue((boolean)gotId);
            Assert.assertTrue((boolean)gotAge);
        }
    }

    @Test
    @Ignore
    public void testMergeModifyAddADirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        MachineBean addedBean = (MachineBean)xmlService.createBean(MachineBean.class);
        addedBean.setName(BOB_NAME);
        domainCopy.addMachine(addedBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        List<MachineBean> machines = domainOld.getMachines();
        Assert.assertEquals((long)2L, (long)machines.size());
        boolean foundAlice = false;
        boolean foundBob = false;
        for (MachineBean machine : machines) {
            if (machine.getName().equals(BOB_NAME)) {
                if (foundBob) {
                    Assert.fail((String)("There were more than one bob in the list of machines: " + machines));
                }
                foundBob = true;
                continue;
            }
            if (!machine.getName().equals(ALICE_NAME)) continue;
            if (foundAlice) {
                Assert.fail((String)("There were more than one alice in the list of machines: " + machines));
            }
            foundAlice = true;
        }
        Assert.assertTrue((String)("Added child was not found: " + machines), (boolean)foundBob);
        Assert.assertTrue((String)("Existing child was not found: " + machines), (boolean)foundAlice);
        Instance machineBobInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, BOB_INSTANCE);
        Assert.assertNotNull((Object)machineBobInstance);
        Map bobMap = (Map)machineBobInstance.getBean();
        Assert.assertEquals((Object)BOB_NAME, bobMap.get("name"));
        Assert.assertNull(bobMap.get(ADDRESS_TAG));
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        DomainBean root = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator);
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> original, XmlRootCopy<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        Assert.assertEquals(original, (Object)rootHandle.getParent());
        DomainBean root = (DomainBean)rootHandle.getChildRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator);
    }

    private static void verifyDomain1XmlDomain(DomainBean root, Hub hub, ServiceLocator locator) {
        Assert.assertEquals((String)("Failing bean is " + root), (Object)DOMAIN1_NAME, (Object)root.getName());
        SecurityManagerBean securityManager = root.getSecurityManager();
        Assert.assertNotNull((Object)securityManager);
        List<AuthorizationProviderBean> atzProviders = securityManager.getAuthorizationProviders();
        Assert.assertNotNull(atzProviders);
        Assert.assertEquals((long)1L, (long)atzProviders.size());
        for (AuthorizationProviderBean atzProvider : atzProviders) {
            Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)atzProvider.getName());
            Assert.assertEquals((Object)RSA_DOM_PFX, (Object)atzProvider.getAtzDomainPrefix());
        }
        Assert.assertNull((Object)securityManager.getSSLManager());
        List<MachineBean> machines = root.getMachines();
        Assert.assertNotNull(machines);
        Assert.assertEquals((long)1L, (long)machines.size());
        for (MachineBean machine : machines) {
            Assert.assertEquals((Object)ALICE_NAME, (Object)machine.getName());
            Assert.assertEquals((Object)ALICE_ADDRESS, (Object)machine.getAddress());
            List<ServerBean> servers = machine.getServers();
            Assert.assertNotNull(servers);
            Assert.assertEquals((long)1L, (long)servers.size());
            for (ServerBean server : servers) {
                Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)server.getName());
                Assert.assertEquals((long)12345L, (long)server.getPort());
            }
        }
        JMSServerBean[] jmsServers = root.getJMSServers();
        Assert.assertEquals((long)2L, (long)jmsServers.length);
        int lcv = 0;
        for (JMSServerBean jmsServer : jmsServers) {
            QueueBean[] queues;
            List<TopicBean> topics;
            if (lcv == 0) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)CAROL_NAME, (Object)jmsServer.getName());
                topics = jmsServer.getTopics();
                Assert.assertEquals((long)2L, (long)topics.size());
                Assert.assertEquals((Object)TOPIC0_NAME, (Object)topics.get(0).getName());
                Assert.assertEquals((Object)TOPIC1_NAME, (Object)topics.get(1).getName());
                queues = jmsServer.getQueues();
                Assert.assertEquals((long)3L, (long)queues.length);
                Assert.assertEquals((Object)QUEUE0_NAME, (Object)queues[0].getName());
                Assert.assertEquals((Object)QUEUE1_NAME, (Object)queues[1].getName());
                Assert.assertEquals((Object)QUEUE2_NAME, (Object)queues[2].getName());
            } else if (lcv == 1) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)DAVE_NAME, (Object)jmsServer.getName());
                topics = jmsServer.getTopics();
                Assert.assertEquals((long)1L, (long)topics.size());
                Assert.assertEquals((Object)TOPICD0_NAME, (Object)topics.get(0).getName());
                queues = jmsServer.getQueues();
                Assert.assertEquals((long)1L, (long)queues.length);
                Assert.assertEquals((Object)QUEUED0_NAME, (Object)queues[0].getName());
            }
            ++lcv;
        }
        Instance domainInstance = hub.getCurrentDatabase().getInstance(DOMAIN_TYPE, DOMAIN_INSTANCE);
        Assert.assertNotNull((Object)domainInstance);
        Instance machineAliceInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, ALICE_INSTANCE);
        Assert.assertNotNull((Object)machineAliceInstance);
        Map aliceMap = (Map)machineAliceInstance.getBean();
        Assert.assertEquals((Object)ALICE_NAME, aliceMap.get("name"));
        Assert.assertEquals((Object)ALICE_ADDRESS, aliceMap.get(ADDRESS_TAG));
        Instance aliceServer0Instance = hub.getCurrentDatabase().getInstance(SERVER_TYPE, SERVER0_INSTANCE);
        Assert.assertNotNull((Object)aliceServer0Instance);
        Map server0Map = (Map)aliceServer0Instance.getBean();
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, server0Map.get("name"));
        Assert.assertEquals((Object)12345, server0Map.get(PORT_TAG));
        Instance securityManagerInstance = hub.getCurrentDatabase().getInstance(SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        Assert.assertNotNull((Object)securityManagerInstance);
        Map securityManagerMap = (Map)securityManagerInstance.getBean();
        Assert.assertNotNull((Object)securityManagerMap);
        Instance rsaInstance = hub.getCurrentDatabase().getInstance(AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        Assert.assertNotNull((Object)rsaInstance);
        Map rsaMap = (Map)rsaInstance.getBean();
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, rsaMap.get("name"));
        Assert.assertEquals((Object)RSA_DOM_PFX, rsaMap.get(ATZ_DOMAIN_PFX_TAG));
        MergeTest.assertNameOnlyBean(hub, JMS_SERVER_TYPE, JMS_SERVER_INSTANCE, CAROL_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC0_INSTANCE, TOPIC0_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC1_INSTANCE, TOPIC1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE0_INSTANCE, QUEUE0_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE1_INSTANCE, QUEUE1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE2_INSTANCE, QUEUE2_NAME);
        MergeTest.assertDomain1Services(locator);
    }

    private static void assertDomain1Services(ServiceLocator locator) {
        DomainBean db = (DomainBean)locator.getService(DomainBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)DOMAIN1_NAME, (Object)db.getName());
        SecurityManagerBean smb = (SecurityManagerBean)locator.getService(SecurityManagerBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)smb);
        AuthorizationProviderBean rsa = (AuthorizationProviderBean)locator.getService(AuthorizationProviderBean.class, RSA_ATZ_PROV_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)rsa);
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)rsa.getName());
        MachineBean mb = (MachineBean)locator.getService(MachineBean.class, ALICE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)mb);
        Assert.assertEquals((Object)ALICE_NAME, (Object)mb.getName());
        ServerBean sb = (ServerBean)locator.getService(ServerBean.class, ALICE_SERVER0_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)sb);
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)sb.getName());
        JMSServerBean carolJMS = (JMSServerBean)locator.getService(JMSServerBean.class, CAROL_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)carolJMS);
        Assert.assertEquals((Object)CAROL_NAME, (Object)carolJMS.getName());
        JMSServerBean daveJMS = (JMSServerBean)locator.getService(JMSServerBean.class, DAVE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)daveJMS);
        Assert.assertEquals((Object)DAVE_NAME, (Object)daveJMS.getName());
        MergeTest.assertTopicOfName(locator, TOPIC0_NAME);
        MergeTest.assertTopicOfName(locator, TOPIC1_NAME);
        MergeTest.assertTopicOfName(locator, TOPICD0_NAME);
        MergeTest.assertQueueOfName(locator, QUEUE0_NAME);
        MergeTest.assertQueueOfName(locator, QUEUE1_NAME);
        MergeTest.assertQueueOfName(locator, QUEUE2_NAME);
        MergeTest.assertQueueOfName(locator, QUEUED0_NAME);
    }

    public static void assertQueueOfName(ServiceLocator locator, String expectedName) {
        QueueBean qb = (QueueBean)locator.getService(QueueBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)qb);
        Assert.assertEquals((Object)expectedName, (Object)qb.getName());
    }

    public static void assertTopicOfName(ServiceLocator locator, String expectedName) {
        TopicBean tb = (TopicBean)locator.getService(TopicBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)tb);
        Assert.assertEquals((Object)expectedName, (Object)tb.getName());
    }

    private static void assertNameOnlyBean(Hub hub, String type, String instance, String expectedName) {
        Instance namedInstance = hub.getCurrentDatabase().getInstance(type, instance);
        Assert.assertNotNull((String)("Could not find instance of " + type + "," + instance), (Object)namedInstance);
        Map namedMap = (Map)namedInstance.getBean();
        Assert.assertEquals((Object)expectedName, namedMap.get("name"));
    }
}

