/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.rawsets;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.Museum;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class RawSetsTest {
    public static final String MUSEUM2_FILE = "museum2.xml";
    public static final String MUSEUM_TYPE = "/museum";
    public static final String MUSEUM_INSTANCE = "museum";
    public static final String AGE_TAG = "age";
    public static final int ONE_OH_ONE_INT = 101;

    public static void verifyPreState(XmlRootHandle<Museum> rootHandle, Hub hub) {
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)110, beanLikeMap.get(AGE_TAG));
    }

    @Test
    public void testModifySingleProperty() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        museum.setAge(101);
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List changes = listener.changes;
        Assert.assertNotNull((Object)changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        }
    }

    @Singleton
    public static class UpdateListener
    implements BeanDatabaseUpdateListener {
        private List<Change> changes;

        public void prepareDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }

        public void commitDatabaseChange(BeanDatabase oldDatabase, BeanDatabase currentDatabase, Object commitMessage, List<Change> changes) {
            this.changes = changes;
        }

        public void rollbackDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }

        public List<Change> getChanges() {
            return this.changes;
        }
    }
}

