/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.Model;

public class ParentedModel
implements Serializable {
    private static final long serialVersionUID = -2480798409414987937L;
    private final Object lock = new Object();
    private String childInterface;
    private String childXmlTag;
    private ChildType childType;
    private String givenDefault;
    private ClassLoader myLoader;
    private transient JAUtilities jaUtilities;
    private Model childModel;

    public ParentedModel() {
    }

    public ParentedModel(String childInterface, String childXmlTag, ChildType childType, String givenDefault) {
        this.childInterface = childInterface;
        this.childXmlTag = childXmlTag;
        this.childType = childType;
        this.givenDefault = givenDefault;
    }

    public String getChildInterface() {
        return this.childInterface;
    }

    public String getChildXmlTag() {
        return this.childXmlTag;
    }

    public ChildType getChildType() {
        return this.childType;
    }

    public String getGivenDefault() {
        return this.givenDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getChildModel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myLoader == null) {
                throw new IllegalStateException("Cannot call getChildModel before the classloader has been determined");
            }
            if (this.childModel != null) {
                return this.childModel;
            }
            Class beanClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childInterface);
            if (beanClass == null) {
                throw new IllegalStateException("Interface " + this.childInterface + " could not be loaded by " + this.myLoader);
            }
            this.childModel = this.jaUtilities.getModel(beanClass);
            return this.childModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRuntimeInformation(JAUtilities jaUtilities, ClassLoader myLoader) {
        Object object = this.lock;
        synchronized (object) {
            this.jaUtilities = jaUtilities;
            this.myLoader = myLoader;
        }
    }

    public String toString() {
        return "ParentedModel(" + this.childInterface + "," + this.childXmlTag + "," + (Object)((Object)this.childType) + "," + this.givenDefault + ")";
    }
}

