/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.childlocators;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class ChildLocatorTest {
    @Test
    public void testChildrenDoNotSeeParentServices() {
        ServiceLocator parentLocator = Utilities.createDomLocator(new Class[0]);
        ServiceLocator childALocator = Utilities.createDomLocator(parentLocator, new Class[0]);
        ServiceLocator childBLocator = Utilities.createDomLocator(parentLocator, new Class[0]);
        ServiceLocator grandChildALocator = Utilities.createDomLocator(childALocator, new Class[0]);
        List allXmlServices = grandChildALocator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allXmlServices.size());
        XmlService grandChildAXmlService = (XmlService)allXmlServices.get(0);
        allXmlServices = childALocator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allXmlServices.size());
        XmlService childAXmlService = (XmlService)allXmlServices.get(0);
        allXmlServices = parentLocator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allXmlServices.size());
        XmlService parentXmlService = (XmlService)allXmlServices.get(0);
        allXmlServices = childBLocator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allXmlServices.size());
        XmlService childBXmlService = (XmlService)allXmlServices.get(0);
        Assert.assertNotEquals((Object)grandChildAXmlService, (Object)childAXmlService);
        Assert.assertNotEquals((Object)grandChildAXmlService, (Object)parentXmlService);
        Assert.assertNotEquals((Object)grandChildAXmlService, (Object)childBXmlService);
        Assert.assertNotEquals((Object)childAXmlService, (Object)parentXmlService);
        Assert.assertNotEquals((Object)childAXmlService, (Object)childBXmlService);
        Assert.assertNotEquals((Object)parentXmlService, (Object)childBXmlService);
        List allHubServices = grandChildALocator.getAllServices(Hub.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allHubServices.size());
        Hub grandChildAHub = (Hub)allHubServices.get(0);
        allHubServices = childALocator.getAllServices(Hub.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allHubServices.size());
        Hub childAHub = (Hub)allHubServices.get(0);
        allHubServices = parentLocator.getAllServices(Hub.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allHubServices.size());
        Hub parentHub = (Hub)allHubServices.get(0);
        allHubServices = childBLocator.getAllServices(Hub.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allHubServices.size());
        Hub childBHub = (Hub)allHubServices.get(0);
        Assert.assertNotEquals((Object)grandChildAHub, (Object)childAHub);
        Assert.assertNotEquals((Object)grandChildAHub, (Object)parentHub);
        Assert.assertNotEquals((Object)grandChildAHub, (Object)childBHub);
        Assert.assertNotEquals((Object)childAHub, (Object)parentHub);
        Assert.assertNotEquals((Object)childAHub, (Object)childBHub);
        Assert.assertNotEquals((Object)parentHub, (Object)childBHub);
    }

    @Test
    public void testReadingInChildOnlyWorks() throws Exception {
        ServiceLocator parentLocator = Utilities.createDomLocator(new Class[0]);
        ServiceLocator childLocator = Utilities.createDomLocator(parentLocator, new Class[0]);
        XmlService childXmlService = (XmlService)childLocator.getService(XmlService.class, new Annotation[0]);
        Hub childHub = (Hub)childLocator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = childXmlService.unmarshall(url.toURI(), DomainBean.class);
        Hub parentHub = (Hub)parentLocator.getService(Hub.class, new Annotation[0]);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, childHub, childLocator);
        MergeTest.verifyDomain1XmlDomainNotThere(parentHub, parentLocator);
    }

    @Test
    public void testReadingInChildAndParentWorks() throws Exception {
        ServiceLocator parentLocator = Utilities.createDomLocator(new Class[0]);
        ServiceLocator childLocator = Utilities.createDomLocator(parentLocator, new Class[0]);
        XmlService childXmlService = (XmlService)childLocator.getService(XmlService.class, new Annotation[0]);
        XmlService parentXmlService = (XmlService)parentLocator.getService(XmlService.class, new Annotation[0]);
        Hub childHub = (Hub)childLocator.getService(Hub.class, new Annotation[0]);
        Hub parentHub = (Hub)parentLocator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle childHandle = childXmlService.unmarshall(url.toURI(), DomainBean.class);
        XmlRootHandle parentHandle = parentXmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)parentHandle, parentHub, parentLocator);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)childHandle, childHub, childLocator);
    }

    @Test
    public void testReadingInParentOnlyWorks() throws Exception {
        ServiceLocator parentLocator = Utilities.createDomLocator(new Class[0]);
        ServiceLocator childLocator = Utilities.createDomLocator(parentLocator, new Class[0]);
        XmlService parentXmlService = (XmlService)parentLocator.getService(XmlService.class, new Annotation[0]);
        Hub childHub = (Hub)childLocator.getService(Hub.class, new Annotation[0]);
        Hub parentHub = (Hub)parentLocator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle parentHandle = parentXmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)parentHandle, parentHub, parentLocator);
        MergeTest.assertDomain1Services(childLocator, parentLocator);
        MergeTest.verifyDomain1XmlDomainNotThere(childHub, childLocator);
    }
}

