/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.ReferenceKey;
import org.glassfish.hk2.xml.internal.UnresolvedReference;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootCopyImpl;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class XmlRootHandleImpl<T>
implements XmlRootHandle<T> {
    private final XmlServiceImpl parent;
    private final Hub hub;
    private T root;
    private final ModelImpl rootNode;
    private URI rootURI;
    private final boolean advertised;
    private final boolean advertisedInHub;
    private final DynamicChangeInfo changeControl;

    XmlRootHandleImpl(XmlServiceImpl parent, Hub hub, T root, ModelImpl rootNode, URI rootURI, boolean advertised, boolean inHub, DynamicChangeInfo changes) {
        this.parent = parent;
        this.hub = hub;
        this.root = root;
        this.rootNode = rootNode;
        this.rootURI = rootURI;
        this.advertised = advertised;
        this.advertisedInHub = inHub;
        this.changeControl = changes;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public Class<T> getRootClass() {
        return this.rootNode.getOriginalInterfaceAsClass();
    }

    @Override
    public URI getURI() {
        return this.rootURI;
    }

    @Override
    public boolean isAdvertisedInLocator() {
        return this.advertised;
    }

    @Override
    public boolean isAdvertisedInHub() {
        return this.advertisedInHub;
    }

    @Override
    public void overlay(XmlRootHandle<T> newRoot) {
        if (!(newRoot instanceof XmlRootHandle)) {
            throw new IllegalArgumentException("newRoot must have been created by the same XmlService as this one");
        }
        XmlRootHandleImpl newRootImpl = (XmlRootHandleImpl)newRoot;
        if (newRootImpl.isAdvertisedInHub()) {
            throw new IllegalArgumentException("The newRoot must not be advertised in the Hub");
        }
        if (newRootImpl.isAdvertisedInLocator()) {
            throw new IllegalArgumentException("The newRoot must not be advertised as hk2 services");
        }
        if (this.root == null) {
            throw new IllegalArgumentException("This XmlRootHandle must have a root to be overlayed");
        }
        T newRootRoot = newRootImpl.getRoot();
        if (newRootRoot == null) {
            throw new IllegalArgumentException("The newRoot must have a root to overlay onto this root");
        }
        if (!(newRootRoot instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The newRoot has a root of an unknown type: " + newRootRoot.getClass().getName());
        }
        BaseHK2JAXBBean newRootBase = (BaseHK2JAXBBean)newRootRoot;
        throw new AssertionError((Object)"overlay not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlRootCopy<T> getXmlRootCopy() {
        Hub useHub = this.advertisedInHub ? this.hub : null;
        DynamicChangeInfo copyController = new DynamicChangeInfo(this.changeControl.getJAUtilities(), null, this.changeControl.getIdGenerator(), null, this.changeControl.getServiceLocator());
        this.changeControl.getReadLock().lock();
        try {
            BaseHK2JAXBBean copy;
            BaseHK2JAXBBean bean = (BaseHK2JAXBBean)this.root;
            if (bean == null) {
                XmlRootCopyImpl<Object> xmlRootCopyImpl = new XmlRootCopyImpl<Object>(useHub, this, this.changeControl.getChangeNumber(), null);
                return xmlRootCopyImpl;
            }
            try {
                HashMap<ReferenceKey, BaseHK2JAXBBean> referenceMap = new HashMap<ReferenceKey, BaseHK2JAXBBean>();
                LinkedList<UnresolvedReference> unresolved = new LinkedList<UnresolvedReference>();
                copy = XmlRootHandleImpl.doCopy(bean, copyController, null, referenceMap, unresolved);
                Utilities.fillInUnfinishedReferences(referenceMap, unresolved);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            XmlRootCopyImpl<BaseHK2JAXBBean> xmlRootCopyImpl = new XmlRootCopyImpl<BaseHK2JAXBBean>(useHub, this, this.changeControl.getChangeNumber(), copy);
            return xmlRootCopyImpl;
        }
        finally {
            this.changeControl.getReadLock().unlock();
        }
    }

    private static BaseHK2JAXBBean doCopy(BaseHK2JAXBBean copyMe, DynamicChangeInfo copyController, BaseHK2JAXBBean theCopiedParent, Map<ReferenceKey, BaseHK2JAXBBean> referenceMap, List<UnresolvedReference> unresolved) throws Throwable {
        String keyPropertyName;
        if (copyMe == null) {
            return null;
        }
        BaseHK2JAXBBean retVal = Utilities.createBean(copyMe.getClass());
        retVal._shallowCopyFrom(copyMe);
        ModelImpl myModel = retVal._getModel();
        Set<String> childrenProps = copyMe._getChildrenXmlTags();
        for (String childProp : childrenProps) {
            Object child = copyMe._getProperty(childProp);
            if (child == null) continue;
            if (child instanceof List) {
                List childList = (List)child;
                ArrayList<BaseHK2JAXBBean> toSetChildList = new ArrayList<BaseHK2JAXBBean>(childList.size());
                for (Object subChild : childList) {
                    BaseHK2JAXBBean copiedChild = XmlRootHandleImpl.doCopy((BaseHK2JAXBBean)subChild, copyController, retVal, referenceMap, unresolved);
                    toSetChildList.add(copiedChild);
                }
                retVal._setProperty(childProp, toSetChildList);
                continue;
            }
            if (child.getClass().isArray()) {
                int length = Array.getLength(child);
                ParentedModel pm = myModel.getChild(childProp);
                ModelImpl childModel = pm.getChildModel();
                Class<?> childInterface = childModel.getOriginalInterfaceAsClass();
                Object toSetChildArray = Array.newInstance(childInterface, length);
                for (int lcv = 0; lcv < length; ++lcv) {
                    Object subChild = Array.get(child, lcv);
                    BaseHK2JAXBBean copiedChild = XmlRootHandleImpl.doCopy((BaseHK2JAXBBean)subChild, copyController, retVal, referenceMap, unresolved);
                    Array.set(toSetChildArray, lcv, copiedChild);
                }
                retVal._setProperty(childProp, toSetChildArray);
                continue;
            }
            BaseHK2JAXBBean copiedChild = XmlRootHandleImpl.doCopy((BaseHK2JAXBBean)child, copyController, retVal, referenceMap, unresolved);
            retVal._setProperty(childProp, copiedChild);
        }
        if (theCopiedParent != null) {
            retVal._setParent(theCopiedParent);
        }
        if ((keyPropertyName = retVal._getKeyPropertyName()) != null) {
            String keyProperty = retVal._getKeyValue();
            if (keyProperty != null) {
                referenceMap.put(new ReferenceKey(myModel.getOriginalInterface(), keyProperty), retVal);
            }
            Map<String, ChildDataModel> nonChildrenProps = myModel.getNonChildProperties();
            for (Map.Entry<String, ChildDataModel> nonChild : nonChildrenProps.entrySet()) {
                Object fromReferenceRaw;
                String xmlTag = nonChild.getKey();
                ChildDataModel cdm = nonChild.getValue();
                if (!cdm.isReference() || (fromReferenceRaw = copyMe._getProperty(xmlTag)) == null || !(fromReferenceRaw instanceof BaseHK2JAXBBean)) continue;
                BaseHK2JAXBBean fromReference = (BaseHK2JAXBBean)fromReferenceRaw;
                String fromKeyValue = fromReference._getKeyValue();
                ReferenceKey rk = new ReferenceKey(cdm.getChildType(), fromKeyValue);
                BaseHK2JAXBBean toReference = referenceMap.get(rk);
                if (toReference != null) {
                    retVal._setProperty(xmlTag, toReference);
                    continue;
                }
                unresolved.add(new UnresolvedReference(cdm.getChildType(), fromKeyValue, xmlTag, retVal));
            }
        }
        retVal._setDynamicChangeInfo(copyController, false);
        return retVal;
    }

    long getRevision() {
        return this.changeControl.getChangeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoot(T newRoot) {
        this.changeControl.getWriteLock().lock();
        try {
            if (this.root != null) {
                throw new IllegalStateException("An attempt was made to add a root to a handle that already has a root " + this);
            }
            if (!(newRoot instanceof BaseHK2JAXBBean)) {
                throw new IllegalArgumentException("The added bean must be from XmlService.createBean");
            }
            WriteableBeanDatabase wbd = null;
            if (this.advertisedInHub) {
                wbd = this.hub.getWriteableDatabaseCopy();
            }
            DynamicConfiguration config = null;
            if (this.advertised) {
                config = this.parent.getDynamicConfigurationService().createDynamicConfiguration();
            }
            BaseHK2JAXBBean copiedRoot = Utilities._addRoot(this.rootNode, newRoot, this.changeControl, this.parent.getClassReflectionHelper(), wbd, config);
            if (config != null) {
                config.commit();
            }
            if (wbd != null) {
                wbd.commit((Object)new XmlHubCommitMessage(){});
            }
            this.root = copiedRoot;
        }
        finally {
            this.changeControl.getWriteLock().unlock();
        }
    }

    @Override
    public void addRoot() {
        this.addRoot(this.parent.createBean(this.rootNode.getOriginalInterfaceAsClass()));
    }

    @Override
    public T removeRoot() {
        throw new AssertionError((Object)"removeRoot not implemented");
    }

    @Override
    public T getReadOnlyRoot(boolean representDefaults) {
        throw new AssertionError((Object)"getReadOnlyRoot not implemented");
    }

    DynamicChangeInfo getChangeInfo() {
        return this.changeControl;
    }

    public String toString() {
        return "XmlRootHandleImpl(" + this.root + "," + this.rootNode + "," + this.rootURI + "," + System.identityHashCode(this) + ")";
    }
}

