/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.Hk2JAXBUnmarshallerListener;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.internal.XmlStreamImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class XmlServiceImpl
implements XmlService {
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private DynamicConfigurationService dynamicConfigurationService;
    @Inject
    private Hub hub;
    @Inject
    private Provider<XmlServiceParser> parser;
    private final ClassReflectionHelper classReflectionHelper = new ClassReflectionHelperImpl();
    private final JAUtilities jaUtilities = new JAUtilities(this.classReflectionHelper);

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedClassOrInterface) {
        return this.unmarshall(uri, jaxbAnnotatedClassOrInterface, true, true);
    }

    @Override
    public <T> XmlRootHandle<T> unmarshall(URI uri, Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (uri == null || jaxbAnnotatedInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        XmlServiceParser localParser = (XmlServiceParser)this.parser.get();
        if (localParser == null) {
            throw new IllegalStateException("There is no XmlServiceParser implementation");
        }
        try {
            boolean generateAll = PreGenerationRequirement.MUST_PREGENERATE.equals((Object)localParser.getPreGenerationRequirement());
            this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface, generateAll);
            ModelImpl model = this.jaUtilities.getModel(jaxbAnnotatedInterface);
            return this.unmarshallClass(uri, model, localParser, null, advertiseInRegistry, advertiseInHub);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    @Override
    public <T> XmlRootHandle<T> unmarshall(XMLStreamReader reader, Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (reader == null || jaxbAnnotatedInterface == null) {
            throw new IllegalArgumentException();
        }
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface, false);
            ModelImpl model = this.jaUtilities.getModel(jaxbAnnotatedInterface);
            return this.unmarshallClass(null, model, null, reader, advertiseInRegistry, advertiseInHub);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    private <T> XmlRootHandle<T> unmarshallClass(URI uri, ModelImpl model, XmlServiceParser localParser, XMLStreamReader reader, boolean advertise, boolean advertiseInHub) throws Exception {
        long elapsedUpToJAXB = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedUpToJAXB = System.currentTimeMillis();
        }
        Hk2JAXBUnmarshallerListener listener = new Hk2JAXBUnmarshallerListener(this.jaUtilities, this.classReflectionHelper);
        long jaxbUnmarshallElapsedTime = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            jaxbUnmarshallElapsedTime = System.currentTimeMillis();
            elapsedUpToJAXB = jaxbUnmarshallElapsedTime - elapsedUpToJAXB;
            Logger.getLogger().debug("Time up to parsing " + uri + " is " + elapsedUpToJAXB + " milliseconds");
        }
        Object root = localParser != null ? localParser.parseRoot(model, uri, listener) : XmlStreamImpl.parseRoot(this, model, reader, listener);
        long elapsedJAXBToAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedJAXBToAdvertisement = System.currentTimeMillis();
            jaxbUnmarshallElapsedTime = elapsedJAXBToAdvertisement - jaxbUnmarshallElapsedTime;
            Logger.getLogger().debug("Time parsing " + uri + " is " + jaxbUnmarshallElapsedTime + " milliseconds " + ", now with " + this.jaUtilities.getNumGenerated() + " proxies generated and " + this.jaUtilities.getNumPreGenerated() + " pre generated proxies loaded");
        }
        DynamicChangeInfo changeControl = new DynamicChangeInfo(this.jaUtilities, advertiseInHub ? this.hub : null, this, advertise ? this.dynamicConfigurationService : null, this.serviceLocator);
        for (BaseHK2JAXBBean base : listener.getAllBeans()) {
            String instanceName = Utilities.createInstanceName(base);
            base._setInstanceName(instanceName);
            base._setDynamicChangeInfo(changeControl);
        }
        long elapsedPreAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedPreAdvertisement = System.currentTimeMillis();
            elapsedJAXBToAdvertisement = elapsedPreAdvertisement - elapsedJAXBToAdvertisement;
            Logger.getLogger().debug("Time from parsing to PreAdvertisement " + uri + " is " + elapsedJAXBToAdvertisement + " milliseconds");
        }
        DynamicConfiguration config = advertise ? this.dynamicConfigurationService.createDynamicConfiguration() : null;
        WriteableBeanDatabase wdb = advertiseInHub ? this.hub.getWriteableDatabaseCopy() : null;
        for (BaseHK2JAXBBean bean : listener.getAllBeans()) {
            Utilities.advertise(wdb, config, bean);
        }
        long elapsedHK2Advertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHK2Advertisement = System.currentTimeMillis();
            elapsedPreAdvertisement = elapsedHK2Advertisement - elapsedPreAdvertisement;
            Logger.getLogger().debug("Time from JAXB to PreAdvertisement " + uri + " is " + elapsedPreAdvertisement + " milliseconds");
        }
        if (config != null) {
            config.commit();
        }
        long elapsedHubAdvertisement = 0L;
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHubAdvertisement = System.currentTimeMillis();
            elapsedHK2Advertisement = elapsedHubAdvertisement - elapsedHK2Advertisement;
            Logger.getLogger().debug("Time to advertise " + uri + " in HK2 is " + elapsedHK2Advertisement + " milliseconds");
        }
        if (wdb != null) {
            wdb.commit((Object)new XmlHubCommitMessage(){});
        }
        if (JAUtilities.DEBUG_GENERATION_TIMING) {
            elapsedHubAdvertisement = System.currentTimeMillis() - elapsedHubAdvertisement;
            Logger.getLogger().debug("Time to advertise " + uri + " in Hub is " + elapsedHubAdvertisement + " milliseconds");
        }
        return new XmlRootHandleImpl(this, this.hub, root, model, uri, advertise, advertiseInHub, changeControl);
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotatedInterface, boolean advertiseInRegistry, boolean advertiseInHub) {
        if (!jaxbAnnotatedInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + jaxbAnnotatedInterface.getName());
        }
        try {
            this.jaUtilities.convertRootAndLeaves(jaxbAnnotatedInterface, true);
            ModelImpl model = this.jaUtilities.getModel(jaxbAnnotatedInterface);
            return new XmlRootHandleImpl<Object>(this, this.hub, null, model, null, advertiseInRegistry, advertiseInHub, new DynamicChangeInfo(this.jaUtilities, this.hub, this, advertiseInRegistry ? this.dynamicConfigurationService : null, this.serviceLocator));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MultiException((Throwable)e);
        }
    }

    @Override
    public <T> XmlRootHandle<T> createEmptyHandle(Class<T> jaxbAnnotationInterface) {
        return this.createEmptyHandle(jaxbAnnotationInterface, true, true);
    }

    @Override
    public <T> T createBean(Class<T> beanInterface) {
        BaseHK2JAXBBean retVal;
        if (!beanInterface.isInterface()) {
            throw new IllegalArgumentException("Only an interface can be given to unmarshall: " + beanInterface.getName());
        }
        this.jaUtilities.convertRootAndLeaves(beanInterface, true);
        ModelImpl model = this.jaUtilities.getModel(beanInterface);
        BaseHK2JAXBBean base = retVal = Utilities.createBean(model.getProxyAsClass());
        base._setClassReflectionHelper(this.classReflectionHelper);
        base._setActive();
        return (T)retVal;
    }

    public ClassReflectionHelper getClassReflectionHelper() {
        return this.classReflectionHelper;
    }

    DynamicConfigurationService getDynamicConfigurationService() {
        return this.dynamicConfigurationService;
    }

    public JAUtilities getJAUtilities() {
        return this.jaUtilities;
    }
}

