/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.defaulting;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBeanCustomizer;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.defaulting.DefaultedBean;
import org.glassfish.hk2.xml.test.defaulting.SecurityManagerBeanDefaulter;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class DefaultingTest {
    private static final String DEFAULTING_FILE = "defaulted.xml";

    @Test
    public void testDefaultedValues() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DEFAULTING_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DefaultedBean.class);
        DefaultedBean db = (DefaultedBean)rootHandle.getRoot();
        Assert.assertEquals((long)13L, (long)db.getIntProp());
        Assert.assertEquals((long)13L, (long)db.getLongProp());
        Assert.assertEquals((long)13L, (long)db.getByteProp());
        Assert.assertEquals((Object)true, (Object)db.isBooleanProp());
        Assert.assertEquals((long)13L, (long)db.getShortProp());
        Assert.assertEquals((long)102L, (long)db.getCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, db.getFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, db.getDoubleProp()));
        Assert.assertEquals((Object)"13", (Object)db.getStringProp());
    }

    @Test
    public void testDefaultDefaultedValues() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DEFAULTING_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DefaultedBean.class);
        DefaultedBean db = (DefaultedBean)rootHandle.getRoot();
        Assert.assertEquals((long)0L, (long)db.getDefaultIntProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultLongProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultByteProp());
        Assert.assertEquals((Object)false, (Object)db.isDefaultBooleanProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultShortProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(0.0f, db.getDefaultFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(0.0, db.getDefaultDoubleProp()));
        Assert.assertEquals(null, (Object)db.getDefaultStringProp());
    }

    @Test
    public void testCanGetValuesFromDynamicallyCreatedBean() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        DefaultedBean db = (DefaultedBean)xmlService.createBean(DefaultedBean.class);
        Assert.assertEquals((long)13L, (long)db.getIntProp());
        Assert.assertEquals((long)13L, (long)db.getLongProp());
        Assert.assertEquals((long)13L, (long)db.getByteProp());
        Assert.assertEquals((Object)true, (Object)db.isBooleanProp());
        Assert.assertEquals((long)13L, (long)db.getShortProp());
        Assert.assertEquals((long)102L, (long)db.getCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, db.getFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, db.getDoubleProp()));
        Assert.assertEquals((Object)"13", (Object)db.getStringProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultIntProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultLongProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultByteProp());
        Assert.assertEquals((Object)false, (Object)db.isDefaultBooleanProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultShortProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(0.0f, db.getDefaultFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(0.0, db.getDefaultDoubleProp()));
        Assert.assertEquals(null, (Object)db.getDefaultStringProp());
    }

    @Test
    public void testDefaultingViaServiceWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator, true);
        SecurityManagerBean smb = (SecurityManagerBean)locator.getService(SecurityManagerBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)smb);
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
    }

    @Test
    public void testDefaultingViaAddWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator, true);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        domain.setSecurityManager(null);
        Assert.assertNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
        SecurityManagerBean smb = (SecurityManagerBean)xmlService.createBean(SecurityManagerBean.class);
        domain.setSecurityManager(smb);
        smb = domain.getSecurityManager();
        Assert.assertNotNull((Object)smb);
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SecurityManagerBean.class, new Annotation[0]));
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
    }
}

