/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.merge;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.HttpFactoryBean;
import org.glassfish.hk2.xml.test.beans.HttpServerBean;
import org.glassfish.hk2.xml.test.beans.HttpsFactoryBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.QueueBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.beans.ServerBean;
import org.glassfish.hk2.xml.test.beans.TopicBean;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MergeTest {
    public static final String DOMAIN1_FILE = "domain1.xml";
    private static final String DOMAIN1_NAME = "domain1";
    public static final String RSA_ATZ_PROV_NAME = "RSA";
    private static final String RSA_DOM_PFX = "rsa";
    private static final String ALICE_NAME = "Alice";
    private static final String BOB_NAME = "Bob";
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    public static final String TOPIC0_NAME = "Topic0";
    public static final String TOPIC1_NAME = "Topic1";
    public static final String QUEUE0_NAME = "Queue0";
    public static final String QUEUE1_NAME = "Queue1";
    public static final String QUEUE2_NAME = "Queue2";
    public static final String TOPICD0_NAME = "TopicD0";
    public static final String QUEUED0_NAME = "QueueD0";
    public static final String ESSEX_NAME = "Essex";
    public static final String FAIRVIEW_NAME = "Fairview";
    public static final String GLENDOLA_NAME = "Glendola";
    public static final String HOLYOKE_NAME = "Holyoke";
    public static final String IROQUIS_NAME = "Iroquis";
    public static final String LIBERTY_NAME = "Liberty";
    private static final String ALICE_ADDRESS = "10.0.0.1";
    private static final String ALICE_SERVER0_NAME = "Server-0";
    private static final int ALICE_SERVER0_PORT = 12345;
    private static final String DOMAIN_TYPE = "/domain";
    private static final String DOMAIN_INSTANCE = "domain";
    private static final String MACHINE_TYPE = "/domain/machine";
    private static final String SERVER_TYPE = "/domain/machine/server";
    public static final String SECURITY_MANAGER_TYPE = "/domain/security-manager";
    public static final String AUTHORIZATION_PROVIDER_TYPE = "/domain/security-manager/authorization-provider";
    public static final String JMS_SERVER_TYPE = "/domain/jms-server";
    public static final String TOPIC_TYPE = "/domain/jms-server/topic";
    public static final String QUEUE_TYPE = "/domain/jms-server/queue";
    public static final String HTTP_FACTORY_TYPE = "/domain/http-factory";
    public static final String HTTP_SERVER_TYPE = "/domain/http-factory/http-server";
    public static final String HTTPS_FACTORY_TYPE = "/domain/https-factory";
    public static final String SSL_MANAGER_TYPE = "/domain/security-manager/ssl-manager";
    private static final String ALICE_INSTANCE = "domain.Alice";
    private static final String BOB_INSTANCE = "domain.Bob";
    public static final String DAVE_INSTANCE = "domain.Dave";
    private static final String SERVER0_INSTANCE = "domain.Alice.Server-0";
    public static final String SECURITY_MANAGER_INSTANCE = "domain.security-manager";
    private static final String RSA_INSTANCE = "domain.security-manager.RSA";
    private static final String JMS_SERVER_INSTANCE = "domain.Carol";
    private static final String TOPIC0_INSTANCE = "domain.Carol.Topic0";
    private static final String TOPIC1_INSTANCE = "domain.Carol.Topic1";
    private static final String QUEUE0_INSTANCE = "domain.Carol.Queue0";
    private static final String QUEUE1_INSTANCE = "domain.Carol.Queue1";
    private static final String QUEUE2_INSTANCE = "domain.Carol.Queue2";
    public static final String SSL_MANAGER_INSTANCE_NAME = "domain.security-manager.ssl-manager";
    private static final String ADDRESS_TAG = "address";
    private static final String PORT_TAG = "port";
    private static final String ATZ_DOMAIN_PFX_TAG = "domain-pfx";

    @Test
    public void testMergeModifyTwoPropertiesOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        Museum museumCopy = (Museum)copy.getChildRoot();
        Museum museumOld = (Museum)rootHandle.getRoot();
        museumCopy.setAge(101);
        museumCopy.setId(101);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        copy.merge();
        Assert.assertEquals((long)101L, (long)museumOld.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museumOld.getName());
        Assert.assertEquals((long)101L, (long)museumOld.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance("/museum", "museum");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get("age"));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
            List events = change.getModifiedProperties();
            Assert.assertEquals((long)2L, (long)events.size());
            boolean gotId = false;
            boolean gotAge = false;
            for (PropertyChangeEvent event : events) {
                if ("age".equals(event.getPropertyName())) {
                    gotAge = true;
                    continue;
                }
                if (!"id".equals(event.getPropertyName())) continue;
                gotId = true;
            }
            Assert.assertTrue((boolean)gotId);
            Assert.assertTrue((boolean)gotAge);
        }
    }

    @Test
    @Ignore
    public void testMergeModifyAddADirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        MachineBean addedBean = (MachineBean)xmlService.createBean(MachineBean.class);
        addedBean.setName(BOB_NAME);
        domainCopy.addMachine(addedBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        List<MachineBean> machines = domainOld.getMachines();
        Assert.assertEquals((long)2L, (long)machines.size());
        boolean foundAlice = false;
        boolean foundBob = false;
        for (MachineBean machine : machines) {
            if (machine.getName().equals(BOB_NAME)) {
                if (foundBob) {
                    Assert.fail((String)("There were more than one bob in the list of machines: " + machines));
                }
                foundBob = true;
                continue;
            }
            if (!machine.getName().equals(ALICE_NAME)) continue;
            if (foundAlice) {
                Assert.fail((String)("There were more than one alice in the list of machines: " + machines));
            }
            foundAlice = true;
        }
        Assert.assertTrue((String)("Added child was not found: " + machines), (boolean)foundBob);
        Assert.assertTrue((String)("Existing child was not found: " + machines), (boolean)foundAlice);
        Instance machineBobInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, BOB_INSTANCE);
        Assert.assertNotNull((Object)machineBobInstance);
        Map bobMap = (Map)machineBobInstance.getBean();
        Assert.assertEquals((Object)BOB_NAME, bobMap.get("name"));
        Assert.assertNull(bobMap.get(ADDRESS_TAG));
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> rootHandle, Hub hub, ServiceLocator locator, boolean didDefault) {
        DomainBean root = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, didDefault);
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        DomainBean root = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, false);
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> original, XmlRootCopy<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        Assert.assertEquals(original, (Object)rootHandle.getParent());
        DomainBean root = (DomainBean)rootHandle.getChildRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, false);
    }

    private static void verifyDomain1XmlDomain(DomainBean root, Hub hub, ServiceLocator locator, boolean didDefault) {
        Assert.assertEquals((String)("Failing bean is " + root), (Object)DOMAIN1_NAME, (Object)root.getName());
        SecurityManagerBean securityManager = root.getSecurityManager();
        Assert.assertNotNull((Object)securityManager);
        List<AuthorizationProviderBean> atzProviders = securityManager.getAuthorizationProviders();
        Assert.assertNotNull(atzProviders);
        Assert.assertEquals((long)1L, (long)atzProviders.size());
        if (!didDefault) {
            Assert.assertNull((Object)securityManager.getSSLManager());
        } else {
            SSLManagerBean sslManager = securityManager.getSSLManager();
            Assert.assertNotNull((Object)sslManager);
            Assert.assertNull((Object)sslManager.getPublicKeyLocation());
            Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
        }
        MachineBean aliceRef = null;
        for (AuthorizationProviderBean atzProvider : atzProviders) {
            Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)atzProvider.getName());
            Assert.assertEquals((Object)RSA_DOM_PFX, (Object)atzProvider.getAtzDomainPrefix());
            aliceRef = atzProvider.getMachine();
        }
        List<MachineBean> machines = root.getMachines();
        Assert.assertNotNull(machines);
        Assert.assertEquals((long)1L, (long)machines.size());
        ServerBean myReference = null;
        for (MachineBean machine : machines) {
            Assert.assertEquals((Object)aliceRef, (Object)machine);
            Assert.assertEquals((Object)ALICE_NAME, (Object)machine.getName());
            Assert.assertEquals((Object)ALICE_ADDRESS, (Object)machine.getAddress());
            List<ServerBean> servers = machine.getServers();
            Assert.assertNotNull(servers);
            Assert.assertEquals((long)1L, (long)servers.size());
            for (ServerBean server : servers) {
                Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)server.getName());
                Assert.assertEquals((long)12345L, (long)server.getPort());
                myReference = server;
            }
        }
        JMSServerBean[] jmsServers = root.getJMSServers();
        Assert.assertEquals((long)2L, (long)jmsServers.length);
        int lcv = 0;
        for (JMSServerBean jmsServer : jmsServers) {
            if (lcv == 0) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)CAROL_NAME, (Object)jmsServer.getName());
                ServerBean serverReference = jmsServer.getServer();
                Assert.assertEquals(myReference, (Object)serverReference);
                List<TopicBean> topics = jmsServer.getTopics();
                Assert.assertEquals((long)2L, (long)topics.size());
                Assert.assertEquals((Object)TOPIC0_NAME, (Object)topics.get(0).getName());
                Assert.assertEquals((Object)TOPIC1_NAME, (Object)topics.get(1).getName());
                QueueBean[] queues = jmsServer.getQueues();
                Assert.assertEquals((long)3L, (long)queues.length);
                Assert.assertEquals((Object)QUEUE0_NAME, (Object)queues[0].getName());
                Assert.assertEquals((Object)QUEUE1_NAME, (Object)queues[1].getName());
                Assert.assertEquals((Object)QUEUE2_NAME, (Object)queues[2].getName());
            } else if (lcv == 1) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)DAVE_NAME, (Object)jmsServer.getName());
                List<TopicBean> topics = jmsServer.getTopics();
                Assert.assertEquals((long)1L, (long)topics.size());
                Assert.assertEquals((Object)TOPICD0_NAME, (Object)topics.get(0).getName());
                QueueBean[] queues = jmsServer.getQueues();
                Assert.assertEquals((long)1L, (long)queues.length);
                Assert.assertEquals((Object)QUEUED0_NAME, (Object)queues[0].getName());
            }
            ++lcv;
        }
        List<HttpFactoryBean> httpFactories = root.getHTTPFactories();
        Assert.assertEquals((long)2L, (long)httpFactories.size());
        String factory0Identifier = null;
        String factory1Identifier = null;
        lcv = 0;
        for (HttpFactoryBean httpFactory : httpFactories) {
            List<HttpServerBean> httpServers;
            if (lcv == 0) {
                factory0Identifier = ((XmlHk2ConfigurationBean)httpFactory)._getInstanceName();
                Assert.assertEquals((Object)ESSEX_NAME, (Object)httpFactory.getNonKeyIdentifier());
                httpServers = httpFactory.getHttpServers();
                Assert.assertEquals((long)1L, (long)httpServers.size());
                for (HttpServerBean httpServer : httpServers) {
                    Assert.assertEquals((Object)FAIRVIEW_NAME, (Object)httpServer.getName());
                    Assert.assertEquals((long)1234L, (long)httpServer.getPort());
                }
            } else {
                factory1Identifier = ((XmlHk2ConfigurationBean)httpFactory)._getInstanceName();
                Assert.assertEquals((Object)GLENDOLA_NAME, (Object)httpFactory.getNonKeyIdentifier());
                httpServers = httpFactory.getHttpServers();
                Assert.assertEquals((long)2L, (long)httpServers.size());
                int lcv2 = 0;
                for (HttpServerBean httpServer : httpServers) {
                    if (lcv2 == 0) {
                        Assert.assertEquals((Object)HOLYOKE_NAME, (Object)httpServer.getName());
                        Assert.assertEquals((long)5678L, (long)httpServer.getPort());
                    } else {
                        Assert.assertEquals((Object)IROQUIS_NAME, (Object)httpServer.getName());
                        Assert.assertEquals((long)5679L, (long)httpServer.getPort());
                    }
                    ++lcv2;
                }
            }
            ++lcv;
        }
        HttpsFactoryBean[] httpsFactories = root.getHTTPSFactories();
        Assert.assertEquals((long)1L, (long)httpsFactories.length);
        Assert.assertEquals((Object)LIBERTY_NAME, (Object)httpsFactories[0].getNonKeyIdentifier());
        String httpsInstanceName = ((XmlHk2ConfigurationBean)httpsFactories[0])._getInstanceName();
        Instance domainInstance = hub.getCurrentDatabase().getInstance(DOMAIN_TYPE, DOMAIN_INSTANCE);
        Assert.assertNotNull((Object)domainInstance);
        Instance machineAliceInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, ALICE_INSTANCE);
        Assert.assertNotNull((Object)machineAliceInstance);
        Map aliceMap = (Map)machineAliceInstance.getBean();
        Assert.assertEquals((Object)ALICE_NAME, aliceMap.get("name"));
        Assert.assertEquals((Object)ALICE_ADDRESS, aliceMap.get(ADDRESS_TAG));
        Instance aliceServer0Instance = hub.getCurrentDatabase().getInstance(SERVER_TYPE, SERVER0_INSTANCE);
        Assert.assertNotNull((Object)aliceServer0Instance);
        Map server0Map = (Map)aliceServer0Instance.getBean();
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, server0Map.get("name"));
        Assert.assertEquals((Object)12345, server0Map.get(PORT_TAG));
        Instance securityManagerInstance = hub.getCurrentDatabase().getInstance(SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        Assert.assertNotNull((Object)securityManagerInstance);
        Map securityManagerMap = (Map)securityManagerInstance.getBean();
        Assert.assertNotNull((Object)securityManagerMap);
        Instance rsaInstance = hub.getCurrentDatabase().getInstance(AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        Assert.assertNotNull((Object)rsaInstance);
        Map rsaMap = (Map)rsaInstance.getBean();
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, rsaMap.get("name"));
        Assert.assertEquals((Object)RSA_DOM_PFX, rsaMap.get(ATZ_DOMAIN_PFX_TAG));
        Instance sslManagerInstance = hub.getCurrentDatabase().getInstance(SSL_MANAGER_TYPE, SSL_MANAGER_INSTANCE_NAME);
        if (didDefault) {
            Assert.assertNotNull((Object)sslManagerInstance);
            Map sslManagerMap = (Map)sslManagerInstance.getBean();
            Assert.assertNull(sslManagerMap.get("public-key-location"));
        } else {
            Assert.assertNull((Object)sslManagerInstance);
        }
        MergeTest.assertNameOnlyBean(hub, JMS_SERVER_TYPE, JMS_SERVER_INSTANCE, CAROL_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC0_INSTANCE, TOPIC0_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC1_INSTANCE, TOPIC1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE0_INSTANCE, QUEUE0_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE1_INSTANCE, QUEUE1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE2_INSTANCE, QUEUE2_NAME);
        Instance f0 = hub.getCurrentDatabase().getInstance(HTTP_FACTORY_TYPE, factory0Identifier);
        Assert.assertNotNull((Object)f0);
        Map beanLike = (Map)f0.getBean();
        Assert.assertEquals((Object)ESSEX_NAME, beanLike.get("non-key-identifier"));
        Instance f1 = hub.getCurrentDatabase().getInstance(HTTP_FACTORY_TYPE, factory1Identifier);
        Assert.assertNotNull((Object)f1);
        beanLike = (Map)f1.getBean();
        Assert.assertEquals((Object)GLENDOLA_NAME, beanLike.get("non-key-identifier"));
        Instance s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory0Identifier + "." + FAIRVIEW_NAME, FAIRVIEW_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(1234), beanLike.get(PORT_TAG));
        s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory1Identifier + "." + HOLYOKE_NAME, HOLYOKE_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(5678), beanLike.get(PORT_TAG));
        s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory1Identifier + "." + IROQUIS_NAME, IROQUIS_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(5679), beanLike.get(PORT_TAG));
        f1 = hub.getCurrentDatabase().getInstance(HTTPS_FACTORY_TYPE, httpsInstanceName);
        Assert.assertNotNull((Object)f1);
        beanLike = (Map)f1.getBean();
        Assert.assertEquals((Object)LIBERTY_NAME, beanLike.get("non-key-identifier"));
        MergeTest.assertDomain1Services(locator, locator, didDefault);
    }

    public static void verifyDomain1XmlDomainNotThere(Hub hub, ServiceLocator locator) {
        MergeTest.assertNotInHub(hub, DOMAIN_TYPE, DOMAIN_INSTANCE);
        MergeTest.assertNotInHub(hub, MACHINE_TYPE, ALICE_INSTANCE);
        MergeTest.assertNotInHub(hub, SERVER_TYPE, SERVER0_INSTANCE);
        MergeTest.assertNotInHub(hub, SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        MergeTest.assertNotInHub(hub, AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        MergeTest.assertNotInHub(hub, JMS_SERVER_TYPE, JMS_SERVER_INSTANCE);
        MergeTest.assertNotInHub(hub, JMS_SERVER_TYPE, JMS_SERVER_INSTANCE);
        MergeTest.assertNotInHub(hub, TOPIC_TYPE, TOPIC0_INSTANCE);
        MergeTest.assertNotInHub(hub, TOPIC_TYPE, TOPIC1_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE0_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE1_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE2_INSTANCE);
        MergeTest.assertNotDomain1Services(locator);
    }

    private static void assertNotInHub(Hub hub, String type, String instance) {
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance(type, instance));
    }

    public static void assertDomain1Services(ServiceLocator locator) {
        MergeTest.assertDomain1Services(locator, locator, false);
    }

    public static void assertDomain1Services(ServiceLocator locator, ServiceLocator fromLocator, boolean didDefault) {
        DomainBean db = (DomainBean)locator.getService(DomainBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)DOMAIN1_NAME, (Object)db.getName());
        MergeTest.assertServiceComesFromSameLocator(db, fromLocator);
        SecurityManagerBean smb = (SecurityManagerBean)locator.getService(SecurityManagerBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)smb);
        MergeTest.assertServiceComesFromSameLocator(smb, fromLocator);
        AuthorizationProviderBean rsa = (AuthorizationProviderBean)locator.getService(AuthorizationProviderBean.class, RSA_ATZ_PROV_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)rsa);
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)rsa.getName());
        MergeTest.assertServiceComesFromSameLocator(rsa, fromLocator);
        MachineBean mb = (MachineBean)locator.getService(MachineBean.class, ALICE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)mb);
        Assert.assertEquals((Object)ALICE_NAME, (Object)mb.getName());
        MergeTest.assertServiceComesFromSameLocator(mb, fromLocator);
        ServerBean sb = (ServerBean)locator.getService(ServerBean.class, ALICE_SERVER0_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)sb);
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)sb.getName());
        MergeTest.assertServiceComesFromSameLocator(sb, fromLocator);
        JMSServerBean carolJMS = (JMSServerBean)locator.getService(JMSServerBean.class, CAROL_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)carolJMS);
        Assert.assertEquals((Object)CAROL_NAME, (Object)carolJMS.getName());
        MergeTest.assertServiceComesFromSameLocator(carolJMS, fromLocator);
        JMSServerBean daveJMS = (JMSServerBean)locator.getService(JMSServerBean.class, DAVE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)daveJMS);
        Assert.assertEquals((Object)DAVE_NAME, (Object)daveJMS.getName());
        MergeTest.assertServiceComesFromSameLocator(daveJMS, fromLocator);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPIC0_NAME);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPIC1_NAME);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPICD0_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE0_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE1_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE2_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUED0_NAME);
        List httpFactories = locator.getAllServices(HttpFactoryBean.class, new Annotation[0]);
        Assert.assertTrue((2 == httpFactories.size() || 4 == httpFactories.size() ? 1 : 0) != 0);
        HttpFactoryBean essexFactory = null;
        HttpFactoryBean glendolaFactory = null;
        int lcv = 0;
        for (HttpFactoryBean httpFactory : httpFactories) {
            MergeTest.assertServiceComesFromSameLocator(httpFactory, fromLocator);
            if (httpFactory.getNonKeyIdentifier().equals(ESSEX_NAME)) {
                essexFactory = httpFactory;
            } else if (httpFactory.getNonKeyIdentifier().equals(GLENDOLA_NAME)) {
                glendolaFactory = httpFactory;
            } else {
                Assert.fail((String)("Unknown factory: " + httpFactory));
            }
            if (++lcv < 2) continue;
            break;
        }
        Assert.assertNotNull(essexFactory);
        Assert.assertNotNull(glendolaFactory);
        MergeTest.assertHttpServerOfName(locator, fromLocator, FAIRVIEW_NAME, 1234);
        MergeTest.assertHttpServerOfName(locator, fromLocator, HOLYOKE_NAME, 5678);
        MergeTest.assertHttpServerOfName(locator, fromLocator, IROQUIS_NAME, 5679);
        HttpsFactoryBean httpsFactory = (HttpsFactoryBean)locator.getService(HttpsFactoryBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)httpsFactory);
        Assert.assertEquals((Object)LIBERTY_NAME, (Object)httpsFactory.getNonKeyIdentifier());
        MergeTest.assertServiceComesFromSameLocator(httpsFactory, fromLocator);
        SSLManagerBean sslManager = (SSLManagerBean)locator.getService(SSLManagerBean.class, new Annotation[0]);
        if (didDefault) {
            Assert.assertNotNull((Object)sslManager);
            Assert.assertNull((Object)sslManager.getPublicKeyLocation());
            Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
            MergeTest.assertServiceComesFromSameLocator(sslManager, fromLocator);
        } else {
            Assert.assertNull((Object)sslManager);
        }
    }

    private static void assertServiceComesFromSameLocator(Object service, ServiceLocator locator) {
        Assert.assertTrue((boolean)(service instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean configBean = (XmlHk2ConfigurationBean)service;
        ActiveDescriptor descriptor = configBean._getSelfDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Long locatorId = locator.getLocatorId();
        Long serviceId = descriptor.getLocatorId();
        Assert.assertEquals((Object)locatorId, (Object)serviceId);
    }

    public static void assertQueueOfName(ServiceLocator locator, String expectedName) {
        MergeTest.assertQueueOfName(locator, locator, expectedName);
    }

    public static void assertQueueOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName) {
        QueueBean qb = (QueueBean)locator.getService(QueueBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)qb);
        Assert.assertEquals((Object)expectedName, (Object)qb.getName());
        MergeTest.assertServiceComesFromSameLocator(qb, fromLocator);
    }

    public static void assertHttpServerOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName, int expectedPort) {
        HttpServerBean hsb = (HttpServerBean)locator.getService(HttpServerBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)hsb);
        Assert.assertEquals((Object)expectedName, (Object)hsb.getName());
        Assert.assertEquals((long)expectedPort, (long)hsb.getPort());
        MergeTest.assertServiceComesFromSameLocator(hsb, fromLocator);
    }

    public static void assertTopicOfName(ServiceLocator locator, String expectedName) {
        MergeTest.assertTopicOfName(locator, locator, expectedName);
    }

    public static void assertTopicOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName) {
        TopicBean tb = (TopicBean)locator.getService(TopicBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)tb);
        Assert.assertEquals((Object)expectedName, (Object)tb.getName());
        MergeTest.assertServiceComesFromSameLocator(tb, fromLocator);
    }

    private static Instance assertNameOnlyBean(Hub hub, String type, String instance, String expectedName) {
        Instance namedInstance = hub.getCurrentDatabase().getInstance(type, instance);
        Assert.assertNotNull((String)("Could not find instance of " + type + "," + instance), (Object)namedInstance);
        Map namedMap = (Map)namedInstance.getBean();
        Assert.assertEquals((Object)expectedName, namedMap.get("name"));
        return namedInstance;
    }

    private static void assertNotDomain1Services(ServiceLocator locator) {
        MergeTest.assertLocalServiceNotThere(DomainBean.class, null, locator);
        MergeTest.assertLocalServiceNotThere(SecurityManagerBean.class, null, locator);
        MergeTest.assertLocalServiceNotThere(AuthorizationProviderBean.class, RSA_ATZ_PROV_NAME, locator);
        MergeTest.assertLocalServiceNotThere(MachineBean.class, ALICE_NAME, locator);
        MergeTest.assertLocalServiceNotThere(ServerBean.class, ALICE_SERVER0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(JMSServerBean.class, CAROL_NAME, locator);
        MergeTest.assertLocalServiceNotThere(JMSServerBean.class, DAVE_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPIC0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPIC1_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPICD0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE1_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE2_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUED0_NAME, locator);
    }

    private static void assertLocalServiceNotThere(Class<?> serviceClass, String serviceName, ServiceLocator localLocator) {
        LocalServiceOnlyFilter serviceFilter = new LocalServiceOnlyFilter(serviceClass, serviceName, localLocator);
        List allServices = localLocator.getAllServices((Filter)serviceFilter);
        Assert.assertEquals((long)0L, (long)allServices.size());
    }

    private static final class LocalServiceOnlyFilter
    implements IndexedFilter {
        private final Class<?> serviceClass;
        private final String name;
        private final ServiceLocator localLocator;

        private LocalServiceOnlyFilter(Class<?> serviceClass, String name, ServiceLocator localLocator) {
            this.serviceClass = serviceClass;
            this.name = name;
            this.localLocator = localLocator;
        }

        public boolean matches(Descriptor d) {
            return d.getLocatorId().equals(this.localLocator.getLocatorId());
        }

        public String getAdvertisedContract() {
            return this.serviceClass.getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

