/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.rawsets;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBeanCustomizer;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class RawSetsTest {
    public static final String MUSEUM2_FILE = "museum2.xml";
    public static final String MUSEUM_TYPE = "/museum";
    public static final String MUSEUM_INSTANCE = "museum";
    public static final String AGE_TAG = "age";
    public static final int ONE_OH_ONE_INT = 101;

    public static void verifyPreState(XmlRootHandle<Museum> rootHandle, Hub hub) {
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)110, beanLikeMap.get(AGE_TAG));
    }

    @Test
    public void testModifySingleProperty() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        museum.setAge(101);
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List changes = listener.changes;
        Assert.assertNotNull((Object)changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        }
    }

    @Test
    public void testAddDirectTypeWithSet() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManager = domain.getSecurityManager();
        SSLManagerBean sslManager = (SSLManagerBean)xmlService.createBean(SSLManagerBean.class);
        securityManager.setSSLManager(sslManager);
        sslManager = securityManager.getSSLManager();
        Assert.assertEquals((Object)securityManager, (Object)((XmlHk2ConfigurationBean)sslManager)._getParent());
        Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
        Assert.assertEquals((Object)sslManager, (Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
        Instance instance = hub.getCurrentDatabase().getInstance("/domain/security-manager/ssl-manager", "domain.security-manager.ssl-manager");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertNotNull((Object)beanLikeMap);
        Assert.assertTrue((boolean)beanLikeMap.isEmpty());
    }

    @Test
    public void testRemoveDirectTypeWithSet() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        domain.setSecurityManager(null);
        Assert.assertNull((Object)domain.getSecurityManager());
        Assert.assertNull((Object)locator.getService(SecurityManagerBean.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(AuthorizationProviderBean.class, new Annotation[0]));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance("/domain/security-manager", "domain.security-manager"));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance("/domain/security-manager/authorization-provider", "RSA"));
    }

    @Test
    public void testChangeDirectTypeWithSetFails() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean newOne = (SecurityManagerBean)xmlService.createBean(SecurityManagerBean.class);
        try {
            domain.setSecurityManager(newOne);
            Assert.fail((String)"Should have failed trying to change an existing bean");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    @Test
    public void testNullToNull() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManagerBean = domain.getSecurityManager();
        securityManagerBean.setSSLManager(null);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    @Test
    public void testSameToSame() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManagerBean = domain.getSecurityManager();
        domain.setSecurityManager(securityManagerBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    @Test
    public void testListSetToDifferentFails() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), DomainBean.class);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        LinkedList<MachineBean> newBeans = new LinkedList<MachineBean>();
        try {
            domain.setMachines(newBeans);
            Assert.fail((String)"Should not be able to set machines at this time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            domain.setMachines(null);
            Assert.fail((String)"Should not be able to set machines at this time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        List<MachineBean> oldBeans = domain.getMachines();
        try {
            domain.setMachines(oldBeans);
            Assert.fail((String)"Should not be able to set machines at this time");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
    }

    @Singleton
    public static class UpdateListener
    implements BeanDatabaseUpdateListener {
        private List<Change> changes;

        public void prepareDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }

        public void commitDatabaseChange(BeanDatabase oldDatabase, BeanDatabase currentDatabase, Object commitMessage, List<Change> changes) {
            this.changes = changes;
        }

        public void rollbackDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
        }

        public List<Change> getChanges() {
            return this.changes;
        }
    }
}

