/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;

public class DynamicChangeInfo {
    private final JAUtilities jaUtilities;
    private final ReentrantReadWriteLock treeLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeTreeLock = this.treeLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readTreeLock = this.treeLock.readLock();
    private long changeNumber = 0L;
    private final Hub hub;
    private final XmlServiceImpl idGenerator;
    private final DynamicConfigurationService dynamicService;
    private final ServiceLocator locator;
    private final LinkedHashSet<VetoableChangeListener> listeners = new LinkedHashSet();

    DynamicChangeInfo(JAUtilities jaUtilities, Hub hub, XmlServiceImpl idGenerator, DynamicConfigurationService dynamicService, ServiceLocator locator) {
        this.jaUtilities = jaUtilities;
        this.hub = hub;
        this.idGenerator = idGenerator;
        this.dynamicService = dynamicService;
        this.locator = locator;
    }

    public Hub getHub() {
        return this.hub;
    }

    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readTreeLock;
    }

    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeTreeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChangeNumber() {
        this.readTreeLock.lock();
        try {
            long l = this.changeNumber;
            return l;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementChangeNumber() {
        this.writeTreeLock.lock();
        try {
            ++this.changeNumber;
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    public JAUtilities getJAUtilities() {
        return this.jaUtilities;
    }

    public String getGeneratedId() {
        return this.jaUtilities.getUniqueId();
    }

    public XmlServiceImpl getIdGenerator() {
        return this.idGenerator;
    }

    public DynamicConfigurationService getDynamicConfigurationService() {
        return this.dynamicService;
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(VetoableChangeListener ... allAdds) {
        if (allAdds == null) {
            return;
        }
        this.writeTreeLock.lock();
        try {
            for (VetoableChangeListener add : allAdds) {
                this.listeners.add(add);
            }
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(VetoableChangeListener ... allRemoves) {
        if (allRemoves == null) {
            return;
        }
        this.writeTreeLock.lock();
        try {
            for (VetoableChangeListener remove : allRemoves) {
                this.listeners.remove(remove);
            }
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VetoableChangeListener> getChangeListeners() {
        this.readTreeLock.lock();
        try {
            List<VetoableChangeListener> list = Collections.unmodifiableList(new ArrayList<VetoableChangeListener>(this.listeners));
            return list;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }
}

