/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.PrepareFailedException;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class XmlRootCopyImpl<T>
implements XmlRootCopy<T> {
    private final Hub hub;
    private final XmlRootHandleImpl<T> parent;
    private final long basis;
    private final T copy;

    XmlRootCopyImpl(Hub hub, XmlRootHandleImpl<T> parent, long basis, T copy) {
        if (copy == null) {
            throw new IllegalStateException("Only a non-empty Handle can be copied");
        }
        this.hub = hub;
        this.parent = parent;
        this.basis = basis;
        this.copy = copy;
    }

    @Override
    public XmlRootHandle<T> getParent() {
        return this.parent;
    }

    @Override
    public T getChildRoot() {
        return this.copy;
    }

    @Override
    public boolean isMergeable() {
        return this.parent.getRevision() == this.basis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge() {
        this.parent.getChangeInfo().getWriteLock().lock();
        try {
            if (!this.isMergeable()) {
                throw new AssertionError((Object)"Parent has changed since copy was made, no merge possible");
            }
            WriteableBeanDatabase writeableDatabase = null;
            if (this.hub != null) {
                writeableDatabase = this.hub.getWriteableDatabaseCopy();
            }
            BaseHK2JAXBBean copyBean = (BaseHK2JAXBBean)this.copy;
            BaseHK2JAXBBean original = (BaseHK2JAXBBean)this.parent.getRoot();
            original._merge(copyBean, writeableDatabase);
            boolean success = false;
            try {
                writeableDatabase.commit((Object)new XmlHubCommitMessage(){});
                success = true;
            }
            catch (MultiException me) {
                boolean foundPrepareException = false;
                for (Throwable th : me.getErrors()) {
                    if (!(th instanceof PrepareFailedException)) continue;
                    foundPrepareException = true;
                    break;
                }
                success = !foundPrepareException;
            }
            finally {
                if (success) {
                    this.parent.getChangeInfo().incrementChangeNumber();
                }
                original._endMerge(success);
            }
        }
        finally {
            this.parent.getChangeInfo().getWriteLock().unlock();
        }
    }
}

