/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.InputStream;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.internal.XmlStreamImpl;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class DomXmlParser
implements XmlServiceParser {
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    @Inject
    private Provider<XmlServiceImpl> xmlService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        InputStream urlStream = location.toURL().openStream();
        try {
            Object t;
            XMLStreamReader xmlStreamReader = this.xif.createXMLStreamReader(urlStream);
            try {
                t = XmlStreamImpl.parseRoot((XmlServiceImpl)this.xmlService.get(), rootModel, xmlStreamReader, listener);
            }
            catch (Throwable throwable) {
                xmlStreamReader.close();
                throw throwable;
            }
            xmlStreamReader.close();
            return t;
        }
        finally {
            urlStream.close();
        }
    }

    @Override
    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }
}

