/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TwoPhaseResource;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.utilities.general.ValidatorUtilities;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.XmlDynamicChange;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class DynamicChangeInfo<T> {
    private final JAUtilities jaUtilities;
    private final ReentrantReadWriteLock treeLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeTreeLock = this.treeLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readTreeLock = this.treeLock.readLock();
    private long changeNumber = 0L;
    private final Hub hub;
    private final XmlServiceImpl idGenerator;
    private final boolean advertiseInLocator;
    private final boolean advertiseInHub;
    private final DynamicConfigurationService dynamicService;
    private final ServiceLocator locator;
    private final LinkedHashSet<VetoableChangeListener> listeners = new LinkedHashSet();
    private final LinkedHashSet<BaseHK2JAXBBean> participants = new LinkedHashSet();
    private XmlRootHandleImpl<T> root;
    private XmlDynamicChange dynamicChange = null;
    private int changeDepth = 0;
    private boolean globalSuccess = true;
    private Validator validator;

    DynamicChangeInfo(JAUtilities jaUtilities, Hub hub, boolean advertiseInHub, XmlServiceImpl idGenerator, DynamicConfigurationService dynamicService, boolean advertiseInLocator, ServiceLocator locator) {
        this.jaUtilities = jaUtilities;
        this.hub = hub;
        this.advertiseInHub = advertiseInHub;
        this.idGenerator = idGenerator;
        this.advertiseInLocator = advertiseInLocator;
        this.dynamicService = dynamicService;
        this.locator = locator;
    }

    void setRoot(XmlRootHandleImpl<T> root) {
        this.root = root;
    }

    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.readTreeLock;
    }

    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeTreeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChangeNumber() {
        this.readTreeLock.lock();
        try {
            long l = this.changeNumber;
            return l;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementChangeNumber() {
        this.writeTreeLock.lock();
        try {
            ++this.changeNumber;
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    public JAUtilities getJAUtilities() {
        return this.jaUtilities;
    }

    public String getGeneratedId() {
        return this.jaUtilities.getUniqueId();
    }

    public XmlServiceImpl getIdGenerator() {
        return this.idGenerator;
    }

    public XmlDynamicChange startOrContinueChange(BaseHK2JAXBBean participant) {
        ++this.changeDepth;
        if (participant != null) {
            this.participants.add(participant);
        }
        if (this.dynamicChange != null) {
            return this.dynamicChange;
        }
        this.globalSuccess = true;
        DynamicConfiguration change = null;
        DynamicConfiguration systemChange = null;
        if (this.dynamicService != null) {
            systemChange = this.dynamicService.createDynamicConfiguration();
            if (this.advertiseInLocator) {
                change = systemChange;
            }
        }
        WriteableBeanDatabase wbd = null;
        if (this.hub != null && this.advertiseInHub) {
            wbd = this.hub.getWriteableDatabaseCopy();
            wbd.setCommitMessage((Object)new XmlHubCommitMessage(){});
            if (systemChange != null) {
                systemChange.registerTwoPhaseResources(new TwoPhaseResource[]{wbd.getTwoPhaseResource()});
            }
        }
        this.dynamicChange = new XmlDynamicChange(wbd, change, systemChange);
        return this.dynamicChange;
    }

    public void endOrDeferChange(boolean success) throws MultiException {
        Set violations;
        --this.changeDepth;
        if (this.changeDepth < 0) {
            this.changeDepth = 0;
        }
        if (!success) {
            this.globalSuccess = false;
        }
        if (this.changeDepth > 0) {
            return;
        }
        ArrayList<BaseHK2JAXBBean> localParticipants = new ArrayList<BaseHK2JAXBBean>(this.participants);
        this.participants.clear();
        XmlDynamicChange localDynamicChange = this.dynamicChange;
        this.dynamicChange = null;
        if (localDynamicChange == null) {
            return;
        }
        ConstraintViolationException validationException = null;
        if (this.globalSuccess && this.validator != null && this.root != null && (violations = this.validator.validate(this.root.getRoot(), new Class[0])) != null & !violations.isEmpty()) {
            validationException = new ConstraintViolationException(violations);
        }
        if (!this.globalSuccess || validationException != null) {
            for (BaseHK2JAXBBean participant : localParticipants) {
                participant.__rollbackChange();
            }
            if (validationException != null) {
                throw validationException;
            }
            return;
        }
        for (BaseHK2JAXBBean participant : localParticipants) {
            participant.__activateChange();
        }
        DynamicConfiguration systemChange = localDynamicChange.getSystemDynamicConfiguration();
        WriteableBeanDatabase wbd = localDynamicChange.getBeanDatabase();
        if (systemChange == null && wbd != null) {
            wbd.commit((Object)new XmlHubCommitMessage(){});
            return;
        }
        if (systemChange == null) {
            return;
        }
        systemChange.commit();
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(VetoableChangeListener ... allAdds) {
        if (allAdds == null) {
            return;
        }
        this.writeTreeLock.lock();
        try {
            for (VetoableChangeListener add : allAdds) {
                this.listeners.add(add);
            }
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(VetoableChangeListener ... allRemoves) {
        if (allRemoves == null) {
            return;
        }
        this.writeTreeLock.lock();
        try {
            for (VetoableChangeListener remove : allRemoves) {
                this.listeners.remove(remove);
            }
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VetoableChangeListener> getChangeListeners() {
        this.readTreeLock.lock();
        try {
            List<VetoableChangeListener> list = Collections.unmodifiableList(new ArrayList<VetoableChangeListener>(this.listeners));
            return list;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validator findOrCreateValidator() {
        this.writeTreeLock.lock();
        try {
            if (this.validator != null) {
                Validator validator = this.validator;
                return validator;
            }
            Validator validator = this.validator = ValidatorUtilities.getValidator();
            return validator;
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValidator() {
        this.writeTreeLock.lock();
        try {
            this.validator = null;
        }
        finally {
            this.writeTreeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validator findValidator() {
        this.readTreeLock.lock();
        try {
            Validator validator = this.validator;
            return validator;
        }
        finally {
            this.readTreeLock.unlock();
        }
    }

    public String toString() {
        return "DynamicChangeInfo(inLocator=" + this.advertiseInLocator + ",inHub=" + this.advertiseInHub + "," + System.identityHashCode(this) + ")";
    }
}

