/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.customizer;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.customizer.CustomOne;
import org.glassfish.hk2.xml.test.customizer.CustomTwo;
import org.glassfish.hk2.xml.test.customizer.CustomizerOne;
import org.glassfish.hk2.xml.test.customizer.CustomizerThreeFirstHalf;
import org.glassfish.hk2.xml.test.customizer.CustomizerThreeSecondHalf;
import org.glassfish.hk2.xml.test.customizer.CustomizerTwoFirstHalf;
import org.glassfish.hk2.xml.test.customizer.CustomizerTwoSecondHalf;
import org.glassfish.hk2.xml.test.customizer.EmployeeBean;
import org.glassfish.hk2.xml.test.customizer.EmployeesBean;
import org.glassfish.hk2.xml.test.customizer.MuseumBean;
import org.glassfish.hk2.xml.test.customizer.MuseumBeanDoubleCustomized;
import org.glassfish.hk2.xml.test.customizer.MuseumBeanDoubleNamedCustomized;
import org.glassfish.hk2.xml.test.customizer.SpecializedEmployeeCustomizer;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class CustomizerTest {
    private static final String PREFIX = "Go ";
    private static final String POSTFIX = " Eagles";
    public static final boolean C4 = false;
    public static final int C5 = 5;
    public static final long C6 = 6L;
    public static final float C7 = 7.0f;
    public static final double C8 = 8.0;
    public static final byte C9 = 9;
    public static final short C10 = 10;
    public static final char C11 = 'E';
    public static final String ALICE_NAME = "Alice";
    public static final String BOB_NAME = "Bob";
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    private static final String TEST_STRING = "TestString for ";

    @Test
    public void testBasicCustomizerOnRoot() throws Exception {
        ServiceLocator locator = Utilities.createLocator(CustomizerOne.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), MuseumBean.class);
        MuseumBean museum = (MuseumBean)rootHandle.getRoot();
        CustomOne custom1 = (CustomOne)locator.getService(CustomOne.class, new Annotation[0]);
        CustomTwo custom2 = (CustomTwo)locator.getService(CustomTwo.class, new Annotation[0]);
        this.verifyBasicCustomizersWorked(museum, custom1, custom2, true);
    }

    @Test
    public void testTwoCustomizersWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(CustomizerTwoFirstHalf.class, CustomizerTwoSecondHalf.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), MuseumBeanDoubleCustomized.class);
        MuseumBeanDoubleCustomized museum = (MuseumBeanDoubleCustomized)rootHandle.getRoot();
        CustomOne custom1 = (CustomOne)locator.getService(CustomOne.class, new Annotation[0]);
        CustomTwo custom2 = (CustomTwo)locator.getService(CustomTwo.class, new Annotation[0]);
        this.verifyBasicCustomizersWorked(museum, custom1, custom2, true);
    }

    @Test
    public void testTwoNamedCustomizersWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(CustomizerTwoFirstHalf.class, CustomizerTwoSecondHalf.class, CustomizerThreeFirstHalf.class, CustomizerThreeSecondHalf.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), MuseumBeanDoubleNamedCustomized.class);
        MuseumBeanDoubleNamedCustomized museum = (MuseumBeanDoubleNamedCustomized)rootHandle.getRoot();
        CustomOne custom1 = (CustomOne)locator.getService(CustomOne.class, CAROL_NAME, new Annotation[0]);
        CustomTwo custom2 = (CustomTwo)locator.getService(CustomTwo.class, DAVE_NAME, new Annotation[0]);
        this.verifyBasicCustomizersWorked(museum, custom1, custom2, false);
        CustomOne custom1_neg = (CustomOne)locator.getService(CustomOne.class, ALICE_NAME, new Annotation[0]);
        CustomTwo custom2_neg = (CustomTwo)locator.getService(CustomTwo.class, BOB_NAME, new Annotation[0]);
        Assert.assertFalse((boolean)custom1_neg.getCustomizer2Called());
        Assert.assertFalse((boolean)custom2_neg.getFauxAddCalled());
    }

    private void verifyBasicCustomizersWorked(MuseumBean museum, CustomOne custom1, CustomTwo custom2, boolean badFails) throws Exception {
        block3: {
            String retVal = museum.customizer1(PREFIX, POSTFIX);
            Assert.assertEquals((Object)retVal, (Object)"Go Ben Franklin Eagles");
            Assert.assertFalse((boolean)custom1.getCustomizer2Called());
            museum.customizer2();
            Assert.assertTrue((boolean)custom1.getCustomizer2Called());
            long[] c3 = museum.customizer3(null);
            Assert.assertNotNull((Object)c3);
            Assert.assertEquals((long)0L, (long)c3.length);
            Assert.assertEquals((Object)false, (Object)museum.customizer4());
            Assert.assertEquals((long)5L, (long)museum.customizer5());
            Assert.assertEquals((long)6L, (long)museum.customizer6());
            Assert.assertEquals((long)0L, (long)Float.compare(7.0f, museum.customizer7()));
            Assert.assertEquals((long)0L, (long)Double.compare(8.0, museum.customizer8()));
            Assert.assertEquals((long)9L, (long)museum.customizer9());
            Assert.assertEquals((long)10L, (long)museum.customizer10());
            Assert.assertEquals((long)69L, (long)museum.customizer11());
            int varSize = museum.customizer12(false, 5, 6L, 7.0f, 8.0, (byte)9, (short)10, 'E', new int[0][]);
            Assert.assertEquals((long)0L, (long)varSize);
            int[] i1 = new int[]{1, 2, 3};
            int[] i2 = new int[]{4, 5, 6, 7};
            varSize = museum.customizer12(false, 5, 6L, 7.0f, 8.0, (byte)9, (short)10, 'E', i1, i2);
            Assert.assertEquals((long)2L, (long)varSize);
            Assert.assertFalse((boolean)custom2.getFauxAddCalled());
            museum.addListener(null);
            Assert.assertTrue((boolean)custom2.getFauxAddCalled());
            String[] uppers = museum.toUpper(new String[]{"Go", "Eagles"});
            Assert.assertEquals((Object)"GO", (Object)uppers[0]);
            Assert.assertEquals((Object)"EAGLES", (Object)uppers[1]);
            Assert.assertEquals((long)2L, (long)uppers.length);
            try {
                museum.theVeryBadNotGoodMethod();
                if (badFails) {
                    Assert.fail((String)"The verby bad not good method should not have worked");
                }
            }
            catch (MultiException me) {
                if (badFails) break block3;
                throw me;
            }
        }
    }

    @Test
    public void testCustomizerWithBeanAsFirstArgument() throws Exception {
        ServiceLocator locator = Utilities.createLocator(SpecializedEmployeeCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshall(url.toURI(), EmployeesBean.class);
        EmployeesBean employees = (EmployeesBean)rootHandle.getRoot();
        Assert.assertNotNull((Object)employees);
        EmployeeBean bob = (EmployeeBean)locator.getService(EmployeeBean.class, BOB_NAME, new Annotation[0]);
        EmployeeBean carol = (EmployeeBean)locator.getService(EmployeeBean.class, CAROL_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)bob);
        Assert.assertNotNull((Object)carol);
        Assert.assertEquals((Object)"TestString for Bob", (Object)bob.doACustomThing(TEST_STRING));
        Assert.assertEquals((Object)"TestString for Carol", (Object)carol.doACustomThing(TEST_STRING));
    }
}

