/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.copy;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.QueueBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.beans.ServerBean;
import org.glassfish.hk2.xml.test.beans.TopicBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class CopyTest {
    @Test
    public void testCopyOfDeepTree() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, (XmlRootCopy<DomainBean>)copy, hub, locator);
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOriginal = (DomainBean)rootHandle.getRoot();
        CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)domainOriginal, (XmlHk2ConfigurationBean)domainCopy);
        SecurityManagerBean securityManagerCopy = domainCopy.getSecurityManager();
        SecurityManagerBean securityManagerOriginal = domainCopy.getSecurityManager();
        CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)securityManagerOriginal, (XmlHk2ConfigurationBean)securityManagerCopy);
        AuthorizationProviderBean atzProviderCopy = securityManagerCopy.getAuthorizationProviders().get(0);
        AuthorizationProviderBean atzProviderOriginal = securityManagerOriginal.getAuthorizationProviders().get(0);
        CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)atzProviderOriginal, (XmlHk2ConfigurationBean)atzProviderCopy);
        MachineBean machineCopy = domainCopy.getMachines().get(0);
        MachineBean machineOriginal = domainOriginal.getMachines().get(0);
        CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)machineOriginal, (XmlHk2ConfigurationBean)machineCopy);
        ServerBean serverCopy = machineCopy.getServers().get(0);
        ServerBean serverOriginal = machineOriginal.getServers().get(0);
        CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)serverOriginal, (XmlHk2ConfigurationBean)serverCopy);
        JMSServerBean[] jmsServersCopy = domainCopy.getJMSServers();
        JMSServerBean[] jmsServersOriginal = domainOriginal.getJMSServers();
        Assert.assertEquals((long)jmsServersCopy.length, (long)jmsServersOriginal.length);
        for (int lcv = 0; lcv < jmsServersOriginal.length; ++lcv) {
            int lcv1;
            JMSServerBean jmsServerCopy = jmsServersCopy[lcv];
            JMSServerBean jmsServerOriginal = jmsServersOriginal[lcv];
            CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)jmsServerOriginal, (XmlHk2ConfigurationBean)jmsServerCopy);
            List<TopicBean> topicsCopy = jmsServerCopy.getTopics();
            List<TopicBean> topicsOriginal = jmsServerOriginal.getTopics();
            Assert.assertEquals((long)topicsCopy.size(), (long)topicsOriginal.size());
            for (lcv1 = 0; lcv1 < topicsOriginal.size(); ++lcv1) {
                TopicBean topicCopy = topicsCopy.get(lcv1);
                TopicBean topicOriginal = topicsOriginal.get(lcv1);
                CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)topicOriginal, (XmlHk2ConfigurationBean)topicCopy);
            }
            QueueBean[] queuesCopy = jmsServerCopy.getQueues();
            QueueBean[] queuesOriginal = jmsServerOriginal.getQueues();
            Assert.assertEquals((long)queuesCopy.length, (long)queuesOriginal.length);
            for (lcv1 = 0; lcv1 < queuesOriginal.length; ++lcv1) {
                QueueBean queueCopy = queuesCopy[lcv1];
                QueueBean queueOriginal = queuesOriginal[lcv1];
                CopyTest.verifyMetadataTheSame((XmlHk2ConfigurationBean)queueOriginal, (XmlHk2ConfigurationBean)queueCopy);
            }
        }
    }

    private static void verifyMetadataTheSame(XmlHk2ConfigurationBean original, XmlHk2ConfigurationBean copy) {
        Assert.assertEquals((String)"xmlPath does not match", (Object)original._getXmlPath(), (Object)copy._getXmlPath());
        Assert.assertEquals((String)"instanceName does not match", (Object)original._getInstanceName(), (Object)copy._getInstanceName());
        Assert.assertEquals((String)"keyPropertyName does not match", (Object)original._getKeyPropertyName(), (Object)copy._getKeyPropertyName());
        Assert.assertEquals((String)"keyValue does not match", (Object)original._getKeyValue(), (Object)copy._getKeyValue());
    }
}

