/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import org.glassfish.hk2.xml.api.XmlHandleTransaction;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.Differences;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class XmlRootCopyImpl<T>
implements XmlRootCopy<T> {
    private final XmlRootHandleImpl<T> parent;
    private final long basis;
    private final T copy;

    XmlRootCopyImpl(XmlRootHandleImpl<T> parent, long basis, T copy) {
        if (copy == null) {
            throw new IllegalStateException("Only a non-empty Handle can be copied");
        }
        this.parent = parent;
        this.basis = basis;
        this.copy = copy;
    }

    @Override
    public XmlRootHandle<T> getParent() {
        return this.parent;
    }

    @Override
    public T getChildRoot() {
        return this.copy;
    }

    @Override
    public boolean isMergeable() {
        return this.parent.getRevision() == this.basis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge() {
        boolean success = false;
        XmlHandleTransaction<T> handle = this.parent.lockForTransaction();
        try {
            if (!this.isMergeable()) {
                throw new AssertionError((Object)"Parent has changed since copy was made, no merge possible");
            }
            BaseHK2JAXBBean copyBean = (BaseHK2JAXBBean)this.copy;
            BaseHK2JAXBBean original = (BaseHK2JAXBBean)this.parent.getRoot();
            Differences differences = Utilities.getDiff(original, copyBean);
            if (!differences.getDifferences().isEmpty()) {
                Utilities.applyDiff(differences);
            }
            success = true;
        }
        finally {
            if (success) {
                handle.commit();
            } else {
                handle.abandon();
            }
        }
    }

    public String toString() {
        return "XmlRootCopyImpl(" + this.parent + "," + this.basis + "," + this.copy + "," + System.identityHashCode(this) + ")";
    }
}

