/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.PropertyChangeEvent;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Differences {
    private List<Difference> differences = new LinkedList<Difference>();

    public void addDifference(Difference difference) {
        this.differences.add(difference);
    }

    public List<Difference> getDifferences() {
        return this.differences;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Differences(num=" + this.differences.size() + "\n");
        int lcv = 1;
        for (Difference d : this.differences) {
            BaseHK2JAXBBean source = d.getSource();
            String xmlPath = source._getXmlPath();
            String instanceName = source._getInstanceName();
            List<PropertyChangeEvent> events = d.getNonChildChanges();
            sb.append(lcv + ". Modified Bean sourcePath=" + xmlPath + " sourceInstance=" + instanceName + "\n");
            for (PropertyChangeEvent event : events) {
                sb.append("  CHANGED: " + event.getPropertyName() + " from " + event.getOldValue() + " to " + event.getNewValue() + "\n");
            }
            Map<String, BaseHK2JAXBBean> adds = d.getAdds();
            for (Map.Entry<String, BaseHK2JAXBBean> add : adds.entrySet()) {
                BaseHK2JAXBBean added = add.getValue();
                String addedXmlPath = added._getXmlPath();
                String addedInstanceName = added._getInstanceName();
                sb.append("  ADDED: addedPath=" + addedXmlPath + " addedInstanceName=" + addedInstanceName);
            }
            Map<String, RemoveData> removed = d.getRemoves();
            for (Map.Entry<String, RemoveData> remove : removed.entrySet()) {
                RemoveData removeMe = remove.getValue();
                String removedXmlPath = removeMe.getChild()._getXmlPath();
                String removedInstanceName = removeMe.getChild()._getInstanceName();
                sb.append("  REMOVED: removedPath=" + removedXmlPath + " removedInstanceName=" + removedInstanceName);
            }
            ++lcv;
        }
        return sb.toString();
    }

    public static class RemoveData {
        private final String childProperty;
        private final String childKey;
        private final int index;
        private final BaseHK2JAXBBean child;

        public RemoveData(String childProperty, BaseHK2JAXBBean child) {
            this(childProperty, null, -1, child);
        }

        public RemoveData(String childProperty, String childKey, BaseHK2JAXBBean child) {
            this(childProperty, childKey, -1, child);
        }

        public RemoveData(String childProperty, int index, BaseHK2JAXBBean child) {
            this(childProperty, null, index, child);
        }

        private RemoveData(String childProperty, String childKey, int index, BaseHK2JAXBBean child) {
            this.childProperty = childProperty;
            this.childKey = childKey;
            this.index = index;
            this.child = child;
        }

        public String getChildProperty() {
            return this.childProperty;
        }

        public String getChildKey() {
            return this.childKey;
        }

        public int getIndex() {
            return this.index;
        }

        public BaseHK2JAXBBean getChild() {
            return this.child;
        }
    }

    public static class Difference {
        private final BaseHK2JAXBBean source;
        private final List<PropertyChangeEvent> nonChildChanges = new LinkedList<PropertyChangeEvent>();
        private final Map<String, BaseHK2JAXBBean> adds = new LinkedHashMap<String, BaseHK2JAXBBean>();
        private final Map<String, RemoveData> removes = new LinkedHashMap<String, RemoveData>();

        public Difference(BaseHK2JAXBBean source) {
            this.source = source;
        }

        public BaseHK2JAXBBean getSource() {
            return this.source;
        }

        public void addNonChildChange(PropertyChangeEvent evt) {
            this.nonChildChanges.add(evt);
        }

        public List<PropertyChangeEvent> getNonChildChanges() {
            return this.nonChildChanges;
        }

        public void addAdd(String propName, BaseHK2JAXBBean toAdd) {
            this.adds.put(propName, toAdd);
        }

        public Map<String, BaseHK2JAXBBean> getAdds() {
            return this.adds;
        }

        public void addRemove(String propName, RemoveData removeData) {
            this.removes.put(propName, removeData);
        }

        public Map<String, RemoveData> getRemoves() {
            return this.removes;
        }

        public boolean isDirty() {
            return !this.nonChildChanges.isEmpty() || !this.adds.isEmpty() || !this.removes.isEmpty();
        }

        public String toString() {
            return "Difference(" + this.source + "," + System.identityHashCode(this) + ")";
        }
    }
}

