/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Hk2JAXBUnmarshallerListener
extends Unmarshaller.Listener {
    private final JAUtilities jaUtilities;
    private final ClassReflectionHelper classReflectionHelper;
    private final LinkedList<BaseHK2JAXBBean> allBeans = new LinkedList();

    Hk2JAXBUnmarshallerListener(JAUtilities jaUtilities, ClassReflectionHelper classReflectionHelper) {
        this.jaUtilities = jaUtilities;
        this.classReflectionHelper = classReflectionHelper;
    }

    private void setUserKey(BaseHK2JAXBBean bean, boolean listOrArray) {
        ModelImpl model = bean._getModel();
        String keyProperty = model.getKeyProperty();
        if (keyProperty == null && listOrArray) {
            bean._setKeyValue(this.jaUtilities.getUniqueId());
            return;
        }
        if (keyProperty == null) {
            return;
        }
        String key = (String)bean._getProperty(keyProperty);
        if (key == null) {
            return;
        }
        bean._setKeyValue(key);
    }

    private void setSelfXmlTagInAllChildren(BaseHK2JAXBBean targetBean) {
        ModelImpl model = targetBean._getModel();
        for (ParentedModel parentedNode : model.getAllChildren()) {
            Object children = targetBean._getProperty(parentedNode.getChildXmlTag());
            if (children == null) continue;
            if (children instanceof List) {
                for (Object child : (List)children) {
                    BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)child;
                    childBean._setSelfXmlTag(parentedNode.getChildXmlTag());
                    this.setUserKey(childBean, true);
                }
                continue;
            }
            if (children.getClass().isArray()) {
                for (Object child : (Object[])children) {
                    BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)child;
                    childBean._setSelfXmlTag(parentedNode.getChildXmlTag());
                    this.setUserKey(childBean, true);
                }
                continue;
            }
            BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)children;
            childBean._setSelfXmlTag(parentedNode.getChildXmlTag());
            this.setUserKey(childBean, false);
        }
    }

    public void afterUnmarshal(Object target, Object parent) {
        if (!(target instanceof BaseHK2JAXBBean)) {
            return;
        }
        BaseHK2JAXBBean targetBean = (BaseHK2JAXBBean)target;
        BaseHK2JAXBBean parentBean = (BaseHK2JAXBBean)parent;
        ModelImpl targetNode = targetBean._getModel();
        this.allBeans.add(targetBean);
        if (parentBean == null) {
            targetBean._setSelfXmlTag(targetNode.getRootName());
        }
        this.setSelfXmlTagInAllChildren(targetBean);
    }

    public void beforeUnmarshal(Object target, Object parent) {
        if (!(target instanceof BaseHK2JAXBBean)) {
            return;
        }
        BaseHK2JAXBBean targetBean = (BaseHK2JAXBBean)target;
        targetBean._setClassReflectionHelper(this.classReflectionHelper);
        targetBean._setParent(parent);
    }

    LinkedList<BaseHK2JAXBBean> getAllBeans() {
        return this.allBeans;
    }
}

