/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.general.IndentingXMLStreamWriter;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.ReferenceKey;
import org.glassfish.hk2.xml.internal.UnresolvedReference;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;

public class XmlStreamImpl {
    private static final boolean DEBUG_PARSING = XmlServiceImpl.DEBUG_PARSING;

    public static <T> T parseRoot(XmlServiceImpl xmlService, Model rootModel, XMLStreamReader reader, Unmarshaller.Listener listener) throws Exception {
        Class<?> rootProxyClass = rootModel.getProxyAsClass();
        ClassReflectionHelper classReflectionHelper = xmlService.getClassReflectionHelper();
        BaseHK2JAXBBean hk2Root = Utilities.createBean(rootProxyClass);
        hk2Root._setClassReflectionHelper(classReflectionHelper);
        if (DEBUG_PARSING) {
            Logger.getLogger().debug("XmlServiceDebug Created root bean with model " + hk2Root._getModel());
        }
        HashMap<ReferenceKey, BaseHK2JAXBBean> referenceMap = new HashMap<ReferenceKey, BaseHK2JAXBBean>();
        LinkedList<UnresolvedReference> unresolved = new LinkedList<UnresolvedReference>();
        while (reader.hasNext()) {
            int event = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (A) " + XmlStreamImpl.eventToString(event));
            }
            switch (event) {
                case 1: {
                    String elementTag = reader.getName().getLocalPart();
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug starting document tag " + elementTag);
                    }
                    XmlStreamImpl.handleElement(hk2Root, null, reader, classReflectionHelper, listener, referenceMap, unresolved, elementTag);
                    break;
                }
                case 8: {
                    Utilities.fillInUnfinishedReferences(referenceMap, unresolved);
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug finished reading document");
                    }
                    return (T)hk2Root;
                }
            }
        }
        throw new IllegalStateException("Unexpected end of XMLReaderStream");
    }

    private static <T> void handleElement(BaseHK2JAXBBean target, BaseHK2JAXBBean parent, XMLStreamReader reader, ClassReflectionHelper classReflectionHelper, Unmarshaller.Listener listener, Map<ReferenceKey, BaseHK2JAXBBean> referenceMap, List<UnresolvedReference> unresolved, String outerElementTag) throws Exception {
        BaseHK2JAXBBean reference;
        Object convertedValue;
        Class<?> childType;
        listener.beforeUnmarshal((Object)target, (Object)parent);
        HashMap<String, ArrayList<BaseHK2JAXBBean>> listChildren = new HashMap<String, ArrayList<BaseHK2JAXBBean>>();
        HashMap<String, ArrayList<BaseHK2JAXBBean>> arrayChildren = new HashMap<String, ArrayList<BaseHK2JAXBBean>>();
        ModelImpl targetModel = target._getModel();
        Map<String, ChildDataModel> nonChildProperties = targetModel.getNonChildProperties();
        Map<String, ParentedModel> childProperties = targetModel.getChildrenByName();
        int numAttributes = reader.getAttributeCount();
        for (int lcv = 0; lcv < numAttributes; ++lcv) {
            ReferenceKey rk;
            ChildDataModel childDataModel;
            String attributeName = reader.getAttributeLocalName(lcv);
            String attributeValue = reader.getAttributeValue(lcv);
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug handling attribute " + attributeName + " with value " + attributeValue);
            }
            if ((childDataModel = nonChildProperties.get(attributeName)) == null) continue;
            childType = targetModel.getNonChildType(attributeName);
            if (!childDataModel.isReference()) {
                convertedValue = Utilities.getDefaultValue(attributeValue, childType);
                target._setProperty(attributeName, convertedValue);
                continue;
            }
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug attribute " + attributeName + " is a reference");
            }
            if ((reference = referenceMap.get(rk = new ReferenceKey(childDataModel.getChildType(), attributeValue))) != null) {
                target._setProperty(attributeName, reference);
                continue;
            }
            unresolved.add(new UnresolvedReference(childDataModel.getChildType(), attributeValue, attributeName, target));
        }
        while (reader.hasNext()) {
            int event = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (B) " + XmlStreamImpl.eventToString(event));
            }
            switch (event) {
                case 1: {
                    ChildDataModel cdm;
                    String elementTag = reader.getName().getLocalPart();
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug starting parse of element " + elementTag);
                    }
                    if ((cdm = nonChildProperties.get(elementTag)) != null) {
                        String elementValue = XmlStreamImpl.advanceNonChildElement(reader, elementTag);
                        childType = cdm.getChildTypeAsClass();
                        if (!cdm.isReference()) {
                            convertedValue = Utilities.getDefaultValue(elementValue, childType);
                            target._setProperty(elementTag, convertedValue);
                            break;
                        }
                        ReferenceKey referenceKey = new ReferenceKey(cdm.getChildType(), elementValue);
                        reference = referenceMap.get(referenceKey);
                        if (reference != null) {
                            target._setProperty(elementTag, reference);
                            break;
                        }
                        unresolved.add(new UnresolvedReference(cdm.getChildType(), elementValue, elementTag, target));
                        break;
                    }
                    ParentedModel informedChild = childProperties.get(elementTag);
                    if (informedChild != null) {
                        List<BaseHK2JAXBBean> cList;
                        ModelImpl grandChild = informedChild.getChildModel();
                        BaseHK2JAXBBean hk2Root = Utilities.createBean(grandChild.getProxyAsClass());
                        hk2Root._setClassReflectionHelper(classReflectionHelper);
                        if (DEBUG_PARSING) {
                            Logger.getLogger().debug("XmlServiceBean created child bean of " + outerElementTag + " with model " + hk2Root._getModel());
                        }
                        XmlStreamImpl.handleElement(hk2Root, target, reader, classReflectionHelper, listener, referenceMap, unresolved, elementTag);
                        if (informedChild.getChildType().equals((Object)ChildType.DIRECT)) {
                            target._setProperty(elementTag, hk2Root);
                            break;
                        }
                        if (informedChild.getChildType().equals((Object)ChildType.LIST)) {
                            cList = (ArrayList<BaseHK2JAXBBean>)listChildren.get(elementTag);
                            if (cList == null) {
                                cList = new ArrayList<BaseHK2JAXBBean>();
                                listChildren.put(elementTag, (ArrayList<BaseHK2JAXBBean>)cList);
                            }
                            cList.add(hk2Root);
                            break;
                        }
                        if (!informedChild.getChildType().equals((Object)ChildType.ARRAY)) break;
                        cList = (List)arrayChildren.get(elementTag);
                        if (cList == null) {
                            cList = new LinkedList();
                            arrayChildren.put(elementTag, (ArrayList<BaseHK2JAXBBean>)cList);
                        }
                        cList.add(hk2Root);
                        break;
                    }
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceBean found unknown element in " + outerElementTag + " named " + elementTag + " skipping");
                    }
                    XmlStreamImpl.skip(reader, elementTag);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    for (Map.Entry entry : listChildren.entrySet()) {
                        target._setProperty((String)entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry entry : arrayChildren.entrySet()) {
                        String childTag = (String)entry.getKey();
                        ParentedModel pn = targetModel.getChild(childTag);
                        Class<?> childType2 = pn.getChildModel().getOriginalInterfaceAsClass();
                        List individuals = (List)entry.getValue();
                        Object actualArray = Array.newInstance(childType2, individuals.size());
                        int index = 0;
                        for (BaseHK2JAXBBean individual : individuals) {
                            Array.set(actualArray, index++, individual);
                        }
                        target._setProperty(childTag, actualArray);
                    }
                    listener.afterUnmarshal((Object)target, (Object)parent);
                    String keyProp = target._getKeyPropertyName();
                    if (keyProp != null) {
                        String keyVal = (String)target._getProperty(keyProp);
                        String myType = target._getModel().getOriginalInterface();
                        if (keyVal != null && myType != null) {
                            referenceMap.put(new ReferenceKey(myType, keyVal), target);
                        }
                    }
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug ending parse of element " + outerElementTag);
                    }
                    return;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    private static String advanceNonChildElement(XMLStreamReader reader, String outerTag) throws Exception {
        String retVal = null;
        while (reader.hasNext()) {
            int nextEvent = reader.next();
            if (DEBUG_PARSING) {
                Logger.getLogger().debug("XmlServiceDebug got xml event (C) " + XmlStreamImpl.eventToString(nextEvent));
            }
            switch (nextEvent) {
                case 4: {
                    String text = reader.getText();
                    retVal = text.trim();
                    if (!DEBUG_PARSING) break;
                    Logger.getLogger().debug("XmlServiceDebug characters of tag " + outerTag + " is " + retVal);
                    break;
                }
                case 2: {
                    if (DEBUG_PARSING) {
                        Logger.getLogger().debug("XmlServiceDebug ending parse of non-child element " + outerTag);
                    }
                    return retVal;
                }
            }
        }
        return retVal;
    }

    private static void skip(XMLStreamReader reader, String skipOverTag) throws Exception {
        while (reader.hasNext()) {
            String elementTag;
            int event = reader.next();
            if (DEBUG_PARSING) {
                String name = null;
                if (reader.hasName()) {
                    name = reader.getName().getLocalPart();
                }
                Logger.getLogger().debug("XmlServiceDebug got xml event (D) " + XmlStreamImpl.eventToString(event) + " with name " + name);
            }
            if (2 != event || !skipOverTag.equals(elementTag = reader.getName().getLocalPart())) continue;
            return;
        }
    }

    private static String eventToString(int event) {
        switch (event) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
        }
        return "UNKNOWN EVENT: " + event;
    }

    public static <T> void marshall(OutputStream outputStream, XmlRootHandle<T> root) throws IOException {
        try {
            XmlStreamImpl.marshallXmlStream(outputStream, root);
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void marshallXmlStream(OutputStream outputStream, XmlRootHandle<T> root) throws XMLStreamException {
        XMLStreamWriter rawWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
        IndentingXMLStreamWriter indenter = new IndentingXMLStreamWriter(rawWriter);
        try {
            indenter.writeStartDocument();
            XmlHk2ConfigurationBean bean = (XmlHk2ConfigurationBean)root.getRoot();
            if (bean != null) {
                XmlStreamImpl.marshallElement((XMLStreamWriter)indenter, bean, null);
            }
            indenter.writeEndDocument();
        }
        finally {
            rawWriter.close();
        }
    }

    private static void marshallElement(XMLStreamWriter indenter, XmlHk2ConfigurationBean bean, ParentedModel parented) throws XMLStreamException {
        ModelImpl model = bean._getModel();
        Map<String, Object> beanLikeMap = bean._getBeanLikeMap();
        String xmlTag = parented == null ? model.getRootName() : parented.getChildXmlTag();
        indenter.writeStartElement(xmlTag);
        Map<String, ChildDataModel> attributeModels = model.getAllAttributeChildren();
        for (Map.Entry<String, ChildDataModel> entry : attributeModels.entrySet()) {
            String valueAsString;
            String attributeTag = entry.getKey();
            ChildDataModel childDataModel = entry.getValue();
            Object value = beanLikeMap.get(attributeTag);
            if (value == null) continue;
            if (!childDataModel.isReference()) {
                valueAsString = value.toString();
            } else {
                XmlHk2ConfigurationBean reference = (XmlHk2ConfigurationBean)value;
                valueAsString = reference._getKeyValue();
            }
            if (GeneralUtilities.safeEquals((Object)valueAsString, (Object)childDataModel.getDefaultAsString())) continue;
            indenter.writeAttribute(attributeTag, valueAsString);
        }
        Map<String, ChildDescriptor> elementDescriptors = model.getAllElementChildren();
        for (Map.Entry<String, ChildDescriptor> entry : elementDescriptors.entrySet()) {
            String elementTag = entry.getKey();
            ChildDescriptor descriptor = entry.getValue();
            Object value = beanLikeMap.get(elementTag);
            if (value == null) continue;
            ParentedModel parentedChild = descriptor.getParentedModel();
            if (parentedChild != null) {
                if (ChildType.LIST.equals((Object)parentedChild.getChildType())) {
                    List asList = (List)value;
                    if (asList.isEmpty()) continue;
                    for (XmlHk2ConfigurationBean child : asList) {
                        XmlStreamImpl.marshallElement(indenter, child, parentedChild);
                    }
                    continue;
                }
                if (ChildType.ARRAY.equals((Object)parentedChild.getChildType())) {
                    int length = Array.getLength(value);
                    if (length <= 0) continue;
                    for (int lcv = 0; lcv < length; ++lcv) {
                        XmlHk2ConfigurationBean child;
                        child = (XmlHk2ConfigurationBean)Array.get(value, lcv);
                        XmlStreamImpl.marshallElement(indenter, child, parentedChild);
                    }
                    continue;
                }
                XmlStreamImpl.marshallElement(indenter, (XmlHk2ConfigurationBean)value, parentedChild);
                continue;
            }
            ChildDataModel childDataModel = descriptor.getChildDataModel();
            if (!childDataModel.isReference()) {
                String valueAsString = value.toString();
                if (GeneralUtilities.safeEquals((Object)valueAsString, (Object)childDataModel.getDefaultAsString())) continue;
                indenter.writeStartElement(elementTag);
                indenter.writeCharacters(valueAsString);
                indenter.writeEndElement();
                continue;
            }
            XmlHk2ConfigurationBean reference = (XmlHk2ConfigurationBean)value;
            String keyValue = reference._getKeyValue();
            indenter.writeStartElement(elementTag);
            indenter.writeCharacters(keyValue);
            indenter.writeEndElement();
        }
        indenter.writeEndElement();
    }
}

