/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.marshall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans2.RefereeBean;
import org.glassfish.hk2.xml.test.beans2.ReferencesBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MarshallTest {
    private static final File OUTPUT_FILE = new File("output.xml");
    private static final String LOOK_FOR_ME = "0.255.255.255";
    public static final String REFEREES1_FILE = "Referees1.xml";
    private static final String REF1 = "<machine>Alice</machine>";
    private static final String REF2 = "<subnetwork>0.255.255.255</subnetwork>";
    private static final String REF3 = "<references first-referee=\"Laird Hayes\" last-referee=\"Boris Cheek\">";

    @Before
    public void before() {
        if (OUTPUT_FILE.exists()) {
            boolean didDelete = OUTPUT_FILE.delete();
            Assert.assertTrue((boolean)didDelete);
        }
    }

    @After
    public void after() {
        if (OUTPUT_FILE.exists()) {
            OUTPUT_FILE.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testMarshallBackAfterUpdate() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean root = (DomainBean)rootHandle.getRoot();
        root.setSubnetwork(LOOK_FOR_ME);
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF1, REF2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFile(String ... strings) throws Exception {
        HashMap<String, Boolean> foundAll = new HashMap<String, Boolean>();
        for (String string : strings) {
            foundAll.put(string, false);
        }
        FileReader reader = new FileReader(OUTPUT_FILE);
        BufferedReader buffered = new BufferedReader(reader);
        try {
            String line;
            while ((line = buffered.readLine()) != null) {
                for (String string : foundAll.keySet()) {
                    if (!line.contains(string)) continue;
                    foundAll.put(string, true);
                }
            }
        }
        finally {
            buffered.close();
            reader.close();
        }
        for (Map.Entry entry : foundAll.entrySet()) {
            String lookingFor = (String)entry.getKey();
            boolean found = (Boolean)entry.getValue();
            Assert.assertTrue((String)("Did not find the string " + lookingFor), (boolean)found);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshallBackAfterUpdateDom() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean root = (DomainBean)rootHandle.getRoot();
        root.setSubnetwork(LOOK_FOR_ME);
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF1, REF2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalAttributeReferences() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(REFEREES1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ReferencesBean.class, false, false);
        ReferencesBean references = (ReferencesBean)rootHandle.getRoot();
        RefereeBean hayes = references.getReferees().get(0);
        RefereeBean cheek = references.getReferees().get(1);
        Assert.assertNotNull((Object)hayes);
        Assert.assertNotNull((Object)cheek);
        Assert.assertEquals((Object)hayes, (Object)references.getFirstReferee());
        Assert.assertEquals((Object)cheek, (Object)references.getLastReferee());
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF3);
    }
}

