/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.removes;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Employee;
import org.glassfish.hk2.xml.test.basic.beans.Employees;
import org.glassfish.hk2.xml.test.basic.beans.Financials;
import org.glassfish.hk2.xml.test.basic.beans.OtherData;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.HttpFactoryBean;
import org.glassfish.hk2.xml.test.beans.HttpServerBean;
import org.glassfish.hk2.xml.test.beans.HttpsFactoryBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.QueueBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.beans.TopicBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class RemovesTest {
    public static final String EMPLOYEE_TYPE = "/employees/employee";
    public static final String BOB_EMPLOYEE_INSTANCE = "employees.Bob";
    public static final String ACME3_FILE = "Acme3.xml";
    public static final String INDEX0 = "Index0";
    public static final String INDEX1 = "Index1";
    public static final String INDEX2 = "Index2";
    public static final String INDEX3 = "Index3";
    public static final String OTHER_DATA_TYPE = "/employees/other-data";
    private static final String DATA_KEY = "data";
    private static final String QUEUED0_INSTANCE_NAME = "domain.Dave.QueueD0";
    private static final String TOPICD0_INSTANCE_NAME = "domain.Dave.TopicD0";

    @Test
    public void testRemoveOfNamedChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Employee bob = employees.lookupEmployee("Bob");
        Assert.assertNotNull((Object)bob);
        Assert.assertNotNull((Object)locator.getService(Employee.class, "Bob", new Annotation[0]));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, BOB_EMPLOYEE_INSTANCE));
        employees.removeEmployee("Bob");
        bob = employees.lookupEmployee("Bob");
        Assert.assertNull((Object)bob);
        Assert.assertNull((Object)locator.getService(Employee.class, "Bob", new Annotation[0]));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, BOB_EMPLOYEE_INSTANCE));
    }

    @Test
    public void testRemoveOfIndexedChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME3_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        RemovesTest.validateAcme3InitialState(employees, hub);
        Assert.assertFalse((boolean)employees.removeOtherData(-1));
        RemovesTest.validateAcme3InitialState(employees, hub);
        Assert.assertFalse((boolean)employees.removeOtherData(4));
        RemovesTest.validateAcme3InitialState(employees, hub);
        Assert.assertTrue((boolean)employees.removeOtherData(2));
        List<OtherData> otherDatum = employees.getOtherData();
        Assert.assertEquals((long)3L, (long)otherDatum.size());
        Assert.assertEquals((Object)INDEX0, (Object)otherDatum.get(0).getData());
        Assert.assertEquals((Object)INDEX1, (Object)otherDatum.get(1).getData());
        Assert.assertEquals((Object)INDEX3, (Object)otherDatum.get(2).getData());
        RemovesTest.checkHubDataInstanceOrder(hub, INDEX0, INDEX1, INDEX3);
        Assert.assertTrue((boolean)employees.removeOtherData(2));
        otherDatum = employees.getOtherData();
        Assert.assertEquals((Object)INDEX0, (Object)otherDatum.get(0).getData());
        Assert.assertEquals((Object)INDEX1, (Object)otherDatum.get(1).getData());
        RemovesTest.checkHubDataInstanceOrder(hub, INDEX0, INDEX1);
        Assert.assertTrue((boolean)employees.removeOtherData(0));
        otherDatum = employees.getOtherData();
        Assert.assertEquals((Object)INDEX1, (Object)otherDatum.get(0).getData());
        RemovesTest.checkHubDataInstanceOrder(hub, INDEX1);
        Assert.assertTrue((boolean)employees.removeOtherData(0));
        otherDatum = employees.getOtherData();
        Assert.assertTrue((boolean)otherDatum.isEmpty());
        RemovesTest.checkHubDataInstanceOrder(hub, new String[0]);
        employees.addOtherData(0);
        otherDatum = employees.getOtherData();
        OtherData zeroEntry = otherDatum.get(0);
        zeroEntry.setData(INDEX0);
        RemovesTest.checkHubDataInstanceOrder(hub, INDEX0);
        Assert.assertTrue((boolean)employees.removeOtherData(0));
        otherDatum = employees.getOtherData();
        Assert.assertTrue((boolean)otherDatum.isEmpty());
        RemovesTest.checkHubDataInstanceOrder(hub, new String[0]);
    }

    @Test
    public void testRemoveOfDirectNodeWithoutChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(ACME3_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        RemovesTest.validateAcme3InitialState(employees, hub);
        Financials removed = employees.removeFinancials();
        Assert.assertNotNull((Object)removed);
        Assert.assertNull((Object)employees.getFinancials());
        BeanDatabase db = hub.getCurrentDatabase();
        Instance financialsInstance = db.getInstance("/employees/financials", "employees.financials");
        Assert.assertNull((Object)financialsInstance);
    }

    @Test
    public void testRemoveOfDirectNodeWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        Assert.assertTrue((boolean)domain.removeSecurityManager());
        Assert.assertNull((Object)domain.getSecurityManager());
        BeanDatabase db = hub.getCurrentDatabase();
        Type securityManagerType = db.getType("/domain/security-manager");
        Assert.assertNotNull((Object)securityManagerType);
        Map securityManagerInstances = securityManagerType.getInstances();
        Assert.assertNotNull((Object)securityManagerInstances);
        Assert.assertTrue((boolean)securityManagerInstances.isEmpty());
        Assert.assertNull((Object)locator.getService(SecurityManagerBean.class, new Annotation[0]));
        Type atzProvidersType = db.getType("/domain/security-manager/authorization-provider");
        Assert.assertNotNull((Object)atzProvidersType);
        Map atzProvidersInstances = atzProvidersType.getInstances();
        Assert.assertNotNull((Object)atzProvidersInstances);
        Assert.assertTrue((boolean)atzProvidersInstances.isEmpty());
        Assert.assertNull((Object)locator.getService(AuthorizationProviderBean.class, "RSA", new Annotation[0]));
    }

    @Test
    public void testRemoveOfArrayNodeWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        JMSServerBean removed = domain.removeJMSServer("Carol");
        Assert.assertNotNull((Object)removed);
        Assert.assertEquals((Object)"Carol", (Object)removed.getName());
        JMSServerBean[] jmsServers = domain.getJMSServers();
        Assert.assertNotNull((Object)jmsServers);
        Assert.assertEquals((long)1L, (long)jmsServers.length);
        Assert.assertEquals((Object)"Dave", (Object)jmsServers[0].getName());
        BeanDatabase db = hub.getCurrentDatabase();
        Type jmsServerType = db.getType("/domain/jms-server");
        Assert.assertNotNull((Object)jmsServerType);
        Map jmsServerInstances = jmsServerType.getInstances();
        Assert.assertNotNull((Object)jmsServerInstances);
        Assert.assertEquals((long)1L, (long)jmsServerInstances.size());
        Instance daveInstance = (Instance)jmsServerInstances.get("domain.Dave");
        Assert.assertNotNull((Object)daveInstance);
        Map daveMap = (Map)daveInstance.getBean();
        Assert.assertEquals((Object)"Dave", daveMap.get("name"));
        Assert.assertNull((Object)locator.getService(JMSServerBean.class, "Carol", new Annotation[0]));
        JMSServerBean daveJMS = (JMSServerBean)locator.getService(JMSServerBean.class, "Dave", new Annotation[0]);
        Assert.assertNotNull((Object)daveJMS);
        Assert.assertEquals((Object)"Dave", (Object)daveJMS.getName());
        Type queueType = db.getType("/domain/jms-server/queue");
        Assert.assertNotNull((Object)queueType);
        Map queueInstances = queueType.getInstances();
        Assert.assertNotNull((Object)queueInstances);
        Assert.assertEquals((long)1L, (long)queueInstances.size());
        Instance queueInstance = (Instance)queueInstances.get(QUEUED0_INSTANCE_NAME);
        Assert.assertNotNull((Object)queueInstance);
        Map beanLikeQueue = (Map)queueInstance.getBean();
        Assert.assertEquals((Object)"QueueD0", beanLikeQueue.get("name"));
        Assert.assertNull((Object)locator.getService(QueueBean.class, "Queue0", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(QueueBean.class, "Queue1", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(QueueBean.class, "Queue2", new Annotation[0]));
        MergeTest.assertQueueOfName(locator, "QueueD0");
        Type topicType = db.getType("/domain/jms-server/topic");
        Assert.assertNotNull((Object)topicType);
        Map topicInstances = topicType.getInstances();
        Assert.assertNotNull((Object)topicInstances);
        Assert.assertEquals((long)1L, (long)topicInstances.size());
        Instance topicInstance = (Instance)topicInstances.get(TOPICD0_INSTANCE_NAME);
        Assert.assertNotNull((Object)topicInstance);
        beanLikeQueue = (Map)topicInstance.getBean();
        Assert.assertEquals((Object)"TopicD0", beanLikeQueue.get("name"));
        Assert.assertNull((Object)locator.getService(TopicBean.class, "Topic0", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(TopicBean.class, "Topic1", new Annotation[0]));
        MergeTest.assertTopicOfName(locator, "TopicD0");
    }

    @Test
    public void testRemoveOfUnkeyedListChildWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        List<HttpFactoryBean> factories = domain.getHTTPFactories();
        HttpFactoryBean killMe = null;
        for (HttpFactoryBean factory : factories) {
            if (!factory.getNonKeyIdentifier().equals("Glendola")) continue;
            killMe = factory;
        }
        Assert.assertNotNull(killMe);
        HttpFactoryBean killed = domain.removeHTTPFactory(killMe);
        Assert.assertEquals(killMe, (Object)killed);
        factories = domain.getHTTPFactories();
        Assert.assertEquals((long)1L, (long)factories.size());
        for (HttpFactoryBean factory : factories) {
            Assert.assertEquals((Object)"Essex", (Object)factory.getNonKeyIdentifier());
            List<HttpServerBean> servers = factory.getHttpServers();
            Assert.assertEquals((long)1L, (long)servers.size());
            for (HttpServerBean server : servers) {
                Assert.assertEquals((Object)"Fairview", (Object)server.getName());
                Assert.assertEquals((long)1234L, (long)server.getPort());
            }
        }
        BeanDatabase db = hub.getCurrentDatabase();
        Type httpFactoryType = db.getType("/domain/http-factory");
        Assert.assertNotNull((Object)httpFactoryType);
        Map httpFactoryInstances = httpFactoryType.getInstances();
        Assert.assertNotNull((Object)httpFactoryInstances);
        Assert.assertEquals((long)1L, (long)httpFactoryInstances.size());
        Instance essexInstance = null;
        Iterator i$ = httpFactoryInstances.values().iterator();
        while (i$.hasNext()) {
            Instance i;
            essexInstance = i = (Instance)i$.next();
        }
        Assert.assertNotNull(essexInstance);
        Map essexMap = (Map)essexInstance.getBean();
        Assert.assertEquals((Object)"Essex", essexMap.get("non-key-identifier"));
        List asServices = locator.getAllServices(HttpFactoryBean.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)asServices.size());
        HttpFactoryBean foundBean = null;
        Iterator i$2 = asServices.iterator();
        while (i$2.hasNext()) {
            HttpFactoryBean a;
            foundBean = a = (HttpFactoryBean)i$2.next();
        }
        Assert.assertNotNull(foundBean);
        Assert.assertEquals((Object)"Essex", (Object)foundBean.getNonKeyIdentifier());
        Type httpServerType = db.getType("/domain/http-factory/http-server");
        Assert.assertNotNull((Object)httpServerType);
        Map httpServerInstances = httpServerType.getInstances();
        Assert.assertNotNull((Object)httpServerInstances);
        Assert.assertEquals((long)1L, (long)httpServerInstances.size());
        Instance httpServerInstance = null;
        i$ = httpServerInstances.values().iterator();
        while (i$.hasNext()) {
            Instance a;
            httpServerInstance = a = (Instance)i$.next();
        }
        Assert.assertNotNull(httpServerInstance);
        Map beanLike = (Map)httpServerInstance.getBean();
        Assert.assertEquals((Object)"Fairview", beanLike.get("name"));
        Assert.assertEquals((Object)new Integer(1234), beanLike.get("port"));
        Assert.assertNull((Object)locator.getService(HttpServerBean.class, "Holyoke", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(HttpServerBean.class, "Iroquis", new Annotation[0]));
        HttpServerBean hsb = (HttpServerBean)locator.getService(HttpServerBean.class, "Fairview", new Annotation[0]);
        Assert.assertNotNull((Object)hsb);
        Assert.assertEquals((Object)"Fairview", (Object)hsb.getName());
        Assert.assertEquals((long)1234L, (long)hsb.getPort());
    }

    @Test
    public void testRemoveOfUnkeyedArrayChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        HttpsFactoryBean[] factories = domain.getHTTPSFactories();
        HttpsFactoryBean factory = factories[0];
        domain.removeHTTPSFactory(factory);
        factories = domain.getHTTPSFactories();
        Assert.assertEquals((long)0L, (long)factories.length);
        BeanDatabase db = hub.getCurrentDatabase();
        Type httpFactoryType = db.getType("/domain/https-factory");
        Assert.assertNotNull((Object)httpFactoryType);
        Map httpFactoryInstances = httpFactoryType.getInstances();
        Assert.assertNotNull((Object)httpFactoryInstances);
        Assert.assertEquals((long)0L, (long)httpFactoryInstances.size());
        Assert.assertNull((Object)locator.getService(HttpsFactoryBean.class, new Annotation[0]));
    }

    @Test
    public void testRemoveOfKeyedChildOfUnkeyedParent() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        HttpFactoryBean glendolaFactory = domain.getHTTPFactories().get(1);
        glendolaFactory.removeHttpServer("Iroquis");
        List<HttpServerBean> glendolaServers = glendolaFactory.getHttpServers();
        Assert.assertEquals((long)1L, (long)glendolaServers.size());
        for (HttpServerBean one : glendolaServers) {
            Assert.assertEquals((Object)"Holyoke", (Object)one.getName());
            Assert.assertEquals((long)5678L, (long)one.getPort());
        }
        BeanDatabase db = hub.getCurrentDatabase();
        Type httpServerType = db.getType("/domain/http-factory/http-server");
        Assert.assertNotNull((Object)httpServerType);
        Map httpServerInstances = httpServerType.getInstances();
        Assert.assertNotNull((Object)httpServerInstances);
        Assert.assertEquals((long)2L, (long)httpServerInstances.size());
        Instance fairviewInstance = null;
        Instance holyokeInstance = null;
        for (Instance value : httpServerInstances.values()) {
            Map bean = (Map)value.getBean();
            Assert.assertNotNull((Object)bean);
            String httpServerName = (String)bean.get("name");
            if ("Fairview".equals(httpServerName)) {
                fairviewInstance = value;
                continue;
            }
            if ("Holyoke".equals(httpServerName)) {
                holyokeInstance = value;
                continue;
            }
            Assert.fail((String)("After deletion the instance should not be there " + httpServerName));
        }
        Assert.assertNotNull(fairviewInstance);
        Assert.assertNotNull(holyokeInstance);
        Assert.assertNull((Object)locator.getService(HttpServerBean.class, "Iroquis", new Annotation[0]));
    }

    @Test
    public void testRemoveOfUnkeyedArrayChildUsingIndex() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        domain.removeHTTPSFactory(0);
        HttpsFactoryBean[] factories = domain.getHTTPSFactories();
        Assert.assertEquals((long)0L, (long)factories.length);
        BeanDatabase db = hub.getCurrentDatabase();
        Type httpFactoryType = db.getType("/domain/https-factory");
        Assert.assertNotNull((Object)httpFactoryType);
        Map httpFactoryInstances = httpFactoryType.getInstances();
        Assert.assertNotNull((Object)httpFactoryInstances);
        Assert.assertEquals((long)0L, (long)httpFactoryInstances.size());
        Assert.assertNull((Object)locator.getService(HttpsFactoryBean.class, new Annotation[0]));
    }

    private static void validateAcme3InitialState(Employees employees, Hub hub) {
        Assert.assertEquals((Object)"Acme", (Object)employees.getCompanyName());
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertEquals((Object)"acme", (Object)financials.getSymbol());
        Assert.assertEquals((Object)"NYSE", (Object)financials.getExchange());
        Assert.assertNull((Object)financials.getCountry());
        List<OtherData> otherDatum = employees.getOtherData();
        Assert.assertEquals((long)4L, (long)otherDatum.size());
        Assert.assertEquals((Object)INDEX0, (Object)otherDatum.get(0).getData());
        Assert.assertEquals((Object)INDEX1, (Object)otherDatum.get(1).getData());
        Assert.assertEquals((Object)INDEX2, (Object)otherDatum.get(2).getData());
        Assert.assertEquals((Object)INDEX3, (Object)otherDatum.get(3).getData());
        RemovesTest.checkHubDataInstanceOrder(hub, INDEX0, INDEX1, INDEX2, INDEX3);
        BeanDatabase db = hub.getCurrentDatabase();
        Instance financialsInstance = db.getInstance("/employees/financials", "employees.financials");
        Assert.assertNotNull((Object)financialsInstance);
        Map financialsBean = (Map)financialsInstance.getBean();
        Assert.assertEquals((Object)"acme", financialsBean.get("symbol"));
        Assert.assertEquals((Object)"NYSE", financialsBean.get("exchange"));
    }

    private static void checkHubDataInstanceOrder(Hub hub, String ... expecteds) {
        BeanDatabase db = hub.getCurrentDatabase();
        Type otherDataType = db.getType(OTHER_DATA_TYPE);
        HashSet<String> hashedExpecteds = new HashSet<String>();
        for (String expected : expecteds) {
            hashedExpecteds.add(expected);
        }
        Map instances = otherDataType.getInstances();
        Assert.assertEquals((long)expecteds.length, (long)instances.size());
        Assert.assertEquals((long)expecteds.length, (long)hashedExpecteds.size());
        for (Instance instance : instances.values()) {
            Map beanLikeMap = (Map)instance.getBean();
            String data = (String)beanLikeMap.get(DATA_KEY);
            Assert.assertTrue((boolean)hashedExpecteds.contains(data));
        }
    }
}

