/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.overlay;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayRootABean;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayUtilities;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class OverlayTest {
    @Test
    public void testRootBeanOnlyOverlay() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        URL url2 = this.getClass().getClassLoader().getResource("museum2.xml");
        XmlRootHandle rootHandle2 = xmlService.unmarshal(url2.toURI(), Museum.class, false, false);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        XmlHk2ConfigurationBean museumAsBean = (XmlHk2ConfigurationBean)museum;
        rootHandle.overlay(rootHandle2);
        Assert.assertEquals((long)101L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance("/museum", "museum");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get("age"));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        Change oneChange = null;
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
            oneChange = change;
        }
    }

    private List<Change> doTestA(String original, String overlay) {
        return this.doTestA(original, overlay, true, true);
    }

    private List<Change> doTestA(String original, String overlay, boolean generateLists, boolean generateArrays) {
        ServiceLocator locator = Utilities.createLocator(RawSetsTest.UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        RawSetsTest.UpdateListener listener = (RawSetsTest.UpdateListener)locator.getService(RawSetsTest.UpdateListener.class, new Annotation[0]);
        XmlRootHandle originalHandle = xmlService.createEmptyHandle(OverlayRootABean.class, true, true);
        OverlayUtilities.generateOverlayRootABean((XmlRootHandle<OverlayRootABean>)originalHandle, generateLists, generateArrays, original);
        String originalFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), true);
        String originalFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)original, (Object)originalFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)original, (Object)originalFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, original);
        XmlRootHandle overlayHandle = xmlService.createEmptyHandle(OverlayRootABean.class, false, false);
        OverlayUtilities.generateOverlayRootABean((XmlRootHandle<OverlayRootABean>)overlayHandle, generateLists, generateArrays, overlay);
        String overlayFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)overlayHandle.getRoot(), true);
        String overlayFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)overlayHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)overlay, (Object)overlayFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)overlay, (Object)overlayFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, original);
        originalHandle.overlay(overlayHandle);
        String overlayedFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), true);
        String overlayedFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)overlay, (Object)overlayedFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)overlay, (Object)overlayedFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, overlay);
        return listener.getChanges();
    }

    private static String instanceToName(Instance instance) {
        if (instance == null) {
            return null;
        }
        Map blm = (Map)instance.getBean();
        if (blm == null) {
            return null;
        }
        return (String)blm.get("name");
    }

    private static String getChangeDescription(Change change) {
        StringBuffer sb = new StringBuffer("" + change.getChangeCategory() + " type=");
        Type type = change.getChangeType();
        sb.append(type.getName() + " ");
        switch (change.getChangeCategory()) {
            case REMOVE_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance instanceRemoved = change.getInstanceValue();
                String instanceName = OverlayTest.instanceToName(instanceRemoved);
                sb.append(" removedName=" + instanceName + " instanceKey=" + instanceKey);
                break;
            }
            case ADD_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance instanceAdded = change.getInstanceValue();
                String instanceName = OverlayTest.instanceToName(instanceAdded);
                sb.append(" addedName=" + instanceName + " instanceKey=" + instanceKey);
                break;
            }
            case MODIFY_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance originalMod = change.getOriginalInstanceValue();
                Instance changedMod = change.getInstanceValue();
                String originalName = OverlayTest.instanceToName(originalMod);
                String changedName = OverlayTest.instanceToName(changedMod);
                sb.append(" originalName=" + originalName + " newName=" + changedName + " instanceKey=" + instanceKey);
                break;
            }
        }
        return sb.toString();
    }

    private static String getAssertString(List<Change> changes, ChangeDescriptor ... changeDescriptors) {
        StringBuffer received = new StringBuffer("\n");
        int count = 1;
        for (Change change : changes) {
            received.append("  " + count + ". " + OverlayTest.getChangeDescription(change) + "\n");
            ++count;
        }
        StringBuffer expected = new StringBuffer("\n");
        for (int lcv = 0; lcv < changeDescriptors.length; ++lcv) {
            expected.append("  " + (lcv + 1) + ". " + changeDescriptors[lcv] + "\n");
        }
        return "Expected Changes were: " + expected + "Recieved changes are: " + received;
    }

    private static void checkChanges(List<Change> changes, ChangeDescriptor ... changeDescriptors) {
        if (changes.size() != changeDescriptors.length) {
            Assert.fail((String)OverlayTest.getAssertString(changes, changeDescriptors));
        }
        HashSet<Integer> usedDescriptors = new HashSet<Integer>();
        for (int lcv = 0; lcv < changeDescriptors.length; ++lcv) {
            ChangeDescriptor cd = changeDescriptors[lcv];
            for (int inner = 0; inner < changes.size(); ++inner) {
                Change change;
                String isSame;
                if (usedDescriptors.contains(inner) || (isSame = cd.check(change = changes.get(inner))) != null) continue;
                usedDescriptors.add(inner);
            }
        }
        Assert.assertEquals((String)(OverlayTest.getAssertString(changes, changeDescriptors) + " usedDescriptors=" + usedDescriptors), (long)changeDescriptors.length, (long)changes.size());
    }

    @Test
    public void testABCxBC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "BC");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}));
    }

    @Test
    public void testABCxAB() throws Exception {
        List<Change> changes = this.doTestA("ABC", "AB");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[0]));
    }

    @Test
    public void testABCxCBA() throws Exception {
        List<Change> changes = this.doTestA("ABC", "CBA");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}));
    }

    @Test
    public void testABCxBCA() throws Exception {
        List<Change> changes = this.doTestA("ABC", "BCA");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}));
    }

    @Test
    public void testABCxABCD() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABCD");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "D", new String[0]));
    }

    @Test
    public void testABCxCABC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "CABC");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[0]));
    }

    @Test
    public void testABCxABDC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABDC");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "D", new String[0]));
    }

    @Test
    public void testABCxABC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABC");
        OverlayTest.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testABCxABD() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABD");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[]{"name"}), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[]{"name"}));
    }

    @Test
    public void testA_B_A_C_A_D_xA_B_A_C_A_D_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(B)A(C)A(D)");
        OverlayTest.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testA_B_A_C_A_D_xA_B_A_C_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(B)A(C)");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-list", "overlay-root-A", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A", "D", new String[0]));
    }

    @Test
    public void testA_B_A_CxA_C_A_B_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)", "A(C)A(B)");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, new String[]{"unkeyed-leaf-list", "unkeyed-leaf-array"}));
    }

    @Test
    public void testA_B_A_C_A_D_xA_C_A_D_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(C)A(D)");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", "unkeyed-leaf-list", new String[]{"unkeyed-leaf-array"}), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list", "overlay-root-A.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-array", "overlay-root-A.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-list", "overlay-root-A", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A", "B", new String[0]));
    }

    @Test
    public void testA_B_C_D_EF__G_HI_JKL__xA_B_C_D_EF__G_HI_JKL__() throws Exception {
        List<Change> changes = this.doTestA("A(B(C)D(EF))G(HI(JKL))", "A(B(C)D(EF))G(HI(JKL))");
        OverlayTest.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testA_B_C_D_EF__G_HI_JKL__xG_HI_JKL__A_B_C_D_EF__() throws Exception {
        List<Change> changes = this.doTestA("A(B(C)D(EF))G(HI(JKL))", "G(HI(JKL))A(B(C)D(EF))");
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", "unkeyed-leaf-list", new String[]{"unkeyed-leaf-array"}));
    }

    @Test
    public void testListA_B_C__xA_B_CD_E___() throws Exception {
        List<Change> changes = this.doTestA("A(B(C))", "A(B(CD(E)))", true, false);
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list", "overlay-root-A.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list/leaf-list", null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list/leaf-list", "overlay-root-A.*.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-list/leaf-lst", "overlay-root-A.*.*", "leaf-list", new String[0]));
    }

    @Test
    public void testArrayA_B_C__xA_B_CD_E___() throws Exception {
        List<Change> changes = this.doTestA("A(B(C))", "A(B(CD(E)))", false, true);
        OverlayTest.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array", "overlay-root-A.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array/leaf-array", null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array/leaf-array", "overlay-root-A.*.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*.*", "leaf-array", new String[0]));
    }

    private static final class ChangeDescriptor {
        private final Change.ChangeCategory category;
        private final String typeName;
        private final List<String> instanceKey;
        private final String[] props;
        private final String instance;
        private final String arName;

        private ChangeDescriptor(Change.ChangeCategory category, String type, String instance, String arName, String ... props) {
            this.category = category;
            this.typeName = type;
            this.props = props;
            this.instanceKey = ChangeDescriptor.tokenizeInstanceKey(instance);
            this.instance = instance;
            this.arName = arName;
        }

        private static List<String> tokenizeInstanceKey(String instance) {
            LinkedList<String> retVal = new LinkedList<String>();
            if (instance == null) {
                return retVal;
            }
            StringTokenizer st = new StringTokenizer(instance, ".");
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.startsWith("XMLServiceUID")) continue;
                retVal.add(nextToken);
            }
            return retVal;
        }

        private String checkInstanceKey(String recievedKey) {
            List<String> receivedToken = ChangeDescriptor.tokenizeInstanceKey(recievedKey);
            if (this.instanceKey.size() != receivedToken.size()) {
                return "Instance cardinality for " + recievedKey + " does not match " + this.instance;
            }
            for (int lcv = 0; lcv < receivedToken.size(); ++lcv) {
                String expected = this.instanceKey.get(lcv);
                String received = receivedToken.get(lcv);
                if ("*".equals(expected) || GeneralUtilities.safeEquals((Object)expected, (Object)received)) continue;
                return "Failed in " + this + " at index " + lcv;
            }
            return null;
        }

        private String check(Change change) {
            if (!GeneralUtilities.safeEquals((Object)this.category, (Object)change.getChangeCategory())) {
                return "Category is not the same expected=" + this + " got=" + change;
            }
            if (!GeneralUtilities.safeEquals((Object)this.typeName, (Object)change.getChangeType().getName())) {
                return "Type is not the same expected=" + this + " got=" + change;
            }
            String errorInstanceKey = this.checkInstanceKey(change.getInstanceKey());
            if (errorInstanceKey != null) {
                return errorInstanceKey;
            }
            List modifiedProperties = change.getModifiedProperties();
            if (modifiedProperties == null) {
                modifiedProperties = Collections.emptyList();
            }
            if (this.props.length != modifiedProperties.size()) {
                return "Expectect property length of " + this.props.length + " but got size " + modifiedProperties.size();
            }
            for (int lcv = 0; lcv < this.props.length; ++lcv) {
                String prop = this.props[lcv];
                boolean found = false;
                for (int inner = 0; inner < modifiedProperties.size(); ++inner) {
                    if (!GeneralUtilities.safeEquals((Object)prop, (Object)((PropertyChangeEvent)modifiedProperties.get(inner)).getPropertyName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return "Did not find prop " + prop + " in " + this;
            }
            return null;
        }

        public String toString() {
            return this.category + " type=" + this.typeName + " name=" + this.arName + " instanceKey=" + this.instanceKey;
        }
    }
}

