/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.xml.bind.annotation.XmlRootElement;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.Differences;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.ReferenceKey;
import org.glassfish.hk2.xml.internal.UnkeyedDiff;
import org.glassfish.hk2.xml.internal.UnresolvedReference;
import org.glassfish.hk2.xml.internal.XmlDynamicChange;
import org.glassfish.hk2.xml.internal.XmlRootHandleImpl;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.ArrayTypeAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.TypeElementAltClassImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Utilities {
    public static final char INSTANCE_PATH_SEPARATOR = '.';
    private static final String CLASS_ADD_ON_NAME = "_Hk2_Jaxb";
    private static final String NOT_UNIQUE_UNIQUE_ID = "not-unique";
    private static final String EMPTY_STRING = "";
    private static final Boolean DEFAULT_BOOLEAN = Boolean.FALSE;
    private static final Byte DEFAULT_BYTE = new Byte(0);
    private static final Character DEFAULT_CHARACTER = new Character('\u0000');
    private static final Short DEFAULT_SHORT = new Short(0);
    private static final Integer DEFAULT_INTEGER = new Integer(0);
    private static final Long DEFAULT_LONG = new Long(0L);
    private static final Float DEFAULT_FLOAT = new Float(0.0f);
    private static final Double DEFAULT_DOUBLE = new Double(0.0);

    static String convertXmlRootElementName(XmlRootElement root, Class<?> clazz) {
        if (!"##default".equals(root.name())) {
            return root.name();
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    public static BaseHK2JAXBBean createBean(Class<?> implClass) {
        try {
            Constructor<?> noArgsConstructor = implClass.getConstructor(new Class[0]);
            return (BaseHK2JAXBBean)ReflectionHelper.makeMe(noArgsConstructor, (Object[])new Object[0], (boolean)false);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static String getKeySegment(BaseHK2JAXBBean bean) {
        String baseKeySegment = bean._getKeyValue();
        if (baseKeySegment == null) {
            baseKeySegment = bean._getSelfXmlTag();
        }
        return baseKeySegment;
    }

    public static String createInstanceName(BaseHK2JAXBBean bean) {
        if (bean._getParent() == null) {
            return Utilities.getKeySegment(bean);
        }
        return Utilities.createInstanceName((BaseHK2JAXBBean)bean._getParent()) + '.' + Utilities.getKeySegment(bean);
    }

    public static ActiveDescriptor<?> advertise(WriteableBeanDatabase wbd, DynamicConfiguration config, BaseHK2JAXBBean bean) {
        ActiveDescriptor selfDescriptor = null;
        if (config != null) {
            AbstractActiveDescriptor cDesc = BuilderHelper.createConstantDescriptor((Object)bean);
            cDesc.setScopeAsAnnotation((Annotation)ServiceLocatorUtilities.getSingletonAnnotation());
            if (bean._getKeyValue() != null) {
                cDesc.setName(bean._getKeyValue());
            }
            selfDescriptor = config.addActiveDescriptor((ActiveDescriptor)cDesc);
            bean._setSelfDescriptor(selfDescriptor);
        }
        if (wbd != null) {
            WriteableType wt = wbd.findOrAddWriteableType(bean._getXmlPath());
            wt.addInstance(bean._getInstanceName(), bean._getBeanLikeMap(), (Object)bean);
        }
        return selfDescriptor;
    }

    public static String convertToSetter(String getterName) {
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring("is".length());
        }
        if (!getterName.startsWith("get")) {
            throw new IllegalArgumentException("Unknown getter format: " + getterName);
        }
        return "set" + getterName.substring("get".length());
    }

    public static String convertNameToString(Name name) {
        if (name == null) {
            return null;
        }
        return name.toString();
    }

    public static AltClass convertTypeMirror(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        if (TypeKind.VOID.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.VOID;
        }
        if (TypeKind.BOOLEAN.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BOOLEAN;
        }
        if (TypeKind.INT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.INT;
        }
        if (TypeKind.LONG.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.LONG;
        }
        if (TypeKind.BYTE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.BYTE;
        }
        if (TypeKind.CHAR.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.CHAR;
        }
        if (TypeKind.SHORT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.SHORT;
        }
        if (TypeKind.FLOAT.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.FLOAT;
        }
        if (TypeKind.DOUBLE.equals((Object)typeMirror.getKind())) {
            return ClassAltClassImpl.DOUBLE;
        }
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            DeclaredType dt = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)dt.asElement();
            TypeElementAltClassImpl addMe = new TypeElementAltClassImpl(typeElement, processingEnv);
            return addMe;
        }
        if (TypeKind.ARRAY.equals((Object)typeMirror.getKind())) {
            ArrayType at = (ArrayType)typeMirror;
            return new ArrayTypeAltClassImpl(at, processingEnv);
        }
        if (TypeKind.TYPEVAR.equals((Object)typeMirror.getKind())) {
            TypeVariable tv = (TypeVariable)typeMirror;
            TypeMirror upperBound = tv.getUpperBound();
            if (upperBound != null && TypeKind.DECLARED.equals((Object)upperBound.getKind())) {
                return Utilities.convertTypeMirror(upperBound, processingEnv);
            }
            return ClassAltClassImpl.OBJECT;
        }
        throw new AssertionError((Object)("Unknown parameter kind: " + (Object)((Object)typeMirror.getKind())));
    }

    public static BaseHK2JAXBBean internalAdd(BaseHK2JAXBBean myParent, String childProperty, Object rawChild, String childKey, int index, DynamicChangeInfo<?> changeInformation, XmlDynamicChange xmlDynamicChange, List<ActiveDescriptor<?>> addedServices, boolean changeList) {
        if (index < -1) {
            throw new IllegalArgumentException("Unknown index " + index);
        }
        if (childKey != null && myParent._lookupChild(childProperty, childKey) != null) {
            throw new IllegalStateException("There is already a child with name " + childKey + " for child " + childProperty);
        }
        if (rawChild != null && !(rawChild instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The child added must be from XmlService.createBean");
        }
        ParentedModel childNode = myParent._getModel().getChild(childProperty);
        if (childNode == null) {
            throw new IllegalArgumentException("There is no child with xmlTag " + childProperty + " of " + myParent);
        }
        Object allMyChildren = myParent._getProperty(childProperty);
        ArrayList<Object> multiChildren = null;
        if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
            multiChildren = allMyChildren == null ? new ArrayList(10) : (ChildType.LIST.equals((Object)childNode.getChildType()) ? new ArrayList((List)allMyChildren) : new ArrayList<Object>(Arrays.asList((Object[])allMyChildren)));
            if (index > multiChildren.size()) {
                throw new IllegalArgumentException("The index given to add child " + childProperty + " to " + myParent + " is not in range");
            }
            if (index == -1) {
                index = multiChildren.size();
            }
        } else if (allMyChildren != null) {
            throw new IllegalStateException("Attempting to add direct child of " + myParent + " of name " + childProperty + " but there is already one there");
        }
        BaseHK2JAXBBean child = Utilities.createBean(childNode.getChildModel().getProxyAsClass());
        child._setClassReflectionHelper(myParent._getClassReflectionHelper());
        if (rawChild != null) {
            BaseHK2JAXBBean childToCopy = (BaseHK2JAXBBean)rawChild;
            for (String nonChildProperty : childToCopy._getModel().getNonChildProperties().keySet()) {
                Object value = childToCopy._getProperty(nonChildProperty);
                if (value == null) continue;
                child._setProperty(nonChildProperty, value, false, true);
            }
        }
        if (childKey == null) {
            if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
                if (childNode.getChildModel().getKeyProperty() != null) {
                    if (rawChild != null) {
                        childKey = (String)child._getProperty(childNode.getChildModel().getKeyProperty());
                    }
                    if (childKey == null) {
                        throw new IllegalArgumentException("Attempted to create child with xmlTag " + childProperty + " with no key field in " + myParent);
                    }
                    child._setKeyValue(childKey);
                } else if (myParent._getChangeControl() == null) {
                    childKey = NOT_UNIQUE_UNIQUE_ID;
                    child._setKeyValue(NOT_UNIQUE_UNIQUE_ID);
                } else {
                    childKey = myParent._getChangeControl().getGeneratedId();
                    child._setKeyValue(childKey);
                }
            }
        } else {
            if (childNode.getChildModel().getKeyProperty() == null) {
                throw new IllegalArgumentException("Attempted to add an unkeyed child with key " + childKey + " in " + myParent);
            }
            child._setProperty(childNode.getChildModel().getKeyProperty(), childKey, false, true);
            child._setKeyValue(childKey);
        }
        child._setParent(myParent);
        child._setSelfXmlTag(childNode.getChildXmlTag());
        child._setKeyValue(childKey);
        if (!ChildType.DIRECT.equals((Object)childNode.getChildType())) {
            child._setInstanceName(myParent._getInstanceName() + '.' + child._getKeyValue());
        } else {
            child._setInstanceName(myParent._getInstanceName() + '.' + childNode.getChildXmlTag());
        }
        child._setDynamicChangeInfo((XmlRootHandleImpl)myParent._getRoot(), changeInformation);
        Utilities.externalAdd(child, xmlDynamicChange.getDynamicConfiguration(), xmlDynamicChange.getBeanDatabase(), addedServices);
        Utilities.invokeVetoableChangeListeners(changeInformation, child, null, child, EMPTY_STRING, myParent._getClassReflectionHelper());
        if (rawChild != null) {
            Utilities.handleChildren(child, (BaseHK2JAXBBean)rawChild, changeInformation, addedServices, xmlDynamicChange);
        }
        if (changeList && multiChildren != null) {
            Object finalChildList;
            multiChildren.add(index, child);
            if (ChildType.LIST.equals((Object)childNode.getChildType())) {
                finalChildList = Collections.unmodifiableList(multiChildren);
            } else {
                finalChildList = Array.newInstance(childNode.getChildModel().getOriginalInterfaceAsClass(), multiChildren.size());
                for (int lcv = 0; lcv < multiChildren.size(); ++lcv) {
                    Array.set(finalChildList, lcv, multiChildren.get(lcv));
                }
            }
            if (xmlDynamicChange.getBeanDatabase() != null) {
                myParent.changeInHub(childProperty, finalChildList, xmlDynamicChange.getBeanDatabase());
            }
            myParent._setProperty(childProperty, finalChildList, false, true);
        } else if (multiChildren == null) {
            if (xmlDynamicChange.getBeanDatabase() != null) {
                myParent.changeInHub(childProperty, child, xmlDynamicChange.getBeanDatabase());
            }
            myParent._setProperty(childProperty, child, false, true);
        }
        return child;
    }

    public static String getProxyNameFromInterfaceName(String iFaceName) {
        return iFaceName + CLASS_ADD_ON_NAME;
    }

    private static void handleChildren(BaseHK2JAXBBean child, BaseHK2JAXBBean childToCopy, DynamicChangeInfo<?> changeInformation, List<ActiveDescriptor<?>> addedServices, XmlDynamicChange xmlDynamicChange) {
        Map<String, ParentedModel> childrenMap = childToCopy._getModel().getChildrenProperties();
        for (Map.Entry<String, ParentedModel> childsChildrenEntry : childrenMap.entrySet()) {
            String childsChildProperty = childsChildrenEntry.getKey();
            ParentedModel childsChildParentNode = childsChildrenEntry.getValue();
            if (!ChildType.DIRECT.equals((Object)childsChildParentNode.getChildType())) {
                ArrayList<BaseHK2JAXBBean> childsChildren = null;
                if (ChildType.LIST.equals((Object)childsChildParentNode.getChildType())) {
                    childsChildren = (ArrayList<BaseHK2JAXBBean>)childToCopy._getProperty(childsChildProperty);
                } else {
                    Object arrayChildsChildren = childToCopy._getProperty(childsChildProperty);
                    if (arrayChildsChildren != null) {
                        childsChildren = new ArrayList<BaseHK2JAXBBean>(Array.getLength(arrayChildsChildren));
                        for (int lcv = 0; lcv < Array.getLength(arrayChildsChildren); ++lcv) {
                            childsChildren.add(lcv, (BaseHK2JAXBBean)Array.get(arrayChildsChildren, lcv));
                        }
                    }
                }
                if (childsChildren == null || childsChildren.size() <= 0) continue;
                ArrayList<BaseHK2JAXBBean> copiedChildArray = new ArrayList<BaseHK2JAXBBean>(childsChildren.size());
                Object asArray = Array.newInstance(childsChildParentNode.getChildModel().getOriginalInterfaceAsClass(), childsChildren.size());
                int lcv = 0;
                for (BaseHK2JAXBBean childsChild : childsChildren) {
                    BaseHK2JAXBBean grandchild = Utilities.internalAdd(child, childsChildProperty, childsChild, null, -1, changeInformation, xmlDynamicChange, addedServices, false);
                    copiedChildArray.add(grandchild);
                    Array.set(asArray, lcv++, grandchild);
                }
                if (ChildType.LIST.equals((Object)childsChildParentNode.getChildType())) {
                    child._setProperty(childsChildProperty, copiedChildArray, false, true);
                    continue;
                }
                child._setProperty(childsChildProperty, asArray, false, true);
                continue;
            }
            BaseHK2JAXBBean childsChild = (BaseHK2JAXBBean)childToCopy._getProperty(childsChildProperty);
            if (childsChild == null) continue;
            BaseHK2JAXBBean grandchild = Utilities.internalAdd(child, childsChildProperty, childsChild, null, -1, changeInformation, xmlDynamicChange, addedServices, true);
            child._setProperty(childsChildProperty, grandchild, false, true);
        }
    }

    private static void externalAdd(BaseHK2JAXBBean root, DynamicConfiguration config, WriteableBeanDatabase writeableDatabase, List<ActiveDescriptor<?>> addedDescriptors) {
        BaseHK2JAXBBean child2;
        if (config == null && writeableDatabase == null) {
            return;
        }
        ActiveDescriptor<?> added = Utilities.advertise(writeableDatabase, config, root);
        if (added != null) {
            addedDescriptors.add(added);
        }
        for (String keyedChildProperty : root._getModel().getKeyedChildren()) {
            Object keyedRawChild = root._getProperty(keyedChildProperty);
            if (keyedRawChild == null) continue;
            if (keyedRawChild instanceof Iterable) {
                Iterable iterable = (Iterable)keyedRawChild;
                for (BaseHK2JAXBBean child2 : iterable) {
                    Utilities.externalAdd(child2, config, writeableDatabase, addedDescriptors);
                }
                continue;
            }
            if (keyedRawChild.getClass().isArray()) {
                int aLength = Array.getLength(keyedRawChild);
                for (int lcv = 0; lcv < aLength; ++lcv) {
                    child2 = (BaseHK2JAXBBean)Array.get(keyedRawChild, lcv);
                    Utilities.externalAdd(child2, config, writeableDatabase, addedDescriptors);
                }
                continue;
            }
            Utilities.externalAdd((BaseHK2JAXBBean)keyedRawChild, config, writeableDatabase, addedDescriptors);
        }
        for (String unkeyedChildProperty : root._getModel().getUnKeyedChildren()) {
            Object unkeyedRawChild = root._getProperty(unkeyedChildProperty);
            if (unkeyedRawChild == null) continue;
            if (unkeyedRawChild instanceof Iterable) {
                Iterable unkeyedMultiChildren = (Iterable)unkeyedRawChild;
                for (BaseHK2JAXBBean child2 : unkeyedMultiChildren) {
                    Utilities.externalAdd(child2, config, writeableDatabase, addedDescriptors);
                }
                continue;
            }
            if (unkeyedRawChild.getClass().isArray()) {
                int aLength = Array.getLength(unkeyedRawChild);
                for (int lcv = 0; lcv < aLength; ++lcv) {
                    child2 = (BaseHK2JAXBBean)Array.get(unkeyedRawChild, lcv);
                    Utilities.externalAdd(child2, config, writeableDatabase, addedDescriptors);
                }
                continue;
            }
            Utilities.externalAdd((BaseHK2JAXBBean)unkeyedRawChild, config, writeableDatabase, addedDescriptors);
        }
    }

    public static BaseHK2JAXBBean _addRoot(ModelImpl rootNode, Object rawRoot, DynamicChangeInfo<?> changeInfo, ClassReflectionHelper helper, WriteableBeanDatabase writeableDatabase, DynamicConfiguration dynamicService, List<ActiveDescriptor<?>> addedServices, XmlRootHandleImpl<?> xmlRootHandle) {
        if (!(rawRoot instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The root added must be from XmlService.createBean");
        }
        BaseHK2JAXBBean child = Utilities.createBean(rootNode.getProxyAsClass());
        child._setClassReflectionHelper(helper);
        BaseHK2JAXBBean childToCopy = (BaseHK2JAXBBean)rawRoot;
        for (String nonChildProperty : childToCopy._getModel().getNonChildProperties().keySet()) {
            Object value = childToCopy._getProperty(nonChildProperty);
            if (value == null) continue;
            child._setProperty(nonChildProperty, value, false);
        }
        if (rootNode.getKeyProperty() != null) {
            child._setKeyValue((String)child._getProperty(rootNode.getKeyProperty()));
        }
        child._setSelfXmlTag(rootNode.getRootName());
        child._setInstanceName(rootNode.getRootName());
        Utilities.handleChildren(child, childToCopy, changeInfo, addedServices, XmlDynamicChange.EMPTY);
        child._setDynamicChangeInfo(xmlRootHandle, changeInfo);
        Utilities.externalAdd(child, dynamicService, writeableDatabase, addedServices);
        return child;
    }

    public static BaseHK2JAXBBean internalRemove(BaseHK2JAXBBean myParent, String childProperty, String childKey, int index, Object childToRemove, DynamicChangeInfo<?> changeInformation, XmlDynamicChange xmlDynamicChange, boolean changeList) {
        if (childProperty == null) {
            return null;
        }
        String instanceToRemove = null;
        if (childKey == null && index < 0 && childToRemove != null) {
            if (!(childToRemove instanceof BaseHK2JAXBBean)) {
                throw new IllegalArgumentException("Removed child must be a child of the parent " + myParent + " but is not of the correct type " + childToRemove.getClass().getName());
            }
            BaseHK2JAXBBean childToRemoveBean = (BaseHK2JAXBBean)childToRemove;
            BaseHK2JAXBBean childToRemoveParent = (BaseHK2JAXBBean)childToRemoveBean._getParent();
            if (childToRemoveParent == null) {
                throw new IllegalArgumentException("Removed child must be a child of the parent " + myParent + " but has no parent of its own");
            }
            if (!childToRemoveParent.equals(myParent)) {
                throw new IllegalArgumentException("Removed child must be a child of the parent " + myParent + " but has a different parent " + childToRemoveParent);
            }
            instanceToRemove = childToRemoveBean._getInstanceName();
        }
        ParentedModel removeMeParentedNode = myParent._getModel().getChild(childProperty);
        ModelImpl removeMeNode = removeMeParentedNode.getChildModel();
        BaseHK2JAXBBean rootForDeletion = null;
        if (!ChildType.DIRECT.equals((Object)removeMeParentedNode.getChildType())) {
            if (childKey == null && index < 0 && instanceToRemove == null) {
                return null;
            }
            if (ChildType.LIST.equals((Object)removeMeParentedNode.getChildType())) {
                List removeFromList = (List)myParent._getProperty(childProperty);
                if (removeFromList == null) {
                    return null;
                }
                int minusOneSize = removeFromList.size() - 1;
                if (minusOneSize < 0) {
                    return null;
                }
                ArrayList<BaseHK2JAXBBean> listWithObjectRemoved = new ArrayList<BaseHK2JAXBBean>(minusOneSize + 1);
                if (childKey != null || instanceToRemove != null) {
                    String comparisonKey = childKey != null ? childKey : instanceToRemove;
                    for (BaseHK2JAXBBean candidate : removeFromList) {
                        String candidateKeyValue = childKey != null ? candidate._getKeyValue() : candidate._getInstanceName();
                        if (GeneralUtilities.safeEquals((Object)candidateKeyValue, (Object)comparisonKey)) {
                            rootForDeletion = candidate;
                            continue;
                        }
                        listWithObjectRemoved.add(candidate);
                    }
                } else {
                    if (index >= removeFromList.size()) {
                        return null;
                    }
                    for (int lcv = 0; lcv < removeFromList.size(); ++lcv) {
                        if (lcv == index) {
                            rootForDeletion = (BaseHK2JAXBBean)removeFromList.get(lcv);
                            continue;
                        }
                        listWithObjectRemoved.add((BaseHK2JAXBBean)removeFromList.get(lcv));
                    }
                }
                if (rootForDeletion == null) {
                    return null;
                }
                if (changeList) {
                    if (xmlDynamicChange.getBeanDatabase() != null) {
                        myParent.changeInHub(childProperty, listWithObjectRemoved, xmlDynamicChange.getBeanDatabase());
                    }
                    myParent._setProperty(childProperty, listWithObjectRemoved, false, true);
                }
            } else {
                int lcv;
                int lcv2;
                Object removeFromArray = myParent._getProperty(childProperty);
                if (removeFromArray == null) {
                    return null;
                }
                int removeFromArrayLength = Array.getLength(removeFromArray);
                if (removeFromArrayLength == 0) {
                    return null;
                }
                Class<?> arrayType = removeMeNode.getOriginalInterfaceAsClass();
                Object arrayWithObjectRemoved = Array.newInstance(arrayType, removeFromArrayLength - 1);
                if (childKey != null || instanceToRemove != null) {
                    String comparisonKey = childKey != null ? childKey : instanceToRemove;
                    int removeIndex = -1;
                    for (lcv2 = 0; lcv2 < removeFromArrayLength; ++lcv2) {
                        BaseHK2JAXBBean candidate = (BaseHK2JAXBBean)Array.get(removeFromArray, lcv2);
                        String candidateKeyValue = childKey != null ? candidate._getKeyValue() : candidate._getInstanceName();
                        if (!GeneralUtilities.safeEquals((Object)candidateKeyValue, (Object)comparisonKey)) continue;
                        rootForDeletion = candidate;
                        removeIndex = lcv2;
                        break;
                    }
                    if (rootForDeletion == null) {
                        return null;
                    }
                    int addIndex = 0;
                    for (int lcv3 = 0; lcv3 < removeFromArrayLength; ++lcv3) {
                        if (lcv3 == removeIndex) continue;
                        Array.set(arrayWithObjectRemoved, addIndex++, Array.get(removeFromArray, lcv3));
                    }
                } else if (index >= 0) {
                    if (index >= removeFromArrayLength) {
                        return null;
                    }
                    rootForDeletion = (BaseHK2JAXBBean)Array.get(removeFromArray, index);
                    int addIndex = 0;
                    for (lcv = 0; lcv < removeFromArrayLength; ++lcv) {
                        if (lcv == index) continue;
                        Array.set(arrayWithObjectRemoved, addIndex++, Array.get(removeFromArray, lcv));
                    }
                } else {
                    int removeIndex = -1;
                    for (lcv = 0; lcv < removeFromArrayLength; ++lcv) {
                        BaseHK2JAXBBean candidate = (BaseHK2JAXBBean)Array.get(removeFromArray, lcv);
                        String candidateKeyValue = candidate._getInstanceName();
                        if (!GeneralUtilities.safeEquals((Object)candidateKeyValue, (Object)instanceToRemove)) continue;
                        rootForDeletion = candidate;
                        removeIndex = lcv;
                        break;
                    }
                    if (rootForDeletion == null) {
                        return null;
                    }
                    int addIndex = 0;
                    for (lcv2 = 0; lcv2 < removeFromArrayLength; ++lcv2) {
                        if (lcv2 == removeIndex) continue;
                        Array.set(arrayWithObjectRemoved, addIndex++, Array.get(removeFromArray, lcv2));
                    }
                }
                if (rootForDeletion == null) {
                    return null;
                }
                if (changeList) {
                    if (xmlDynamicChange.getBeanDatabase() != null) {
                        myParent.changeInHub(childProperty, arrayWithObjectRemoved, xmlDynamicChange.getBeanDatabase());
                    }
                    myParent._setProperty(childProperty, arrayWithObjectRemoved, false, true);
                }
            }
        } else {
            rootForDeletion = (BaseHK2JAXBBean)myParent._getProperty(childProperty);
            if (rootForDeletion == null) {
                return null;
            }
            if (xmlDynamicChange.getBeanDatabase() != null) {
                myParent.changeInHub(childProperty, null, xmlDynamicChange.getBeanDatabase());
            }
            myParent._setProperty(childProperty, null, false, true);
        }
        Utilities.invokeAllDeletedChangeListeners(changeInformation, rootForDeletion, myParent._getClassReflectionHelper());
        if (xmlDynamicChange.getDynamicConfiguration() != null) {
            HashSet descriptorsToRemove = new HashSet();
            Utilities.getDescriptorsToRemove(rootForDeletion, descriptorsToRemove);
            for (ActiveDescriptor<?> descriptorToRemove : descriptorsToRemove) {
                xmlDynamicChange.getDynamicConfiguration().addUnbindFilter((Filter)BuilderHelper.createSpecificDescriptorFilter(descriptorToRemove));
            }
        }
        if (xmlDynamicChange.getBeanDatabase() != null) {
            String rootXmlPath = rootForDeletion._getXmlPath();
            String rootInstanceName = rootForDeletion._getInstanceName();
            WriteableType rootType = xmlDynamicChange.getBeanDatabase().getWriteableType(rootXmlPath);
            if (rootType != null) {
                rootType.removeInstance(rootInstanceName);
                String typeRemovalIndicator = rootXmlPath + '/';
                Set allTypes = xmlDynamicChange.getBeanDatabase().getAllWriteableTypes();
                for (WriteableType allType : allTypes) {
                    if (!allType.getName().startsWith(typeRemovalIndicator)) continue;
                    Map allInstances = allType.getInstances();
                    LinkedHashSet<String> removeMe = new LinkedHashSet<String>();
                    String rootInstancePrefix = rootInstanceName + ".";
                    for (String iKey : allInstances.keySet()) {
                        if (!iKey.startsWith(rootInstancePrefix)) continue;
                        removeMe.add(iKey);
                    }
                    for (String iKey : removeMe) {
                        allType.removeInstance(iKey);
                    }
                }
            }
        }
        return rootForDeletion;
    }

    private static void getDescriptorsToRemove(BaseHK2JAXBBean fromMe, HashSet<ActiveDescriptor<?>> descriptorsToRemove) {
        ActiveDescriptor<?> fromMeDescriptor = fromMe._getSelfDescriptor();
        if (fromMeDescriptor == null) {
            return;
        }
        descriptorsToRemove.add(fromMeDescriptor);
        ModelImpl model = fromMe._getModel();
        if (model == null) {
            return;
        }
        block5: for (ParentedModel parentedChild : model.getAllChildren()) {
            String childPropertyName = parentedChild.getChildXmlTag();
            switch (parentedChild.getChildType()) {
                case LIST: {
                    List listChildren = (List)fromMe._getProperty(childPropertyName);
                    if (listChildren == null) continue block5;
                    for (BaseHK2JAXBBean listChild : listChildren) {
                        Utilities.getDescriptorsToRemove(listChild, descriptorsToRemove);
                    }
                    continue block5;
                }
                case ARRAY: {
                    Object arrayChildren = fromMe._getProperty(childPropertyName);
                    if (arrayChildren == null) continue block5;
                    int arrayLength = Array.getLength(arrayChildren);
                    for (int lcv = 0; lcv < arrayLength; ++lcv) {
                        BaseHK2JAXBBean bean = (BaseHK2JAXBBean)Array.get(arrayChildren, lcv);
                        Utilities.getDescriptorsToRemove(bean, descriptorsToRemove);
                    }
                    continue block5;
                }
                case DIRECT: {
                    BaseHK2JAXBBean bean = (BaseHK2JAXBBean)fromMe._getProperty(childPropertyName);
                    if (bean == null) continue block5;
                    Utilities.getDescriptorsToRemove(bean, descriptorsToRemove);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown child type " + (Object)((Object)parentedChild.getChildType())));
                }
            }
        }
    }

    public static Object getDefaultValue(String givenStringDefault, Class<?> expectedClass) {
        if (givenStringDefault == null || "\u0000".equals(givenStringDefault)) {
            if (Integer.TYPE.equals(expectedClass)) {
                return DEFAULT_INTEGER;
            }
            if (Long.TYPE.equals(expectedClass)) {
                return DEFAULT_LONG;
            }
            if (Boolean.TYPE.equals(expectedClass)) {
                return DEFAULT_BOOLEAN;
            }
            if (Short.TYPE.equals(expectedClass)) {
                return DEFAULT_SHORT;
            }
            if (Byte.TYPE.equals(expectedClass)) {
                return DEFAULT_BYTE;
            }
            if (Character.TYPE.equals(expectedClass)) {
                return DEFAULT_CHARACTER;
            }
            if (Float.TYPE.equals(expectedClass)) {
                return DEFAULT_FLOAT;
            }
            if (Double.TYPE.equals(expectedClass)) {
                return DEFAULT_DOUBLE;
            }
            return null;
        }
        if (String.class.equals(expectedClass)) {
            return givenStringDefault;
        }
        if (Integer.TYPE.equals(expectedClass)) {
            return Integer.parseInt(givenStringDefault);
        }
        if (Long.TYPE.equals(expectedClass)) {
            return Long.parseLong(givenStringDefault);
        }
        if (Boolean.TYPE.equals(expectedClass)) {
            return Boolean.parseBoolean(givenStringDefault);
        }
        if (Short.TYPE.equals(expectedClass)) {
            return Short.parseShort(givenStringDefault);
        }
        if (Byte.TYPE.equals(expectedClass)) {
            return Byte.parseByte(givenStringDefault);
        }
        if (Character.TYPE.equals(expectedClass)) {
            return Character.valueOf(givenStringDefault.charAt(0));
        }
        if (Float.TYPE.equals(expectedClass)) {
            return Float.valueOf(Float.parseFloat(givenStringDefault));
        }
        if (Double.TYPE.equals(expectedClass)) {
            return Double.parseDouble(givenStringDefault);
        }
        if (expectedClass.isArray() && Byte.TYPE.equals(expectedClass.getComponentType())) {
            return givenStringDefault.getBytes();
        }
        throw new AssertionError((Object)("Default for type " + expectedClass.getName() + " not implemented"));
    }

    public static void fillInUnfinishedReferences(Map<ReferenceKey, BaseHK2JAXBBean> referenceMap, List<UnresolvedReference> unresolved) {
        LinkedList<IllegalStateException> errors = new LinkedList<IllegalStateException>();
        for (UnresolvedReference unresolvedRef : unresolved) {
            ReferenceKey key = new ReferenceKey(unresolvedRef.getType(), unresolvedRef.getXmlID());
            BaseHK2JAXBBean reference = referenceMap.get(key);
            if (reference == null) {
                errors.add(new IllegalStateException("No Reference was found for " + unresolvedRef));
            }
            BaseHK2JAXBBean unfinished = unresolvedRef.getUnfinished();
            unfinished._setProperty(unresolvedRef.getPropertyName(), reference);
        }
        if (!errors.isEmpty()) {
            throw new MultiException(errors);
        }
    }

    public static Method findSuitableCustomizerMethod(Class<?> cClass, String methodName, Class<?>[] params, Class<?> topInterface) {
        try {
            return cClass.getMethod(methodName, params);
        }
        catch (NoSuchMethodException nsme) {
            if (topInterface == null) {
                return null;
            }
            int altParamsLength = params.length + 1;
            Class[] exactParams = new Class[altParamsLength];
            exactParams[0] = topInterface;
            for (int lcv = 0; lcv < params.length; ++lcv) {
                exactParams[lcv + 1] = params[lcv];
            }
            try {
                return cClass.getMethod(methodName, exactParams);
            }
            catch (NoSuchMethodException nsme2) {
                for (Method candidate : cClass.getMethods()) {
                    if (!methodName.equals(candidate.getName())) continue;
                    int altParamsLength2 = params.length + 1;
                    Class<?>[] candidateParams = candidate.getParameterTypes();
                    if (candidateParams.length != altParamsLength2 || !candidateParams[0].isAssignableFrom(topInterface)) continue;
                    boolean found = true;
                    for (int lcv = 1; lcv < altParamsLength2; ++lcv) {
                        if (candidateParams[lcv].equals(params[lcv - 1])) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    return candidate;
                }
                return null;
            }
        }
    }

    private static void invokeAllDeletedChangeListeners(DynamicChangeInfo<?> control, BaseHK2JAXBBean rootBean, ClassReflectionHelper helper) {
        ModelImpl model = rootBean._getModel();
        Map<String, ParentedModel> childrenByName = model.getChildrenByName();
        for (Map.Entry<String, ParentedModel> entry : childrenByName.entrySet()) {
            String propertyName = entry.getKey();
            ParentedModel parentModel = entry.getValue();
            Object child = rootBean._getProperty(propertyName);
            if (child == null) continue;
            if (ChildType.LIST.equals((Object)parentModel.getChildType())) {
                List listChildren = (List)child;
                for (BaseHK2JAXBBean grandchild : listChildren) {
                    Utilities.invokeAllDeletedChangeListeners(control, grandchild, helper);
                }
                continue;
            }
            if (ChildType.ARRAY.equals((Object)parentModel.getChildType())) {
                int length = Array.getLength(child);
                for (int lcv = 0; lcv < length; ++lcv) {
                    BaseHK2JAXBBean grandchild;
                    grandchild = (BaseHK2JAXBBean)Array.get(child, lcv);
                    Utilities.invokeAllDeletedChangeListeners(control, grandchild, helper);
                }
                continue;
            }
            if (!ChildType.DIRECT.equals((Object)parentModel.getChildType())) continue;
            BaseHK2JAXBBean grandchild = (BaseHK2JAXBBean)child;
            Utilities.invokeAllDeletedChangeListeners(control, grandchild, helper);
        }
        Utilities.invokeVetoableChangeListeners(control, rootBean, rootBean, null, EMPTY_STRING, helper);
    }

    public static void invokeVetoableChangeListeners(DynamicChangeInfo<?> control, BaseHK2JAXBBean source, Object oldValue, Object newValue, String propertyName, ClassReflectionHelper helper) {
        Set violations;
        ModelImpl model;
        String javaName;
        if (control == null) {
            return;
        }
        Validator validator = control.findValidator();
        if (validator != null && (javaName = (model = source._getModel()).getJavaNameFromKey(propertyName, helper)) != null && (violations = validator.validateValue(source.getClass(), javaName, newValue, new Class[0])) != null && !violations.isEmpty()) {
            throw new MultiException((Throwable)new ConstraintViolationException(violations));
        }
        List<VetoableChangeListener> vetoers = control.getChangeListeners();
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        for (VetoableChangeListener listener : vetoers) {
            try {
                listener.vetoableChange(event);
            }
            catch (PropertyVetoException pve) {
                errors.add(pve);
                throw new MultiException(errors);
            }
            catch (Throwable th) {
                errors.add(th);
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException(errors);
        }
    }

    public static Differences getDiff(BaseHK2JAXBBean source, BaseHK2JAXBBean other) {
        ModelImpl otherModel;
        ModelImpl sourceModel = source._getModel();
        if (!sourceModel.equals(otherModel = other._getModel())) {
            throw new AssertionError((Object)("Can only diff two beans of the same type.  Source is " + sourceModel + " other is " + otherModel));
        }
        Differences retVal = new Differences();
        Utilities.getAllDifferences(source, other, retVal);
        return retVal;
    }

    private static void getAllDifferences(BaseHK2JAXBBean source, BaseHK2JAXBBean other, Differences differences) {
        Differences.Difference localDifference = new Differences.Difference(source);
        ModelImpl sourceModel = source._getModel();
        Map<String, Object> sourceMap = source._getBeanLikeMap();
        Map<String, Object> otherMap = other._getBeanLikeMap();
        Map<String, ChildDataModel> nonChildProperties = sourceModel.getNonChildProperties();
        for (Map.Entry<String, ChildDataModel> nonChildPropertyEntry : nonChildProperties.entrySet()) {
            String otherReferenceKey;
            String nonChildProperty = nonChildPropertyEntry.getKey();
            ChildDataModel dataModel = nonChildPropertyEntry.getValue();
            Object sourceValue = sourceMap.get(nonChildProperty);
            Object otherValue = otherMap.get(nonChildProperty);
            if (!dataModel.isReference()) {
                if (GeneralUtilities.safeEquals((Object)sourceValue, (Object)otherValue)) continue;
                localDifference.addNonChildChange(new PropertyChangeEvent(source, nonChildProperty, sourceValue, otherValue));
                continue;
            }
            if (sourceValue != null && otherValue == null) {
                localDifference.addNonChildChange(new PropertyChangeEvent(source, nonChildProperty, sourceValue, otherValue));
                continue;
            }
            if (sourceValue == null && otherValue != null) {
                localDifference.addNonChildChange(new PropertyChangeEvent(source, nonChildProperty, sourceValue, otherValue));
                continue;
            }
            if (sourceValue == null) continue;
            BaseHK2JAXBBean sourceReference = (BaseHK2JAXBBean)sourceValue;
            BaseHK2JAXBBean otherReference = (BaseHK2JAXBBean)otherValue;
            String sourceReferenceKey = sourceReference._getKeyValue();
            if (GeneralUtilities.safeEquals((Object)sourceReferenceKey, (Object)(otherReferenceKey = otherReference._getKeyValue()))) continue;
            localDifference.addNonChildChange(new PropertyChangeEvent(source, nonChildProperty, sourceValue, otherValue));
        }
        Map<String, ParentedModel> childProperties = sourceModel.getChildrenByName();
        for (Map.Entry<String, ParentedModel> childEntry : childProperties.entrySet()) {
            BaseHK2JAXBBean[] otherArray;
            Object otherBean;
            String keyProperty;
            String xmlTag = childEntry.getKey();
            ParentedModel pModel = childEntry.getValue();
            BaseHK2JAXBBean[] sourceValue = sourceMap.get(xmlTag);
            BaseHK2JAXBBean[] otherValue = otherMap.get(xmlTag);
            if (ChildType.DIRECT.equals((Object)pModel.getChildType())) {
                if (sourceValue == null && otherValue != null) {
                    localDifference.addAdd(xmlTag, (BaseHK2JAXBBean)otherValue, -1);
                    continue;
                }
                if (sourceValue != null && otherValue == null) {
                    localDifference.addRemove(xmlTag, new Differences.RemoveData(xmlTag, (BaseHK2JAXBBean)sourceValue));
                    continue;
                }
                if (sourceValue == null) continue;
                Utilities.getAllDifferences((BaseHK2JAXBBean)sourceValue, (BaseHK2JAXBBean)otherValue, differences);
                continue;
            }
            if (ChildType.LIST.equals((Object)pModel.getChildType())) {
                keyProperty = pModel.getChildModel().getKeyProperty();
                List<BaseHK2JAXBBean> sourceValueList = (List<BaseHK2JAXBBean>)sourceValue;
                List<BaseHK2JAXBBean> otherValueList = (List<BaseHK2JAXBBean>)otherValue;
                if (sourceValueList == null) {
                    sourceValueList = Collections.emptyList();
                }
                if (otherValueList == null) {
                    otherValueList = Collections.emptyList();
                }
                if (keyProperty != null) {
                    for (BaseHK2JAXBBean sourceBean : sourceValueList) {
                        String sourceKeyValue = sourceBean._getKeyValue();
                        otherBean = other._lookupChild(xmlTag, sourceKeyValue);
                        if (otherBean == null) {
                            localDifference.addRemove(xmlTag, new Differences.RemoveData(xmlTag, sourceKeyValue, sourceBean));
                            continue;
                        }
                        Utilities.getAllDifferences(sourceBean, (BaseHK2JAXBBean)otherBean, differences);
                    }
                    for (BaseHK2JAXBBean otherBean2 : otherValueList) {
                        String otherKeyValue = otherBean2._getKeyValue();
                        Object addMe = source._lookupChild(xmlTag, otherKeyValue);
                        if (addMe != null) continue;
                        localDifference.addAdd(xmlTag, otherBean2, -1);
                    }
                    continue;
                }
                UnkeyedDiff unkeyedDiff = new UnkeyedDiff(sourceValueList, otherValueList, source, pModel);
                Differences unkeyedDiffs = unkeyedDiff.compute();
                differences.merge(unkeyedDiffs);
                continue;
            }
            if (!ChildType.ARRAY.equals((Object)pModel.getChildType())) continue;
            keyProperty = pModel.getChildModel().getKeyProperty();
            BaseHK2JAXBBean[] sourceArray = sourceValue == null ? new BaseHK2JAXBBean[]{} : sourceValue;
            BaseHK2JAXBBean[] baseHK2JAXBBeanArray = otherArray = otherValue == null ? new BaseHK2JAXBBean[]{} : otherValue;
            if (keyProperty != null) {
                int sourceLength = Array.getLength(sourceArray);
                for (int lcv = 0; lcv < sourceLength; ++lcv) {
                    BaseHK2JAXBBean sourceBean = (BaseHK2JAXBBean)Array.get(sourceArray, lcv);
                    String sourceKeyValue = sourceBean._getKeyValue();
                    Object otherBean3 = other._lookupChild(xmlTag, sourceKeyValue);
                    if (otherBean3 == null) {
                        localDifference.addRemove(xmlTag, new Differences.RemoveData(xmlTag, sourceKeyValue, sourceBean));
                        continue;
                    }
                    Utilities.getAllDifferences(sourceBean, (BaseHK2JAXBBean)otherBean3, differences);
                }
                int otherLength = Array.getLength(otherArray);
                for (int lcv = 0; lcv < otherLength; ++lcv) {
                    otherBean = (BaseHK2JAXBBean)Array.get(otherArray, lcv);
                    String otherKeyValue = ((BaseHK2JAXBBean)otherBean)._getKeyValue();
                    Object addMe = source._lookupChild(xmlTag, otherKeyValue);
                    if (addMe != null) continue;
                    localDifference.addAdd(xmlTag, (BaseHK2JAXBBean)otherBean, -1);
                }
                continue;
            }
            UnkeyedDiff unkeyedDiff = new UnkeyedDiff(sourceArray, otherArray, source, pModel);
            Differences unkeyedDiffs = unkeyedDiff.compute();
            differences.merge(unkeyedDiffs);
        }
        if (localDifference.isDirty()) {
            differences.addDifference(localDifference);
        }
    }

    public static void applyDiff(Differences differences, DynamicChangeInfo<?> changeControl) {
        for (Differences.Difference difference : differences.getDifferences()) {
            BaseHK2JAXBBean source = difference.getSource();
            LinkedList<PropertyChangeEvent> allSourceChanges = new LinkedList<PropertyChangeEvent>();
            allSourceChanges.addAll(difference.getNonChildChanges());
            if (!difference.hasChildChanges()) {
                Utilities.applyAllSourceChanges(source, allSourceChanges, changeControl);
                continue;
            }
            ModelImpl model = source._getModel();
            for (Map.Entry<String, Differences.AddRemoveMoveDifference> childEntry : difference.getChildChanges().entrySet()) {
                String xmlKey = childEntry.getKey();
                Differences.AddRemoveMoveDifference childDiffs = childEntry.getValue();
                ParentedModel parentedModel = model.getChild(xmlKey);
                ChildType childType = parentedModel.getChildType();
                boolean changeList = ChildType.DIRECT.equals((Object)childType);
                Object oldListOrArray = source._getProperty(xmlKey);
                LinkedHashMap<Integer, BaseHK2JAXBBean> arrayChanges = null;
                if (!changeList) {
                    arrayChanges = new LinkedHashMap<Integer, BaseHK2JAXBBean>();
                }
                for (Differences.AddData added : childDiffs.getAdds()) {
                    BaseHK2JAXBBean addMe = added.getToAdd();
                    int index = added.getIndex();
                    BaseHK2JAXBBean addedBean = (BaseHK2JAXBBean)source._doAdd(xmlKey, addMe, null, index, changeList);
                    if (!changeList) {
                        arrayChanges.put(index, addedBean);
                        continue;
                    }
                    allSourceChanges.add(new PropertyChangeEvent(source, xmlKey, null, addedBean));
                }
                for (Differences.RemoveData removed : childDiffs.getRemoves()) {
                    source._doRemove(xmlKey, removed.getChildKey(), removed.getIndex(), removed.getChild(), changeList);
                    if (!changeList) continue;
                    allSourceChanges.add(new PropertyChangeEvent(source, xmlKey, oldListOrArray, null));
                }
                for (Differences.MoveData md : childDiffs.getMoves()) {
                    BaseHK2JAXBBean movedBean = Utilities.getLOABean(oldListOrArray, childType, md.getOldIndex());
                    if (changeList) continue;
                    arrayChanges.put(md.getNewIndex(), movedBean);
                }
                if (changeList) continue;
                int newSize = childDiffs.getNewSize(Utilities.getLOASize(oldListOrArray, childType));
                Object newListOrArray = Utilities.createLOA(childType, newSize, parentedModel.getChildModel());
                for (int lcv = 0; lcv < newSize; ++lcv) {
                    BaseHK2JAXBBean toPut = (BaseHK2JAXBBean)arrayChanges.get(lcv);
                    if (toPut == null) {
                        toPut = Utilities.getLOABean(oldListOrArray, childType, lcv);
                    }
                    Utilities.putLOABean(newListOrArray, childType, lcv, toPut);
                }
                allSourceChanges.add(new PropertyChangeEvent(source, xmlKey, oldListOrArray, newListOrArray));
            }
            Utilities.applyAllSourceChanges(source, allSourceChanges, changeControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyAllSourceChanges(BaseHK2JAXBBean source, List<PropertyChangeEvent> events, DynamicChangeInfo<?> changeControl) {
        boolean success = false;
        XmlDynamicChange xmlDynamicChange = changeControl.startOrContinueChange(source);
        try {
            WriteableBeanDatabase wbd = xmlDynamicChange.getBeanDatabase();
            boolean madeAChange = false;
            for (PropertyChangeEvent pce : events) {
                if (GeneralUtilities.safeEquals((Object)pce.getOldValue(), (Object)pce.getNewValue())) continue;
                madeAChange = true;
                Utilities.invokeVetoableChangeListeners(changeControl, source, pce.getOldValue(), pce.getNewValue(), pce.getPropertyName(), source._getClassReflectionHelper());
            }
            if (!madeAChange) {
                success = true;
                return;
            }
            if (wbd != null) {
                source.changeInHub(events, wbd);
            }
            for (PropertyChangeEvent pce : events) {
                source._setProperty(pce.getPropertyName(), pce.getNewValue(), false, true);
            }
            success = true;
        }
        finally {
            changeControl.endOrDeferChange(success);
        }
    }

    private static Object createLOA(ChildType type, int size, ModelImpl childModel) {
        if (ChildType.ARRAY.equals((Object)type)) {
            return Array.newInstance(childModel.getOriginalInterfaceAsClass(), size);
        }
        return new ArrayList(size);
    }

    private static void putLOABean(Object listOrArray, ChildType type, int index, BaseHK2JAXBBean putMe) {
        if (ChildType.ARRAY.equals((Object)type)) {
            Array.set(listOrArray, index, putMe);
            return;
        }
        List list = (List)listOrArray;
        list.add(index, putMe);
    }

    private static BaseHK2JAXBBean getLOABean(Object listOrArray, ChildType type, int index) {
        if (ChildType.ARRAY.equals((Object)type)) {
            return (BaseHK2JAXBBean)Array.get(listOrArray, index);
        }
        if (ChildType.LIST.equals((Object)type)) {
            List list = (List)listOrArray;
            return (BaseHK2JAXBBean)list.get(index);
        }
        return (BaseHK2JAXBBean)listOrArray;
    }

    private static int getLOASize(Object listOrArray, ChildType type) {
        if (ChildType.ARRAY.equals((Object)type)) {
            return Array.getLength(listOrArray);
        }
        if (ChildType.LIST.equals((Object)type)) {
            List list = (List)listOrArray;
            return list.size();
        }
        return 1;
    }

    public static int calculateAddCost(BaseHK2JAXBBean bean) {
        if (bean == null) {
            return -1;
        }
        int knownValue = bean.__getAddCost();
        if (knownValue >= 0) {
            return knownValue;
        }
        int retVal = 1;
        ModelImpl model = bean._getModel();
        block5: for (ParentedModel parentedModel : model.getAllChildren()) {
            String propName = parentedModel.getChildXmlTag();
            Object rawChild = bean._getProperty(propName);
            if (rawChild == null) continue;
            switch (parentedModel.getChildType()) {
                case DIRECT: {
                    BaseHK2JAXBBean child = (BaseHK2JAXBBean)rawChild;
                    int childCost = Utilities.calculateAddCost(child);
                    retVal += childCost;
                    break;
                }
                case LIST: {
                    List childList = (List)rawChild;
                    for (BaseHK2JAXBBean child : childList) {
                        int childCost = Utilities.calculateAddCost(child);
                        retVal += childCost;
                    }
                    continue block5;
                }
                case ARRAY: {
                    int length = Array.getLength(rawChild);
                    for (int lcv = 0; lcv < length; ++lcv) {
                        BaseHK2JAXBBean child = (BaseHK2JAXBBean)Array.get(rawChild, lcv);
                        int childCost = Utilities.calculateAddCost(child);
                        retVal += childCost;
                    }
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("Unknown child type " + (Object)((Object)parentedModel.getChildType())));
                }
            }
        }
        bean.__setAddCost(retVal);
        return retVal;
    }
}

