/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.merge;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DiagnosticsBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.HttpFactoryBean;
import org.glassfish.hk2.xml.test.beans.HttpServerBean;
import org.glassfish.hk2.xml.test.beans.HttpsFactoryBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.QueueBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.beans.ServerBean;
import org.glassfish.hk2.xml.test.beans.TopicBean;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.dynamic.rawsets.UpdateListener;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class MergeTest {
    public static final String DOMAIN1_FILE = "domain1.xml";
    private static final String DOMAIN1_NAME = "domain1";
    public static final String RSA_ATZ_PROV_NAME = "RSA";
    private static final String RSA_DOM_PFX = "rsa";
    public static final String ALICE_NAME = "Alice";
    public static final String BOB_NAME = "Bob";
    public static final String CAROL_NAME = "Carol";
    public static final String DAVE_NAME = "Dave";
    public static final String EDDIE_NAME = "Eddie";
    public static final String TOPIC0_NAME = "Topic0";
    public static final String TOPIC1_NAME = "Topic1";
    public static final String TOPIC2_NAME = "Topic2";
    public static final String QUEUE0_NAME = "Queue0";
    public static final String QUEUE1_NAME = "Queue1";
    public static final String QUEUE2_NAME = "Queue2";
    public static final String TOPICD0_NAME = "TopicD0";
    public static final String QUEUED0_NAME = "QueueD0";
    public static final String ESSEX_NAME = "Essex";
    public static final String FAIRVIEW_NAME = "Fairview";
    public static final String GLENDOLA_NAME = "Glendola";
    public static final String HOLYOKE_NAME = "Holyoke";
    public static final String IROQUIS_NAME = "Iroquis";
    public static final String LIBERTY_NAME = "Liberty";
    private static final String ALICE_ADDRESS = "10.0.0.1";
    private static final String ALICE_SERVER0_NAME = "Server-0";
    private static final int ALICE_SERVER0_PORT = 12345;
    private static final String DEFAULT_SUBNET = "0.0.0.255";
    public static final String SERVER1_NAME = "Server-1";
    public static final String DOMAIN_TYPE = "/domain";
    public static final String DOMAIN_INSTANCE = "domain";
    public static final String MACHINE_TYPE = "/domain/machine";
    public static final String SERVER_TYPE = "/domain/machine/server";
    public static final String SECURITY_MANAGER_TYPE = "/domain/security-manager";
    public static final String AUTHORIZATION_PROVIDER_TYPE = "/domain/security-manager/authorization-provider";
    public static final String JMS_SERVER_TYPE = "/domain/jms-server";
    public static final String TOPIC_TYPE = "/domain/jms-server/topic";
    public static final String QUEUE_TYPE = "/domain/jms-server/queue";
    public static final String HTTP_FACTORY_TYPE = "/domain/http-factory";
    public static final String HTTP_SERVER_TYPE = "/domain/http-factory/http-server";
    public static final String HTTPS_FACTORY_TYPE = "/domain/https-factory";
    public static final String SSL_MANAGER_TYPE = "/domain/security-manager/ssl-manager";
    public static final String DIAGNOSTICS_TYPE = "/domain/diagnostics";
    public static final String ALICE_INSTANCE = "domain.Alice";
    public static final String BOB_INSTANCE = "domain.Bob";
    public static final String CAROL_INSTANCE = "domain.Carol";
    public static final String DAVE_INSTANCE = "domain.Dave";
    public static final String EDDIE_INSTANCE = "domain.Eddie";
    private static final String SERVER0_INSTANCE = "domain.Alice.Server-0";
    public static final String SERVER1_INSTANCE = "domain.Eddie.Server-1";
    public static final String SECURITY_MANAGER_INSTANCE = "domain.security-manager";
    private static final String RSA_INSTANCE = "domain.security-manager.RSA";
    public static final String JMS_SERVER_CAROL_INSTANCE = "domain.Carol";
    private static final String TOPIC0_INSTANCE = "domain.Carol.Topic0";
    private static final String TOPIC1_INSTANCE = "domain.Carol.Topic1";
    private static final String TOPIC2_INSTANCE = "domain.Bob.Topic2";
    private static final String QUEUE0_INSTANCE = "domain.Carol.Queue0";
    private static final String QUEUE0_BOB_INSTANCE = "domain.Bob.Queue0";
    private static final String QUEUE1_INSTANCE = "domain.Carol.Queue1";
    private static final String QUEUE2_INSTANCE = "domain.Carol.Queue2";
    public static final String SSL_MANAGER_INSTANCE_NAME = "domain.security-manager.ssl-manager";
    private static final String ADDRESS_TAG = "address";
    private static final String PORT_TAG = "port";
    private static final String ATZ_DOMAIN_PFX_TAG = "domain-pfx";
    public static final String SUBNET_TAG = "subnetwork";
    public static final String TAXONOMY_TAG = "taxonomy";
    public static final String COMPRESSION_TAG = "compression-algorithm";
    public static final String LZ_COMPRESSION = "LZ";

    @Test
    public void testMergeModifyTwoPropertiesOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        Museum museumCopy = (Museum)copy.getChildRoot();
        Museum museumOld = (Museum)rootHandle.getRoot();
        museumCopy.setAge(101);
        museumCopy.setId(101);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        copy.merge();
        Assert.assertEquals((long)101L, (long)museumOld.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museumOld.getName());
        Assert.assertEquals((long)101L, (long)museumOld.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance("/museum", "museum");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get("age"));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        Change change = changes.get(0);
        Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        List events = change.getModifiedProperties();
        boolean gotId = false;
        boolean gotAge = false;
        for (PropertyChangeEvent event : events) {
            if ("age".equals(event.getPropertyName())) {
                gotAge = true;
                continue;
            }
            if (!"id".equals(event.getPropertyName())) continue;
            gotId = true;
        }
        Assert.assertTrue((boolean)gotId);
        Assert.assertTrue((boolean)gotAge);
    }

    @Test
    public void testMergeModifyAddAListChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        MachineBean addedBean = (MachineBean)xmlService.createBean(MachineBean.class);
        addedBean.setName(BOB_NAME);
        domainCopy.addMachine(addedBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        List<MachineBean> machines = domainOld.getMachines();
        Assert.assertEquals((long)2L, (long)machines.size());
        boolean foundAlice = false;
        boolean foundBob = false;
        for (MachineBean machine : machines) {
            if (machine.getName().equals(BOB_NAME)) {
                if (foundBob) {
                    Assert.fail((String)("There were more than one bob in the list of machines: " + machines));
                }
                foundBob = true;
                continue;
            }
            if (!machine.getName().equals(ALICE_NAME)) continue;
            if (foundAlice) {
                Assert.fail((String)("There were more than one alice in the list of machines: " + machines));
            }
            foundAlice = true;
        }
        Assert.assertTrue((String)("Added child was not found: " + machines), (boolean)foundBob);
        Assert.assertTrue((String)("Existing child was not found: " + machines), (boolean)foundAlice);
        Instance machineBobInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, BOB_INSTANCE);
        Assert.assertNotNull((Object)machineBobInstance);
        Map bobMap = (Map)machineBobInstance.getBean();
        Assert.assertEquals((Object)BOB_NAME, bobMap.get("name"));
        Assert.assertNull(bobMap.get(ADDRESS_TAG));
        List<Change> hubChanges = listener.getChanges();
        Assert.assertEquals((long)2L, (long)hubChanges.size());
        boolean foundAdd = false;
        boolean foundMod = false;
        for (Change change : hubChanges) {
            if (Change.ChangeCategory.ADD_INSTANCE.equals((Object)change.getChangeCategory())) {
                Assert.assertEquals((Object)BOB_INSTANCE, (Object)change.getInstanceKey());
                foundAdd = true;
                continue;
            }
            if (Change.ChangeCategory.MODIFY_INSTANCE.equals((Object)change.getChangeCategory())) {
                Assert.assertEquals((Object)DOMAIN_INSTANCE, (Object)change.getInstanceKey());
                foundMod = true;
                continue;
            }
            Assert.fail((String)("Unknown change found: " + change));
        }
        Assert.assertTrue((boolean)foundAdd);
        Assert.assertTrue((boolean)foundMod);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMergeModifyAddAnArrayChild() throws Exception {
        void var20_24;
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        JMSServerBean addedBean = (JMSServerBean)xmlService.createBean(JMSServerBean.class);
        addedBean.setName(BOB_NAME);
        TopicBean addedTopic = (TopicBean)xmlService.createBean(TopicBean.class);
        addedTopic.setName(TOPIC2_NAME);
        addedBean.addTopic(addedTopic);
        QueueBean addedQueue = (QueueBean)xmlService.createBean(QueueBean.class);
        addedQueue.setName(QUEUE0_NAME);
        addedBean.addQueue(addedQueue);
        domainCopy.addJMSServer(addedBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        Object[] jmsServers = domainOld.getJMSServers();
        Assert.assertEquals((long)3L, (long)jmsServers.length);
        boolean foundCarol = false;
        boolean foundDave = false;
        boolean foundBob = false;
        for (JMSServerBean jMSServerBean : jmsServers) {
            if (jMSServerBean.getName().equals(BOB_NAME)) {
                if (foundBob) {
                    Assert.fail((String)("There were more than one bob in the list of machines: " + Arrays.toString(jmsServers)));
                }
                foundBob = true;
                Assert.assertNotNull((Object)jMSServerBean.lookupTopic(TOPIC2_NAME));
                Assert.assertNotNull((Object)jMSServerBean.lookupQueue(QUEUE0_NAME));
                continue;
            }
            if (jMSServerBean.getName().equals(CAROL_NAME)) {
                if (foundCarol) {
                    Assert.fail((String)("There were more than one alice in the list of machines: " + Arrays.toString(jmsServers)));
                }
                foundCarol = true;
                continue;
            }
            if (jMSServerBean.getName().equals(DAVE_NAME)) {
                if (foundDave) {
                    Assert.fail((String)("There were more than one alice in the list of machines: " + Arrays.toString(jmsServers)));
                }
                foundDave = true;
                continue;
            }
            Assert.fail((String)("Unknown JMSServer: " + jMSServerBean));
        }
        Assert.assertTrue((String)("Added child was not found: " + Arrays.toString(jmsServers)), (boolean)foundBob);
        Assert.assertTrue((String)("Existing child was not found: " + Arrays.toString(jmsServers)), (boolean)foundCarol);
        Assert.assertTrue((String)("Existing child was not found: " + Arrays.toString(jmsServers)), (boolean)foundDave);
        Instance machineBobInstance = hub.getCurrentDatabase().getInstance(JMS_SERVER_TYPE, BOB_INSTANCE);
        Assert.assertNotNull((Object)machineBobInstance);
        Map bobMap = (Map)machineBobInstance.getBean();
        Assert.assertEquals((Object)BOB_NAME, bobMap.get("name"));
        Assert.assertNull(bobMap.get(ADDRESS_TAG));
        Instance topic2Instance = hub.getCurrentDatabase().getInstance(TOPIC_TYPE, TOPIC2_INSTANCE);
        Assert.assertNotNull((Object)topic2Instance);
        Map topic2Map = (Map)topic2Instance.getBean();
        Assert.assertEquals((Object)TOPIC2_NAME, topic2Map.get("name"));
        Instance queue0Instance = hub.getCurrentDatabase().getInstance(QUEUE_TYPE, QUEUE0_BOB_INSTANCE);
        Assert.assertNotNull((Object)queue0Instance);
        Map queue0Map = (Map)queue0Instance.getBean();
        Assert.assertEquals((Object)QUEUE0_NAME, queue0Map.get("name"));
        List<Change> hubChanges = listener.getChanges();
        Assert.assertEquals((String)("changeSize=" + hubChanges.size() + " Changes=" + hubChanges), (long)4L, (long)hubChanges.size());
        boolean foundTopic2Instance = false;
        boolean foundQueue0BobInstance = false;
        boolean bl = false;
        while (var20_24 < 4) {
            Change change = hubChanges.get((int)var20_24);
            switch (var20_24) {
                case 0: {
                    Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)BOB_INSTANCE, (Object)change.getInstanceKey());
                    break;
                }
                case 1: 
                case 2: {
                    Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)change.getChangeCategory());
                    String changeInstance = change.getInstanceKey();
                    if (TOPIC2_INSTANCE.equals(changeInstance)) {
                        foundTopic2Instance = true;
                        break;
                    }
                    if (QUEUE0_BOB_INSTANCE.equals(changeInstance)) {
                        foundQueue0BobInstance = true;
                        break;
                    }
                    Assert.fail((String)("Found add_instance of unknown instance name " + changeInstance));
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)DOMAIN_INSTANCE, (Object)change.getInstanceKey());
                    break;
                }
                default: {
                    Assert.fail((String)("Too many changes: " + (int)var20_24 + " change=" + change));
                }
            }
            ++var20_24;
        }
        Assert.assertTrue((boolean)foundTopic2Instance);
        Assert.assertTrue((boolean)foundQueue0BobInstance);
    }

    @Test
    public void testRemoveDirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        Assert.assertTrue((boolean)domainCopy.removeSecurityManager());
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        Assert.assertNull((Object)domainOld.getSecurityManager());
        MergeTest.assertNotInHub(hub, SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        MergeTest.assertNotInHub(hub, AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        List<Change> hubChanges = listener.getChanges();
        Assert.assertEquals((String)("Did not get expected changes, got " + hubChanges), (long)3L, (long)hubChanges.size());
        block5: for (int lcv = 0; lcv < hubChanges.size(); ++lcv) {
            Change change = hubChanges.get(lcv);
            switch (lcv) {
                case 0: {
                    Assert.assertEquals((Object)Change.ChangeCategory.REMOVE_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)SECURITY_MANAGER_INSTANCE, (Object)change.getInstanceKey());
                    continue block5;
                }
                case 1: {
                    Assert.assertEquals((Object)Change.ChangeCategory.REMOVE_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)RSA_INSTANCE, (Object)change.getInstanceKey());
                    continue block5;
                }
                case 2: {
                    Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)DOMAIN_INSTANCE, (Object)change.getInstanceKey());
                    continue block5;
                }
                default: {
                    Assert.fail((String)("Uknown change " + lcv + " was " + change));
                }
            }
        }
    }

    @Test
    public void testAddDirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(DOMAIN1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        XmlRootCopy copy = rootHandle.getXmlRootCopy();
        DomainBean domainCopy = (DomainBean)copy.getChildRoot();
        DomainBean domainOld = (DomainBean)rootHandle.getRoot();
        DiagnosticsBean diagnostics = (DiagnosticsBean)xmlService.createBean(DiagnosticsBean.class);
        diagnostics.setName(ESSEX_NAME);
        domainCopy.setDiagnostics(diagnostics);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        copy.merge();
        diagnostics = domainOld.getDiagnostics();
        Assert.assertNotNull((Object)diagnostics);
        MergeTest.assertNameOnlyBean(hub, DIAGNOSTICS_TYPE, "domain.Essex", ESSEX_NAME);
        List<Change> hubChanges = listener.getChanges();
        Assert.assertEquals((String)("Did not get expected changes, got " + hubChanges), (long)3L, (long)hubChanges.size());
        block5: for (int lcv = 0; lcv < hubChanges.size(); ++lcv) {
            Change change = hubChanges.get(lcv);
            switch (lcv) {
                case 0: {
                    Assert.assertEquals((Object)Change.ChangeCategory.ADD_TYPE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)DIAGNOSTICS_TYPE, (Object)change.getChangeType().getName());
                    continue block5;
                }
                case 1: {
                    Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)"domain.Essex", (Object)change.getInstanceKey());
                    Assert.assertEquals((Object)DIAGNOSTICS_TYPE, (Object)change.getChangeType().getName());
                    continue block5;
                }
                case 2: {
                    Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
                    Assert.assertEquals((Object)DOMAIN_INSTANCE, (Object)change.getInstanceKey());
                    Assert.assertEquals((Object)DOMAIN_TYPE, (Object)change.getChangeType().getName());
                    continue block5;
                }
                default: {
                    Assert.fail((String)("Uknown change " + lcv + " was " + change));
                }
            }
        }
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> rootHandle, Hub hub, ServiceLocator locator, boolean didDefault) {
        DomainBean root = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, didDefault);
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        DomainBean root = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, false);
    }

    public static void verifyDomain1Xml(XmlRootHandle<DomainBean> original, XmlRootCopy<DomainBean> rootHandle, Hub hub, ServiceLocator locator) {
        Assert.assertEquals(original, (Object)rootHandle.getParent());
        DomainBean root = (DomainBean)rootHandle.getChildRoot();
        MergeTest.verifyDomain1XmlDomain(root, hub, locator, false);
    }

    private static void verifyDomain1XmlDomain(DomainBean root, Hub hub, ServiceLocator locator, boolean didDefault) {
        Assert.assertEquals((String)("Failing bean is " + root), (Object)DOMAIN1_NAME, (Object)root.getName());
        Assert.assertEquals((Object)DEFAULT_SUBNET, (Object)root.getSubnetwork());
        Assert.assertNull((Object)root.getTaxonomy());
        SecurityManagerBean securityManager = root.getSecurityManager();
        Assert.assertNotNull((Object)securityManager);
        List<AuthorizationProviderBean> atzProviders = securityManager.getAuthorizationProviders();
        Assert.assertNotNull(atzProviders);
        Assert.assertEquals((long)1L, (long)atzProviders.size());
        if (!didDefault) {
            Assert.assertNull((Object)securityManager.getSSLManager());
        } else {
            SSLManagerBean sslManager = securityManager.getSSLManager();
            Assert.assertNotNull((Object)sslManager);
            Assert.assertNull((Object)sslManager.getPublicKeyLocation());
            Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
        }
        MachineBean aliceRef = null;
        for (AuthorizationProviderBean atzProvider : atzProviders) {
            Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)atzProvider.getName());
            Assert.assertEquals((Object)RSA_DOM_PFX, (Object)atzProvider.getAtzDomainPrefix());
            aliceRef = atzProvider.getMachine();
        }
        Assert.assertNotNull(aliceRef);
        List<MachineBean> machines = root.getMachines();
        Assert.assertNotNull(machines);
        Assert.assertEquals((long)1L, (long)machines.size());
        MachineBean alice = null;
        ServerBean myReference = null;
        Iterator<MachineBean> i$ = machines.iterator();
        while (i$.hasNext()) {
            MachineBean machine;
            alice = machine = i$.next();
            Assert.assertEquals((Object)aliceRef, (Object)machine);
            Assert.assertEquals((Object)ALICE_NAME, (Object)machine.getName());
            Assert.assertEquals((Object)ALICE_ADDRESS, (Object)machine.getAddress());
            List<ServerBean> servers = machine.getServers();
            Assert.assertNotNull(servers);
            Assert.assertEquals((long)1L, (long)servers.size());
            for (ServerBean server : servers) {
                Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)server.getName());
                Assert.assertEquals((long)12345L, (long)server.getPort());
                myReference = server;
            }
        }
        JMSServerBean[] jmsServers = root.getJMSServers();
        Assert.assertEquals((long)2L, (long)jmsServers.length);
        int lcv = 0;
        for (JMSServerBean jmsServer : jmsServers) {
            if (lcv == 0) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)CAROL_NAME, (Object)jmsServer.getName());
                ServerBean serverReference = jmsServer.getServer();
                Assert.assertEquals(myReference, (Object)serverReference);
                List<TopicBean> topics = jmsServer.getTopics();
                Assert.assertEquals((long)2L, (long)topics.size());
                Assert.assertEquals((Object)TOPIC0_NAME, (Object)topics.get(0).getName());
                Assert.assertEquals((Object)TOPIC1_NAME, (Object)topics.get(1).getName());
                QueueBean[] queues = jmsServer.getQueues();
                Assert.assertEquals((long)3L, (long)queues.length);
                Assert.assertEquals((Object)QUEUE0_NAME, (Object)queues[0].getName());
                Assert.assertEquals((Object)QUEUE1_NAME, (Object)queues[1].getName());
                Assert.assertEquals((Object)QUEUE2_NAME, (Object)queues[2].getName());
                Assert.assertNull((Object)jmsServer.getCompressionAlgorithm());
            } else if (lcv == 1) {
                Assert.assertEquals((String)("Did not find name in " + jmsServer), (Object)DAVE_NAME, (Object)jmsServer.getName());
                List<TopicBean> topics = jmsServer.getTopics();
                Assert.assertEquals((long)1L, (long)topics.size());
                Assert.assertEquals((Object)TOPICD0_NAME, (Object)topics.get(0).getName());
                QueueBean[] queues = jmsServer.getQueues();
                Assert.assertEquals((long)1L, (long)queues.length);
                Assert.assertEquals((Object)QUEUED0_NAME, (Object)queues[0].getName());
                Assert.assertNull((Object)jmsServer.getCompressionAlgorithm());
            }
            ++lcv;
        }
        List<HttpFactoryBean> httpFactories = root.getHTTPFactories();
        Assert.assertEquals((long)2L, (long)httpFactories.size());
        String factory0Identifier = null;
        String factory1Identifier = null;
        lcv = 0;
        for (HttpFactoryBean httpFactory : httpFactories) {
            List<HttpServerBean> httpServers;
            if (lcv == 0) {
                factory0Identifier = ((XmlHk2ConfigurationBean)httpFactory)._getInstanceName();
                Assert.assertEquals((Object)ESSEX_NAME, (Object)httpFactory.getNonKeyIdentifier());
                httpServers = httpFactory.getHttpServers();
                Assert.assertEquals((long)1L, (long)httpServers.size());
                for (HttpServerBean httpServer : httpServers) {
                    Assert.assertEquals((Object)FAIRVIEW_NAME, (Object)httpServer.getName());
                    Assert.assertEquals((long)1234L, (long)httpServer.getPort());
                }
            } else {
                factory1Identifier = ((XmlHk2ConfigurationBean)httpFactory)._getInstanceName();
                Assert.assertEquals((Object)GLENDOLA_NAME, (Object)httpFactory.getNonKeyIdentifier());
                httpServers = httpFactory.getHttpServers();
                Assert.assertEquals((long)2L, (long)httpServers.size());
                int lcv2 = 0;
                for (HttpServerBean httpServer : httpServers) {
                    if (lcv2 == 0) {
                        Assert.assertEquals((Object)HOLYOKE_NAME, (Object)httpServer.getName());
                        Assert.assertEquals((long)5678L, (long)httpServer.getPort());
                    } else {
                        Assert.assertEquals((Object)IROQUIS_NAME, (Object)httpServer.getName());
                        Assert.assertEquals((long)5679L, (long)httpServer.getPort());
                    }
                    ++lcv2;
                }
            }
            ++lcv;
        }
        HttpsFactoryBean[] httpsFactories = root.getHTTPSFactories();
        Assert.assertEquals((long)1L, (long)httpsFactories.length);
        Assert.assertEquals((Object)LIBERTY_NAME, (Object)httpsFactories[0].getNonKeyIdentifier());
        String httpsInstanceName = ((XmlHk2ConfigurationBean)httpsFactories[0])._getInstanceName();
        if (hub == null || locator == null) {
            return;
        }
        Instance domainInstance = hub.getCurrentDatabase().getInstance(DOMAIN_TYPE, DOMAIN_INSTANCE);
        Assert.assertNotNull((Object)domainInstance);
        Map domainMap = (Map)domainInstance.getBean();
        Assert.assertNull(domainMap.get(SUBNET_TAG));
        Assert.assertNull(domainMap.get(TAXONOMY_TAG));
        Object domainInstanceMetadata = domainInstance.getMetadata();
        Assert.assertNotNull((Object)domainInstanceMetadata);
        Assert.assertEquals((Object)root, (Object)domainInstanceMetadata);
        Instance machineAliceInstance = hub.getCurrentDatabase().getInstance(MACHINE_TYPE, ALICE_INSTANCE);
        Assert.assertNotNull((Object)machineAliceInstance);
        Map aliceMap = (Map)machineAliceInstance.getBean();
        Assert.assertEquals((Object)ALICE_NAME, aliceMap.get("name"));
        Assert.assertEquals((Object)ALICE_ADDRESS, aliceMap.get(ADDRESS_TAG));
        Object machineAliceInstanceMetadata = machineAliceInstance.getMetadata();
        Assert.assertNotNull((Object)machineAliceInstanceMetadata);
        Assert.assertEquals((Object)alice, (Object)machineAliceInstanceMetadata);
        Instance aliceServer0Instance = hub.getCurrentDatabase().getInstance(SERVER_TYPE, SERVER0_INSTANCE);
        Assert.assertNotNull((Object)aliceServer0Instance);
        Map server0Map = (Map)aliceServer0Instance.getBean();
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, server0Map.get("name"));
        Assert.assertEquals((Object)12345, server0Map.get(PORT_TAG));
        Instance securityManagerInstance = hub.getCurrentDatabase().getInstance(SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        Assert.assertNotNull((Object)securityManagerInstance);
        Map securityManagerMap = (Map)securityManagerInstance.getBean();
        Assert.assertNotNull((Object)securityManagerMap);
        Instance rsaInstance = hub.getCurrentDatabase().getInstance(AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        Assert.assertNotNull((Object)rsaInstance);
        Map rsaMap = (Map)rsaInstance.getBean();
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, rsaMap.get("name"));
        Assert.assertEquals((Object)RSA_DOM_PFX, rsaMap.get(ATZ_DOMAIN_PFX_TAG));
        Instance sslManagerInstance = hub.getCurrentDatabase().getInstance(SSL_MANAGER_TYPE, SSL_MANAGER_INSTANCE_NAME);
        if (didDefault) {
            Assert.assertNotNull((Object)sslManagerInstance);
            Map sslManagerMap = (Map)sslManagerInstance.getBean();
            Assert.assertNull(sslManagerMap.get("public-key-location"));
        } else {
            Assert.assertNull((Object)sslManagerInstance);
        }
        MergeTest.assertNameOnlyBean(hub, JMS_SERVER_TYPE, "domain.Carol", CAROL_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC0_INSTANCE, TOPIC0_NAME);
        MergeTest.assertNameOnlyBean(hub, TOPIC_TYPE, TOPIC1_INSTANCE, TOPIC1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE0_INSTANCE, QUEUE0_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE1_INSTANCE, QUEUE1_NAME);
        MergeTest.assertNameOnlyBean(hub, QUEUE_TYPE, QUEUE2_INSTANCE, QUEUE2_NAME);
        Instance f0 = hub.getCurrentDatabase().getInstance(HTTP_FACTORY_TYPE, factory0Identifier);
        Assert.assertNotNull((Object)f0);
        Map beanLike = (Map)f0.getBean();
        Assert.assertEquals((Object)ESSEX_NAME, beanLike.get("non-key-identifier"));
        Instance f1 = hub.getCurrentDatabase().getInstance(HTTP_FACTORY_TYPE, factory1Identifier);
        Assert.assertNotNull((Object)f1);
        beanLike = (Map)f1.getBean();
        Assert.assertEquals((Object)GLENDOLA_NAME, beanLike.get("non-key-identifier"));
        Instance s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory0Identifier + "." + FAIRVIEW_NAME, FAIRVIEW_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(1234), beanLike.get(PORT_TAG));
        s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory1Identifier + "." + HOLYOKE_NAME, HOLYOKE_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(5678), beanLike.get(PORT_TAG));
        s1 = MergeTest.assertNameOnlyBean(hub, HTTP_SERVER_TYPE, factory1Identifier + "." + IROQUIS_NAME, IROQUIS_NAME);
        beanLike = (Map)s1.getBean();
        Assert.assertEquals((Object)new Integer(5679), beanLike.get(PORT_TAG));
        f1 = hub.getCurrentDatabase().getInstance(HTTPS_FACTORY_TYPE, httpsInstanceName);
        Assert.assertNotNull((Object)f1);
        beanLike = (Map)f1.getBean();
        Assert.assertEquals((Object)LIBERTY_NAME, beanLike.get("non-key-identifier"));
        MergeTest.assertNotInHub(hub, DIAGNOSTICS_TYPE);
        MergeTest.assertDomain1Services(locator, locator, didDefault);
    }

    public static void verifyDomain1XmlDomainNotThere(Hub hub, ServiceLocator locator) {
        MergeTest.assertNotInHub(hub, DOMAIN_TYPE, DOMAIN_INSTANCE);
        MergeTest.assertNotInHub(hub, MACHINE_TYPE, ALICE_INSTANCE);
        MergeTest.assertNotInHub(hub, SERVER_TYPE, SERVER0_INSTANCE);
        MergeTest.assertNotInHub(hub, SECURITY_MANAGER_TYPE, SECURITY_MANAGER_INSTANCE);
        MergeTest.assertNotInHub(hub, AUTHORIZATION_PROVIDER_TYPE, RSA_INSTANCE);
        MergeTest.assertNotInHub(hub, JMS_SERVER_TYPE, "domain.Carol");
        MergeTest.assertNotInHub(hub, JMS_SERVER_TYPE, "domain.Carol");
        MergeTest.assertNotInHub(hub, TOPIC_TYPE, TOPIC0_INSTANCE);
        MergeTest.assertNotInHub(hub, TOPIC_TYPE, TOPIC1_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE0_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE1_INSTANCE);
        MergeTest.assertNotInHub(hub, QUEUE_TYPE, QUEUE2_INSTANCE);
        MergeTest.assertNotDomain1Services(locator);
    }

    private static void assertNotInHub(Hub hub, String type, String instance) {
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance(type, instance));
    }

    private static void assertNotInHub(Hub hub, String type) {
        Type dbType = hub.getCurrentDatabase().getType(type);
        if (dbType == null) {
            return;
        }
        Map instances = dbType.getInstances();
        Assert.assertTrue((String)("Found instances of type: " + instances), (boolean)instances.isEmpty());
    }

    public static void assertDomain1Services(ServiceLocator locator) {
        MergeTest.assertDomain1Services(locator, locator, false);
    }

    public static void assertDomain1Services(ServiceLocator locator, ServiceLocator fromLocator, boolean didDefault) {
        DomainBean db = (DomainBean)locator.getService(DomainBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)DOMAIN1_NAME, (Object)db.getName());
        MergeTest.assertServiceComesFromSameLocator(db, fromLocator);
        SecurityManagerBean smb = (SecurityManagerBean)locator.getService(SecurityManagerBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)smb);
        MergeTest.assertServiceComesFromSameLocator(smb, fromLocator);
        AuthorizationProviderBean rsa = (AuthorizationProviderBean)locator.getService(AuthorizationProviderBean.class, RSA_ATZ_PROV_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)rsa);
        Assert.assertEquals((Object)RSA_ATZ_PROV_NAME, (Object)rsa.getName());
        MergeTest.assertServiceComesFromSameLocator(rsa, fromLocator);
        MachineBean mb = (MachineBean)locator.getService(MachineBean.class, ALICE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)mb);
        Assert.assertEquals((Object)ALICE_NAME, (Object)mb.getName());
        MergeTest.assertServiceComesFromSameLocator(mb, fromLocator);
        ServerBean sb = (ServerBean)locator.getService(ServerBean.class, ALICE_SERVER0_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)sb);
        Assert.assertEquals((Object)ALICE_SERVER0_NAME, (Object)sb.getName());
        MergeTest.assertServiceComesFromSameLocator(sb, fromLocator);
        JMSServerBean carolJMS = (JMSServerBean)locator.getService(JMSServerBean.class, CAROL_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)carolJMS);
        Assert.assertEquals((Object)CAROL_NAME, (Object)carolJMS.getName());
        MergeTest.assertServiceComesFromSameLocator(carolJMS, fromLocator);
        JMSServerBean daveJMS = (JMSServerBean)locator.getService(JMSServerBean.class, DAVE_NAME, new Annotation[0]);
        Assert.assertNotNull((Object)daveJMS);
        Assert.assertEquals((Object)DAVE_NAME, (Object)daveJMS.getName());
        MergeTest.assertServiceComesFromSameLocator(daveJMS, fromLocator);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPIC0_NAME);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPIC1_NAME);
        MergeTest.assertTopicOfName(locator, fromLocator, TOPICD0_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE0_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE1_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUE2_NAME);
        MergeTest.assertQueueOfName(locator, fromLocator, QUEUED0_NAME);
        List httpFactories = locator.getAllServices(HttpFactoryBean.class, new Annotation[0]);
        Assert.assertTrue((2 == httpFactories.size() || 4 == httpFactories.size() ? 1 : 0) != 0);
        HttpFactoryBean essexFactory = null;
        HttpFactoryBean glendolaFactory = null;
        int lcv = 0;
        for (HttpFactoryBean httpFactory : httpFactories) {
            MergeTest.assertServiceComesFromSameLocator(httpFactory, fromLocator);
            if (httpFactory.getNonKeyIdentifier().equals(ESSEX_NAME)) {
                essexFactory = httpFactory;
            } else if (httpFactory.getNonKeyIdentifier().equals(GLENDOLA_NAME)) {
                glendolaFactory = httpFactory;
            } else {
                Assert.fail((String)("Unknown factory: " + httpFactory));
            }
            if (++lcv < 2) continue;
            break;
        }
        Assert.assertNotNull(essexFactory);
        Assert.assertNotNull(glendolaFactory);
        MergeTest.assertHttpServerOfName(locator, fromLocator, FAIRVIEW_NAME, 1234);
        MergeTest.assertHttpServerOfName(locator, fromLocator, HOLYOKE_NAME, 5678);
        MergeTest.assertHttpServerOfName(locator, fromLocator, IROQUIS_NAME, 5679);
        HttpsFactoryBean httpsFactory = (HttpsFactoryBean)locator.getService(HttpsFactoryBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)httpsFactory);
        Assert.assertEquals((Object)LIBERTY_NAME, (Object)httpsFactory.getNonKeyIdentifier());
        MergeTest.assertServiceComesFromSameLocator(httpsFactory, fromLocator);
        SSLManagerBean sslManager = (SSLManagerBean)locator.getService(SSLManagerBean.class, new Annotation[0]);
        if (didDefault) {
            Assert.assertNotNull((Object)sslManager);
            Assert.assertNull((Object)sslManager.getPublicKeyLocation());
            Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
            MergeTest.assertServiceComesFromSameLocator(sslManager, fromLocator);
        } else {
            Assert.assertNull((Object)sslManager);
        }
        Assert.assertNull((Object)fromLocator.getService(DiagnosticsBean.class, new Annotation[0]));
    }

    private static void assertServiceComesFromSameLocator(Object service, ServiceLocator locator) {
        Assert.assertTrue((boolean)(service instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean configBean = (XmlHk2ConfigurationBean)service;
        ActiveDescriptor descriptor = configBean._getSelfDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Long locatorId = locator.getLocatorId();
        Long serviceId = descriptor.getLocatorId();
        Assert.assertEquals((Object)locatorId, (Object)serviceId);
    }

    public static void assertQueueOfName(ServiceLocator locator, String expectedName) {
        MergeTest.assertQueueOfName(locator, locator, expectedName);
    }

    public static void assertQueueOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName) {
        QueueBean qb = (QueueBean)locator.getService(QueueBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)qb);
        Assert.assertEquals((Object)expectedName, (Object)qb.getName());
        MergeTest.assertServiceComesFromSameLocator(qb, fromLocator);
    }

    public static void assertHttpServerOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName, int expectedPort) {
        HttpServerBean hsb = (HttpServerBean)locator.getService(HttpServerBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)hsb);
        Assert.assertEquals((Object)expectedName, (Object)hsb.getName());
        Assert.assertEquals((long)expectedPort, (long)hsb.getPort());
        MergeTest.assertServiceComesFromSameLocator(hsb, fromLocator);
    }

    public static void assertTopicOfName(ServiceLocator locator, String expectedName) {
        MergeTest.assertTopicOfName(locator, locator, expectedName);
    }

    public static void assertTopicOfName(ServiceLocator locator, ServiceLocator fromLocator, String expectedName) {
        TopicBean tb = (TopicBean)locator.getService(TopicBean.class, expectedName, new Annotation[0]);
        Assert.assertNotNull((Object)tb);
        Assert.assertEquals((Object)expectedName, (Object)tb.getName());
        MergeTest.assertServiceComesFromSameLocator(tb, fromLocator);
    }

    public static Instance assertNameOnlyBean(Hub hub, String type, String instance, String expectedName) {
        Instance namedInstance = hub.getCurrentDatabase().getInstance(type, instance);
        Assert.assertNotNull((String)("Could not find instance of " + type + "," + instance), (Object)namedInstance);
        Map namedMap = (Map)namedInstance.getBean();
        Assert.assertEquals((Object)expectedName, namedMap.get("name"));
        return namedInstance;
    }

    private static void assertNotDomain1Services(ServiceLocator locator) {
        MergeTest.assertLocalServiceNotThere(DomainBean.class, null, locator);
        MergeTest.assertLocalServiceNotThere(SecurityManagerBean.class, null, locator);
        MergeTest.assertLocalServiceNotThere(AuthorizationProviderBean.class, RSA_ATZ_PROV_NAME, locator);
        MergeTest.assertLocalServiceNotThere(MachineBean.class, ALICE_NAME, locator);
        MergeTest.assertLocalServiceNotThere(ServerBean.class, ALICE_SERVER0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(JMSServerBean.class, CAROL_NAME, locator);
        MergeTest.assertLocalServiceNotThere(JMSServerBean.class, DAVE_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPIC0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPIC1_NAME, locator);
        MergeTest.assertLocalServiceNotThere(TopicBean.class, TOPICD0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE0_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE1_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUE2_NAME, locator);
        MergeTest.assertLocalServiceNotThere(QueueBean.class, QUEUED0_NAME, locator);
    }

    private static void assertLocalServiceNotThere(Class<?> serviceClass, String serviceName, ServiceLocator localLocator) {
        LocalServiceOnlyFilter serviceFilter = new LocalServiceOnlyFilter(serviceClass, serviceName, localLocator);
        List allServices = localLocator.getAllServices((Filter)serviceFilter);
        Assert.assertEquals((long)0L, (long)allServices.size());
    }

    private static final class LocalServiceOnlyFilter
    implements IndexedFilter {
        private final Class<?> serviceClass;
        private final String name;
        private final ServiceLocator localLocator;

        private LocalServiceOnlyFilter(Class<?> serviceClass, String name, ServiceLocator localLocator) {
            this.serviceClass = serviceClass;
            this.name = name;
            this.localLocator = localLocator;
        }

        public boolean matches(Descriptor d) {
            return d.getLocatorId().equals(this.localLocator.getLocatorId());
        }

        public String getAdvertisedContract() {
            return this.serviceClass.getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

