/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.clazz.MethodAltMethodImpl;
import org.glassfish.hk2.xml.spi.Model;

public class ModelImpl
implements Model {
    private static final long serialVersionUID = 752816761552710497L;
    private static final Object lock = new Object();
    private String originalInterface;
    private volatile Class<?> originalInterfaceAsClass;
    private String translatedClass;
    private volatile Class<?> translatedClassAsClass;
    private String rootName;
    private final Map<String, ParentedModel> childrenByName = new LinkedHashMap<String, ParentedModel>();
    private final Map<String, ChildDataModel> nonChildProperty = new LinkedHashMap<String, ChildDataModel>();
    private final Map<String, ChildDescriptor> allChildren = new LinkedHashMap<String, ChildDescriptor>();
    private String keyProperty;
    private Set<String> unKeyedChildren = null;
    private Set<String> keyedChildren = null;
    private transient JAUtilities jaUtilities = null;
    private ClassLoader myLoader;
    private Map<String, String> keyToJavaNameMap = null;

    public ModelImpl() {
    }

    public ModelImpl(String originalInterface, String translatedClass) {
        this.originalInterface = originalInterface;
        this.translatedClass = translatedClass;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public void addChild(String childInterface, String xmlTag, ChildType childType, String givenDefault) {
        ParentedModel pm = new ParentedModel(childInterface, xmlTag, childType, givenDefault);
        this.childrenByName.put(xmlTag, pm);
        this.allChildren.put(xmlTag, new ChildDescriptor(pm));
    }

    public void addNonChild(String xmlTag, String defaultValue, String childType, boolean isReference, boolean isElement) {
        ChildDataModel cdm = new ChildDataModel(childType, defaultValue, isReference, isElement);
        this.nonChildProperty.put(xmlTag, cdm);
        this.allChildren.put(xmlTag, new ChildDescriptor(cdm));
    }

    @Override
    public String getOriginalInterface() {
        return this.originalInterface;
    }

    @Override
    public String getTranslatedClass() {
        return this.translatedClass;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public String getKeyProperty() {
        return this.keyProperty;
    }

    public Map<String, ParentedModel> getChildrenByName() {
        return this.childrenByName;
    }

    public Map<String, ChildDataModel> getNonChildProperties() {
        return this.nonChildProperty;
    }

    public Map<String, ChildDescriptor> getAllChildrenDescriptors() {
        return this.allChildren;
    }

    public ChildDescriptor getChildDescriptor(String xmlTag) {
        return this.allChildren.get(xmlTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnKeyedChildren() {
        Object object = lock;
        synchronized (object) {
            if (this.unKeyedChildren != null) {
                return this.unKeyedChildren;
            }
            this.unKeyedChildren = new HashSet<String>();
            for (Map.Entry<String, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() != null) continue;
                this.unKeyedChildren.add(entry.getKey());
            }
            return this.unKeyedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeyedChildren() {
        Object object = lock;
        synchronized (object) {
            if (this.keyedChildren != null) {
                return this.keyedChildren;
            }
            this.keyedChildren = new HashSet<String>();
            for (Map.Entry<String, ParentedModel> entry : this.childrenByName.entrySet()) {
                if (entry.getValue().getChildModel().getKeyProperty() == null) continue;
                this.keyedChildren.add(entry.getKey());
            }
            return this.keyedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJAUtilities(JAUtilities jaUtilities, ClassLoader myLoader) {
        Object object = lock;
        synchronized (object) {
            if (this.jaUtilities != null) {
                return;
            }
            this.jaUtilities = jaUtilities;
            this.myLoader = myLoader;
            for (ParentedModel pm : this.childrenByName.values()) {
                pm.setRuntimeInformation(jaUtilities, myLoader);
            }
            for (ChildDataModel cdm : this.nonChildProperty.values()) {
                cdm.setLoader(myLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultChildValue(String propName) {
        Object object = lock;
        synchronized (object) {
            ChildDataModel cd = this.nonChildProperty.get(propName);
            if (cd == null) {
                return null;
            }
            return cd.getDefaultAsString();
        }
    }

    public boolean isChildProperty(String propName) {
        Object object = lock;
        synchronized (object) {
            if (this.nonChildProperty.containsKey(propName)) {
                return false;
            }
            if (this.childrenByName.containsKey(propName)) {
                return true;
            }
            throw new AssertionError((Object)("Unknwn property " + propName + " for " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getNonChildType(String propName) {
        Object object = lock;
        synchronized (object) {
            ChildDataModel cd = this.nonChildProperty.get(propName);
            if (cd == null) {
                return null;
            }
            return cd.getChildTypeAsClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentedModel getChild(String propName) {
        Object object = lock;
        synchronized (object) {
            return this.childrenByName.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getOriginalInterfaceAsClass() {
        if (this.originalInterfaceAsClass != null) {
            return this.originalInterfaceAsClass;
        }
        Object object = lock;
        synchronized (object) {
            if (this.originalInterfaceAsClass != null) {
                return this.originalInterfaceAsClass;
            }
            this.originalInterfaceAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.originalInterface);
            return this.originalInterfaceAsClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getProxyAsClass() {
        if (this.translatedClassAsClass != null) {
            return this.translatedClassAsClass;
        }
        Object object = lock;
        synchronized (object) {
            if (this.translatedClassAsClass != null) {
                return this.translatedClassAsClass;
            }
            this.translatedClassAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.translatedClass);
            return this.translatedClassAsClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ParentedModel> getAllChildren() {
        Object object = lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.childrenByName.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ParentedModel> getChildrenProperties() {
        Object object = lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.childrenByName);
        }
    }

    public Map<String, ChildDataModel> getAllAttributeChildren() {
        LinkedHashMap<String, ChildDataModel> retVal = new LinkedHashMap<String, ChildDataModel>();
        for (Map.Entry<String, ChildDataModel> candidate : this.nonChildProperty.entrySet()) {
            String xmlKey = candidate.getKey();
            ChildDataModel childDataModel = candidate.getValue();
            if (childDataModel.isElement()) continue;
            retVal.put(xmlKey, childDataModel);
        }
        return retVal;
    }

    public Map<String, ChildDescriptor> getAllElementChildren() {
        LinkedHashMap<String, ChildDescriptor> retVal = new LinkedHashMap<String, ChildDescriptor>();
        for (Map.Entry<String, ChildDescriptor> candidate : this.allChildren.entrySet()) {
            String xmlKey = candidate.getKey();
            ChildDescriptor childDescriptor = candidate.getValue();
            if (childDescriptor.getParentedModel() != null) {
                retVal.put(xmlKey, childDescriptor);
                continue;
            }
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (!childDataModel.isElement()) continue;
            retVal.put(xmlKey, childDescriptor);
        }
        return retVal;
    }

    public synchronized String getJavaNameFromKey(String key, ClassReflectionHelper reflectionHelper) {
        String result;
        if (this.keyToJavaNameMap == null) {
            this.keyToJavaNameMap = new LinkedHashMap<String, String>();
        }
        if ((result = this.keyToJavaNameMap.get(key)) != null) {
            return result;
        }
        if (reflectionHelper == null) {
            return null;
        }
        Class<?> originalInterface = this.getOriginalInterfaceAsClass();
        for (MethodWrapper wrapper : reflectionHelper.getAllMethods(originalInterface)) {
            String xmlName;
            Method m = wrapper.getMethod();
            XmlElement element = m.getAnnotation(XmlElement.class);
            if (element == null) {
                XmlAttribute attribute = m.getAnnotation(XmlAttribute.class);
                if (attribute == null) continue;
                xmlName = attribute.name();
            } else {
                xmlName = element.name();
            }
            String javaName = ModelImpl.getJavaNameFromGetterOrSetter(m, reflectionHelper);
            String keyName = "##default".equals(xmlName) ? javaName : xmlName;
            if (!key.equals(keyName)) continue;
            this.keyToJavaNameMap.put(key, javaName);
            return javaName;
        }
        return null;
    }

    private static String getJavaNameFromGetterOrSetter(Method m, ClassReflectionHelper reflectionHelper) {
        MethodAltMethodImpl alt = new MethodAltMethodImpl(m, reflectionHelper);
        String retVal = Utilities.isGetter(alt);
        if (retVal != null) {
            return retVal;
        }
        return Utilities.isSetter(alt);
    }

    public int hashCode() {
        return this.translatedClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ModelImpl)) {
            return false;
        }
        return this.translatedClass.equals(((ModelImpl)o).getTranslatedClass());
    }

    public String toString() {
        return "ModelImpl(interface=" + this.originalInterface + ",class=" + this.translatedClass + ",root=" + this.rootName + ",keyProperty=" + this.keyProperty + ")";
    }
}

