/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.xml.api.XmlHandleTransaction;
import org.glassfish.hk2.xml.api.XmlHubCommitMessage;
import org.glassfish.hk2.xml.api.XmlRootCopy;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.Differences;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ReferenceKey;
import org.glassfish.hk2.xml.internal.UnresolvedReference;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlHandleTransactionImpl;
import org.glassfish.hk2.xml.internal.XmlRootCopyImpl;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.internal.XmlStreamImpl;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

public class XmlRootHandleImpl<T>
implements XmlRootHandle<T> {
    private final XmlServiceImpl parent;
    private final Hub hub;
    private T root;
    private final ModelImpl rootNode;
    private URI rootURI;
    private final boolean advertised;
    private final boolean advertisedInHub;
    private final DynamicChangeInfo<T> changeControl;

    XmlRootHandleImpl(XmlServiceImpl parent, Hub hub, T root, ModelImpl rootNode, URI rootURI, boolean advertised, boolean inHub, DynamicChangeInfo<T> changes) {
        this.parent = parent;
        this.hub = hub;
        this.root = root;
        this.rootNode = rootNode;
        this.rootURI = rootURI;
        this.advertised = advertised;
        this.advertisedInHub = inHub;
        this.changeControl = changes;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public Class<T> getRootClass() {
        return this.rootNode.getOriginalInterfaceAsClass();
    }

    @Override
    public URI getURI() {
        return this.rootURI;
    }

    @Override
    public boolean isAdvertisedInLocator() {
        return this.advertised;
    }

    @Override
    public boolean isAdvertisedInHub() {
        return this.advertisedInHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlay(XmlRootHandle<T> newRoot) {
        if (!(newRoot instanceof XmlRootHandle)) {
            throw new IllegalArgumentException("newRoot must have been created by the same XmlService as this one");
        }
        XmlRootHandleImpl newRootImpl = (XmlRootHandleImpl)newRoot;
        if (newRootImpl.isAdvertisedInHub()) {
            throw new IllegalArgumentException("The newRoot must not be advertised in the Hub");
        }
        if (newRootImpl.isAdvertisedInLocator()) {
            throw new IllegalArgumentException("The newRoot must not be advertised as hk2 services");
        }
        if (this.root == null) {
            throw new IllegalArgumentException("This XmlRootHandle must have a root to be overlayed");
        }
        T newRootRoot = newRootImpl.getRoot();
        if (newRootRoot == null) {
            throw new IllegalArgumentException("The newRoot must have a root to overlay onto this root");
        }
        if (!(newRootRoot instanceof BaseHK2JAXBBean)) {
            throw new IllegalArgumentException("The newRoot has a root of an unknown type: " + newRootRoot.getClass().getName());
        }
        if (!newRootRoot.getClass().equals(this.root.getClass())) {
            throw new IllegalArgumentException("The two roots must have the same class as this root, instead it is of type " + newRootRoot.getClass().getName());
        }
        if (newRootRoot.equals(this.root)) {
            throw new IllegalArgumentException("Cannot overlay the same bean on top of itself");
        }
        BaseHK2JAXBBean newRootBase = (BaseHK2JAXBBean)newRootRoot;
        BaseHK2JAXBBean oldRootBase = (BaseHK2JAXBBean)this.root;
        boolean success = false;
        XmlHandleTransaction<T> handle = this.lockForTransaction();
        try {
            Differences differences = Utilities.getDiff(oldRootBase, newRootBase);
            if (!differences.getDifferences().isEmpty()) {
                Utilities.applyDiff(differences, this.changeControl);
            }
            success = true;
        }
        finally {
            if (success) {
                handle.commit();
            } else {
                handle.abandon();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlRootCopy<T> getXmlRootCopy() {
        DynamicChangeInfo copyController = new DynamicChangeInfo(this.changeControl.getJAUtilities(), null, false, this.changeControl.getIdGenerator(), null, false, this.changeControl.getServiceLocator());
        this.changeControl.getReadLock().lock();
        try {
            BaseHK2JAXBBean copy;
            BaseHK2JAXBBean bean = (BaseHK2JAXBBean)this.root;
            if (bean == null) {
                XmlRootCopyImpl<Object> xmlRootCopyImpl = new XmlRootCopyImpl<Object>(this, this.changeControl.getChangeNumber(), null);
                return xmlRootCopyImpl;
            }
            try {
                HashMap<ReferenceKey, BaseHK2JAXBBean> referenceMap = new HashMap<ReferenceKey, BaseHK2JAXBBean>();
                LinkedList<UnresolvedReference> unresolved = new LinkedList<UnresolvedReference>();
                copy = Utilities.doCopy(bean, copyController, null, this, referenceMap, unresolved);
                Utilities.fillInUnfinishedReferences(referenceMap, unresolved);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            XmlRootCopyImpl<BaseHK2JAXBBean> xmlRootCopyImpl = new XmlRootCopyImpl<BaseHK2JAXBBean>(this, this.changeControl.getChangeNumber(), copy);
            return xmlRootCopyImpl;
        }
        finally {
            this.changeControl.getReadLock().unlock();
        }
    }

    long getRevision() {
        return this.changeControl.getChangeNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoot(T newRoot) {
        this.changeControl.getWriteLock().lock();
        try {
            if (this.root != null) {
                throw new IllegalStateException("An attempt was made to add a root to a handle that already has a root " + this);
            }
            if (!(newRoot instanceof BaseHK2JAXBBean)) {
                throw new IllegalArgumentException("The added bean must be from XmlService.createBean");
            }
            WriteableBeanDatabase wbd = null;
            if (this.advertisedInHub) {
                wbd = this.hub.getWriteableDatabaseCopy();
            }
            DynamicConfiguration config = null;
            if (this.advertised) {
                config = this.parent.getDynamicConfigurationService().createDynamicConfiguration();
            }
            LinkedList addedServices = new LinkedList();
            BaseHK2JAXBBean copiedRoot = Utilities._addRoot(this.rootNode, newRoot, this.changeControl, this.parent.getClassReflectionHelper(), wbd, config, addedServices, this);
            if (config != null) {
                config.commit();
            }
            if (wbd != null) {
                wbd.commit((Object)new XmlHubCommitMessage(){});
            }
            this.root = copiedRoot;
            ServiceLocator locator = this.parent.getServiceLocator();
            for (ActiveDescriptor activeDescriptor : addedServices) {
                locator.getServiceHandle(activeDescriptor).getService();
            }
        }
        finally {
            this.changeControl.getWriteLock().unlock();
        }
    }

    @Override
    public void addRoot() {
        this.addRoot(this.parent.createBean(this.rootNode.getOriginalInterfaceAsClass()));
    }

    @Override
    public T removeRoot() {
        throw new AssertionError((Object)"removeRoot not implemented");
    }

    @Override
    public T getReadOnlyRoot(boolean representDefaults) {
        throw new AssertionError((Object)"getReadOnlyRoot not implemented");
    }

    DynamicChangeInfo<T> getChangeInfo() {
        return this.changeControl;
    }

    @Override
    public void addChangeListener(VetoableChangeListener ... listeners) {
        this.changeControl.addChangeListener(listeners);
    }

    @Override
    public void removeChangeListener(VetoableChangeListener ... listeners) {
        this.changeControl.removeChangeListener(listeners);
    }

    @Override
    public List<VetoableChangeListener> getChangeListeners() {
        return this.changeControl.getChangeListeners();
    }

    @Override
    public XmlHandleTransaction<T> lockForTransaction() throws IllegalStateException {
        if (this.changeControl == null) {
            throw new IllegalStateException();
        }
        return new XmlHandleTransactionImpl(this, this.changeControl);
    }

    @Override
    public void startValidating() {
        if (this.changeControl == null) {
            throw new IllegalStateException();
        }
        Validator validator = this.changeControl.findOrCreateValidator();
        if (this.root == null) {
            return;
        }
        Set violations = validator.validate(this.root, new Class[0]);
        if (violations == null || violations.isEmpty()) {
            return;
        }
        throw new ConstraintViolationException(violations);
    }

    @Override
    public void stopValidating() {
        if (this.changeControl == null) {
            throw new IllegalStateException();
        }
        this.changeControl.deleteValidator();
    }

    @Override
    public boolean isValidating() {
        if (this.changeControl == null) {
            throw new IllegalStateException();
        }
        return this.changeControl.findValidator() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(OutputStream outputStream) throws IOException {
        if (this.changeControl == null) {
            throw new IllegalStateException("marshall May only be called on a fully initialized root handle " + this);
        }
        this.changeControl.getWriteLock().lock();
        try {
            XmlServiceParser parser = this.parent.getParser();
            if (parser == null) {
                XmlStreamImpl.marshall(outputStream, this);
                return;
            }
            parser.marshal(outputStream, this);
        }
        finally {
            this.changeControl.getWriteLock().unlock();
        }
    }

    public String toString() {
        return "XmlRootHandleImpl(" + this.root + "," + this.rootNode + "," + this.rootURI + "," + System.identityHashCode(this) + ")";
    }
}

