/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.elements;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.elements.beans.BasicElementalBean;
import org.glassfish.hk2.xml.test.elements.beans.EarthBean;
import org.glassfish.hk2.xml.test.elements.beans.ElementType;
import org.glassfish.hk2.xml.test.elements.beans.ElementalBean;
import org.glassfish.hk2.xml.test.elements.beans.FireBean;
import org.glassfish.hk2.xml.test.elements.beans.ScalarRootBean;
import org.glassfish.hk2.xml.test.elements.beans.WaterBean;
import org.glassfish.hk2.xml.test.elements.beans.WindBean;
import org.junit.Assert;

public class ElementsCommon {
    private static final String BENDER_EARTH = "Toph";
    private static final String BENDER_WIND = "Ang";
    private static final String BENDER_WATER = "Kitara";
    private static final String BENDER_FIRE = "Zuko";
    private static final String BENDER_NONE = "CabbageVendor";
    private static final String SPECIAL1 = "Sparky Sparky Boom Boom";
    private static final String FIRE_OZAI = "Ozai";
    private static final String NONE_SOKKA = "Sokka";
    private static final String BENDER_SAND = "Ghashiun";
    private static final String SPECIAL_MOMO = "Momo";
    private static final String SPECIAL_APPA = "Appa";
    private static final String[] ALL_NAMES = new String[]{"Toph", "Ang", "Kitara", "Zuko", "CabbageVendor", "Sparky Sparky Boom Boom", "Ozai", "Sokka", "Ghashiun", "Momo", "Appa"};
    private static final String ONE_OF_EACH = "elemental/oneofeach.xml";
    private static final String BENCHMARK = "elemental/benchmark.xml";
    private static final String SCALAR1 = "elemental/scalar1.xml";
    private static final String EARTH_TYPE = "/basic-elements/earth";
    private static final String WIND_TYPE = "/basic-elements/wind";
    private static final String WATER_TYPE = "/basic-elements/water";
    private static final String FIRE_TYPE = "/basic-elements/fire";
    private static final String NONE_TYPE = "/basic-elements/none";
    private static final String EARTH_INSTANCE = "basic-elements.Toph";
    private static final String WIND_INSTANCE = "basic-elements.Ang";
    private static final String WATER_INSTANCE = "basic-elements.Kitara";
    private static final String FIRE_INSTANCE = "basic-elements.Zuko";
    private static final String NONE_INSTANCE = "basic-elements.CabbageVendor";

    public static void testReadOneOfEachElement(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(ONE_OF_EACH);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, BasicElementalBean.class, true, true);
        BasicElementalBean root = (BasicElementalBean)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<ElementalBean> elementals = root.getEarthWindAndFire();
        Assert.assertEquals((String)("elements found =" + elementals), (long)5L, (long)elementals.size());
        EarthBean earth = (EarthBean)elementals.get(0);
        WindBean wind = (WindBean)elementals.get(3);
        WaterBean water = (WaterBean)elementals.get(2);
        FireBean fire = (FireBean)elementals.get(1);
        ElementalBean none = elementals.get(4);
        Assert.assertEquals((Object)BENDER_EARTH, (Object)earth.getName());
        Assert.assertEquals((Object)BENDER_WIND, (Object)wind.getName());
        Assert.assertEquals((Object)BENDER_WATER, (Object)water.getName());
        Assert.assertEquals((Object)BENDER_FIRE, (Object)fire.getName());
        Assert.assertEquals((Object)BENDER_NONE, (Object)none.getName());
        Assert.assertEquals((Object)((Object)ElementType.EARTH), (Object)((Object)earth.getType()));
        Assert.assertEquals((Object)((Object)ElementType.WIND), (Object)((Object)wind.getType()));
        Assert.assertEquals((Object)((Object)ElementType.WATER), (Object)((Object)water.getType()));
        Assert.assertEquals((Object)((Object)ElementType.FIRE), (Object)((Object)fire.getType()));
        Assert.assertEquals((Object)((Object)ElementType.NONE), (Object)((Object)none.getType()));
        Assert.assertEquals((Object)EARTH_TYPE, (Object)((XmlHk2ConfigurationBean)earth)._getXmlPath());
        Assert.assertEquals((Object)WIND_TYPE, (Object)((XmlHk2ConfigurationBean)wind)._getXmlPath());
        Assert.assertEquals((Object)WATER_TYPE, (Object)((XmlHk2ConfigurationBean)water)._getXmlPath());
        Assert.assertEquals((Object)FIRE_TYPE, (Object)((XmlHk2ConfigurationBean)fire)._getXmlPath());
        Assert.assertEquals((Object)NONE_TYPE, (Object)((XmlHk2ConfigurationBean)none)._getXmlPath());
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        ElementsCommon.checkService(locator, hub, EARTH_TYPE, EARTH_INSTANCE, BENDER_EARTH);
        ElementsCommon.checkService(locator, hub, WIND_TYPE, WIND_INSTANCE, BENDER_WIND);
        ElementsCommon.checkService(locator, hub, WATER_TYPE, WATER_INSTANCE, BENDER_WATER);
        ElementsCommon.checkService(locator, hub, FIRE_TYPE, FIRE_INSTANCE, BENDER_FIRE);
        ElementsCommon.checkService(locator, hub, NONE_TYPE, NONE_INSTANCE, BENDER_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testMarshal(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(BENCHMARK);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, BasicElementalBean.class, true, true);
        BasicElementalBean root = (BasicElementalBean)handle.getRoot();
        Assert.assertNotNull((Object)root);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            handle.marshal((OutputStream)baos);
        }
        finally {
            baos.close();
        }
        String asString = baos.toString();
        for (String name : ALL_NAMES) {
            Assert.assertTrue((boolean)asString.contains(name));
        }
        Assert.assertFalse((boolean)asString.contains("earthWindAndFire"));
    }

    public static void testScalarElements(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(SCALAR1);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, ScalarRootBean.class, true, true);
        ScalarRootBean root = (ScalarRootBean)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<Integer> numbers = root.getNumbers();
        Assert.assertEquals((long)3L, (long)numbers.size());
        Integer foo = numbers.get(0);
        Assert.assertTrue((boolean)(foo instanceof Integer));
        Assert.assertEquals((long)12L, (long)numbers.get(0).intValue());
        Assert.assertEquals((long)13L, (long)numbers.get(1).intValue());
        Assert.assertEquals((long)14L, (long)numbers.get(2).intValue());
        int[] arrayNumbers = root.getArrayNumbers();
        Assert.assertEquals((long)1L, (long)arrayNumbers.length);
        Assert.assertEquals((long)16L, (long)arrayNumbers[0]);
        List<Long> times = root.getTimes();
        Assert.assertEquals((long)2L, (long)times.size());
        Assert.assertEquals((long)10000000L, (long)times.get(0));
        Assert.assertEquals((long)20000000L, (long)times.get(1));
        Long[] arrayTimes = root.getArrayTimes();
        Assert.assertEquals((long)3L, (long)arrayTimes.length);
        Assert.assertEquals((long)30000000L, (long)arrayTimes[0]);
        Assert.assertEquals((long)40000000L, (long)arrayTimes[1]);
        Assert.assertEquals((long)50000000L, (long)arrayTimes[2]);
        Assert.assertEquals((long)15L, (long)root.getOneNumber());
        List<String> strings = root.getStrings();
        Assert.assertEquals((long)3L, (long)strings.size());
        Assert.assertEquals((Object)"foo", (Object)strings.get(0));
        Assert.assertEquals((Object)"bar", (Object)strings.get(1));
        Assert.assertEquals((Object)"baz", (Object)strings.get(2));
    }

    private static void checkService(ServiceLocator locator, Hub hub, String type, String instance, String name) {
        ElementsCommon.checkInLocator(locator, name);
        ElementsCommon.checkNamedInHub(hub, type, instance, name);
    }

    private static void checkInLocator(ServiceLocator locator, String name) {
        ElementalBean eb = (ElementalBean)locator.getService(ElementalBean.class, name, new Annotation[0]);
        Assert.assertNotNull((Object)eb);
        Assert.assertEquals((Object)name, (Object)eb.getName());
    }

    private static void checkNamedInHub(Hub hub, String type, String instance, String name) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Type hubType = bd.getType(type);
        Assert.assertNotNull((Object)hubType);
        Instance i = null;
        if (instance.contains(".*")) {
            Map instances = hubType.getInstances();
            Assert.assertEquals((long)1L, (long)instances.size());
            Iterator i$ = instances.values().iterator();
            while (i$.hasNext()) {
                Instance found;
                i = found = (Instance)i$.next();
            }
        } else {
            i = hubType.getInstance(instance);
        }
        Assert.assertNotNull((String)("Could not find instance " + instance + " in type " + type), (Object)i);
        Object bean = i.getBean();
        Assert.assertNotNull((Object)bean);
        String beanName = (String)((Map)bean).get("name");
        Assert.assertEquals((Object)name, (Object)beanName);
    }
}

