/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.xml.api.annotations.Hk2XmlPreGenerate;
import org.glassfish.hk2.xml.api.annotations.PluralOf;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.MethodType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.NameInformation;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.XmlElementData;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltEnum;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.MethodInformationI;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.jaxb.internal.XmlElementImpl;
import org.glassfish.hk2.xml.jaxb.internal.XmlRootElementImpl;
import org.jvnet.hk2.annotations.Contract;

public class Generator {
    private static final boolean DEBUG_METHODS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty("org.jvnet.hk2.xmlservice.compiler.methods", "false"));
        }
    });
    private static final String JAXB_DEFAULT_STRING = "##default";
    public static final String JAXB_DEFAULT_DEFAULT = "\u0000";
    public static final String NO_CHILD_PACKAGE = "java.";
    public static final String STATIC_GET_MODEL_METHOD_NAME = "__getModel";
    private static final String QUOTE = "\"";
    private static final Set<String> NO_COPY_ANNOTATIONS = new HashSet<String>(Arrays.asList(Contract.class.getName(), XmlTransient.class.getName(), Hk2XmlPreGenerate.class.getName(), "org.jvnet.hk2.config.Configured"));
    private static final Set<String> NO_COPY_ANNOTATIONS_METHOD = new HashSet<String>(Arrays.asList("javax.validation.Valid"));

    public static CtClass generate(AltClass convertMe, CtClass superClazz, ClassPool defaultClassPool) throws Throwable {
        CtClass originalCtClass;
        String modelOriginalInterface = convertMe.getName();
        String modelTranslatedClass = Utilities.getProxyNameFromInterfaceName(modelOriginalInterface);
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Converting " + convertMe.getName() + " to " + modelTranslatedClass);
        }
        CtClass targetCtClass = defaultClassPool.makeClass(modelTranslatedClass);
        ClassFile targetClassFile = targetCtClass.getClassFile();
        targetClassFile.setVersionToJava5();
        ConstPool targetConstPool = targetClassFile.getConstPool();
        ModelImpl compiledModel = new ModelImpl(modelOriginalInterface, modelTranslatedClass);
        AnnotationsAttribute ctAnnotations = null;
        String[] propOrder = null;
        for (AltAnnotation convertMeAnnotation : convertMe.getAnnotations()) {
            if (NO_COPY_ANNOTATIONS.contains(convertMeAnnotation.annotationType())) continue;
            if (ctAnnotations == null) {
                ctAnnotations = new AnnotationsAttribute(targetConstPool, "RuntimeVisibleAnnotations");
            }
            if (XmlRootElement.class.getName().equals(convertMeAnnotation.annotationType())) {
                String modelRootName = Generator.convertXmlRootElementName(convertMeAnnotation, convertMe);
                compiledModel.setRootName(modelRootName);
                XmlRootElementImpl replacement = new XmlRootElementImpl(convertMeAnnotation.getStringValue("namespace"), modelRootName);
                Generator.createAnnotationCopy(targetConstPool, (java.lang.annotation.Annotation)((Object)replacement), ctAnnotations);
            } else {
                Generator.createAnnotationCopy(targetConstPool, convertMeAnnotation, ctAnnotations);
            }
            if (!XmlType.class.getName().equals(convertMeAnnotation.annotationType())) continue;
            propOrder = convertMeAnnotation.getStringArrayValue("propOrder");
        }
        if (ctAnnotations != null) {
            targetClassFile.addAttribute(ctAnnotations);
        }
        if ((originalCtClass = defaultClassPool.getOrNull(convertMe.getName())) == null) {
            originalCtClass = defaultClassPool.makeInterface(convertMe.getName());
        }
        targetCtClass.setSuperclass(superClazz);
        targetCtClass.addInterface(originalCtClass);
        NameInformation xmlNameMap = Generator.getXmlNameMap(convertMe);
        LinkedHashSet<String> alreadyAddedNaked = new LinkedHashSet<String>();
        List<AltMethod> allMethods = convertMe.getMethods();
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Analyzing " + allMethods.size() + " methods of " + convertMe.getName());
        }
        allMethods = Utilities.prioritizeMethods(allMethods, propOrder, xmlNameMap);
        LinkedHashSet<String> setters = new LinkedHashSet<String>();
        LinkedHashMap<String, MethodInformationI> getters = new LinkedHashMap<String, MethodInformationI>();
        LinkedHashMap<String, GhostXmlElementData> elementsMethods = new LinkedHashMap<String, GhostXmlElementData>();
        for (AltMethod altMethod : allMethods) {
            CtMethod addMeCtMethod;
            List<AltClass> paramTypes;
            boolean isVoid;
            MethodInformationI mi = Utilities.getMethodInformation(altMethod, xmlNameMap);
            if (mi.isKey()) {
                compiledModel.setKeyProperty(mi.getRepresentedProperty());
            }
            if (!MethodType.CUSTOM.equals((Object)mi.getMethodType())) {
                Generator.createInterfaceForAltClassIfNeeded(mi.getGetterSetterType(), defaultClassPool);
            } else {
                AltMethod original = mi.getOriginalMethod();
                AltClass originalReturn = original.getReturnType();
                if (!ClassAltClassImpl.VOID.equals(originalReturn)) {
                    Generator.createInterfaceForAltClassIfNeeded(originalReturn, defaultClassPool);
                }
                for (AltClass parameter : original.getParameterTypes()) {
                    Generator.createInterfaceForAltClassIfNeeded(parameter, defaultClassPool);
                }
            }
            if (DEBUG_METHODS) {
                Logger.getLogger().debug("Analyzing method " + mi + " of " + convertMe.getSimpleName());
            }
            String name = altMethod.getName();
            StringBuffer sb = new StringBuffer("public ");
            AltClass originalRetType = altMethod.getReturnType();
            if (originalRetType == null || Void.TYPE.getName().equals(originalRetType.getName())) {
                sb.append("void ");
                isVoid = true;
            } else {
                sb.append(Generator.getCompilableClass(originalRetType) + " ");
                isVoid = false;
            }
            sb.append(name + "(");
            AltClass childType = null;
            boolean getterOrSetter = false;
            boolean isReference = false;
            boolean isSetter = false;
            if (MethodType.SETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                isSetter = true;
                setters.add(mi.getRepresentedProperty());
                childType = mi.getBaseChildType();
                isReference = mi.isReference();
                sb.append(Generator.getCompilableClass(mi.getGetterSetterType()) + " arg0) { super._setProperty(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            } else if (MethodType.GETTER.equals((Object)mi.getMethodType())) {
                getterOrSetter = true;
                getters.put(mi.getRepresentedProperty(), mi);
                childType = mi.getBaseChildType();
                isReference = mi.isReference();
                String cast = "";
                String superMethodName = "_getProperty";
                if (Integer.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "I";
                } else if (Long.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "J";
                } else if (Boolean.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "Z";
                } else if (Byte.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "B";
                } else if (Character.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "C";
                } else if (Short.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "S";
                } else if (Float.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "F";
                } else if (Double.TYPE.getName().equals(mi.getGetterSetterType().getName())) {
                    superMethodName = superMethodName + "D";
                } else {
                    cast = "(" + Generator.getCompilableClass(mi.getGetterSetterType()) + ") ";
                }
                sb.append(") { return " + cast + "super." + superMethodName + "(\"" + mi.getRepresentedProperty() + "\"); }");
            } else if (MethodType.LOOKUP.equals((Object)mi.getMethodType())) {
                sb.append("java.lang.String arg0) { return (" + Generator.getCompilableClass(originalRetType) + ") super._lookupChild(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            } else if (MethodType.ADD.equals((Object)mi.getMethodType())) {
                List<AltClass> paramTypes2;
                String returnClause = "";
                if (!isVoid) {
                    Generator.createInterfaceForAltClassIfNeeded(originalRetType, defaultClassPool);
                    returnClause = "return (" + Generator.getCompilableClass(originalRetType) + ") ";
                }
                if ((paramTypes2 = altMethod.getParameterTypes()).size() == 0) {
                    sb.append(") { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\", null, null, -1); }");
                } else if (paramTypes2.size() == 1) {
                    Generator.createInterfaceForAltClassIfNeeded(paramTypes2.get(0), defaultClassPool);
                    sb.append(paramTypes2.get(0).getName() + " arg0) { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\",");
                    if (paramTypes2.get(0).isInterface()) {
                        sb.append("arg0, null, -1); }");
                    } else if (String.class.getName().equals(paramTypes2.get(0).getName())) {
                        sb.append("null, arg0, -1); }");
                    } else {
                        sb.append("null, null, arg0); }");
                    }
                } else {
                    sb.append(paramTypes2.get(0).getName() + " arg0, int arg1) { " + returnClause + "super._doAdd(\"" + mi.getRepresentedProperty() + "\",");
                    if (paramTypes2.get(0).isInterface()) {
                        Generator.createInterfaceForAltClassIfNeeded(paramTypes2.get(0), defaultClassPool);
                        sb.append("arg0, null, arg1); }");
                    } else {
                        sb.append("null, arg0, arg1); }");
                    }
                }
            } else if (MethodType.REMOVE.equals((Object)mi.getMethodType())) {
                paramTypes = altMethod.getParameterTypes();
                String cast = "";
                String function = "super._doRemoveZ(\"";
                String doReturn = "return";
                if (!Boolean.TYPE.getName().equals(originalRetType.getName())) {
                    if (Void.TYPE.getName().equals(originalRetType.getName())) {
                        doReturn = "";
                    } else {
                        cast = "(" + Generator.getCompilableClass(originalRetType) + ") ";
                    }
                    function = "super._doRemove(\"";
                }
                if (paramTypes.size() == 0) {
                    sb.append(") { " + doReturn + " " + cast + function + mi.getRepresentedProperty() + "\", null, -1, null); }");
                } else if (String.class.getName().equals(paramTypes.get(0).getName())) {
                    sb.append("java.lang.String arg0) { " + doReturn + " " + cast + function + mi.getRepresentedProperty() + "\", arg0, -1, null); }");
                } else if (Integer.TYPE.getName().equals(paramTypes.get(0).getName())) {
                    sb.append("int arg0) { " + doReturn + " " + cast + function + mi.getRepresentedProperty() + "\", null, arg0, null); }");
                } else {
                    sb.append(paramTypes.get(0).getName() + " arg0) { " + doReturn + " " + cast + function + mi.getRepresentedProperty() + "\", null, -1, arg0); }");
                }
            } else if (MethodType.CUSTOM.equals((Object)mi.getMethodType())) {
                paramTypes = altMethod.getParameterTypes();
                StringBuffer classSets = new StringBuffer();
                StringBuffer valSets = new StringBuffer();
                int lcv = 0;
                for (AltClass paramType : paramTypes) {
                    Generator.createInterfaceForAltClassIfNeeded(paramType, defaultClassPool);
                    if (lcv == 0) {
                        sb.append(Generator.getCompilableClass(paramType) + " arg" + lcv);
                    } else {
                        sb.append(", " + Generator.getCompilableClass(paramType) + " arg" + lcv);
                    }
                    classSets.append("mParams[" + lcv + "] = " + Generator.getCompilableClass(paramType) + ".class;\n");
                    valSets.append("mVars[" + lcv + "] = ");
                    if (Integer.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Integer(arg" + lcv + ");\n");
                    } else if (Long.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Long(arg" + lcv + ");\n");
                    } else if (Boolean.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Boolean(arg" + lcv + ");\n");
                    } else if (Byte.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Byte(arg" + lcv + ");\n");
                    } else if (Character.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Character(arg" + lcv + ");\n");
                    } else if (Short.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Short(arg" + lcv + ");\n");
                    } else if (Float.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Float(arg" + lcv + ");\n");
                    } else if (Double.TYPE.getName().equals(paramType.getName())) {
                        valSets.append("new java.lang.Double(arg" + lcv + ");\n");
                    } else {
                        valSets.append("arg" + lcv + ";\n");
                    }
                    ++lcv;
                }
                sb.append(") { Class[] mParams = new Class[" + paramTypes.size() + "];\n");
                sb.append("Object[] mVars = new Object[" + paramTypes.size() + "];\n");
                sb.append(classSets.toString());
                sb.append(valSets.toString());
                String cast = "";
                String superMethodName = "_invokeCustomizedMethod";
                if (Integer.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "I";
                } else if (Long.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "J";
                } else if (Boolean.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "Z";
                } else if (Byte.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "B";
                } else if (Character.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "C";
                } else if (Short.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "S";
                } else if (Float.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "F";
                } else if (Double.TYPE.getName().equals(originalRetType.getName())) {
                    superMethodName = superMethodName + "D";
                } else if (!isVoid) {
                    cast = "(" + Generator.getCompilableClass(originalRetType) + ") ";
                }
                if (!isVoid) {
                    sb.append("return " + cast);
                }
                sb.append("super." + superMethodName + "(\"" + name + "\", mParams, mVars);}");
            }
            if (DEBUG_METHODS) {
                Logger.getLogger().debug("Adding method for " + convertMe.getSimpleName() + " with implementation " + sb);
            }
            try {
                addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            }
            catch (CannotCompileException cce) {
                MultiException me = new MultiException((Throwable)cce);
                me.addError((Throwable)((Object)new AssertionError((Object)("Cannot compile method with source " + sb.toString()))));
                throw me;
            }
            if (altMethod.isVarArgs()) {
                addMeCtMethod.setModifiers(addMeCtMethod.getModifiers() | 0x80);
            }
            if (mi.getListParameterizedType() != null) {
                Generator.addListGenericSignature(addMeCtMethod, mi.getListParameterizedType(), isSetter);
            }
            MethodInfo methodInfo = addMeCtMethod.getMethodInfo();
            ConstPool methodConstPool = methodInfo.getConstPool();
            ctAnnotations = null;
            for (AltAnnotation convertMeAnnotation : altMethod.getAnnotations()) {
                if (NO_COPY_ANNOTATIONS_METHOD.contains(convertMeAnnotation.annotationType())) continue;
                if (ctAnnotations == null) {
                    ctAnnotations = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                }
                if (childType != null && XmlElement.class.getName().equals(convertMeAnnotation.annotationType())) {
                    String translatedClassName = Utilities.getProxyNameFromInterfaceName(childType.getName());
                    XmlElementImpl anno = new XmlElementImpl(convertMeAnnotation.getStringValue("name"), convertMeAnnotation.getBooleanValue("nillable"), convertMeAnnotation.getBooleanValue("required"), convertMeAnnotation.getStringValue("namespace"), convertMeAnnotation.getStringValue("defaultValue"), translatedClassName);
                    Generator.createAnnotationCopy(methodConstPool, (java.lang.annotation.Annotation)((Object)anno), ctAnnotations);
                    continue;
                }
                if (getterOrSetter && childType != null && XmlElements.class.getName().equals(convertMeAnnotation.annotationType())) {
                    String representedProperty = mi.getRepresentedProperty();
                    AltAnnotation[] elements = convertMeAnnotation.getAnnotationArrayValue("value");
                    if (elements == null) {
                        elements = new AltAnnotation[]{};
                    }
                    elementsMethods.put(representedProperty, new GhostXmlElementData(elements, mi.getGetterSetterType()));
                    continue;
                }
                Generator.createAnnotationCopy(methodConstPool, convertMeAnnotation, ctAnnotations);
            }
            if (getterOrSetter) {
                String listPType;
                if (childType != null) {
                    if (!isReference) {
                        List<XmlElementData> aliases = xmlNameMap.getAliases(mi.getRepresentedProperty());
                        AliasType aType = aliases == null ? AliasType.NORMAL : AliasType.HAS_ALIASES;
                        compiledModel.addChild(childType.getName(), mi.getRepresentedProperty(), mi.getRepresentedProperty(), Generator.getChildType(mi.isList(), mi.isArray()), mi.getDefaultValue(), aType);
                        if (aliases != null) {
                            for (XmlElementData alias : aliases) {
                                String aliasType = alias.getType();
                                if (aliasType == null) {
                                    aliasType = childType.getName();
                                }
                                compiledModel.addChild(aliasType, alias.getName(), alias.getAlias(), Generator.getChildType(mi.isList(), mi.isArray()), alias.getDefaultValue(), AliasType.IS_ALIAS);
                            }
                        }
                    } else {
                        listPType = mi.getListParameterizedType() == null ? null : mi.getListParameterizedType().getName();
                        compiledModel.addNonChild(mi.getRepresentedProperty(), mi.getDefaultValue(), mi.getGetterSetterType().getName(), listPType, true, mi.isElement());
                    }
                } else {
                    listPType = mi.getListParameterizedType() == null ? null : mi.getListParameterizedType().getName();
                    compiledModel.addNonChild(mi.getRepresentedProperty(), mi.getDefaultValue(), mi.getGetterSetterType().getName(), listPType, false, mi.isElement());
                }
            }
            if (getterOrSetter && childType != null && xmlNameMap.hasNoXmlElement(mi.getRepresentedProperty()) && !alreadyAddedNaked.contains(mi.getRepresentedProperty())) {
                alreadyAddedNaked.add(mi.getRepresentedProperty());
                if (ctAnnotations == null) {
                    ctAnnotations = new AnnotationsAttribute(methodConstPool, "RuntimeVisibleAnnotations");
                }
                String translatedClassName = Utilities.getProxyNameFromInterfaceName(childType.getName());
                XmlElementImpl convertMeAnnotation = new XmlElementImpl(JAXB_DEFAULT_STRING, false, false, JAXB_DEFAULT_STRING, JAXB_DEFAULT_DEFAULT, translatedClassName);
                if (DEBUG_METHODS) {
                    Logger.getLogger().debug("Adding ghost XmlElement for " + convertMe.getSimpleName() + " with data " + (Object)((Object)convertMeAnnotation));
                }
                Generator.createAnnotationCopy(methodConstPool, (java.lang.annotation.Annotation)((Object)convertMeAnnotation), ctAnnotations);
            }
            if (ctAnnotations != null) {
                methodInfo.addAttribute((AttributeInfo)ctAnnotations);
            }
            targetCtClass.addMethod(addMeCtMethod);
        }
        for (Map.Entry entry : getters.entrySet()) {
            String getterProperty = (String)entry.getKey();
            MethodInformationI mi = (MethodInformationI)entry.getValue();
            if (setters.contains(getterProperty)) continue;
            String getterName = mi.getOriginalMethod().getName();
            String setterName = Utilities.convertToSetter(getterName);
            StringBuffer sb = new StringBuffer("private void " + setterName + "(");
            sb.append(Generator.getCompilableClass(mi.getGetterSetterType()) + " arg0) { super._setProperty(\"" + mi.getRepresentedProperty() + "\", arg0); }");
            CtMethod addMeCtMethod = CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass);
            targetCtClass.addMethod(addMeCtMethod);
            if (mi.getListParameterizedType() != null) {
                Generator.addListGenericSignature(addMeCtMethod, mi.getListParameterizedType(), true);
            }
            if (!DEBUG_METHODS) continue;
            Logger.getLogger().debug("Adding ghost setter method for " + convertMe.getSimpleName() + " with implementation " + sb);
        }
        for (Map.Entry entry : elementsMethods.entrySet()) {
            String basePropName = (String)entry.getKey();
            GhostXmlElementData gxed = (GhostXmlElementData)entry.getValue();
            AltAnnotation[] xmlElements = gxed.xmlElements;
            String baseSetSetterName = "set_" + basePropName;
            String baseGetterName = "get_" + basePropName;
            for (AltAnnotation xmlElement : xmlElements) {
                String elementName = xmlElement.getStringValue("name");
                String ghostMethodName = baseSetSetterName + "_" + elementName;
                String ghostMethodGetName = baseGetterName + "_" + elementName;
                AltClass ac = (AltClass)xmlElement.getAnnotationValues().get("type");
                StringBuffer ghostBufferSetter = new StringBuffer("private void " + ghostMethodName + "(");
                ghostBufferSetter.append(Generator.getCompilableClass(gxed.getterSetterType) + " arg0) { super._setProperty(\"" + elementName + "\", arg0); }");
                CtMethod elementsCtMethod = CtNewMethod.make((String)ghostBufferSetter.toString(), (CtClass)targetCtClass);
                if (DEBUG_METHODS) {
                    Logger.getLogger().debug("Adding ghost elements method for " + convertMe.getSimpleName() + " with implementation " + ghostBufferSetter);
                }
                Generator.addListGenericSignature(elementsCtMethod, ac, true);
                targetCtClass.addMethod(elementsCtMethod);
                StringBuffer ghostBufferGetter = new StringBuffer("private " + Generator.getCompilableClass(gxed.getterSetterType) + " " + ghostMethodGetName + "() { return (" + Generator.getCompilableClass(gxed.getterSetterType) + ") super._getProperty(\"" + elementName + "\"); }");
                CtMethod elementsCtMethodGetter = CtNewMethod.make((String)ghostBufferGetter.toString(), (CtClass)targetCtClass);
                Generator.addListGenericSignature(elementsCtMethodGetter, ac, false);
                MethodInfo elementsMethodInfo = elementsCtMethodGetter.getMethodInfo();
                ConstPool elementsMethodConstPool = elementsMethodInfo.getConstPool();
                AnnotationsAttribute aa = new AnnotationsAttribute(elementsMethodConstPool, "RuntimeVisibleAnnotations");
                String translatedClassName = Utilities.getProxyNameFromInterfaceName(ac.getName());
                XmlElementImpl xElement = new XmlElementImpl(elementName, xmlElement.getBooleanValue("nillable"), xmlElement.getBooleanValue("required"), xmlElement.getStringValue("namespace"), xmlElement.getStringValue("defaultValue"), translatedClassName);
                Generator.createAnnotationCopy(elementsMethodConstPool, (java.lang.annotation.Annotation)((Object)xElement), aa);
                elementsMethodInfo.addAttribute((AttributeInfo)aa);
                if (DEBUG_METHODS) {
                    Logger.getLogger().debug("Adding ghost elements getter method for " + convertMe.getSimpleName() + " with implementation " + ghostBufferGetter);
                }
                targetCtClass.addMethod(elementsCtMethodGetter);
            }
        }
        Generator.generateStaticModelFieldAndAbstractMethodImpl(targetCtClass, compiledModel, defaultClassPool);
        return targetCtClass;
    }

    static ChildType getChildType(boolean isList, boolean isArray) {
        if (isList) {
            return ChildType.LIST;
        }
        if (isArray) {
            return ChildType.ARRAY;
        }
        return ChildType.DIRECT;
    }

    private static void generateStaticModelFieldAndAbstractMethodImpl(CtClass targetCtClass, ModelImpl model, ClassPool defaultClassPool) throws CannotCompileException, NotFoundException {
        StringBuffer sb = new StringBuffer();
        sb.append("private static final org.glassfish.hk2.xml.internal.ModelImpl INIT_MODEL() {\n");
        sb.append("org.glassfish.hk2.xml.internal.ModelImpl retVal = new org.glassfish.hk2.xml.internal.ModelImpl(\"");
        sb.append(model.getOriginalInterface() + "\",\"" + model.getTranslatedClass() + "\");\n");
        if (model.getRootName() != null) {
            sb.append("retVal.setRootName(\"" + model.getRootName() + "\");\n");
        }
        if (model.getKeyProperty() != null) {
            sb.append("retVal.setKeyProperty(\"" + model.getKeyProperty() + "\");\n");
        }
        Map<String, ChildDescriptor> allChildren = model.getAllChildrenDescriptors();
        for (Map.Entry<String, ChildDescriptor> entry : allChildren.entrySet()) {
            String xmlTag = entry.getKey();
            ChildDescriptor descriptor = entry.getValue();
            ParentedModel parentedModel = descriptor.getParentedModel();
            if (parentedModel != null) {
                sb.append("retVal.addChild(" + Generator.asParameter(parentedModel.getChildInterface()) + "," + Generator.asParameter(parentedModel.getChildXmlTag()) + "," + Generator.asParameter(parentedModel.getChildXmlAlias()) + "," + Generator.asParameter(parentedModel.getChildType()) + "," + Generator.asParameter(parentedModel.getGivenDefault()) + "," + Generator.asParameter(parentedModel.getAliasType()) + ");\n");
                continue;
            }
            ChildDataModel childDataModel = descriptor.getChildDataModel();
            sb.append("retVal.addNonChild(" + Generator.asParameter(xmlTag) + "," + Generator.asParameter(childDataModel.getDefaultAsString()) + "," + Generator.asParameter(childDataModel.getChildType()) + "," + Generator.asParameter(childDataModel.getChildListType()) + "," + Generator.asBoolean(childDataModel.isReference()) + "," + Generator.asBoolean(childDataModel.isElement()) + ");\n");
        }
        sb.append("return retVal; }");
        if (DEBUG_METHODS) {
            Logger.getLogger().debug("Adding static model generator for " + targetCtClass.getSimpleName() + " with implementation " + sb);
        }
        targetCtClass.addMethod(CtNewMethod.make((String)sb.toString(), (CtClass)targetCtClass));
        CtClass modelCt = defaultClassPool.get(ModelImpl.class.getName());
        CtField sField = new CtField(modelCt, "MODEL", targetCtClass);
        sField.setModifiers(26);
        targetCtClass.addField(sField, CtField.Initializer.byCall((CtClass)targetCtClass, (String)"INIT_MODEL"));
        CtMethod aMethod = CtNewMethod.make((String)"public org.glassfish.hk2.xml.internal.ModelImpl _getModel() { return MODEL; }", (CtClass)targetCtClass);
        targetCtClass.addMethod(aMethod);
        CtMethod sMethod = CtNewMethod.make((String)"public static final org.glassfish.hk2.xml.internal.ModelImpl __getModel() { return MODEL; }", (CtClass)targetCtClass);
        targetCtClass.addMethod(sMethod);
    }

    private static String asParameter(String me) {
        if (me == null) {
            return "null";
        }
        if (JAXB_DEFAULT_DEFAULT.equals(me)) {
            return "null";
        }
        return QUOTE + me + QUOTE;
    }

    private static String asBoolean(boolean bool) {
        return bool ? "true" : "false";
    }

    private static String asParameter(ChildType ct) {
        switch (ct) {
            case DIRECT: {
                return ChildType.class.getName() + ".DIRECT";
            }
            case LIST: {
                return ChildType.class.getName() + ".LIST";
            }
            case ARRAY: {
                return ChildType.class.getName() + ".ARRAY";
            }
        }
        throw new AssertionError((Object)("unknown ChildType " + (Object)((Object)ct)));
    }

    private static String asParameter(AliasType ct) {
        switch (ct) {
            case NORMAL: {
                return AliasType.class.getName() + ".NORMAL";
            }
            case HAS_ALIASES: {
                return AliasType.class.getName() + ".HAS_ALIASES";
            }
            case IS_ALIAS: {
                return AliasType.class.getName() + ".IS_ALIAS";
            }
        }
        throw new AssertionError((Object)("unknown ChildType " + (Object)((Object)ct)));
    }

    private static void createAnnotationCopy(ConstPool parent, java.lang.annotation.Annotation javaAnnotation, AnnotationsAttribute retVal) throws Throwable {
        Generator.createAnnotationCopy(parent, new AnnotationAltAnnotationImpl(javaAnnotation, null), retVal);
    }

    private static void createAnnotationCopy(ConstPool parent, AltAnnotation javaAnnotation, AnnotationsAttribute retVal) throws Throwable {
        Annotation addMe = Generator.createAnnotationCopyOnly(parent, javaAnnotation);
        retVal.addAnnotation(addMe);
    }

    private static Annotation createAnnotationCopyOnly(ConstPool parent, AltAnnotation javaAnnotation) throws Throwable {
        Annotation annotation = new Annotation(javaAnnotation.annotationType(), parent);
        Map<String, Object> annotationValues = javaAnnotation.getAnnotationValues();
        for (Map.Entry<String, Object> entry : annotationValues.entrySet()) {
            String valueName = entry.getKey();
            Object value = entry.getValue();
            Class<?> javaAnnotationType = value.getClass();
            if (String.class.equals(javaAnnotationType)) {
                annotation.addMemberValue(valueName, (MemberValue)new StringMemberValue((String)value, parent));
                continue;
            }
            if (Boolean.class.equals(javaAnnotationType)) {
                boolean bvalue = (Boolean)value;
                annotation.addMemberValue(valueName, (MemberValue)new BooleanMemberValue(bvalue, parent));
                continue;
            }
            if (AltClass.class.isAssignableFrom(javaAnnotationType)) {
                AltClass altJavaAnnotationType = (AltClass)value;
                String sValue = javaAnnotation.annotationType().equals(XmlElement.class.getName()) && javaAnnotation.getStringValue("getTypeByName") != null ? javaAnnotation.getStringValue("getTypeByName") : altJavaAnnotationType.getName();
                annotation.addMemberValue(valueName, (MemberValue)new ClassMemberValue(sValue, parent));
                continue;
            }
            if (Integer.class.equals(javaAnnotationType)) {
                int ivalue = (Integer)value;
                annotation.addMemberValue(valueName, (MemberValue)new IntegerMemberValue(parent, ivalue));
                continue;
            }
            if (Long.class.equals(javaAnnotationType)) {
                long lvalue = (Long)value;
                annotation.addMemberValue(valueName, (MemberValue)new LongMemberValue(lvalue, parent));
                continue;
            }
            if (Double.class.equals(javaAnnotationType)) {
                double dvalue = (Double)value;
                annotation.addMemberValue(valueName, (MemberValue)new DoubleMemberValue(dvalue, parent));
                continue;
            }
            if (Byte.class.equals(javaAnnotationType)) {
                byte bvalue = (Byte)value;
                annotation.addMemberValue(valueName, (MemberValue)new ByteMemberValue(bvalue, parent));
                continue;
            }
            if (Character.class.equals(javaAnnotationType)) {
                char cvalue = ((Character)value).charValue();
                annotation.addMemberValue(valueName, (MemberValue)new CharMemberValue(cvalue, parent));
                continue;
            }
            if (Short.class.equals(javaAnnotationType)) {
                short svalue = (Short)value;
                annotation.addMemberValue(valueName, (MemberValue)new ShortMemberValue(svalue, parent));
                continue;
            }
            if (Float.class.equals(javaAnnotationType)) {
                float fvalue = ((Float)value).floatValue();
                annotation.addMemberValue(valueName, (MemberValue)new FloatMemberValue(fvalue, parent));
                continue;
            }
            if (AltEnum.class.isAssignableFrom(javaAnnotationType)) {
                AltEnum evalue = (AltEnum)value;
                EnumMemberValue jaEnum = new EnumMemberValue(parent);
                jaEnum.setType(evalue.getDeclaringClass());
                jaEnum.setValue(evalue.getName());
                annotation.addMemberValue(valueName, (MemberValue)jaEnum);
                continue;
            }
            if (javaAnnotationType.isArray()) {
                int lcv;
                MemberValue[] arrayValue;
                Object[] iVals;
                Class<?> typeOfArray = javaAnnotationType.getComponentType();
                if (Integer.TYPE.equals(typeOfArray)) {
                    iVals = (int[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new IntegerMemberValue(parent, iVals[lcv]);
                    }
                } else if (String.class.equals(typeOfArray)) {
                    iVals = (String[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new StringMemberValue((String)iVals[lcv], parent);
                    }
                } else if (Long.TYPE.equals(typeOfArray)) {
                    iVals = (long[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new LongMemberValue((long)iVals[lcv], parent);
                    }
                } else if (Boolean.TYPE.equals(typeOfArray)) {
                    iVals = (boolean[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new BooleanMemberValue(iVals[lcv], parent);
                    }
                } else if (Float.TYPE.equals(typeOfArray)) {
                    iVals = (float[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new FloatMemberValue((float)iVals[lcv], parent);
                    }
                } else if (Double.TYPE.equals(typeOfArray)) {
                    iVals = (double[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new DoubleMemberValue((double)iVals[lcv], parent);
                    }
                } else if (Byte.TYPE.equals(typeOfArray)) {
                    iVals = (byte[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new ByteMemberValue(iVals[lcv], parent);
                    }
                } else if (Character.TYPE.equals(typeOfArray)) {
                    iVals = (char[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new CharMemberValue(iVals[lcv], parent);
                    }
                } else if (Short.TYPE.equals(typeOfArray)) {
                    iVals = (short[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        arrayValue[lcv] = new ShortMemberValue(iVals[lcv], parent);
                    }
                } else if (AltEnum.class.isAssignableFrom(typeOfArray)) {
                    iVals = (AltEnum[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        EnumMemberValue jaEnum = new EnumMemberValue(parent);
                        jaEnum.setType(iVals[lcv].getDeclaringClass());
                        jaEnum.setValue(iVals[lcv].getName());
                        arrayValue[lcv] = jaEnum;
                    }
                } else if (AltClass.class.isAssignableFrom(typeOfArray)) {
                    iVals = (AltClass[])value;
                    arrayValue = new MemberValue[iVals.length];
                    for (lcv = 0; lcv < iVals.length; ++lcv) {
                        int arrayElementClass = iVals[lcv];
                        arrayValue[lcv] = new ClassMemberValue(arrayElementClass.getName(), parent);
                    }
                } else if (AltAnnotation.class.isAssignableFrom(typeOfArray)) {
                    AltAnnotation[] aVals = (AltAnnotation[])value;
                    arrayValue = new MemberValue[aVals.length];
                    for (lcv = 0; lcv < aVals.length; ++lcv) {
                        AltAnnotation arrayAnnotation = aVals[lcv];
                        arrayValue[lcv] = new AnnotationMemberValue(Generator.createAnnotationCopyOnly(parent, arrayAnnotation), parent);
                    }
                } else {
                    throw new AssertionError((Object)("Array type " + typeOfArray.getName() + " is not yet implemented for " + valueName));
                }
                ArrayMemberValue arrayMemberValue = new ArrayMemberValue(parent);
                arrayMemberValue.setValue(arrayValue);
                annotation.addMemberValue(valueName, (MemberValue)arrayMemberValue);
                continue;
            }
            throw new AssertionError((Object)("Annotation type " + javaAnnotationType.getName() + " is not yet implemented for " + valueName));
        }
        return annotation;
    }

    private static String getMethodName(MethodType methodType, String unDecapitalizedVariable, AltAnnotation instructions) {
        String retVal;
        switch (methodType) {
            case ADD: {
                retVal = instructions.getStringValue("add");
                break;
            }
            case REMOVE: {
                retVal = instructions.getStringValue("remove");
                break;
            }
            case LOOKUP: {
                retVal = instructions.getStringValue("lookup");
                break;
            }
            default: {
                throw new AssertionError((Object)"Only ADD, REMOVE and LOOKUP supported");
            }
        }
        if (!"*".equals(retVal)) {
            return retVal;
        }
        String pluralOf = instructions.getStringValue("value");
        if (!"*".equals(pluralOf)) {
            switch (methodType) {
                case ADD: {
                    return "add" + pluralOf;
                }
                case REMOVE: {
                    return "remove" + pluralOf;
                }
                case LOOKUP: {
                    return "lookup" + pluralOf;
                }
            }
            throw new AssertionError((Object)"Only add, remove and lookup supported");
        }
        if (unDecapitalizedVariable.endsWith("s")) {
            unDecapitalizedVariable = unDecapitalizedVariable.substring(0, unDecapitalizedVariable.length() - 1);
        }
        switch (methodType) {
            case ADD: {
                return "add" + unDecapitalizedVariable;
            }
            case REMOVE: {
                return "remove" + unDecapitalizedVariable;
            }
            case LOOKUP: {
                return "lookup" + unDecapitalizedVariable;
            }
        }
        throw new AssertionError((Object)"Only add, remove and lookup supported");
    }

    private static NameInformation getXmlNameMap(AltClass convertMe) {
        LinkedHashMap<String, XmlElementData> xmlNameMap = new LinkedHashMap<String, XmlElementData>();
        LinkedHashSet<String> unmappedNames = new LinkedHashSet<String>();
        LinkedHashMap<String, String> addMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> removeMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> lookupMethodToVariableMap = new LinkedHashMap<String, String>();
        LinkedHashSet<String> referenceSet = new LinkedHashSet<String>();
        LinkedHashMap<String, List<XmlElementData>> aliasMap = new LinkedHashMap<String, List<XmlElementData>>();
        for (AltMethod originalMethod : convertMe.getMethods()) {
            String setterVariable = Utilities.isSetter(originalMethod);
            if (setterVariable == null && (setterVariable = Utilities.isGetter(originalMethod)) == null) continue;
            if (Generator.isSpecifiedReference(originalMethod)) {
                referenceSet.add(setterVariable);
            }
            AltAnnotation pluralOf = null;
            AltAnnotation xmlElement = originalMethod.getAnnotation(XmlElement.class.getName());
            AltAnnotation xmlElements = originalMethod.getAnnotation(XmlElements.class.getName());
            if (xmlElement != null && xmlElements != null) {
                throw new IllegalArgumentException("The method " + originalMethod + " of " + convertMe + " has both @XmlElement and @XmlElements, which is illegal");
            }
            if (xmlElement != null || xmlElements != null) {
                String defaultValue;
                if (xmlElements != null) {
                    pluralOf = originalMethod.getAnnotation(PluralOf.class.getName());
                    defaultValue = JAXB_DEFAULT_DEFAULT;
                    xmlNameMap.put(setterVariable, new XmlElementData(setterVariable, defaultValue, true));
                    String aliasName = setterVariable;
                    AltAnnotation[] allXmlElements = xmlElements.getAnnotationArrayValue("value");
                    ArrayList<XmlElementData> aliases = new ArrayList<XmlElementData>(allXmlElements.length);
                    aliasMap.put(setterVariable, aliases);
                    for (AltAnnotation allXmlElement : allXmlElements) {
                        String allXmlElementTypeName;
                        defaultValue = allXmlElement.getStringValue("defaultValue");
                        String allXmlElementName = allXmlElement.getStringValue("name");
                        AltClass allXmlElementType = (AltClass)allXmlElement.getAnnotationValues().get("type");
                        String string = allXmlElementTypeName = allXmlElementType == null ? null : allXmlElementType.getName();
                        if (JAXB_DEFAULT_STRING.equals(allXmlElementName)) {
                            throw new IllegalArgumentException("The name field of an XmlElement inside an XmlElements must have a specified name");
                        }
                        aliases.add(new XmlElementData(allXmlElementName, aliasName, defaultValue, true, allXmlElementTypeName));
                    }
                } else {
                    pluralOf = originalMethod.getAnnotation(PluralOf.class.getName());
                    defaultValue = xmlElement.getStringValue("defaultValue");
                    if (JAXB_DEFAULT_STRING.equals(xmlElement.getStringValue("name"))) {
                        xmlNameMap.put(setterVariable, new XmlElementData(setterVariable, defaultValue, true));
                    } else {
                        xmlNameMap.put(setterVariable, new XmlElementData(xmlElement.getStringValue("name"), defaultValue, true));
                    }
                }
            } else {
                AltAnnotation xmlAttribute = originalMethod.getAnnotation(XmlAttribute.class.getName());
                if (xmlAttribute != null) {
                    if (JAXB_DEFAULT_STRING.equals(xmlAttribute.getStringValue("name"))) {
                        xmlNameMap.put(setterVariable, new XmlElementData(setterVariable, JAXB_DEFAULT_DEFAULT, false));
                    } else {
                        xmlNameMap.put(setterVariable, new XmlElementData(xmlAttribute.getStringValue("name"), JAXB_DEFAULT_DEFAULT, false));
                    }
                } else {
                    unmappedNames.add(setterVariable);
                }
            }
            if (pluralOf == null) {
                pluralOf = new AnnotationAltAnnotationImpl(new PluralOfDefault(), null);
            }
            String unDecapitalizedVariable = originalMethod.getName().substring(3);
            addMethodToVariableMap.put(Generator.getMethodName(MethodType.ADD, unDecapitalizedVariable, pluralOf), setterVariable);
            removeMethodToVariableMap.put(Generator.getMethodName(MethodType.REMOVE, unDecapitalizedVariable, pluralOf), setterVariable);
            lookupMethodToVariableMap.put(Generator.getMethodName(MethodType.LOOKUP, unDecapitalizedVariable, pluralOf), setterVariable);
        }
        LinkedHashSet<String> noXmlElementNames = new LinkedHashSet<String>();
        for (String unmappedName : unmappedNames) {
            if (xmlNameMap.containsKey(unmappedName)) continue;
            noXmlElementNames.add(unmappedName);
        }
        return new NameInformation(xmlNameMap, noXmlElementNames, addMethodToVariableMap, removeMethodToVariableMap, lookupMethodToVariableMap, referenceSet, aliasMap);
    }

    private static String convertXmlRootElementName(AltAnnotation root, AltClass clazz) {
        String rootName = root.getStringValue("name");
        if (!JAXB_DEFAULT_STRING.equals(rootName)) {
            return rootName;
        }
        String simpleName = clazz.getSimpleName();
        char[] asChars = simpleName.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean firstChar = true;
        boolean lastCharWasCapital = false;
        for (char asChar : asChars) {
            if (firstChar) {
                firstChar = false;
                if (Character.isUpperCase(asChar)) {
                    lastCharWasCapital = true;
                    sb.append(Character.toLowerCase(asChar));
                    continue;
                }
                lastCharWasCapital = false;
                sb.append(asChar);
                continue;
            }
            if (Character.isUpperCase(asChar)) {
                if (!lastCharWasCapital) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(asChar));
                lastCharWasCapital = true;
                continue;
            }
            sb.append(asChar);
            lastCharWasCapital = false;
        }
        return sb.toString();
    }

    private static boolean isSpecifiedReference(AltMethod method) {
        AltAnnotation customAnnotation = method.getAnnotation(XmlIDREF.class.getName());
        return customAnnotation != null;
    }

    private static String getCompilableClass(AltClass clazz) {
        int depth = 0;
        while (clazz.isArray()) {
            ++depth;
            clazz = clazz.getComponentType();
        }
        StringBuffer sb = new StringBuffer(clazz.getName());
        for (int lcv = 0; lcv < depth; ++lcv) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static AltClass getUltimateNonArrayClass(AltClass clazz) {
        if (clazz == null) {
            return null;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private static void createInterfaceForAltClassIfNeeded(AltClass toFix, ClassPool defaultClassPool) {
        if (toFix == null) {
            return;
        }
        String fixerClass = (toFix = Generator.getUltimateNonArrayClass(toFix)).getName();
        if (defaultClassPool.getOrNull(fixerClass) == null) {
            defaultClassPool.makeInterface(fixerClass);
        }
    }

    private static void addListGenericSignature(CtMethod method, AltClass listPT, boolean isSetter) {
        SignatureAttribute.MethodSignature ms;
        SignatureAttribute.ClassType intSignature = new SignatureAttribute.ClassType(listPT.getName());
        SignatureAttribute.TypeArgument[] typeArguments = new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)intSignature)};
        SignatureAttribute.ClassType listSignature = new SignatureAttribute.ClassType(List.class.getName(), typeArguments);
        if (isSetter) {
            SignatureAttribute.Type[] params = new SignatureAttribute.Type[]{listSignature};
            ms = new SignatureAttribute.MethodSignature(null, params, null, null);
        } else {
            ms = new SignatureAttribute.MethodSignature(null, null, (SignatureAttribute.Type)listSignature, null);
        }
        method.setGenericSignature(ms.encode());
    }

    private static class GhostXmlElementData {
        private final AltAnnotation[] xmlElements;
        private final AltClass getterSetterType;

        private GhostXmlElementData(AltAnnotation[] xmlElements, AltClass getterSetterType) {
            this.xmlElements = xmlElements;
            this.getterSetterType = getterSetterType;
        }
    }

    private static final class PluralOfDefault
    extends AnnotationLiteral<PluralOf>
    implements PluralOf {
        private static final long serialVersionUID = 4358923840720264176L;

        private PluralOfDefault() {
        }

        @Override
        public String value() {
            return "*";
        }

        @Override
        public String add() {
            return "*";
        }

        @Override
        public String remove() {
            return "*";
        }

        @Override
        public String lookup() {
            return "*";
        }
    }
}

