/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.Utilities;

public class ParentedModel
implements Serializable {
    private static final long serialVersionUID = -2480798409414987937L;
    private final Object lock = new Object();
    private String childInterface;
    private String childXmlTag;
    private String childXmlAlias;
    private ChildType childType;
    private String givenDefault;
    private AliasType aliased;
    private ClassLoader myLoader;
    private transient JAUtilities jaUtilities;
    private ModelImpl childModel;

    public ParentedModel() {
    }

    public ParentedModel(String childInterface, String childXmlTag, String childXmlAlias, ChildType childType, String givenDefault, AliasType aliased) {
        this.childInterface = childInterface;
        this.childXmlTag = childXmlTag;
        this.childXmlAlias = childXmlAlias;
        this.childType = childType;
        this.givenDefault = givenDefault;
        this.aliased = aliased;
    }

    public String getChildInterface() {
        return this.childInterface;
    }

    public String getChildXmlTag() {
        return this.childXmlTag;
    }

    public String getChildXmlAlias() {
        return this.childXmlAlias;
    }

    public ChildType getChildType() {
        return this.childType;
    }

    public String getGivenDefault() {
        return this.givenDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelImpl getChildModel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myLoader == null) {
                throw new IllegalStateException("Cannot call getChildModel before the classloader has been determined");
            }
            if (this.childModel != null) {
                return this.childModel;
            }
            Class beanClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childInterface);
            if (beanClass == null) {
                throw new IllegalStateException("Interface " + this.childInterface + " could not be loaded by " + this.myLoader);
            }
            try {
                this.childModel = this.jaUtilities.getModel(beanClass);
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Could not get model for " + beanClass.getName() + " in " + this, re);
            }
            return this.childModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRuntimeInformation(JAUtilities jaUtilities, ClassLoader myLoader) {
        Object object = this.lock;
        synchronized (object) {
            this.jaUtilities = jaUtilities;
            this.myLoader = myLoader;
        }
    }

    public AliasType getAliasType() {
        return this.aliased;
    }

    public String toString() {
        return "ParentedModel(interface=" + this.childInterface + ",xmlTag=" + this.childXmlTag + ",xmlAlias=" + this.childXmlAlias + ",type=" + (Object)((Object)this.childType) + ",givenDefault=" + ",aliased=" + (Object)((Object)this.aliased) + Utilities.safeString(this.givenDefault) + ")";
    }
}

