/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.AliasType;

public class ChildDataModel
implements Serializable {
    private static final long serialVersionUID = 208423310453044595L;
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final Object lock = new Object();
    private String childType;
    private String defaultAsString;
    private boolean isReference;
    private boolean isElement;
    private String childListType;
    private AliasType aliasType;
    private String aliasOf;
    private ClassLoader myLoader;
    private Class<?> childTypeAsClass;
    private Class<?> childListTypeAsClass;

    public ChildDataModel() {
    }

    public ChildDataModel(String childType, String childListType, String defaultAsString, boolean isReference, boolean isElement, AliasType aliasType, String aliasOf) {
        this.childType = childType;
        this.defaultAsString = defaultAsString;
        this.isReference = isReference;
        this.isElement = isElement;
        this.childListType = childListType;
        this.aliasType = aliasType;
        this.aliasOf = aliasOf;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getChildListType() {
        return this.childListType;
    }

    public String getDefaultAsString() {
        return this.defaultAsString;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isElement() {
        return this.isElement;
    }

    public AliasType getAliasType() {
        return this.aliasType;
    }

    public String getXmlAlias() {
        return this.aliasOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader myLoader) {
        Object object = this.lock;
        synchronized (object) {
            this.myLoader = myLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getChildTypeAsClass() {
        Object object = this.lock;
        synchronized (object) {
            if (this.childTypeAsClass != null) {
                return this.childTypeAsClass;
            }
            this.childTypeAsClass = TYPE_MAP.get(this.childType);
            if (this.childTypeAsClass != null) {
                return this.childTypeAsClass;
            }
            this.childTypeAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childType);
            return this.childTypeAsClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getChildListTypeAsClass() {
        Object object = this.lock;
        synchronized (object) {
            if (this.childListType == null) {
                return null;
            }
            if (this.childListTypeAsClass != null) {
                return this.childListTypeAsClass;
            }
            this.childListTypeAsClass = TYPE_MAP.get(this.childListType);
            if (this.childListTypeAsClass != null) {
                return this.childListTypeAsClass;
            }
            this.childListTypeAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childListType);
            return this.childListTypeAsClass;
        }
    }

    public String toString() {
        return "ChildDataModel(" + this.childType + "," + this.defaultAsString + "," + this.isReference + "," + this.childListType + "," + (Object)((Object)this.aliasType) + "," + System.identityHashCode(this) + ")";
    }

    static {
        TYPE_MAP.put("char", Character.TYPE);
        TYPE_MAP.put("byte", Byte.TYPE);
        TYPE_MAP.put("short", Short.TYPE);
        TYPE_MAP.put("int", Integer.TYPE);
        TYPE_MAP.put("float", Float.TYPE);
        TYPE_MAP.put("long", Long.TYPE);
        TYPE_MAP.put("double", Double.TYPE);
        TYPE_MAP.put("boolean", Boolean.TYPE);
    }
}

