/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.internal.XmlStreamImpl;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
@Named(value="StreamXmlParsingService")
public class DomXmlParser
implements XmlServiceParser {
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    @Inject
    @Named(value="StreamXmlParsingService")
    private Provider<XmlServiceImpl> xmlService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        InputStream urlStream = location.toURL().openStream();
        try {
            T t = this.parseRoot(rootModel, urlStream, listener);
            return t;
        }
        finally {
            urlStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener) throws Exception {
        XMLStreamReader xmlStreamReader = this.xif.createXMLStreamReader(input);
        try {
            Object t = XmlStreamImpl.parseRoot((XmlServiceImpl)this.xmlService.get(), rootModel, xmlStreamReader, listener);
            return t;
        }
        finally {
            xmlStreamReader.close();
        }
    }

    @Override
    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }

    @Override
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> root) throws IOException {
        XmlStreamImpl.marshall(outputStream, root);
    }
}

