/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.overlay;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.utilities.general.GeneralUtilities;

public final class ChangeDescriptor {
    private final Change.ChangeCategory category;
    private final String typeName;
    private final List<String> instanceKey;
    private final String[] props;
    private final String instance;
    private final String arName;

    public ChangeDescriptor(Change.ChangeCategory category, String type, String instance, String arName, String ... props) {
        this.category = category;
        this.typeName = type;
        this.props = props;
        this.instanceKey = ChangeDescriptor.tokenizeInstanceKey(instance);
        this.instance = instance;
        this.arName = arName;
    }

    private static List<String> tokenizeInstanceKey(String instance) {
        LinkedList<String> retVal = new LinkedList<String>();
        if (instance == null) {
            return retVal;
        }
        StringTokenizer st = new StringTokenizer(instance, ".");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (nextToken.startsWith("XMLServiceUID")) continue;
            retVal.add(nextToken);
        }
        return retVal;
    }

    private String checkInstanceKey(String recievedKey) {
        List<String> receivedToken = ChangeDescriptor.tokenizeInstanceKey(recievedKey);
        if (this.instanceKey.size() != receivedToken.size()) {
            return "Expected instance cardinality of " + this.instanceKey.size() + " does not match received " + receivedToken.size() + " (" + this.instanceKey + " , " + receivedToken + ")";
        }
        for (int lcv = 0; lcv < receivedToken.size(); ++lcv) {
            String expected = this.instanceKey.get(lcv);
            String received = receivedToken.get(lcv);
            if ("*".equals(expected) || GeneralUtilities.safeEquals((Object)expected, (Object)received)) continue;
            return "Failed in " + this + " at index " + lcv;
        }
        return null;
    }

    String check(Change change) {
        if (!GeneralUtilities.safeEquals((Object)this.category, (Object)change.getChangeCategory())) {
            return "Category is not the same expected=" + this.category + " got=" + change.getChangeCategory();
        }
        if (!GeneralUtilities.safeEquals((Object)this.typeName, (Object)change.getChangeType().getName())) {
            return "Type is not the same expected=" + this.typeName + " got=" + change.getChangeType().getName();
        }
        String errorInstanceKey = this.checkInstanceKey(change.getInstanceKey());
        if (errorInstanceKey != null) {
            return errorInstanceKey;
        }
        List modifiedProperties = change.getModifiedProperties();
        if (modifiedProperties == null) {
            modifiedProperties = Collections.emptyList();
        }
        if (this.props.length != modifiedProperties.size()) {
            return "Expectect property length of " + this.props.length + " but got size " + modifiedProperties.size();
        }
        for (int lcv = 0; lcv < this.props.length; ++lcv) {
            String prop = this.props[lcv];
            boolean found = false;
            for (int inner = 0; inner < modifiedProperties.size(); ++inner) {
                if (!GeneralUtilities.safeEquals((Object)prop, (Object)((PropertyChangeEvent)modifiedProperties.get(inner)).getPropertyName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return "Did not find prop " + prop + " in " + this;
        }
        return null;
    }

    public String toString() {
        return this.category + " type=" + this.typeName + " name=" + this.arName + " instanceKey=" + this.instanceKey + " props=" + Arrays.toString(this.props);
    }
}

