/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.namespace;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.namespace.beans.DoubleNamespaceTroubleRootBean;
import org.glassfish.hk2.xml.test.namespace.beans.FooBean;
import org.glassfish.hk2.xml.test.namespace.beans.XtraAttributesRootBean;
import org.junit.Assert;

public class NamespaceCommon {
    public static final String XTRA_ATTRIBUTES_FILE = "xmlns/xtra-attributes.xml";
    public static final String NAMESPACE_CLASH_FILE = "xmlns/xml-namespace-clash.xml";
    private static final String ACME_NS_URI = "http://www.acme.org/jmxoverjms";
    private static final String BOX_NS_URI = "http://www.boxco.com/boxes";
    private static final String HLMS_NS_URI = "http://www.holmes.com/ac";
    private static final String ATTA_LOCAL = "attA";
    private static final String ATTA_PREFIX = "xos";
    private static final String ATTB_LOCAL = "attB";
    private static final String ATTB_PREFIX = "box";
    private static final String ATTC_LOCAL = "attC";
    private static final String ATTC_PREFIX = "sox";
    private static final String ATTD_LOCAL = "attD";
    private static final QName JOJ_ATTA_QNAME = new QName("http://www.acme.org/jmxoverjms", "attA", "xos");
    private static final QName BOX_ATTB_QNAME = new QName("http://www.boxco.com/boxes", "attB", "box");
    private static final QName DFL_ATTB_QNAME = new QName("attB");
    private static final QName SOX_ATTC_QNAME = new QName("http://www.holmes.com/ac", "attC", "sox");
    private static final QName DFL_ATTD_QNAME = new QName("attD");
    private static final String FOO = "foo";
    private static final String BAZ = "baz";
    private static final String GRAX = "grax";
    private static final String BAR = "bar";
    private static final String GMB = "gumby";
    private static final String FIG = "figaro";
    public static final String NAMESPACE_0 = "Namespace0";
    public static final String NAMESPACE_A = "NamespaceA";
    public static final String NAMESPACE_B = "NamespaceB";
    public static final String NAMESPACE_C = "NamespaceC";

    public static void testExtraAttributes(ServiceLocator locator, URI uri) {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.unmarshal(uri, XtraAttributesRootBean.class);
        XtraAttributesRootBean root = (XtraAttributesRootBean)rootHandle.getRoot();
        FooBean fooBean = root.getFoo();
        Assert.assertEquals((Object)FOO, (Object)fooBean.getAttA());
        Map<QName, String> others = fooBean.getOtherAttributes();
        Assert.assertNotNull(others);
        Assert.assertEquals((long)5L, (long)others.size());
        boolean foundBaz = false;
        boolean foundGrax = false;
        boolean foundBar = false;
        boolean foundGumby = false;
        boolean foundFigaro = false;
        for (Map.Entry<QName, String> entry : others.entrySet()) {
            QName qEntry = entry.getKey();
            String value = entry.getValue();
            if (qEntry.equals(JOJ_ATTA_QNAME)) {
                Assert.assertEquals((Object)BAZ, (Object)value);
                foundBaz = true;
                continue;
            }
            if (qEntry.equals(BOX_ATTB_QNAME)) {
                Assert.assertEquals((Object)GRAX, (Object)value);
                foundGrax = true;
                continue;
            }
            if (qEntry.equals(DFL_ATTB_QNAME)) {
                Assert.assertEquals((Object)BAR, (Object)value);
                foundBar = true;
                continue;
            }
            if (qEntry.equals(SOX_ATTC_QNAME)) {
                Assert.assertEquals((Object)GMB, (Object)value);
                foundGumby = true;
                continue;
            }
            if (qEntry.equals(DFL_ATTD_QNAME)) {
                Assert.assertEquals((Object)FIG, (Object)value);
                foundFigaro = true;
                continue;
            }
            Assert.fail((String)("Unknown QName=" + qEntry + " and value " + value));
        }
        Assert.assertTrue((boolean)foundBaz);
        Assert.assertTrue((boolean)foundGrax);
        Assert.assertTrue((boolean)foundBar);
        Assert.assertTrue((boolean)foundGumby);
        Assert.assertTrue((boolean)foundFigaro);
    }

    public static void testNamespaceClash(ServiceLocator locator, URI uri) {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.unmarshal(uri, DoubleNamespaceTroubleRootBean.class);
        DoubleNamespaceTroubleRootBean root = (DoubleNamespaceTroubleRootBean)rootHandle.getRoot();
        Assert.assertEquals((Object)FOO, (Object)root.getAlice());
        Assert.assertEquals((Object)BAR, (Object)root.getAliceDefault());
        Assert.assertEquals((Object)BAZ, (Object)root.getAliceB());
        Assert.assertEquals((Object)GRAX, (Object)root.getAliceC());
    }
}

