/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.adds;

import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlHandleTransaction;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Employee;
import org.glassfish.hk2.xml.test.basic.beans.Employees;
import org.glassfish.hk2.xml.test.basic.beans.Financials;
import org.glassfish.hk2.xml.test.basic.beans.NamedBean;
import org.glassfish.hk2.xml.test.basic.beans.OtherData;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class AddsTest {
    private static final String DAVE = "Dave";
    private static final String EMPLOYEE_TYPE = "/employees/employee";
    private static final String OTHER_DATA_TYPE = "/employees/other-data";
    private static final String DAVE_INSTANCE = "employees.Dave";
    private static final String ATT_SYMBOL = "ATT";
    private static final String NASDAQ = "Nasdaq";
    private static final long ALICE_ID = 12L;
    private static final long BOB_ID = 14L;
    private static final long CAROL_ID = 16L;
    private static final String DATA1 = "Spiner";
    private static final String DATA2 = "10100101";
    private static final String UNO = "uno";
    private static final String DOS = "dos";
    private static final String TRES = "tres";
    private static final String QUATRO = "quatro";

    @Test
    public void testCreateAndAdd() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        Assert.assertNull((Object)rootHandle.getRoot());
        rootHandle.addRoot();
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.getFinancials());
        Assert.assertEquals((long)0L, (long)root.getEmployees().size());
        Assert.assertNull((Object)root.getCompanyName());
    }

    @Test
    public void testCreateAndAddWithValidation() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        rootHandle.startValidating();
        Assert.assertNull((Object)rootHandle.getRoot());
        rootHandle.addRoot();
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        Assert.assertNull((Object)root.getFinancials());
        Assert.assertEquals((long)0L, (long)root.getEmployees().size());
        Assert.assertNull((Object)root.getCompanyName());
        root.setCompanyName(DAVE);
        Assert.assertEquals((Object)DAVE, (Object)root.getCompanyName());
    }

    private void addToExistingTree(ServiceLocator locator, Hub hub, XmlRootHandle<Employees> rootHandle, boolean inRegistry, boolean inHub) {
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addEmployee(DAVE);
        employees.setAStringThatWillBeSetToNull(null);
        Employee daveDirect = employees.lookupEmployee(DAVE);
        Assert.assertNotNull((Object)daveDirect);
        if (inRegistry) {
            Employee daveService = (Employee)locator.getService(Employee.class, DAVE, new Annotation[0]);
            Assert.assertNotNull((Object)daveService);
            Assert.assertEquals((Object)daveDirect, (Object)daveService);
        } else {
            Assert.assertNull((Object)locator.getService(Employee.class, DAVE, new Annotation[0]));
        }
        if (inHub) {
            Instance daveInstance = hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, DAVE_INSTANCE);
            Assert.assertNotNull((Object)daveInstance);
            Object daveInstanceMetadata = daveInstance.getMetadata();
            Assert.assertNotNull((Object)daveInstanceMetadata);
            Assert.assertEquals((Object)daveDirect, (Object)daveInstanceMetadata);
        } else {
            Assert.assertNull((Object)hub.getCurrentDatabase().getInstance(EMPLOYEE_TYPE, DAVE_INSTANCE));
        }
        if (inHub) {
            RecordingBeanUpdateListener listener = (RecordingBeanUpdateListener)locator.getService(RecordingBeanUpdateListener.class, new Annotation[0]);
            List<Change> allChanges = listener.latestCommit;
            Assert.assertNotNull(allChanges);
            Assert.assertEquals((long)2L, (long)allChanges.size());
            Change change0 = allChanges.get(0);
            Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)change0.getChangeCategory());
            Type changeType = change0.getChangeType();
            Assert.assertEquals((Object)EMPLOYEE_TYPE, (Object)changeType.getName());
            Assert.assertEquals((Object)DAVE_INSTANCE, (Object)change0.getInstanceKey());
            Assert.assertNotNull((Object)change0.getInstanceValue());
            Assert.assertNull((Object)change0.getOriginalInstanceValue());
            Assert.assertNull((Object)change0.getModifiedProperties());
            Change change1 = allChanges.get(1);
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change1.getChangeCategory());
            changeType = change1.getChangeType();
            Assert.assertEquals((Object)"/employees", (Object)changeType.getName());
            Assert.assertEquals((Object)"employees", (Object)change1.getInstanceKey());
            Assert.assertNotNull((Object)change1.getInstanceValue());
            Assert.assertNotNull((Object)change1.getOriginalInstanceValue());
            List modifiedProperties = change1.getModifiedProperties();
            Assert.assertNotNull((Object)modifiedProperties);
            Assert.assertEquals((long)1L, (long)modifiedProperties.size());
            Assert.assertEquals((Object)"employee", (Object)((PropertyChangeEvent)modifiedProperties.get(0)).getPropertyName());
        }
    }

    @Test
    public void testAddToExistingTree() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RecordingBeanUpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        this.addToExistingTree(locator, hub, (XmlRootHandle<Employees>)rootHandle, true, true);
    }

    @Test
    public void testAddToExistingTreeNoHub() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class, true, false);
        this.addToExistingTree(locator, hub, (XmlRootHandle<Employees>)rootHandle, true, false);
    }

    @Test
    public void testAddToExistingTreeNoHk2Service() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RecordingBeanUpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class, false, true);
        this.addToExistingTree(locator, hub, (XmlRootHandle<Employees>)rootHandle, false, true);
    }

    @Test
    public void testAddToExistingTreeNoHk2ServiceOrHub() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class, false, false);
        this.addToExistingTree(locator, hub, (XmlRootHandle<Employees>)rootHandle, false, false);
    }

    @Test
    public void testAddToExistingTreeUnKeyed() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        employees.addOtherData(0);
        OtherData found = null;
        for (OtherData other : employees.getOtherData()) {
            Assert.assertNull(found);
            found = other;
        }
        Assert.assertNotNull(found);
        OtherData otherService = (OtherData)locator.getService(OtherData.class, new Annotation[0]);
        Assert.assertNotNull((Object)otherService);
        Assert.assertEquals((Object)found, (Object)otherService);
        Type type = hub.getCurrentDatabase().getType(OTHER_DATA_TYPE);
        Instance foundInstance = null;
        for (Instance i : type.getInstances().values()) {
            Assert.assertNull(foundInstance);
            foundInstance = i;
        }
        Assert.assertNotNull(foundInstance);
    }

    @Test
    public void testAddToExistingTreeDirect() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RecordingBeanUpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme2.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertNull((Object)employees.getFinancials());
        employees.addFinancials();
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertNull((Object)financials.getExchange());
        Assert.assertNull((Object)financials.getSymbol());
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance("/employees/financials", "employees.financials"));
        RecordingBeanUpdateListener listener = (RecordingBeanUpdateListener)locator.getService(RecordingBeanUpdateListener.class, new Annotation[0]);
        List<Change> allChanges = listener.latestCommit;
        Assert.assertNotNull(allChanges);
        Assert.assertEquals((long)3L, (long)allChanges.size());
        Change change0 = allChanges.get(0);
        Assert.assertEquals((Object)Change.ChangeCategory.ADD_TYPE, (Object)change0.getChangeCategory());
        Type changeType = change0.getChangeType();
        Assert.assertEquals((Object)"/employees/financials", (Object)changeType.getName());
        Assert.assertNull((Object)change0.getInstanceKey());
        Assert.assertNull((Object)change0.getInstanceValue());
        Assert.assertNull((Object)change0.getOriginalInstanceValue());
        Assert.assertNull((Object)change0.getModifiedProperties());
        Change change1 = allChanges.get(1);
        Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)change1.getChangeCategory());
        changeType = change1.getChangeType();
        Assert.assertEquals((Object)"/employees/financials", (Object)changeType.getName());
        Assert.assertEquals((Object)"employees.financials", (Object)change1.getInstanceKey());
        Assert.assertNotNull((Object)change1.getInstanceValue());
        Assert.assertNull((Object)change1.getOriginalInstanceValue());
        Assert.assertNull((Object)change1.getModifiedProperties());
        Change change2 = allChanges.get(2);
        Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change2.getChangeCategory());
        changeType = change2.getChangeType();
        Assert.assertEquals((Object)"/employees", (Object)changeType.getName());
        Assert.assertEquals((Object)"employees", (Object)change2.getInstanceKey());
        Assert.assertNotNull((Object)change2.getInstanceValue());
        Assert.assertNotNull((Object)change2.getOriginalInstanceValue());
        List modifiedProperties = change2.getModifiedProperties();
        Assert.assertNotNull((Object)modifiedProperties);
        Assert.assertEquals((long)1L, (long)modifiedProperties.size());
        Assert.assertEquals((Object)"financials", (Object)((PropertyChangeEvent)modifiedProperties.get(0)).getPropertyName());
        Assert.assertNull((Object)((PropertyChangeEvent)modifiedProperties.get(0)).getOldValue());
        Assert.assertNotNull((Object)((PropertyChangeEvent)modifiedProperties.get(0)).getNewValue());
    }

    private static Employee createEmployee(XmlService xmlService, String name, long id) {
        Employee employee = (Employee)xmlService.createBean(Employee.class);
        employee.setName(name);
        employee.setId(id);
        return employee;
    }

    private static OtherData createOtherData(XmlService xmlService, String data) {
        OtherData other = (OtherData)xmlService.createBean(OtherData.class);
        other.setData(data);
        return other;
    }

    private static void checkEmployee(Employee employee, String name, long id) {
        Assert.assertNotNull((Object)employee);
        Assert.assertEquals((Object)name, (Object)employee.getName());
        Assert.assertEquals((long)id, (long)employee.getId());
    }

    private static void checkOtherData(OtherData other, String data) {
        Assert.assertNotNull((Object)other);
        Assert.assertEquals((Object)data, (Object)other.getData());
    }

    private static void checkFinancials(Financials fin, String exchange, String symbol) {
        Assert.assertNotNull((Object)fin);
        Assert.assertEquals((Object)exchange, (Object)fin.getExchange());
        Assert.assertEquals((Object)symbol, (Object)fin.getSymbol());
    }

    @Test
    public void testAddOneLevelComplexRoot() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(Employees.class);
        Assert.assertNull((Object)rootHandle.getRoot());
        Employees employees = (Employees)xmlService.createBean(Employees.class);
        Financials financials = (Financials)xmlService.createBean(Financials.class);
        financials.setExchange(NASDAQ);
        financials.setSymbol(ATT_SYMBOL);
        employees.setFinancials(financials);
        Employee alice = AddsTest.createEmployee(xmlService, "Alice", 12L);
        Employee bob = AddsTest.createEmployee(xmlService, "Bob", 14L);
        Employee carol = AddsTest.createEmployee(xmlService, "Carol", 16L);
        employees.addEmployee(alice);
        employees.addEmployee(carol);
        employees.addEmployee(bob, 1);
        OtherData data1 = AddsTest.createOtherData(xmlService, DATA1);
        OtherData data2 = AddsTest.createOtherData(xmlService, DATA2);
        employees.addOtherData(data2);
        employees.addOtherData(data1, 0);
        rootHandle.addRoot((Object)employees);
        Employees root = (Employees)rootHandle.getRoot();
        Assert.assertNotNull((Object)root);
        AddsTest.checkFinancials(root.getFinancials(), NASDAQ, ATT_SYMBOL);
        AddsTest.checkEmployee(root.getEmployees().get(0), "Alice", 12L);
        AddsTest.checkEmployee(root.getEmployees().get(1), "Bob", 14L);
        AddsTest.checkEmployee(root.getEmployees().get(2), "Carol", 16L);
        AddsTest.checkOtherData(root.getOtherData().get(0), DATA1);
        AddsTest.checkOtherData(root.getOtherData().get(1), DATA2);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Alice", new Annotation[0]), "Alice", 12L);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Bob", new Annotation[0]), "Bob", 14L);
        AddsTest.checkEmployee((Employee)locator.getService(Employee.class, "Carol", new Annotation[0]), "Carol", 16L);
        int lcv = 0;
        for (OtherData other : locator.getAllServices(OtherData.class, new Annotation[0])) {
            if (lcv == 0) {
                AddsTest.checkOtherData(other, DATA1);
            } else if (lcv == 1) {
                AddsTest.checkOtherData(other, DATA2);
            } else {
                Assert.fail((String)"Too many OtherData");
            }
            ++lcv;
        }
        Assert.assertEquals((long)2L, (long)lcv);
        AddsTest.checkFinancials((Financials)locator.getService(Financials.class, new Annotation[0]), NASDAQ, ATT_SYMBOL);
    }

    @Test
    public void testAddsThatReturnValues() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class, false, false);
        Employees employees = (Employees)rootHandle.getRoot();
        NamedBean tresBean = employees.addName(TRES);
        Assert.assertNotNull((Object)tresBean);
        Assert.assertEquals((Object)TRES, (Object)tresBean.getName());
        NamedBean quatro = (NamedBean)xmlService.createBean(NamedBean.class);
        quatro.setName(QUATRO);
        NamedBean quatroBean = employees.addName(quatro);
        Assert.assertNotNull((Object)quatroBean);
        Assert.assertEquals((Object)QUATRO, (Object)quatroBean.getName());
        NamedBean uno = (NamedBean)xmlService.createBean(NamedBean.class);
        uno.setName(UNO);
        NamedBean unoBean = employees.addName(uno, 0);
        Assert.assertNotNull((Object)unoBean);
        Assert.assertEquals((Object)UNO, (Object)unoBean.getName());
        NamedBean dosBean = employees.addName(DOS, 1);
        Assert.assertNotNull((Object)dosBean);
        Assert.assertEquals((Object)DOS, (Object)dosBean.getName());
        NamedBean[] allBeans = employees.getNames();
        Assert.assertEquals((long)4L, (long)allBeans.length);
        Assert.assertEquals((Object)unoBean, (Object)allBeans[0]);
        Assert.assertEquals((Object)dosBean, (Object)allBeans[1]);
        Assert.assertEquals((Object)tresBean, (Object)allBeans[2]);
        Assert.assertEquals((Object)quatroBean, (Object)allBeans[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveAddRemoveInOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RecordingBeanUpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        boolean success = false;
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        try {
            employees.removeEmployee(DAVE);
            employees.addEmployee(DAVE);
            employees.removeEmployee(DAVE);
            employees.addEmployee(DAVE);
            employees.removeEmployee(DAVE);
            success = true;
        }
        finally {
            if (success) {
                transaction.commit();
            } else {
                transaction.abandon();
            }
        }
        Assert.assertNull((Object)employees.lookupEmployee(DAVE));
        RecordingBeanUpdateListener listener = (RecordingBeanUpdateListener)locator.getService(RecordingBeanUpdateListener.class, new Annotation[0]);
        Assert.assertNotNull((Object)listener);
        List<Change> committed = listener.latestCommit;
        Assert.assertEquals((long)8L, (long)committed.size());
        for (int lcv = 0; lcv < committed.size(); ++lcv) {
            Change currentChange = committed.get(lcv);
            if (lcv == 0 || lcv == 4) {
                Assert.assertEquals((Object)Change.ChangeCategory.ADD_INSTANCE, (Object)currentChange.getChangeCategory());
                Assert.assertEquals((Object)EMPLOYEE_TYPE, (Object)currentChange.getChangeType().getName());
                Assert.assertEquals((Object)DAVE_INSTANCE, (Object)currentChange.getInstanceKey());
                continue;
            }
            if (lcv == 1 || lcv == 2 || lcv == 5 || lcv == 6) {
                Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)currentChange.getChangeCategory());
                Assert.assertEquals((Object)"/employees", (Object)currentChange.getChangeType().getName());
                Assert.assertEquals((Object)"employees", (Object)currentChange.getInstanceKey());
                List changed = currentChange.getModifiedProperties();
                Assert.assertEquals((long)1L, (long)changed.size());
                Assert.assertEquals((Object)"employee", (Object)((PropertyChangeEvent)changed.get(0)).getPropertyName());
                continue;
            }
            if (lcv == 3 || lcv == 7) {
                Assert.assertEquals((Object)Change.ChangeCategory.REMOVE_INSTANCE, (Object)currentChange.getChangeCategory());
                Assert.assertEquals((Object)EMPLOYEE_TYPE, (Object)currentChange.getChangeType().getName());
                Assert.assertEquals((Object)DAVE_INSTANCE, (Object)currentChange.getInstanceKey());
                continue;
            }
            Assert.fail((String)("Too many entries? " + lcv));
        }
    }

    @Test
    public void testCannotChangeKeyProperty() throws Exception {
        ServiceLocator locator = Utilities.createLocator(RecordingBeanUpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Employee bob = employees.lookupEmployee("Bob");
        Assert.assertNotNull((Object)bob);
        try {
            bob.setName("Alice");
            Assert.fail((String)"Should have failed, cannot change the value of a key property");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().contains("Bob"));
            Assert.assertTrue((boolean)iae.getMessage().contains("Alice"));
        }
    }

    @Singleton
    public static class RecordingBeanUpdateListener
    implements BeanDatabaseUpdateListener {
        public List<Change> latestPrepares;
        public List<Change> latestCommit;
        public List<Change> latestRollback;

        public void prepareDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
            this.latestPrepares = changes;
        }

        public void commitDatabaseChange(BeanDatabase oldDatabase, BeanDatabase currentDatabase, Object commitMessage, List<Change> changes) {
            this.latestCommit = changes;
        }

        public void rollbackDatabaseChange(BeanDatabase currentDatabase, BeanDatabase proposedDatabase, Object commitMessage, List<Change> changes) {
            this.latestRollback = changes;
        }
    }
}

